/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.infoclassify.percre;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.domian.service.infoclassify.IPercreService;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.hr.hspm.common.entity.ocr.IdCardBackResult;
import kd.hr.hspm.common.entity.ocr.IdCardFrontResult;
import kd.hr.hspm.formplugin.web.schedule.utils.PercreFieldUtils;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.entity.InfoclassifyPercreField;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.InfoClassifyPercreFieldUtil;
import kd.sdk.hr.hspm.formplugin.infoclassify.InfoClassifyAttachmentEditPlugin;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.ApCreateUtils;

public class PercreEditPlugin
extends InfoClassifyAttachmentEditPlugin {
    private static final Log LOGGER = LogFactory.getLog(PercreEditPlugin.class);
    private static final Set<String> ALL_COLUMN = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"credentialstype", "number", "expirationdate", "countrycode", "issuingauthor", "issuedate", "isnofixedterm", "birthplace", "idcardaddress", "birthday", "lastnameen", "firstnameen", "lastnamecn", "firstnamecn", "nationality", "isidentity", "ismajor", "gender", "issuingplace", "folk", "faceimage", "reverseimage", "percardname"}));
    private static final Set<String> TRIGGER_CLEAN_COLUMN = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"number", "expirationdate", "countrycode", "issuingauthor", "issuedate", "isnofixedterm", "birthplace", "idcardaddress", "birthday", "lastnameen", "firstnameen", "lastnamecn", "firstnamecn", "nationality", "isidentity", "gender", "issuingplace", "folk", "faceimage", "reverseimage", "percardname"}));
    private static final String PERNONTSPROP_CACHE_KEY = "pernontsprop_cache";
    private final IPercreService percreService = IPercreService.getInstance();
    private final Map<Long, InfoclassifyPercreField> TYPE_FIELD_MAP = InfoClassifyPercreFieldUtil.buildFieldMap();
    private final List<Long> TYPE_FIELD_OTHER_LIST = InfoClassifyPercreFieldUtil.buildOtherFieldList();

    public void afterBindData(EventObject event) {
        DynamicObject credentialstypeDy = this.getModel().getDataEntity().getDynamicObject("credentialstype");
        long credentialstypeId = !HRObjectUtils.isEmpty((Object)credentialstypeDy) ? credentialstypeDy.getLong("id") : 0L;
        HashSet<String> igSet = new HashSet<String>(16);
        this.setVisibleByType(credentialstypeId, igSet, true);
        BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)true);
        this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
        this.getModel().setDataChanged(false);
        BillView view = (BillView)this.getView();
        if (view.getStatus() == OperationStatus.EDIT) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percretips"});
            if (!HRObjectUtils.isEmpty((Object)credentialstypeDy)) {
                this.getView().getPageCache().put("credentialsTypeName", credentialstypeDy.getString("name"));
                this.getView().getPageCache().put("credentialsTypeNumber", credentialstypeDy.getString("number"));
                this.getView().getPageCache().put("credentialsTypeId", String.valueOf(credentialstypeDy.getLong("id")));
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkId = (Long)dataEntity.getPkValue();
            long personId = dataEntity.getLong("person.id");
            int count = this.percreService.queryOtherExistsByPersonIdAndPkId(personId, pkId);
            boolean ismajor = dataEntity.getBoolean("ismajor");
            if (count == 0 && ismajor) {
                view.setEnable(Boolean.FALSE, new String[]{"ismajor"});
            }
        }
        super.afterBindData(event);
    }

    protected void setAttachment() {
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getControl("attachmentpanelap_std");
        if (attachmentpanel == null) {
            return;
        }
        List attachmentData = attachmentpanel.getAttachmentData();
        if (!CollectionUtils.isEmpty((Collection)attachmentData)) {
            this.getView().getPageCache().put("attachmentpanelap_std", SerializationUtils.toJsonString((Object)attachmentData));
        }
    }

    private void setVisibleByType(long credentialstypeId, Set<String> ignoreSet, boolean hiddenClean) {
        InfoclassifyPercreField percreField = this.TYPE_FIELD_MAP.get(credentialstypeId);
        Set showList = percreField != null ? percreField.getFieldSet() : InfoClassifyPercreFieldUtil.DEFAULT_SHOW;
        this.getPageCache().put("showlist", SerializationUtils.toJsonString((Object)showList));
        this.hiddenAndShow(showList, this.TYPE_FIELD_OTHER_LIST.contains(credentialstypeId), hiddenClean);
        this.resetPercreFieldByPernontspropCache();
        if (HspmCommonConstants.NUMBER_1010_ID == credentialstypeId) {
            String imageName = ResManager.loadKDString((String)"\u4eba\u50cf\u9762", (String)"PercreDrawPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            String resImageName = ResManager.loadKDString((String)"\u56fd\u5fbd\u9762", (String)"PercreDrawPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(imageName, resImageName, percreField != null ? percreField.getFaceUrl() : null, percreField != null ? percreField.getReverseUrl() : null);
        } else if (HspmCommonConstants.NUMBER_1020_ID == credentialstypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reverseimageshowlabel"});
            String passportLab = ResManager.loadKDString((String)"\u4e2a\u4eba\u8d44\u6599\u9875", (String)"PercreDrawPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(passportLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (HspmCommonConstants.NUMBER_1080_ID == credentialstypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reverseimageshowlabel"});
            String officerLab = ResManager.loadKDString((String)"\u5185\u5bb9\u9875", (String)"PercreDrawPlugin_37", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(officerLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (HspmCommonConstants.NUMBER_1110_ID == credentialstypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reverseimageshowlabel"});
            String driverLab = ResManager.loadKDString((String)"\u9a7e\u9a76\u8bc1\u4e3b\u9875", (String)"PercreDrawPlugin_38", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(driverLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (HspmCommonConstants.NUMBER_1120_ID == credentialstypeId || HspmCommonConstants.NUMBER_1130_ID == credentialstypeId || HspmCommonConstants.NUMBER_1140_ID == credentialstypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reverseimageshowlabel"});
            String workPermitLab = ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u9762", (String)"PercreDrawPlugin_39", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(workPermitLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (this.TYPE_FIELD_OTHER_LIST.contains(credentialstypeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"faceimageshowlabel", "reverseimageshowlabel"});
        } else if (percreField != null) {
            this.showDiffBackImg(null, null, percreField.getFaceUrl(), percreField.getReverseUrl());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"faceimageshowlabel", "reverseimageshowlabel"});
        }
        ignoreSet.addAll(ALL_COLUMN.stream().filter(item -> !showList.contains(item)).collect(Collectors.toSet()));
        this.getView().updateView("fs_percreinfo");
    }

    private void hiddenAndShow(Set<String> showList, boolean showAttachment, boolean hiddenClean) {
        Object value;
        this.getView().setVisible(Boolean.TRUE, showList.toArray(new String[0]));
        String[] hiddenArr = (String[])ALL_COLUMN.stream().filter(column -> !showList.contains(column)).toArray(String[]::new);
        this.visibleAttachment(showAttachment, "attachmentpanelap_std");
        this.getView().setVisible(Boolean.FALSE, hiddenArr);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (hiddenClean) {
            for (String propName : hiddenArr) {
                dataEntity.set(propName, null);
            }
        } else {
            for (String propName : TRIGGER_CLEAN_COLUMN) {
                dataEntity.set(propName, null);
            }
        }
        if ((value = this.getModel().getValue("ismajor")) == null || HRStringUtils.equals((String)"0", (String)value.toString())) {
            this.getModel().setValue("ismajor", null);
        }
    }

    private void visibleAttachment(Boolean visible, String ... ctlKeys) {
        HashMap<String, Object> visableMap = new HashMap<String, Object>(16);
        visableMap.put("policy", "");
        visableMap.put("visible", visible);
        visableMap.put("keys", ctlKeys);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setVisible", visableMap);
    }

    private void showDiffBackImg(String imgLab, String resImgLab, String imgUrl, String resImgUrl) {
        HashMap<String, HashMap<String, String>> item;
        HashMap<String, String> map;
        if (HRStringUtils.isEmpty((String)imgLab)) {
            imgLab = ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"PercreDrawPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp labelAp = ApCreateUtils.createLabelAp((String)"faceimageshowlabel", (String)imgLab);
        this.getView().updateControlMetadata(labelAp.getKey(), labelAp.createControl());
        if (HRStringUtils.isEmpty((String)resImgLab)) {
            resImgLab = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"PercreDrawPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp resLabelAp = ApCreateUtils.createLabelAp((String)"reverseimageshowlabel", (String)resImgLab);
        this.getView().updateControlMetadata(resLabelAp.getKey(), resLabelAp.createControl());
        if (HRStringUtils.isNotEmpty((String)imgUrl)) {
            map = new HashMap<String, String>(16);
            item = new HashMap<String, HashMap<String, String>>(16);
            map.put("dik", imgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("faceimage", item);
        }
        if (HRStringUtils.isNotEmpty((String)resImgUrl)) {
            map = new HashMap(16);
            item = new HashMap(16);
            map.put("dik", resImgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("reverseimage", item);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        String cacheTypeNumber = this.getView().getPageCache().get("credentialsTypeNumber");
        if (HRStringUtils.equals((String)"credentialstype", (String)key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percretips"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reverseimageshowlabel", "faceimageshowlabel"});
        }
        switch (key) {
            case "person": {
                DynamicObject personNewDy = (DynamicObject)newValue;
                if (personNewDy == null) {
                    return;
                }
                long personid = personNewDy.getLong("id");
                DynamicObject pernontspropDy = this.percreService.getPernontspropInfoByPersonId(personid);
                this.getPageCache().remove(PERNONTSPROP_CACHE_KEY);
                if (HRObjectUtils.isEmpty((Object)pernontspropDy)) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u9ed8\u8ba4\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u624b\u52a8\u586b\u5199\u9ed8\u8ba4\u5c5e\u6027\u3002", (String)"PercreEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), personNewDy.getString("name")));
                } else {
                    this.putPernontspropCache(pernontspropDy);
                    this.resetPercreFieldByPernontspropCache();
                }
                DynamicObject credentialstypeDy = this.getModel().getDataEntity().getDynamicObject("credentialstype");
                if (HRObjectUtils.isEmpty((Object)credentialstypeDy) || HspmCommonConstants.NUMBER_1010_ID.longValue() != credentialstypeDy.getLong("id") || !this.isMultiIdCard(credentialstypeDy.getLong("id"), personid)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "credentialstype": {
                DynamicObject personDy;
                DynamicObject newCredentialstypeDy = (DynamicObject)newValue;
                if (newCredentialstypeDy == null) {
                    this.hiddenAndShow(InfoClassifyPercreFieldUtil.DEFAULT_SHOW, false, false);
                    this.resetPercreFieldByPernontspropCache();
                    this.getView().setVisible(Boolean.TRUE, new String[]{"percretips"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"reverseimageshowlabel", "faceimageshowlabel"});
                    this.getView().updateView("fs_percreinfo");
                    return;
                }
                String newType = newCredentialstypeDy.getString("number");
                long typeId = newCredentialstypeDy.getLong("id");
                if (HRStringUtils.isNotEmpty((String)cacheTypeNumber) && HRStringUtils.isNotEmpty((String)newType) && !newType.equals(cacheTypeNumber)) {
                    this.getModel().setValue("reverseimage", (Object)"");
                    this.getModel().setValue("faceimage", (Object)"");
                }
                this.getView().getPageCache().put("credentialsTypeName", newCredentialstypeDy.getString("name"));
                this.getView().getPageCache().put("credentialsTypeNumber", newType);
                this.getView().getPageCache().put("credentialsTypeId", String.valueOf(typeId));
                if (HspmCommonConstants.NUMBER_1010_ID == typeId && !HRObjectUtils.isEmpty((Object)(personDy = this.getModel().getDataEntity().getDynamicObject("person"))) && this.isMultiIdCard(typeId, personDy.getLong("id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                }
                HashSet<String> igSet = new HashSet<String>(16);
                this.setVisibleByType(typeId, igSet, false);
                this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
                boolean isIdentity = newCredentialstypeDy.getBoolean("isidentity");
                if (!this.isFieldExist("isidentity")) break;
                this.getModel().setValue("isidentity", (Object)(isIdentity ? "1" : "0"));
                break;
            }
            case "ismajor": {
                if (newValue == null || !Boolean.TRUE.equals(Boolean.parseBoolean(newValue.toString()))) break;
                String credentialsTypeName = this.getView().getPageCache().get("credentialsTypeName");
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c06\u6210\u4e3a\u65b0\u7684\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_32", (String)"hr-hspm-formplugin", (Object[])new Object[0]), credentialsTypeName));
                break;
            }
            case "faceimage": {
                if (newValue == null || !HRStringUtils.isNotEmpty((String)((String)newValue)) || HspmCommonConstants.NUMBER_1010_ID != Long.parseLong(this.getView().getPageCache().get("credentialsTypeId")) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromFaceOcr(newValue.toString());
                break;
            }
            case "reverseimage": {
                if (newValue == null || !HRStringUtils.isNotEmpty((String)((String)newValue)) || HspmCommonConstants.NUMBER_1010_ID != Long.parseLong(this.getView().getPageCache().get("credentialsTypeId")) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromReverseOcr(newValue.toString());
                break;
            }
            case "number": {
                DynamicObject dy = this.getModel().getDataEntity();
                long percreId = dy.getLong("id");
                Tuple checkResult = UniquenessCheckUtil.checkCardNo((Long)percreId, (Long)dy.getLong("credentialstype.id"), (String)dy.getString("number"), (boolean)true);
                if (!((Boolean)checkResult.item1).booleanValue()) {
                    this.getView().showErrorNotification((String)checkResult.item2);
                }
                PercreFieldUtils.parseNumber(dy.getString("number"), this.getView());
                break;
            }
            case "isnofixedterm": {
                BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)false);
                break;
            }
        }
    }

    private void putPernontspropCache(DynamicObject pernontspropDy) {
        String name = pernontspropDy.getString("name");
        Long gender = pernontspropDy.getLong("gender.id");
        Long folk = pernontspropDy.getLong("folk.id");
        Long nationality = pernontspropDy.getLong("nationality.id");
        Date birthday = pernontspropDy.getDate("birthday");
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        cacheMap.put("percardname", name);
        cacheMap.put("gender", gender);
        cacheMap.put("folk", folk);
        cacheMap.put("nationality", nationality);
        cacheMap.put("birthday", birthday);
        this.getPageCache().put(PERNONTSPROP_CACHE_KEY, SerializationUtils.toJsonString(cacheMap));
    }

    private void resetPercreFieldByPernontspropCache() {
        String cache = this.getPageCache().get(PERNONTSPROP_CACHE_KEY);
        if (HRStringUtils.isEmpty((String)cache)) {
            return;
        }
        Map cacheMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        long credentialstypeId = this.getModel().getDataEntity().getLong("credentialstype.id");
        if (credentialstypeId > 0L) {
            InfoclassifyPercreField percreField = this.TYPE_FIELD_MAP.get(credentialstypeId);
            Set showList = percreField != null ? percreField.getFieldSet() : InfoClassifyPercreFieldUtil.DEFAULT_SHOW;
            for (Map.Entry entry : cacheMap.entrySet()) {
                if (!showList.contains(entry.getKey())) continue;
                this.getModel().setValue((String)entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromFaceOcr(String url) {
        block16: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                DynamicObject sex;
                AlgoResultData data = IHspmOcrService.getInstance().distinguishOcrImage(this.getView().getEntityId(), "OPM-IdCardBack", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return;
                }
                LOGGER.info(String.format("PercreEditPlugin#refreshFieldFromFaceOcr data: %s", data));
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block16;
                }
                IdCardBackResult result = (IdCardBackResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardBackResult.class);
                if (this.isFieldExist("percardname") && HRStringUtils.isNotEmpty((String)result.getName())) {
                    this.getModel().setValue("percardname", (Object)result.getName());
                }
                if (this.isFieldExist("gender") && HRStringUtils.isNotEmpty((String)result.getSex()) && (sex = BasedataHelper.getAuditBaseDataByName((String)"hbss_sex", (String)result.getSex())) != null) {
                    this.getModel().setValue("gender", (Object)sex);
                }
                if (this.isFieldExist("folk") && HRStringUtils.isNotEmpty((String)result.getNation())) {
                    String suffix = ResManager.loadKDString((String)"\u65cf", (String)"PercreDrawPlugin_36", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    DynamicObject folk = BasedataHelper.getAuditBaseDataByName((String)"hbss_flok", (String)(result.getNation() + suffix));
                    if (folk != null) {
                        this.getModel().setValue("folk", (Object)folk);
                    }
                }
                if (this.isFieldExist("birthday") && HRStringUtils.isNotEmpty((String)result.getBirth())) {
                    Date birthday = null;
                    try {
                        birthday = HspmDateUtils.parseDate((String)result.getBirth(), (String)"yyyy-MM-dd");
                    }
                    catch (ParseException parseException) {
                        LOGGER.error("parse date error, birthday: {}", (Object)result.getBirth(), (Object)parseException);
                    }
                    if (birthday != null) {
                        this.getModel().setValue("birthday", (Object)birthday);
                    }
                }
                if (this.isFieldExist("idcardaddress") && HRStringUtils.isNotEmpty((String)result.getAddress())) {
                    this.getModel().setValue("idcardaddress", (Object)result.getAddress());
                }
                if (this.isFieldExist("number") && HRStringUtils.isNotEmpty((String)result.getIdNum())) {
                    this.getModel().setValue("number", (Object)result.getIdNum());
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromReverseOcr(String url) {
        block11: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                int sepIndex;
                boolean isNeedSet;
                AlgoResultData data = IHspmOcrService.getInstance().distinguishOcrImage(this.getView().getEntityId(), "OPM-IDCardFront", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return;
                }
                LOGGER.info(String.format("PercreEditPlugin#refreshFieldFromReverseOcr data: %s", data));
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block11;
                }
                IdCardFrontResult result = (IdCardFrontResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardFrontResult.class);
                if (HRStringUtils.isNotEmpty((String)result.getAuthority()) && this.isFieldExist("issuingauthor")) {
                    this.getModel().setValue("issuingauthor", (Object)result.getAuthority());
                }
                boolean bl = isNeedSet = HRStringUtils.isNotEmpty((String)result.getValidDate()) && (this.isFieldExist("issuedate") || this.isFieldExist("expirationdate"));
                if (!isNeedSet || (sepIndex = result.getValidDate().indexOf(45)) <= 0) break block11;
                Date issueDate = null;
                Date expirationDate = null;
                try {
                    issueDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(0, sepIndex), (String)"yyyy.MM.dd");
                    expirationDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(sepIndex + 1), (String)"yyyy.MM.dd");
                }
                catch (ParseException parseException) {
                    LOGGER.error("parse date error, validDate: {}", (Object)result.getValidDate(), (Object)parseException);
                }
                if (issueDate != null && this.isFieldExist("issuedate")) {
                    this.getModel().setValue("issuedate", (Object)issueDate);
                }
                if (expirationDate != null && this.isFieldExist("expirationdate")) {
                    this.getModel().setValue("expirationdate", (Object)expirationDate);
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    protected boolean isFieldExist(String key) {
        return this.getModel().getDataEntityType().getAllFields().containsKey(key);
    }

    private boolean isMultiIdCard(long typeId, long personId) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long pkId = dataEntity.getLong("id");
        return this.percreService.isExistsByCredentialstype(pkId, personId, typeId);
    }

    protected void doOperationWithAttachment(List<Map<String, Object>> attachments, Set<String> removeUidSet, InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pkId = (Long)dataEntity.getPkValue();
        long credentialstypeId = dataEntity.getLong("credentialstype.id");
        if (this.TYPE_FIELD_OTHER_LIST.contains(credentialstypeId)) {
            this.percreService.saveAttachment(infoClassifyEntityKeyDTO.getSourceKey(), pkId, attachments, removeUidSet);
        } else {
            removeUidSet.addAll(attachments.stream().map(attach -> (String)attach.get("uid")).collect(Collectors.toList()));
            this.percreService.removeAttachment(infoClassifyEntityKeyDTO.getSourceKey(), pkId, removeUidSet);
        }
    }
}

