/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.infoclassify.pereduexpinfo;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ehcache.syncstatus.MemoryCacheSyncStatusMange;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPereduexpinfoService;
import kd.hr.hspm.formplugin.web.infoclassify.pereduexpinfo.PereduexpcertDynHelper;
import kd.hr.hspm.formplugin.web.infoclassify.pereduexpinfo.PereduexpinfoOcrHelper;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.dto.PereduexpcertDynDto;
import kd.sdk.hr.hspm.common.enums.PereduexpinfoFieldEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.formplugin.infoclassify.InfoClassifyEditPlugin;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.DynamicPanelUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.TemplateEditUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.edu.cert.EduCertExtHelper;
import org.apache.commons.lang.StringUtils;

public class PereduexpinfoEditPlugin
extends InfoClassifyEditPlugin
implements AfterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoEditPlugin.class);
    private static final String LABEL_HREFADDCERT = "hrefaddcert";
    private static final String TBMAIN_PEREDUEXPCERT = "tbmain_pereduexpcert";
    private static final String BTN_ADDCERT = "btnaddcert";
    private static final String FLEXPANEL_PEREDUEXPCERT = "flexpanel_pereduexpcert";
    private static final String PERCRETIPS = "percretips";
    private static final String CHOOSEEDUCERTTYPE_CLOSECALLBACK = "chooseEducerttypeCloseCallBack";
    private static final String CHOOSEEDUATTACH_CLOSECALLBACK = "chooseEduattachCloseCallBack";
    private static final String PREFIX_EDITATTACHMENTFIELDSET = "editAttachmentFieldSet_";
    private static final String PEREDUEXPCERT_DYN_LIST = "PEREDUEXPCERT_DYN_LIST";
    private static final String ALL_FIELDS = "allFields";
    private static final String PEREDUEXPCERT_TYPE_LIST = "PEREDUEXPCERT_TYPE_LIST";
    private static final String ATTACH_FILE_POSITION = "/download.do?path=/";
    private static final String ATTACH_FILE_PATH_REG = "path=/";
    private final IPereduexpinfoService pereduexpinfoService = IPereduexpinfoService.getInstance();
    private final PereduexpcertDynHelper pereduexpcertDynHelper = new PereduexpcertDynHelper();
    private final PereduexpinfoOcrHelper pereduexpinfoOcrHelper = new PereduexpinfoOcrHelper();

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        List<PereduexpcertDynDto> pereduexpcertDynDtos = this.pereduexpcertDynHelper.buildPereduexpcertDynList(Lists.newArrayList());
        this.resetFieldDtoWithReplacePoint(pereduexpcertDynDtos);
        if (!pereduexpcertDynDtos.isEmpty()) {
            args.getFormShowParameter().setCustomParam(PEREDUEXPCERT_DYN_LIST, (Object)SerializationUtils.toJsonString(pereduexpcertDynDtos));
            List<DrawFormFieldDto> drawFormFields = this.pereduexpcertDynHelper.getAllFieldsByDrawFormFieldDto(pereduexpcertDynDtos);
            args.getFormShowParameter().setCustomParam(ALL_FIELDS, (Object)SerializationUtils.toJsonString(drawFormFields));
            List certtypeList = pereduexpcertDynDtos.stream().map(PereduexpcertDynDto::getCerttype).collect(Collectors.toList());
            args.getFormShowParameter().setCustomParam(PEREDUEXPCERT_TYPE_LIST, (Object)SerializationUtils.toJsonString(certtypeList));
        }
    }

    private void resetFieldDtoWithReplacePoint(List<PereduexpcertDynDto> pereduexpcertDynDtos) {
        Map<Long, List> certIdVsDtoListMap = pereduexpcertDynDtos.stream().collect(Collectors.toMap(dyn -> dyn.getCerttype(), dyn -> dyn.getCertFieldList()));
        Map resultCertIdVsDtoListMap = EduCertExtHelper.getEduCertDto((String)"0", certIdVsDtoListMap);
        for (PereduexpcertDynDto pereduexpcertDynDto : pereduexpcertDynDtos) {
            long certtype = pereduexpcertDynDto.getCerttype();
            List drawFormFieldDtoList = (List)resultCertIdVsDtoListMap.get(certtype);
            if (CollectionUtils.isEmpty((Collection)drawFormFieldDtoList)) continue;
            pereduexpcertDynDto.setCertFieldList(drawFormFieldDtoList);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        String pereduexpcertDynDtoStr = (String)formShowParameter.getCustomParam(PEREDUEXPCERT_DYN_LIST);
        if (HRStringUtils.isEmpty((String)pereduexpcertDynDtoStr)) {
            return;
        }
        FlexPanelAp flexPanelAp = this.pereduexpcertDynHelper.loadMetas(pereduexpcertDynDtoStr, formShowParameter);
        HashMap<String, String> flexMap = new HashMap<String, String>(2);
        flexMap.put("id", "flexpanel_pereduexpcertdy");
        flexMap.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(flexMap);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType newMainType;
        super.getEntityType(args);
        String allFields = (String)this.getView().getFormShowParameter().getCustomParam(ALL_FIELDS);
        if (HRStringUtils.isEmpty((String)allFields)) {
            return;
        }
        List fieldMapList = (List)SerializationUtils.fromJsonString((String)allFields, List.class);
        List<DrawFormFieldDto> drawFormFields = this.pereduexpcertDynHelper.getAllFields(fieldMapList);
        MainEntityType oldMainType = args.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
        }
        DynamicProperty attachmentTemp = newMainType.getProperty("attachment_temp");
        drawFormFields.stream().filter(drawFormField -> HRStringUtils.equals((String)drawFormField.getClassSimpleName(), (String)"AttachmentProp")).forEach(drawFormField -> {
            try {
                AttachmentProp cloneAttachmentProp = (AttachmentProp)attachmentTemp.clone();
                cloneAttachmentProp.setName(drawFormField.getField());
                cloneAttachmentProp.setExtendName(".jpg,.png,.jpeg,.pdf");
                DynamicObjectType dynamicCollectionItemPropertyType = cloneAttachmentProp.getDynamicCollectionItemPropertyType();
                dynamicCollectionItemPropertyType.setName(drawFormField.getField());
                dynamicCollectionItemPropertyType.setExtendName(drawFormField.getField());
                newMainType.registerCollectionProperty((DynamicCollectionProperty)cloneAttachmentProp);
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
        });
        DynamicPanelUtils.registDynamicProps((MainEntityType)newMainType, drawFormFields);
        args.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String allFields = (String)this.getView().getFormShowParameter().getCustomParam(ALL_FIELDS);
        if (HRStringUtils.isEmpty((String)allFields)) {
            return;
        }
        List fieldMapList = (List)SerializationUtils.fromJsonString((String)allFields, List.class);
        List<DrawFormFieldDto> drawFormFields = this.pereduexpcertDynHelper.getAllFields(fieldMapList);
        drawFormFields.stream().filter(field -> HRStringUtils.equals((String)field.getField().toLowerCase(Locale.ROOT), (String)args.getKey())).forEach(field -> {
            if (HRStringUtils.equals((String)field.getClassSimpleName(), (String)"AttachmentProp")) {
                AttachmentEdit attachmentField = new AttachmentEdit();
                attachmentField.setKey(field.getField());
                attachmentField.setDisplayProp("name");
                attachmentField.setEditSearchProp("name");
                attachmentField.setView(this.getView());
                args.setControl((Control)attachmentField);
            } else {
                TemplateEditUtils.DRAWFIELD_TL.set(field);
                TemplateEditUtils.addGetControl((String)field.getClassSimpleName(), (String)field.getField(), (OnGetControlArgs)args, (AbstractFormPlugin)this);
            }
        });
        if (args.getKey().contains("deletecert_")) {
            args.setControl((Control)TemplateEditUtils.getLabel((String)args.getKey(), (AbstractFormPlugin)this));
            Label label = (Label)args.getControl();
            label.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject args) {
        super.afterCreateNewData(args);
        this.createControlIndex(this.getView());
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{TBMAIN_PEREDUEXPCERT});
        Label hrefaddcertLabel = (Label)this.getView().getControl(LABEL_HREFADDCERT);
        hrefaddcertLabel.addClickListener((ClickListener)this);
    }

    public void loadData(LoadDataEventArgs args) {
        super.loadData(args);
        BillView view = (BillView)this.getView();
        if (view.getStatus() != OperationStatus.ADDNEW) {
            Long pkId = (Long)args.getPkId();
            DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
            this.pereduexpinfoService.getPereduexpinfoAndSetValue(pkId, dataEntity);
            dataEntity.set("id", (Object)pkId);
            args.setDataEntity(dataEntity);
        }
    }

    public void afterLoadData(EventObject args) {
        super.afterLoadData(args);
        this.createControlIndex(this.getView());
    }

    private void createControlIndex(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String pereduexpcertDynDtoStr = (String)formShowParameter.getCustomParam(PEREDUEXPCERT_DYN_LIST);
        if (HRStringUtils.isEmpty((String)pereduexpcertDynDtoStr)) {
            return;
        }
        FlexPanelAp flexPanelAp = this.pereduexpcertDynHelper.loadMetas(pereduexpcertDynDtoStr, formShowParameter);
        Container fldPanel = (Container)formView.getControl("flexpanel_pereduexpcertdy");
        fldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        formView.createControlIndex(fldPanel.getItems());
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        BillView view = (BillView)this.getView();
        this.pereduexpinfoOcrHelper.initOcrTipsFlex((IFormView)view);
        Container container = (Container)this.getView().getControl("flexpanel_pereduexpcertdy");
        List items = container.getItems();
        for (Control item : items) {
            if (!(item instanceof Container)) continue;
            String educerttypeIdStr = item.getKey().split("_")[1];
            this.hideAdvconap(educerttypeIdStr);
        }
        this.initAdvconapCert();
        this.initRemoveAttachment();
    }

    public void afterBindData(EventObject event) {
        BillView view = (BillView)this.getView();
        OperationStatus operationStatus = view.getStatus();
        if (operationStatus != OperationStatus.ADDNEW) {
            Map pereduexpcertDyMap;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkId = (Long)dataEntity.getPkValue();
            if (operationStatus == OperationStatus.EDIT) {
                long graduateschoolId = dataEntity.getLong("graduateschool.id");
                this.setSchoolrecord(graduateschoolId);
            }
            if (operationStatus == OperationStatus.VIEW) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TBMAIN_PEREDUEXPCERT});
            }
            if (!(pereduexpcertDyMap = this.pereduexpinfoService.queryMapPereduexpcert(pkId)).isEmpty()) {
                for (Map.Entry entry : pereduexpcertDyMap.entrySet()) {
                    Long certtypeId = (Long)entry.getKey();
                    LOGGER.info("personBatchEduCert---{}", entry.getValue());
                    List<Map<String, Object>> attachments = this.getAttachments((DynamicObject)entry.getValue());
                    if (attachments != null && !attachments.isEmpty()) {
                        LOGGER.info("attachmentsBatchEduUrl---{}", attachments.get(0).get("url"));
                        this.getPageCache().put(PREFIX_EDITATTACHMENTFIELDSET + certtypeId, "1");
                        this.setAttachmentField(certtypeId, attachments);
                    }
                    this.showAdvconap(certtypeId);
                    this.putAdvconapCert(certtypeId);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{PERCRETIPS});
                this.getView().scrollIntoView(FLEXPANEL_PEREDUEXPCERT);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"schoolrecord"});
        }
        super.afterBindData(event);
    }

    private List<Map<String, Object>> getAttachments(DynamicObject dy) {
        Long pereduexpcertId = (Long)dy.getPkValue();
        List attachments = AttachmentServiceHelper.getAttachments((String)PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), (Object)pereduexpcertId, (String)"attachmentpanelap_std", (boolean)false);
        if (attachments != null && attachments.size() > 0) {
            attachments.forEach(attach -> {
                try {
                    String url = (String)attach.get("url");
                    if (HRStringUtils.isNotEmpty((String)url) && url.length() > 500) {
                        attach.put("lastModified", null);
                        attach.put("url", this.getPathfromDownloadUrl(URLDecoder.decode(url, "UTF-8")));
                    }
                }
                catch (IOException err) {
                    LOGGER.error("tranferError", (Throwable)err);
                }
            });
        }
        return attachments;
    }

    private String getPathfromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        return URLDecoder.decode(path, "UTF-8");
    }

    private void setAttachmentField(Long certtypeId, List<Map<String, Object>> attachments) {
        if (!attachments.isEmpty()) {
            Set uid = attachments.stream().map(att -> att.get("uid")).collect(Collectors.toSet());
            PereduexpcertDynHelper.BD_ATTACHMENT_HELPER.deleteByFilter(new QFilter[]{new QFilter("uid", "in", uid)});
            AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment_" + certtypeId);
            attachmentEdit.postBack(attachments, -1, -1);
        }
    }

    private void setSchoolrecord(long graduateschoolId) {
        if (graduateschoolId == HspmCommonConstants.OTHER_SCHOOL_BOID) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"schoolrecord"});
        } else {
            this.getModel().getDataEntity().set("schoolrecord", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"schoolrecord"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object oldValue = args.getChangeSet()[0].getOldValue();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (key) {
            case "graduateschool": {
                DynamicObject graduateschoolDy = (DynamicObject)newValue;
                if (graduateschoolDy == null) {
                    this.getModel().getDataEntity().set("schoolrecord", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"schoolrecord"});
                } else {
                    long graduateschoolId = graduateschoolDy.getLong("id");
                    this.setSchoolrecord(graduateschoolId);
                }
                this.getView().updateView("schoolrecord");
                break;
            }
            case "ishighestdegree": {
                if (HRObjectUtils.isEmpty((Object)newValue)) {
                    return;
                }
                if (!HRStringUtils.equals((String)((String)newValue), (String)"1")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6559\u80b2\u7ecf\u5386\u5c06\u6210\u4e3a\u6700\u9ad8\u5b66\u5386\u3002", (String)"PereduexpinfoEditPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "person": {
                DynamicObject personDy = (DynamicObject)newValue;
                if (personDy == null) {
                    return;
                }
                int count = this.pereduexpinfoService.queryExistsByPersonId(personDy.getLong("id"));
                if (count == 0) {
                    dataEntity.set("ishighestdegree", (Object)"1");
                } else {
                    dataEntity.set("ishighestdegree", null);
                }
                this.getView().updateView("ishighestdegree");
                break;
            }
        }
        if (key.contains("attachment_")) {
            DynamicObjectCollection attachmentValue;
            long educerttypeId = Long.parseLong(key.split("_")[1]);
            DynamicObjectCollection attachmentOldValue = (DynamicObjectCollection)oldValue;
            if (!HRObjectUtils.isEmpty((Object)attachmentOldValue) && !attachmentOldValue.isEmpty()) {
                DynamicObject attachmentOldDy = ((DynamicObject)attachmentOldValue.get(0)).getDynamicObject("fbasedataid");
                this.removeEducerttypeAttachment(dataEntity, educerttypeId, attachmentOldDy.getString("uid"), false);
            }
            if ((attachmentValue = (DynamicObjectCollection)newValue) == null || attachmentValue.isEmpty()) {
                return;
            }
            String editAttachmentFieldFlag = this.getPageCache().get(PREFIX_EDITATTACHMENTFIELDSET + educerttypeId);
            if (HRStringUtils.isNotEmpty((String)editAttachmentFieldFlag) && HRStringUtils.equals((String)editAttachmentFieldFlag, (String)"1")) {
                this.getPageCache().remove(PREFIX_EDITATTACHMENTFIELDSET + educerttypeId);
                return;
            }
            DynamicObject attachmentDy = ((DynamicObject)attachmentValue.get(0)).getDynamicObject("fbasedataid");
            this.pereduexpinfoOcrHelper.setOCRValue(this.getView(), educerttypeId, attachmentDy.getString("url"));
        }
    }

    protected List<String> getHisBaseDataEntityList() {
        List hisBaseDataEntityList = super.getHisBaseDataEntityList();
        hisBaseDataEntityList.add("hbss_college");
        return hisBaseDataEntityList;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)LABEL_HREFADDCERT, (String)key)) {
            Set<String> educerttypeIdSet = this.hasAttachmentEducerttypeIdSet(dataEntity);
            FormShowParameter showParameter = this.openEducerttypeAttachForm(educerttypeIdSet);
            this.getView().showForm(showParameter);
        } else if (key.contains("deletecert_")) {
            LOGGER.info("PereduexpinfoEditPlugin#click key: {}", (Object)key);
            String educerttypeIdStr = key.split("_")[1];
            this.hideAdvconap(educerttypeIdStr);
            this.cleanAdvconapValue(Long.parseLong(educerttypeIdStr));
            this.removeAdvconapCert(educerttypeIdStr);
            this.getView().setVisible(Boolean.valueOf(this.checkAdvconapCert()), new String[]{PERCRETIPS});
        }
    }

    private Set<String> hasAttachmentEducerttypeIdSet(DynamicObject dataEntity) {
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        HashSet<String> educerttypeIdSet = new HashSet<String>();
        if (!advconapCertMap.isEmpty()) {
            for (Map.Entry entry : advconapCertMap.entrySet()) {
                String itemKey = (String)entry.getKey();
                String operatetype = (String)entry.getValue();
                if (!HRStringUtils.equals((String)operatetype, (String)"1")) continue;
                String educerttypeIdStr = itemKey.split("_")[1];
                DynamicObjectCollection attachmentfield = dataEntity.getDynamicObjectCollection("attachment_" + educerttypeIdStr);
                if (attachmentfield.isEmpty()) continue;
                educerttypeIdSet.add(educerttypeIdStr);
            }
        }
        return educerttypeIdSet;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_ADDCERT.equals(itemKey)) {
            ListShowParameter showParameter = this.openEducerttypeForm();
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public FormShowParameter openEducerttypeAttachForm(Set<String> educerttypeIdSet) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hspm_eduattach");
        showParameter.setCustomParam("hasAttachEducerttype", (Object)SerializationUtils.toJsonString(educerttypeIdSet));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHOOSEEDUATTACH_CLOSECALLBACK));
        showParameter.setHasRight(true);
        OpenStyle style = this.getOpenStyle();
        showParameter.setOpenStyle(style);
        return showParameter;
    }

    public ListShowParameter openEducerttypeForm() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hbss_educerttype");
        showParameter.setFormId("bos_listf7");
        showParameter.setMultiSelect(true);
        showParameter.setShowApproved(false);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHOOSEEDUCERTTYPE_CLOSECALLBACK));
        showParameter.setHasRight(true);
        List filters = showParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        OpenStyle style = this.getOpenStyle();
        showParameter.setOpenStyle(style);
        return showParameter;
    }

    private OpenStyle getOpenStyle() {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("880px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        return style;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CHOOSEEDUCERTTYPE_CLOSECALLBACK.equals(actionId)) {
            Long educerttypeId;
            Object returnData = closedCallBackEvent.getReturnData();
            if (HRObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            ArrayList<String> existsEducerttypeList = new ArrayList<String>();
            for (ListSelectedRow row : selectedRows) {
                educerttypeId = (Long)row.getPrimaryKeyValue();
                if (this.checkCerttype(educerttypeId)) continue;
                LOGGER.info("PereduexpinfoEditPlugin#closedCallBack CHOOSEEDUCERTTYPE_CLOSECALLBACK educerttypeId has not flexAp: {}", (Object)educerttypeId);
                return;
            }
            for (ListSelectedRow row : selectedRows) {
                educerttypeId = (Long)row.getPrimaryKeyValue();
                LOGGER.info("PereduexpinfoEditPlugin#closedCallBack chooseEducerttypeCloseCallBack row.getPrimaryKeyValue: {}", (Object)educerttypeId);
                if (this.containsAdvconapCert(educerttypeId)) {
                    existsEducerttypeList.add(row.getName());
                    continue;
                }
                this.showAdvconap(educerttypeId);
                this.putAdvconapCert(educerttypeId);
                this.getView().setVisible(Boolean.FALSE, new String[]{PERCRETIPS});
                this.getView().scrollIntoView(FLEXPANEL_PEREDUEXPCERT);
            }
            if (!existsEducerttypeList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6559\u80b2\u8bc1\u4ef6\u7c7b\u578b\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PereduexpinfoEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), HRStringUtils.arrayToString((Object[])existsEducerttypeList.toArray(), (String)",")));
            }
        } else if (CHOOSEEDUATTACH_CLOSECALLBACK.equals(actionId)) {
            String idAndIndexMapStr = this.getPageCache().get("idandindexmapstr");
            if (HRStringUtils.isEmpty((String)idAndIndexMapStr)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkId = (Long)dataEntity.getPkValue();
            Map attachIndexAndCerttypeIdMap = (Map)SerializationUtils.fromJsonString((String)idAndIndexMapStr, Map.class);
            Map indexAttachMapList = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("attachmap"), Map.class);
            if (CollectionUtils.isEmpty((Map)indexAttachMapList)) {
                return;
            }
            for (Map.Entry entry : attachIndexAndCerttypeIdMap.entrySet()) {
                String educerttypeIdStr = (String)entry.getValue();
                long educerttypeId = Long.parseLong(educerttypeIdStr);
                if (this.checkCerttype(educerttypeId)) continue;
                LOGGER.info("PereduexpinfoEditPlugin#closedCallBack CHOOSEEDUATTACH_CLOSECALLBACK educerttypeId has not flexAp: {}", (Object)educerttypeId);
                return;
            }
            for (Map.Entry entry : attachIndexAndCerttypeIdMap.entrySet()) {
                String index = (String)entry.getKey();
                String educerttypeIdStr = (String)entry.getValue();
                List attachmentMapList = (List)indexAttachMapList.get(index);
                if (CollectionUtils.isEmpty((Collection)attachmentMapList)) continue;
                LOGGER.info("PereduexpinfoEditPlugin#closedCallBack chooseEduattachCloseCallBack row.getPrimaryKeyValue: {}", (Object)educerttypeIdStr);
                long educerttypeId = Long.parseLong(educerttypeIdStr);
                if (!this.containsAdvconapCert(educerttypeId)) {
                    this.showAdvconap(educerttypeId);
                    this.putAdvconapCert(educerttypeId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{PERCRETIPS});
                    this.getView().scrollIntoView(FLEXPANEL_PEREDUEXPCERT);
                }
                List<Map<String, Object>> attachments = this.buildAttachmentDataFromEdit(PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), attachmentMapList);
                DynamicObject pereduexpcertDy = this.pereduexpinfoService.getPereduexpcertIdByPereduexpIdAndCerttypeId(pkId, Long.parseLong(educerttypeIdStr));
                if (!HRObjectUtils.isEmpty((Object)pereduexpcertDy)) {
                    long pereducertId = pereduexpcertDy.getLong("id");
                    attachments.get(0).put("billPkId", pereducertId);
                }
                this.getPageCache().put(PREFIX_EDITATTACHMENTFIELDSET + educerttypeId, "1");
                this.setAttachmentField(educerttypeId, attachments);
                this.pereduexpinfoOcrHelper.setOCRValue(this.getView(), educerttypeId, (String)attachments.get(0).get("url"));
            }
        }
    }

    private boolean checkCerttype(Long educerttypeId) {
        boolean result;
        String pereduexpcerTypeListStr = (String)this.getView().getFormShowParameter().getCustomParam(PEREDUEXPCERT_TYPE_LIST);
        if (HRStringUtils.isEmpty((String)pereduexpcerTypeListStr)) {
            result = false;
        } else {
            List pereduexpcerTypeList = SerializationUtils.fromJsonStringToList((String)pereduexpcerTypeListStr, Long.class);
            result = pereduexpcerTypeList.contains(educerttypeId);
        }
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6559\u80b2\u8bc1\u4ef6\u7c7b\u578b\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u9000\u51fa\u7f16\u8f91\u9875\u9762\u540e\u518d\u6b21\u8fdb\u5165\u3002", (String)"PereduexpinfoEditPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private void hideAdvconap(String educerttypeIdStr) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap_" + educerttypeIdStr});
        if (1030L == Long.parseLong(educerttypeIdStr)) {
            this.setMustInput("authcertnumber_" + educerttypeIdStr, false);
        } else {
            this.setMustInput("number_" + educerttypeIdStr, false);
        }
        this.getView().updateView("advconap_" + educerttypeIdStr);
    }

    private void cleanAdvconapValue(long educerttypeId) {
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)("number_" + educerttypeId))) {
            dataEntity.set("number_" + educerttypeId, null);
            view.updateView("number_" + educerttypeId);
        }
        if (properties.containsKey((Object)("isauthenticated_" + educerttypeId))) {
            dataEntity.set("isauthenticated_" + educerttypeId, null);
            view.updateView("isauthenticated_" + educerttypeId);
        }
        if (properties.containsKey((Object)("authcertnumber_" + educerttypeId))) {
            dataEntity.set("authcertnumber_" + educerttypeId, null);
            view.updateView("authcertnumber_" + educerttypeId);
        }
        this.deleteAttachment(educerttypeId, dataEntity);
        view.updateView("fs_certinfo_" + educerttypeId);
        LOGGER.info("PereduexpinfoEditPlugin#cleanAdvconapValue dataEntity: {}", (Object)dataEntity);
    }

    private void deleteAttachment(long educerttypeId, DynamicObject dataEntity) {
        DynamicObjectCollection attachmentValue = dataEntity.getDynamicObjectCollection("attachment_" + educerttypeId);
        if (!attachmentValue.isEmpty()) {
            DynamicObject attachmentDy = ((DynamicObject)attachmentValue.get(0)).getDynamicObject("fbasedataid");
            ArrayList attachList = new ArrayList();
            HashMap<String, Object> attach = new HashMap<String, Object>(16);
            attach.put("delete", Boolean.TRUE);
            attach.put("uid", attachmentDy.getString("uid"));
            attach.put("url", attachmentDy.getString("url"));
            attach.put("description", attachmentDy.get("description"));
            attach.put("type", attachmentDy.getString("type"));
            attach.put("name", attachmentDy.getString("name"));
            attach.put("size", attachmentDy.getLong("size"));
            attach.put("status", "success");
            attach.put("lastModified", attachmentDy.getDate("modifytime").getTime());
            attach.put("uploadTime", attachmentDy.getDate("createtime").getTime());
            attach.put("attKey", "attachment_" + educerttypeId);
            attach.put("client", "web");
            attachList.add(attach);
            AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment_" + educerttypeId);
            attachmentEdit.postBack(attachList, -1, -1);
        }
    }

    private void showAdvconap(Long educerttypeId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconap_" + educerttypeId});
        this.getView().updateView("advconap_" + educerttypeId);
    }

    public void initAdvconapCert() {
        HashMap advconapCertMap = new HashMap(16);
        this.getPageCache().put("advconap_", SerializationUtils.toJsonString(advconapCertMap));
    }

    public boolean checkAdvconapCert() {
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        if (advconapCertMap.isEmpty()) {
            return true;
        }
        for (Object educerttype : advconapCertMap.values()) {
            if (!HRStringUtils.equals((String)((String)educerttype), (String)"1")) continue;
            return false;
        }
        return true;
    }

    public void removeAdvconapCert(String educerttypeIdStr) {
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        advconapCertMap.put("advconap_" + educerttypeIdStr, "0");
        this.getPageCache().put("advconap_", SerializationUtils.toJsonString((Object)advconapCertMap));
    }

    private void putAdvconapCert(Long educerttypeId) {
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        advconapCertMap.put("advconap_" + educerttypeId, "1");
        this.getPageCache().put("advconap_", SerializationUtils.toJsonString((Object)advconapCertMap));
    }

    private boolean containsAdvconapCert(Long educerttypeId) {
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        return advconapCertMap.containsKey("advconap_" + educerttypeId) && HRStringUtils.equals((String)((String)advconapCertMap.get("advconap_" + educerttypeId)), (String)"1");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        LOGGER.info("PereduexpinfoEditPlugin#beforeDoOperation advconapCertMap: {}", (Object)advconapCertMap);
        advconapCertMap.forEach((itemKey, value) -> {
            String operatetype = (String)value;
            String educerttypeIdStr = itemKey.split("_")[1];
            if (HRStringUtils.equals((String)operatetype, (String)"1")) {
                dataEntity.set("operatetype_" + educerttypeIdStr, (Object)"1");
            } else {
                BillView view = (BillView)this.getView();
                if (view.getStatus() == OperationStatus.EDIT) {
                    DynamicObjectCollection attachmentValue = dataEntity.getDynamicObjectCollection("attachment_" + educerttypeIdStr);
                    String uid = "";
                    if (!attachmentValue.isEmpty()) {
                        DynamicObject attachmentDy = ((DynamicObject)attachmentValue.get(0)).getDynamicObject("fbasedataid");
                        uid = attachmentDy.getString("uid");
                    }
                    this.removeEducerttypeAttachment(dataEntity, Long.parseLong(educerttypeIdStr), uid, true);
                }
            }
        });
    }

    private void removeEducerttypeAttachment(DynamicObject dataEntity, long educerttypeId, String uid, boolean pereduexpcertRemoveFlag) {
        DynamicObject pereduexpcertDy;
        Long pkId = (Long)dataEntity.getPkValue();
        if (pkId != null && pkId > 0L && !HRObjectUtils.isEmpty((Object)(pereduexpcertDy = this.pereduexpinfoService.getPereduexpcertIdByPereduexpIdAndCerttypeId(pkId, educerttypeId)))) {
            if (!HRStringUtils.isEmpty((String)uid)) {
                this.putRemoveAttachment(pereduexpcertDy.getLong("id"), uid);
            }
            if (pereduexpcertRemoveFlag) {
                dataEntity.set("operatetype_" + educerttypeId, (Object)"0");
            }
        }
    }

    private void initRemoveAttachment() {
        HashMap attachmentMap = new HashMap(16);
        this.getPageCache().put("attachment_", SerializationUtils.toJsonString(attachmentMap));
    }

    private Map<String, List<String>> getRemoveAttachment() {
        return (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("attachment_"), Map.class);
    }

    private void putRemoveAttachment(Long pkId, String uid) {
        Map<String, List<String>> attachmentMap = this.getRemoveAttachment();
        List<String> uidSet = attachmentMap.get(String.valueOf(pkId));
        if (CollectionUtils.isEmpty(uidSet)) {
            uidSet = new ArrayList<String>();
        }
        uidSet.add(uid);
        attachmentMap.put(String.valueOf(pkId), uidSet);
        this.getPageCache().put("attachment_", SerializationUtils.toJsonString(attachmentMap));
    }

    protected void saveOrUpdateAfterDoOperation() {
        this.doOperationWithAttachment();
        super.saveOrUpdateAfterDoOperation();
    }

    private void doOperationWithAttachment() {
        Map<String, List<String>> removeAttachmentMap;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pkId = (Long)dataEntity.getPkValue();
        Map advconapCertMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("advconap_"), Map.class);
        HashSet<Long> allPereducertRemoveSet = new HashSet<Long>();
        if (!advconapCertMap.isEmpty()) {
            for (Map.Entry entry : advconapCertMap.entrySet()) {
                String itemKey = (String)entry.getKey();
                String operatetype = (String)entry.getValue();
                if (!HRStringUtils.equals((String)operatetype, (String)"1")) continue;
                String educerttypeIdStr = itemKey.split("_")[1];
                DynamicObjectCollection attachmentfield = dataEntity.getDynamicObjectCollection("attachment_" + educerttypeIdStr);
                if (attachmentfield.isEmpty()) continue;
                LOGGER.info("PereduexpinfoEditPlugin#doOperationWithAttachment pkId: {}, educerttypeId: {}", (Object)pkId, (Object)educerttypeIdStr);
                DynamicObject pereduexpcertDy = this.pereduexpinfoService.getPereduexpcertIdByPereduexpIdAndCerttypeId(pkId, Long.parseLong(educerttypeIdStr));
                long pereducertId = pereduexpcertDy.getLong("id");
                List<Map<String, Object>> attachDataMap = this.buildAttachmentDataFromEdit(PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), pereducertId, attachmentfield);
                allPereducertRemoveSet.add(pereducertId);
                AttachmentServiceHelper.upload((String)PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), (Object)pereducertId, (String)"attachmentpanelap_std", attachDataMap);
            }
        }
        if (!(removeAttachmentMap = this.getRemoveAttachment()).isEmpty()) {
            removeAttachmentMap.forEach((key, value) -> {
                if (allPereducertRemoveSet.contains(Long.parseLong(key))) {
                    this.pereduexpinfoService.removeAttachment(PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), Long.valueOf(Long.parseLong(key)), new HashSet(value));
                } else {
                    this.pereduexpinfoService.removeAttachment(PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), Collections.singletonList(Long.parseLong(key)));
                }
            });
        }
    }

    private List<Map<String, Object>> buildAttachmentDataFromEdit(String entityNum, Long pkId, DynamicObjectCollection sourceAttachCol) {
        ArrayList<Map<String, Object>> attachDataMap = new ArrayList<Map<String, Object>>();
        sourceAttachCol.forEach(attach -> {
            DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
            HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
            attachMap.put("description", attachObj.getString("description"));
            attachMap.put("type", attachObj.getString("type"));
            String url = attachObj.getString("url");
            if (url.contains("tempfile/download.do?configKey")) {
                url = BusinessUtils.getDownUrl((DynamicObject)attachObj);
            } else if (url.contains(ATTACH_FILE_POSITION)) {
                try {
                    url = URLDecoder.decode(url, "utf-8");
                    url = url.split(ATTACH_FILE_PATH_REG)[1];
                    while (url.startsWith("//")) {
                        url = url.replace("//", "/");
                    }
                }
                catch (Exception exp) {
                    throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
                }
            }
            attachMap.put("url", url);
            String uid = attachObj.getString("uid");
            if (HRStringUtils.isEmpty((String)uid)) {
                uid = MemoryCacheSyncStatusMange.getUid() + "";
            }
            attachMap.put("uid", uid);
            attachMap.put("name", attachObj.getString("name"));
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", "attachmentpanel");
            attachMap.put("entityNum", entityNum);
            attachMap.put("billPkId", pkId);
            attachMap.put("lastModified", System.currentTimeMillis());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataMap.add(attachMap);
        });
        return attachDataMap;
    }

    public List<Map<String, Object>> buildAttachmentDataFromEdit(String entityNum, List<Map<String, Object>> attachObjList) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> attachObj : attachObjList) {
            HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
            attachMap.put("type", attachObj.get("type"));
            attachMap.put("description", LocaleString.fromMap((Map)((LinkedHashMap)attachObj.get("description"))).getLocaleValue());
            String name = LocaleString.fromMap((Map)((LinkedHashMap)attachObj.get("name"))).getLocaleValue();
            attachMap.put("name", name);
            String url = (String)attachObj.get("url");
            String saveUrl = this.getAttachUrl(url, name);
            attachMap.put("url", saveUrl);
            String uid = (String)attachObj.get("uid");
            if (HRStringUtils.isEmpty((String)uid)) {
                uid = MemoryCacheSyncStatusMange.getUid() + "";
            }
            attachMap.put("uid", uid);
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", "attachmentpanel");
            attachMap.put("entityNum", entityNum);
            attachMap.put("lastModified", System.currentTimeMillis());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        }
        return attachDataList;
    }

    private String getAttachUrl(String url, String name) {
        LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl url: {}", (Object)url);
        if (url.contains(ATTACH_FILE_POSITION)) {
            try {
                url = URLDecoder.decode(url, "utf-8");
                String path = url.split(ATTACH_FILE_PATH_REG)[1];
                LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl path: {}", (Object)path);
                String attach = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
                LOGGER.info("PereduexpinfoEditPlugin#getAttachUrl attach: {}", (Object)attach);
                InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attach);
                String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(name, (InputStream)new BufferedInputStream(inputStream), 7200);
                LOGGER.info("PereduexpinfoEditPlugin#saveUrl saveUrl: {}", (Object)saveUrl);
                return saveUrl;
            }
            catch (Exception exp) {
                throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
        }
        return url;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

