/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.mobile.absbase;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.mobile.file.base.AbstractMobileFormDrawEdit;

public class ContactDrawMobilePlugin
extends AbstractMobileFormDrawEdit {
    private static Log logger = LogFactory.getLog(ContactDrawMobilePlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hrpi_percontact");
        super.loadCustomControlMetas(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.setValueFromDb(formShowParameter, "hrpi_percontact", "person");
        String status = (String)this.getView().getFormShowParameter().getCustomParam("cus_status");
        if ("cus_edit".equals(status)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("btn_edit".equals(source.getKey())) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().getFormShowParameter().setCustomParam("cus_status", (Object)"cus_edit");
            this.getView().invokeOperation("refresh");
            this.getView().updateView();
        } else if ("btn_save".equals(source.getKey())) {
            DynamicObject dy = this.getModel().getDataEntity();
            if (PropertyHelper.existProperty((DynamicObject)dy, (String)"hrpi_percontact-phone") && !this.checkUniqueness(dy.getString("hrpi_percontact-phone"), 1)) {
                return;
            }
            if (PropertyHelper.existProperty((DynamicObject)dy, (String)"hrpi_percontact-peremail") && (this.checkMailError(dy.getString("hrpi_percontact-peremail"), "0") || !this.checkUniqueness(dy.getString("hrpi_percontact-peremail"), 3))) {
                return;
            }
            if (PropertyHelper.existProperty((DynamicObject)dy, (String)"hrpi_percontact-busemail") && this.checkMailError(dy.getString("hrpi_percontact-busemail"), "1")) {
                return;
            }
            this.acrossEntitySaveOrUpdate();
        }
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, true);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("hrpi_percontact-phone".equals(name)) {
            Object value = args.getChangeSet()[0].getNewValue();
            if (value != null && HRStringUtils.isNotEmpty((String)value.toString())) {
                this.checkUniqueness(value.toString(), 1);
            }
        } else if ("hrpi_percontact-peremail".equals(name)) {
            Object value = args.getChangeSet()[0].getNewValue();
            if (value != null && HRStringUtils.isNotEmpty((String)value.toString())) {
                this.checkMailError(value, "0");
                this.checkUniqueness(value.toString(), 3);
            }
        } else if ("hrpi_percontact-busemail".equals(name)) {
            Object emailObj = args.getChangeSet()[0].getNewValue();
            this.checkMailError(emailObj, "1");
        }
    }

    private boolean checkMailError(Object emailObj, String type) {
        String error = null;
        if (emailObj != null && HRStringUtils.isNotEmpty((String)emailObj.toString()) && !BusinessUtils.isEmail((String)emailObj.toString())) {
            if ("1".equals(type)) {
                error = ResManager.loadKDString((String)"\u201c\u516c\u53f8\u7535\u5b50\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContactDrawMobilePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            } else if ("0".equals(type)) {
                error = ResManager.loadKDString((String)"\u201c\u4e2a\u4eba\u7535\u5b50\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContactDrawMobilePlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(error);
            return true;
        }
        return false;
    }

    private boolean checkUniqueness(String value, int type) {
        if (HRStringUtils.isNotEmpty((String)value)) {
            Long personid = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            Tuple checkResult = null;
            if (1 == type) {
                checkResult = UniquenessCheckUtil.checkPhone((long)personid, (String)value, (boolean)false);
            } else if (3 == type) {
                checkResult = UniquenessCheckUtil.checkPerEmail((long)personid, (String)value, (boolean)false);
            }
            if (checkResult != null && !((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return false;
            }
        }
        return true;
    }
}

