/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.mobile.absbase;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.approval.ApprovalMulLineTableOrderHelper;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.MultiViewTemplateService;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.constants.DynConfigConstants;
import kd.sdk.hr.hspm.common.constants.ScheduleDrawConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.enums.OrderEnum;
import kd.sdk.hr.hspm.common.ext.file.EmployeeBillParamsDTO;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.ApCreateUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.MobileBillDetailExtUtil;

public class EntryDetailMobileDrawEdit
extends AbstractMobFormPlugin
implements DynConfigConstants,
ScheduleDrawConstants,
UploadListener {
    private static final Log logger = LogFactory.getLog(EntryDetailMobileDrawEdit.class);
    private String IS_FIRST = "isFirstOpen";
    private static String CANCEL = "cancel";
    private List<Map<String, Object>> groupsInfo;
    private List<Map<String, Object>> headGroups;
    private static HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_infoapproval");

    public void beforeBindData(EventObject e) {
        this.getView().setStatus(OperationStatus.VIEW);
        DynamicObject entry = this.getBill();
        if (entry == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"AbstractFormDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        super.beforeBindData(e);
        Map<Object, List<Map<String, Object>>> listMap = this.getGroupsInfo();
        if (listMap == null) {
            return;
        }
        this.groupsInfo = listMap.get("groups");
        this.headGroups = listMap.get("headentity");
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("container");
        flexPanelAp.setId("container");
        flexPanelAp.setName(new LocaleString("content"));
        flexPanelAp.setWrap(false);
        flexPanelAp.setDirection("column");
        flexPanelAp.setJustifyContent("stretch");
        flexPanelAp.setAlignItems("stretch");
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        flexPanelAp.setOverflow("hidden");
        DynamicObjectCollection entryentity = entry.getDynamicObjectCollection("entryentity");
        this.drawContent(flexPanelAp, entryentity);
        this.setMemberVisibility();
        if (ApprovalHelper.isCanWithDraw((DynamicObject)entry)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mtoolbarap"});
        }
        if (!CommonUtil.hasPerm((String)"hspm_infoapproval", (String)"80513207000000ac", (String)"hssc", (IFormView)this.getView()) && PermCommonUtil.isEnableNoPermBtnHide()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
        }
        this.setTitleLabel();
        MultiViewTemplateService.getInstance().setApToView(flexPanelAp, "container", this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject entry = this.getBill();
        this.showConfirmWhenFirstOpen(false, entry);
    }

    private DynamicObject getBill() {
        Object billno = this.getModel().getValue("billno");
        QFilter billnoFilter = new QFilter("billno", "=", billno);
        return SERVICE_HELPER.loadDynamicObject(billnoFilter);
    }

    private void showConfirmWhenFirstOpen(boolean isClick, DynamicObject entry) {
        String flag = PageCacheUtils.getHomePageCache((IFormView)this.getView().getViewNoPlugin(this.getView().getPageId())).get(this.IS_FIRST);
        if (flag != null && !isClick) {
            return;
        }
        if (entry == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"AbstractFormDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        String billStatus = entry.getString("billstatus");
        if (!"G".equals(billStatus)) {
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5173\u95ed", (String)"AbstractMobileFormDrawEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7\u8bf4\u660e", (String)"AbstractMobileFormDrawEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), this.getPageCache().get("notpassinfo"), MessageBoxOptions.OK, ConfirmTypes.Default, null, btnNameMaps);
        PageCacheUtils.getHomePageCache((IFormView)this.getView()).put(this.IS_FIRST, String.valueOf(true));
    }

    private void setMemberVisibility() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"closepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"openmorepanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"container"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"switchtohome"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"notpassinfo"});
    }

    private void setTitleLabel() {
        Label label = (Label)this.getControl("labelap");
        DynamicObject person = this.getModel().getDataEntity().getDynamicObject("person");
        if (label == null) {
            return;
        }
        if (person != null) {
            label.setText(String.format(ResManager.loadKDString((String)"%s\u7684\u4eba\u5458\u6863\u6848\u4fe1\u606f\u53d8\u66f4\u7533\u8bf7", (String)"InfoApprovalListPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), person.get("name")));
        }
    }

    private void drawHeadContent(String type, FlexPanelAp flexPanelAp, DynamicObject dynamicObject, String targetKey, String groupName, String displayName) {
        FlexPanelAp groupFlexAp = ApCreateUtils.createFlexAp((String)(targetKey.toLowerCase(Locale.ROOT) + dynamicObject.getLong("dataid") + type + "-groupflex"), (String)groupName);
        groupFlexAp.setDirection("column");
        groupFlexAp.setBackColor("#FAFAFA");
        Style style = new Style();
        groupFlexAp.setStyle(style);
        Padding padding = new Padding();
        style.setPadding(padding);
        padding.setTop("12px");
        padding.setLeft("12px");
        padding.setRight("12px");
        Margin margin = new Margin();
        style.setMargin(margin);
        margin.setTop("12px");
        margin.setBottom("12px");
        FlexPanelAp lineFlexAp = ApCreateUtils.createFlexAp((String)(dynamicObject.get("fieldname") + "lineFlexap" + dynamicObject.getLong("dataid") + type), (String)displayName);
        lineFlexAp.setGrow(0);
        lineFlexAp.setWidth(new LocaleString("100%"));
        this.setApStyle((ControlAp)lineFlexAp, this.getMargin("0px", "0px", "0px", "12px"), null);
        String newvalue = dynamicObject.getString("newvalue");
        String oldvalue = dynamicObject.getString("oldvalue");
        String current = type.equals("after") ? newvalue : oldvalue;
        this.pictureDeal(type, dynamicObject.getLong("dataid"), "headsculpture", displayName, lineFlexAp, current);
        groupFlexAp.getItems().add(lineFlexAp);
        if (type.equals("before")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{targetKey.toLowerCase(Locale.ROOT) + dynamicObject.getLong("dataid") + type + "-groupflex"});
        }
        flexPanelAp.getItems().add(groupFlexAp);
    }

    private void drawContent(FlexPanelAp flexPanelAp, DynamicObjectCollection entryentity) {
        for (Map<String, Object> headGroup : this.headGroups) {
            if (!headGroup.get("number").equals("headsculpture")) continue;
            List list = entryentity.stream().filter(arg -> arg.getString("firstgroupnum").equals("0000") && arg.get("fieldname").equals("headsculpture")).collect(Collectors.toList());
            for (DynamicObject dynamicObject2 : list) {
                if (dynamicObject2.getBoolean("status") && !dynamicObject2.getBoolean("change")) {
                    this.appendInfo(dynamicObject2, dynamicObject2.getString("displayname"));
                    continue;
                }
                boolean noPassWhenAdd = !dynamicObject2.getBoolean("isnew") && dynamicObject2.getBoolean("status");
                this.drawTitlePanel(flexPanelAp, "0000", ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"MobileHomeTemplatePlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), dynamicObject2, noPassWhenAdd, "hrpi_person", 0);
                this.drawHeadContent("before", flexPanelAp, dynamicObject2, "0000", ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"MobileHomeTemplatePlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), String.valueOf(headGroup.get("name")));
                this.drawHeadContent("after", flexPanelAp, dynamicObject2, "0000", ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"MobileHomeTemplatePlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), String.valueOf(headGroup.get("name")));
            }
        }
        ArrayList<DrawFormFieldDto> drawList = new ArrayList<DrawFormFieldDto>();
        List eduCertList = entryentity.stream().filter(arg -> arg.getString("entityname").equals("hrpi_pereduexpcert")).collect(Collectors.toList());
        List collect = eduCertList.stream().map(dynamicObject -> dynamicObject.getLong("dataid")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
        DynamicObject[] eduCertDyArr = serviceHelper.query("id,pereduexp", new QFilter[]{new QFilter("id", "in", collect)});
        Map<Long, List<DynamicObject>> eduMap = Arrays.stream(eduCertDyArr).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("pereduexp.id")));
        eduMap.entrySet().forEach(entry -> {
            List longList = ((List)entry.getValue()).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            List certOfEduEpx = entryentity.stream().filter(dynamicObject -> longList.contains(dynamicObject.getLong("dataid"))).collect(Collectors.toList());
            entry.setValue(certOfEduEpx);
        });
        Map entityNameVsOrderStrMap = ApprovalMulLineTableOrderHelper.treatExtOrderParam();
        for (Map<String, Object> map : this.groupsInfo) {
            List<DynamicObject> list = entryentity.stream().filter(arg -> arg.getString("firstgroupnum").equals(map.get("targetkey"))).collect(Collectors.toList());
            Map<Long, List<DynamicObject>> sortedDataLinkedMap = this.getSortedIdVsDynListMap(entityNameVsOrderStrMap, list);
            Map<String, List<DynamicObject>> entityMap = list.stream().collect(Collectors.groupingBy(arg -> arg.getString("entityname")));
            List groups = (List)map.get("groups");
            for (int i = 0; i < groups.size(); ++i) {
                drawList.addAll(this.formatFlexFields((Map)groups.get(i), map));
            }
            for (Map.Entry<Long, List<DynamicObject>> longListEntry : sortedDataLinkedMap.entrySet()) {
                boolean anyFieldNotPass;
                boolean allFieldNew;
                Long dataid = longListEntry.getKey();
                List<DynamicObject> longListEntryValue = longListEntry.getValue();
                String entityName = longListEntryValue.get(0).getString("entityname");
                if (longListEntryValue == null || longListEntryValue.size() <= 0) continue;
                if (entityName.equals("hrpi_pereduexpcert")) {
                    Set<Long> set = eduMap.keySet();
                    boolean anyMatch = entryentity.stream().anyMatch(arg -> set.contains(arg.getLong("dataid")));
                    if (anyMatch) continue;
                }
                boolean noPassWhenAdd = false;
                if (longListEntryValue != null && longListEntryValue.size() > 0) {
                    allFieldNew = longListEntryValue.stream().allMatch(arg -> arg.getBoolean("isdel"));
                    anyFieldNotPass = longListEntryValue.stream().anyMatch(arg -> arg.getBoolean("status"));
                    boolean bl = noPassWhenAdd = allFieldNew && anyFieldNotPass;
                }
                if (eduMap.get(dataid) != null) {
                    longListEntryValue.addAll((Collection<DynamicObject>)eduMap.get(dataid));
                    allFieldNew = longListEntryValue.stream().allMatch(arg -> arg.getBoolean("isdel"));
                    anyFieldNotPass = longListEntryValue.stream().anyMatch(arg -> arg.getBoolean("status"));
                    noPassWhenAdd = allFieldNew && anyFieldNotPass;
                }
                int size = entityMap.get(entityName).size();
                String groupName = this.drawTitlePanel(flexPanelAp, map.get("targetkey").toString(), map.get("groupname").toString(), longListEntryValue.get(0), noPassWhenAdd, entityName, size);
                this.drawGroupFlexPanel("before", flexPanelAp, map, drawList, longListEntryValue, dataid, groupName, noPassWhenAdd);
                this.drawGroupFlexPanel("after", flexPanelAp, map, drawList, longListEntryValue, dataid, groupName, noPassWhenAdd);
            }
            drawList.clear();
        }
    }

    private Map<Long, List<DynamicObject>> getSortedIdVsDynListMap(Map<String, String> entityNameVsOrderStrMap, List<DynamicObject> list) {
        LinkedHashMap sortedDataLinkedMap = Maps.newLinkedHashMapWithExpectedSize((int)list.size());
        if (!CollectionUtils.isEmpty(list)) {
            Set dataIdSet = list.stream().map(dyn -> dyn.getLong("dataid")).collect(Collectors.toSet());
            String entityName = list.get(0).getString("entityName");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            QFilter idFilter = new QFilter("id", "in", dataIdSet);
            String defaultOrderStr = entityNameVsOrderStrMap.getOrDefault(entityName, OrderEnum.getEntityNameByCode((String)entityName));
            DynamicObject[] sortedDynArr = helper.query("id", new QFilter[]{idFilter}, defaultOrderStr);
            List sortedIdList = Arrays.stream(sortedDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            Map<Long, List<DynamicObject>> dataMap = list.stream().collect(Collectors.groupingBy(arg -> arg.getLong("dataid")));
            for (Long sortedId : sortedIdList) {
                sortedDataLinkedMap.put(sortedId, dataMap.get(sortedId));
            }
        }
        return sortedDataLinkedMap;
    }

    private String drawTitlePanel(FlexPanelAp flexPanelAp, String targetKey, String groupName, DynamicObject dynamicObject, boolean isNew, String entityName, int size) {
        boolean isSingle = InfoGroupHelper.isSingleRowTpl((String)entityName);
        long count = flexPanelAp.getItems().stream().filter(arg -> arg.getKey().contains(targetKey.toLowerCase(Locale.ROOT)) && arg.getKey().contains("after")).count();
        String displayGroupName = groupName + (size > 1 && !isSingle ? Long.valueOf(count + 1L) : "");
        FlexPanelAp flexAp = this.getTitlePanelAp(targetKey, displayGroupName, dynamicObject, isNew);
        if (isSingle) {
            Optional<ControlAp> first = flexPanelAp.getItems().stream().filter(arg -> arg.getKey().contains(targetKey.toLowerCase(Locale.ROOT))).findFirst();
            if (!first.isPresent()) {
                flexPanelAp.getItems().add(flexAp);
            }
        } else {
            flexPanelAp.getItems().add(flexAp);
        }
        return displayGroupName;
    }

    private FlexPanelAp getTitlePanelAp(String targetKey, String groupName, DynamicObject dynamicObject, boolean isNew) {
        FlexPanelAp flexAp = ApCreateUtils.createFlexAp((String)("Flex" + targetKey + dynamicObject.getLong("dataid")), (String)String.valueOf(dynamicObject.getLong("dataid")));
        flexAp.setWrap(false);
        flexAp.setHeight(new LocaleString("28px"));
        flexAp.setAlignItems("center");
        this.setApStyle((ControlAp)flexAp, this.getMargin("0px", "0px", "0px", "0px"), null);
        FlexPanelAp buttonFlexAp = ApCreateUtils.createFlexAp((String)("btnFlexAp" + dynamicObject.getLong("dataid")), (String)String.valueOf(dynamicObject.getLong("dataid")));
        buttonFlexAp.setJustifyContent("flex-end");
        this.setApStyle((ControlAp)buttonFlexAp, this.getMargin("0px", "0px", "0px", "0px"), null);
        LabelAp labelAp = ApCreateUtils.createLabelAp((String)(targetKey.toLowerCase(Locale.ROOT) + dynamicObject.getLong("dataid")), (String)groupName);
        labelAp.setFontSize(14);
        labelAp.setForeColor("#666666");
        labelAp.setLineHeight("20px");
        LabelAp buttonApBefore = new LabelAp();
        buttonApBefore.setKey(targetKey.toLowerCase(Locale.ROOT) + dynamicObject.getLong("dataid") + "before-button");
        this.setButtonUnSelectStyle(buttonApBefore);
        buttonApBefore.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"EntryDetailMobileDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        LabelAp buttonApAfter = new LabelAp();
        this.setButtonSelectStyle(buttonApAfter);
        buttonApAfter.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"EntryDetailMobileDrawEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        buttonApAfter.setKey(targetKey.toLowerCase(Locale.ROOT) + dynamicObject.getLong("dataid") + "after-button");
        flexAp.getItems().add(labelAp);
        if (isNew) {
            this.addNopassField(targetKey, flexAp);
        }
        buttonFlexAp.getItems().add(buttonApBefore);
        buttonFlexAp.getItems().add(buttonApAfter);
        flexAp.getItems().add(buttonFlexAp);
        return flexAp;
    }

    private void appendInfo(DynamicObject dynamicObject, String groupName) {
        String info = this.getPageCache().get("notpassinfo") != null ? this.getPageCache().get("notpassinfo") : "";
        String reason = HRStringUtils.isNotEmpty((String)dynamicObject.getString("reason")) ? dynamicObject.getString("reason") : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        this.getPageCache().put("notpassinfo", info + groupName + ":" + reason + "\r\n");
    }

    private void drawGroupFlexPanel(String type, FlexPanelAp flexPanelAp, Map<String, Object> map, List<DrawFormFieldDto> drawList, List<DynamicObject> longListEntryValue, Long dataid, String groupName, boolean isNew) {
        FlexPanelAp groupFlexAp = this.getFlexPanelAp(type, map, dataid);
        boolean isSingle = InfoGroupHelper.isSingleRowTpl((String)longListEntryValue.get(0).getString("entityname"));
        if (isSingle) {
            Optional<ControlAp> first = flexPanelAp.getItems().stream().filter(arg -> arg.getKey().contains(map.get("targetkey").toString().toLowerCase(Locale.ROOT)) && arg.getKey().contains(type)).findFirst();
            if (first.isPresent()) {
                ControlAp controlAp = first.get();
                groupFlexAp = (FlexPanelAp)controlAp;
            } else {
                flexPanelAp.getItems().add(groupFlexAp);
            }
        } else {
            flexPanelAp.getItems().add(groupFlexAp);
        }
        this.drawMainFlex(type, drawList, flexPanelAp, groupFlexAp, longListEntryValue, dataid, groupName, isSingle, isNew);
        if (type.equals("before")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{map.get("targetkey").toString().toLowerCase(Locale.ROOT) + dataid + type + "-groupflex"});
        }
    }

    private FlexPanelAp getFlexPanelAp(String type, Map<String, Object> map, Long dataid) {
        FlexPanelAp groupFlexAp = ApCreateUtils.createFlexAp((String)(map.get("targetkey").toString().toLowerCase(Locale.ROOT) + dataid + type + "-groupflex"), (String)((String)map.get("groupname")));
        groupFlexAp.setDirection("column");
        groupFlexAp.setBackColor("#FAFAFA");
        Style style = new Style();
        groupFlexAp.setStyle(style);
        Padding padding = new Padding();
        style.setPadding(padding);
        padding.setTop("12px");
        padding.setLeft("12px");
        padding.setRight("12px");
        Margin margin = new Margin();
        style.setMargin(margin);
        margin.setTop("12px");
        margin.setBottom("12px");
        return groupFlexAp;
    }

    private void setApStyle(ControlAp flexAp, Margin margin, Padding padding) {
        Style style = new Style();
        flexAp.setStyle(style);
        style.setMargin(margin);
    }

    private Margin getMargin(String left, String right, String top, String bottom) {
        Margin margin = new Margin();
        margin.setLeft(HRStringUtils.isNotEmpty((String)left) ? left : "0px");
        margin.setRight(HRStringUtils.isNotEmpty((String)right) ? right : "0px");
        margin.setTop(HRStringUtils.isNotEmpty((String)top) ? top : "0px");
        margin.setBottom(HRStringUtils.isNotEmpty((String)bottom) ? bottom : "0px");
        return margin;
    }

    protected void drawMainFlex(String type, List<DrawFormFieldDto> drawList, FlexPanelAp flexPanelAp, FlexPanelAp groupFlexAp, List<DynamicObject> entryentity, Long dataid, String groupName, boolean isSingle, boolean isNew) {
        for (DynamicObject dynamicObject : entryentity) {
            for (DrawFormFieldDto fieldDto : drawList) {
                if (!dynamicObject.getString("fieldname").equals(fieldDto.getField()) || !dynamicObject.getString("entityname").equals(fieldDto.getOrigPageId())) continue;
                FlexPanelAp lineFlexAp = ApCreateUtils.createFlexAp((String)(fieldDto.getField() + "lineFlexap" + dataid + type), (String)fieldDto.getName());
                lineFlexAp.setWrap(false);
                lineFlexAp.setGrow(0);
                lineFlexAp.setWidth(new LocaleString("100%"));
                this.setApStyle((ControlAp)lineFlexAp, this.getMargin("0px", "0px", "0px", "12px"), null);
                String newvalue = dynamicObject.getString("newvalue");
                String oldvalue = dynamicObject.getString("oldvalue");
                String firstgroupnum = dynamicObject.getString("firstgroupnum");
                String current = type.equals("after") ? newvalue : oldvalue;
                long entryId = (Long)dynamicObject.getPkValue();
                switch (fieldDto.getClassSimpleName()) {
                    case "AttachmentProp": {
                        this.attachmentDeal(type, dataid, fieldDto, lineFlexAp, current);
                        break;
                    }
                    case "PictureProp": {
                        this.pictureDeal(type, dataid, fieldDto.getField(), fieldDto.getName(), lineFlexAp, current);
                        break;
                    }
                    default: {
                        this.defaultDeal(entryId, firstgroupnum, type, dataid, fieldDto, lineFlexAp, current);
                    }
                }
                if (dynamicObject.getBoolean("status")) {
                    this.addNopassField(fieldDto.getField(), lineFlexAp);
                    if (type.equals("after")) {
                        this.appendInfo(dynamicObject, isSingle ? fieldDto.getName() : groupName + ":" + fieldDto.getName());
                    }
                }
                groupFlexAp.getItems().add(lineFlexAp);
            }
        }
    }

    private void addNopassField(String field, FlexPanelAp lineFlexAp) {
        LabelAp entryLable = ApCreateUtils.createLabelAp((String)(field + "entrylable"), (String)"");
        entryLable.setFontSize(12);
        entryLable.setShrink(0);
        entryLable.setAlignSelf("center");
        entryLable.setLineHeight("16px");
        entryLable.setName(new LocaleString(ResManager.loadKDString((String)"\uff08\u4e0d\u901a\u8fc7\uff09", (String)"FieldContainerViewService_2", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        entryLable.setForeColor("#FB2323");
        lineFlexAp.getItems().add(entryLable);
    }

    private void pictureDeal(String type, Long dataid, String field, String name, FlexPanelAp lineFlexAp, String current) {
        LabelAp labelApKey = ApCreateUtils.createLabelAp((String)(field + "key" + dataid + type), (String)name);
        labelApKey.setWidth(new LocaleString("80px"));
        labelApKey.setAutoTextWrap(true);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(field + dataid + type);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setWidth(new LocaleString("100%"));
        fieldAp.setLock("view,edit,new,submit,audit");
        fieldAp.setShrink(0);
        fieldAp.setGrow(0);
        PictureField pictureField = new PictureField();
        pictureField.setKey(field + dataid + type);
        pictureField.setName(new LocaleString(name));
        fieldAp.setField((Field)pictureField);
        FieldEdit fieldEdit = fieldAp.buildRuntimeControl();
        if (HRStringUtils.isNotEmpty((String)current)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.setFieldProperty(fieldEdit.getKey(), "v", (Object)current);
        }
        lineFlexAp.getItems().add(labelApKey);
        lineFlexAp.getItems().add(fieldAp);
    }

    private void attachmentDeal(String type, Long dataid, DrawFormFieldDto fieldDto, FlexPanelAp lineFlexAp, String current) {
        AttachmentPanelAp attachmentPanelAp = new AttachmentPanelAp();
        attachmentPanelAp.setCollapsible(false);
        attachmentPanelAp.setKey(fieldDto.getField() + dataid + type);
        attachmentPanelAp.setName(new LocaleString(fieldDto.getName()));
        attachmentPanelAp.setWidth(new LocaleString("100%"));
        attachmentPanelAp.setLock("view,edit,new,submit,audit");
        attachmentPanelAp.setShrink(0);
        attachmentPanelAp.setGrow(0);
        AttachmentPanel attachmentPanel = (AttachmentPanel)attachmentPanelAp.buildRuntimeControl();
        if (HRStringUtils.isNotEmpty((String)current)) {
            ArrayList displayAttachment = AttachmentServiceHelper.getAttachments((String)fieldDto.getOrigPageId(), (Object)current, (String)fieldDto.getField(), (boolean)(this.getView() instanceof IMobileView));
            if (current.equals("0")) {
                displayAttachment = new ArrayList();
            }
            if (displayAttachment.size() > 0) {
                for (Map attachmentMap : displayAttachment) {
                    attachmentMap.put("visible", "1111");
                }
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty(attachmentPanel.getKey(), "v", displayAttachment);
            }
        }
        lineFlexAp.getItems().add(attachmentPanelAp);
    }

    private void defaultDeal(long entryId, String firstgroupnum, String type, Long dataid, DrawFormFieldDto fieldDto, FlexPanelAp lineFlexAp, String current) {
        LabelAp labelApKey = ApCreateUtils.createLabelAp((String)(fieldDto.getField() + "key" + dataid + type), (String)fieldDto.getName());
        labelApKey.setWidth(new LocaleString("80px"));
        labelApKey.setAutoTextWrap(true);
        labelApKey.setShrink(0);
        LabelAp labelApValue = ApCreateUtils.createLabelAp((String)(fieldDto.getField() + "value" + dataid + type), (String)(HRStringUtils.isNotEmpty((String)current) ? current : "-"));
        labelApValue.setAutoTextWrap(true);
        this.dealDataDisplay(fieldDto, current, labelApValue);
        EmployeeBillParamsDTO paramsDTO = new EmployeeBillParamsDTO(firstgroupnum, dataid.longValue(), fieldDto.getOrigPageId(), fieldDto.getField(), current, entryId);
        MobileBillDetailExtUtil.modifyEmployeeBillDetail((EmployeeBillParamsDTO)paramsDTO);
        if (!HRStringUtils.equals((String)current, (String)paramsDTO.getValue())) {
            labelApValue.setName(new LocaleString(paramsDTO.getValue()));
        }
        Style style = new Style();
        Margin margin = new Margin();
        style.setMargin(margin);
        margin.setLeft("16px");
        labelApValue.setStyle(style);
        lineFlexAp.getItems().add(labelApKey);
        lineFlexAp.getItems().add(labelApValue);
    }

    private void dealDataDisplay(DrawFormFieldDto fieldDto, String current, LabelAp labelApValue) {
        if (CommonUtil.isBaseDataType((Class)FieldTypeEnum.getTypeClassObject((String)FieldTypeEnum.BASE_DATA.getCode()), (String)fieldDto.getClassSimpleName())) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(fieldDto.getBaseEntityId());
            if (HRStringUtils.isNotEmpty((String)current)) {
                QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(current));
                DynamicObject name = serviceHelper.queryOne("name", new QFilter[]{qFilter});
                if (name != null) {
                    labelApValue.setName(new LocaleString(name.getString("name")));
                } else {
                    labelApValue.setName(new LocaleString("-"));
                }
            }
        }
        if ("ComboProp".equals(fieldDto.getClassSimpleName())) {
            List comboItemList = fieldDto.getComboItemList();
            Optional<ComboItem> first = comboItemList.stream().filter(arg -> arg.getValue().equals(current)).findFirst();
            first.ifPresent(comboItem -> labelApValue.setName(comboItem.getCaption()));
        } else if ("BooleanProp".equals(fieldDto.getClassSimpleName())) {
            String value = HRStringUtils.isEmpty((String)current) ? "-" : (!Boolean.parseBoolean(current) ? ResManager.loadKDString((String)"\u5426", (String)"AbstractCardDrawEdit_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"AbstractCardDrawEdit_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            labelApValue.setName(new LocaleString(value));
        } else if ("MulBasedataProp".equals(fieldDto.getClassSimpleName())) {
            labelApValue.setName(new LocaleString(ValueConvertHelper.handleMulBaseData((String)current, (String)fieldDto.getBaseEntityId())));
        } else if ("AdminDivisionProp".equals(fieldDto.getClassSimpleName())) {
            labelApValue.setName(new LocaleString(ValueConvertHelper.handleAdminDivisionField((String)current)));
        } else if ("DateProp".equals(fieldDto.getClassSimpleName()) && HRStringUtils.isNotEmpty((String)current) && !current.equals("null")) {
            String format = HRDateTimeUtils.format((Date)new Date(Long.parseLong(current)), (String)"yyyy-MM-dd", (TimeZone)KDDateUtils.getSysTimeZone());
            labelApValue.setName(new LocaleString(format));
            if (CommonUtil.getMaxDate((Date)new Date(Long.parseLong(current)))) {
                labelApValue.setName(new LocaleString("-"));
            }
        }
    }

    private void setButtonSelectStyle(LabelAp buttonAp) {
        buttonAp.setForeColor("#276FF5");
        buttonAp.setBackColor("#F2F9FF");
        buttonAp.setClickable(true);
        buttonAp.setHeight(new LocaleString("28px"));
        buttonAp.setWidth(new LocaleString("58px"));
        buttonAp.setShrink(0);
        buttonAp.setFontSize(12);
        buttonAp.setLabelStyle("2");
        buttonAp.setRadius("4px");
        Style style = new Style();
        buttonAp.setStyle(style);
        Border border = new Border();
        style.setBorder(border);
        border.setTop("1px solid #276FF5");
        border.setBottom("0.5px solid #276FF5");
        border.setLeft("0.5px solid #276FF5");
        border.setRight("0.5px solid #276FF5");
        style.setMargin(this.getMargin("8px", "0px", "0px", "0px"));
    }

    private void setButtonUnSelectStyle(LabelAp buttonAp) {
        buttonAp.setHeight(new LocaleString("28px"));
        buttonAp.setWidth(new LocaleString("58px"));
        buttonAp.setFontSize(12);
        buttonAp.setLabelStyle("2");
        buttonAp.setRadius("4px");
        buttonAp.setClickable(true);
        buttonAp.setForeColor("#212121");
        buttonAp.setBackColor("#F2F2F2");
        buttonAp.setShrink(0);
        Style style = new Style();
        buttonAp.setStyle(style);
        Border border = new Border();
        style.setBorder(border);
        border.setTop("1px solid #f2f2f2");
        border.setBottom("0.5px solid #f2f2f2");
        border.setLeft("0.5px solid #f2f2f2");
        border.setRight("0.5px solid #f2f2f2");
    }

    public List<DrawFormFieldDto> formatFlexFields(Map<String, Object> group, Map<String, Object> map) {
        List fields = (List)group.get("fields");
        return fields.stream().map(field -> {
            DrawFormFieldDto drawFormFieldDto = new DrawFormFieldDto().setField((String)field.get("number")).setMaxCount(field.get("maxcount") != null ? Integer.parseInt(field.get("maxcount").toString()) : 0).setMaxSize((String)field.get("max")).setMinSize((String)field.get("min")).setScale(field.get("scale") != null ? Integer.parseInt(field.get("scale").toString()) : 0).setPrecision(field.get("precision") != null ? Integer.parseInt(field.get("precision").toString()) : 0).setName((String)field.get("displayname")).setClassSimpleName(FieldTypeEnum.geCodeByFieldType((String)((String)field.get("type"))).getCodeSimpleName()).setLock(((Boolean)field.get("isedit")).booleanValue()).setMustInput(((Boolean)field.get("isrequired")).booleanValue()).setFireUptEvt(true).setOrigPageId((String)field.get("pnumber")).setComboItemList(this.getComboItemMap(map).get(field.get("number"))).setBaseEntityId((String)field.get("refkey")).setHasEmptyText(true).setIsAudit(((Boolean)field.get("isaudit")).booleanValue());
            return drawFormFieldDto;
        }).collect(Collectors.toList());
    }

    protected Map<String, List<ComboItem>> getComboItemMap(Map<String, Object> tabList) {
        HashMap<String, List<ComboItem>> map = new HashMap<String, List<ComboItem>>(16);
        if (tabList != null && !CollectionUtils.isEmpty((Collection)((List)tabList.get("groups")))) {
            List groups = (List)tabList.get("groups");
            for (Map group : groups) {
                List fields = (List)group.get("fields");
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                for (Map field : fields) {
                    if (!FieldTypeEnum.COMBO.getType().equals(field.get("type"))) continue;
                    String number = (String)field.get("number");
                    String pnumber = (String)field.get("pnumber");
                    String getNumber = "";
                    getNumber = number.contains("businessstatus") ? number.split("-")[0] : number;
                    if (field.get("across_entity") != null && number.contains("-")) {
                        getNumber = number.substring(number.indexOf("-") + 1);
                    }
                    if (!HRStringUtils.isNotEmpty((String)number) || !HRStringUtils.isNotEmpty((String)pnumber)) continue;
                    map.put(number, ComboItemUtil.getComboItem((String)pnumber, (String)getNumber));
                }
            }
        }
        return map;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.contains("before-button")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{key.substring(0, key.indexOf("before")) + "after-groupflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{key.substring(0, key.indexOf("before")) + "before-groupflex"});
            this.changeButtonStyle(key);
        } else if (key.contains("after-button")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{key.substring(0, key.indexOf("after")) + "before-groupflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{key.substring(0, key.indexOf("after")) + "after-groupflex"});
            this.changeButtonStyle(key);
        } else if (key.contains("openmore")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"container"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"closepanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"openmorepanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"switchtohome"});
            if (this.getBill() != null && this.getBill().getString("billstatus").equals("G")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"notpassinfo"});
            }
        } else if (key.contains("close")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"container"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"closepanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"openmorepanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"switchtohome"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"notpassinfo"});
        } else if (key.equals("switchtohome")) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else if (key.equals(CANCEL)) {
            if (!CommonUtil.hasPerm((String)"hspm_infoapproval", (String)"80513207000000ac", (String)"hssc", (IFormView)this.getView())) {
                this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
                return;
            }
            String changeDesc = ResManager.loadKDString((String)"\u64a4\u9500\u540e\u6863\u6848\u4fe1\u606f\u5ba1\u6279\u5355\u636e\u5c06\u4f1a\u5931\u6548\uff0c\u662f\u5426\u64a4\u9500\uff1f", (String)"EntryDetailMobileDrawEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(" ", changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(CANCEL, (IFormPlugin)this));
        } else if (key.equals("notpassinfo")) {
            DynamicObject entry = this.getBill();
            this.showConfirmWhenFirstOpen(true, entry);
        }
    }

    private void changeButtonStyle(String selectKey) {
        LabelAp select = new LabelAp();
        LabelAp unSelect = new LabelAp();
        String unSelectKey = "";
        if (selectKey.contains("before-button")) {
            unSelectKey = selectKey.replace("before", "after");
            select.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"EntryDetailMobileDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            unSelect.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"EntryDetailMobileDrawEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        } else {
            unSelectKey = selectKey.replace("after", "before");
            unSelect.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"EntryDetailMobileDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            select.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"EntryDetailMobileDrawEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        }
        select.setKey(selectKey);
        unSelect.setKey(unSelectKey);
        this.setButtonSelectStyle(select);
        this.setButtonUnSelectStyle(unSelect);
        this.getView().updateControlMetadata(selectKey, select.createControl());
        this.getView().updateControlMetadata(unSelectKey, unSelect.createControl());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().contains("button")) {
            Label button = new Label();
            button.setKey(e.getKey());
            button.addClickListener((ClickListener)this);
            button.setView(this.getView());
            e.setControl((Control)button);
        } else if (e.getKey().toLowerCase(Locale.ROOT).contains("flex")) {
            Container container = new Container();
            container.setKey(e.getKey());
            container.setView(this.getView());
            e.setControl((Control)container);
        }
    }

    private Map<Object, List<Map<String, Object>>> getGroupsInfo() {
        long cnfId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String previewCnfId = (String)formShowParameter.getCustomParam("cnfId");
        String isPreview = null;
        if (HRStringUtils.isNotEmpty((String)previewCnfId)) {
            cnfId = Long.parseLong(previewCnfId);
            isPreview = "1";
        } else {
            Tuple<Boolean, Long> cnfInfo = this.getConfigInfo();
            cnfId = (Long)cnfInfo.item2;
        }
        if (cnfId == 0L) {
            return null;
        }
        Map infoGroupConfig = PageRegConfigService.getInstance().getInfoGroupConfig(cnfId, ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), isPreview);
        List groups = (List)infoGroupConfig.get("mainentry");
        List headGroups = (List)infoGroupConfig.get("headentity");
        HashMap<Object, List<Map<String, Object>>> hashMap = new HashMap<Object, List<Map<String, Object>>>();
        hashMap.put("groups", groups);
        hashMap.put("headentity", headGroups);
        return hashMap;
    }

    private Tuple<Boolean, Long> getConfigInfo() {
        Long cnfId = 0L;
        try {
            Map resultPerson = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
            logger.info("getPersonModelIdResp{}", (Object)resultPerson);
            boolean reqPerson = false;
            if (resultPerson == null || resultPerson.size() == 0) {
                reqPerson = true;
            }
            if (reqPerson) {
                this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
            }
            Map idData = (Map)resultPerson.get("data");
            logger.info("idData{}", (Object)idData);
            if (idData == null || idData.size() == 0 || (Long)idData.get("person") == 0L) {
                reqPerson = true;
            }
            if (reqPerson) {
                this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458ID\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
            }
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)((Long)idData.get("person")));
            IPageCache pageCache = this.getView().getPageCache();
            String personId = String.valueOf(idData.get("person"));
            logger.info("personId{}", (Object)personId);
            pageCache.put("personId", personId);
            if (erFileDy == null) {
                this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u6863\u6848\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
            }
            Tuple tuple = AttacheHandlerService.getInstance().handleRuleEngine(this.getView(), erFileDy.getLong("id"), erFileDy, "hspm" + ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), null, false);
            cnfId = (Long)tuple.item2;
        }
        catch (Exception exc) {
            this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f02\u5e38\u3002", (String)"MobileHomeTemplatePlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            logger.error("getPersonModelIdError", (Throwable)exc);
            return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)cnfId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"openmore"});
        this.addClickListeners(new String[]{"close"});
        this.addClickListeners(new String[]{"switchtohome"});
        this.addClickListeners(new String[]{"cancel"});
        this.addClickListeners(new String[]{"notpassinfo"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("cancel".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.toString().equals(messageBoxClosedEvent.getResultValue())) {
            this.abandon();
        }
    }

    private void abandon() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hspm_infoapproval");
        Object billno = this.getModel().getValue("billno");
        QFilter billnoFilter = new QFilter("billno", "=", billno);
        DynamicObject entry = serviceHelper.loadDynamicObject(billnoFilter);
        if (entry != null && entry.getString("billstatus").equals("D")) {
            Tuple result = ApprovalHelper.widthDraw((DynamicObject)this.getModel().getDataEntity(true));
            if (((Boolean)result.item1).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6210\u529f", (String)"EntryDetailMobileDrawEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), "", MessageTypes.ImageWithText_m);
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            } else {
                this.getView().showErrorNotification((String)result.item2);
            }
        }
    }
}

