/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.mobile.schedule.draw.formview;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.ServiceFactory;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.hr.hspm.common.entity.ocr.IdCardBackResult;
import kd.hr.hspm.common.entity.ocr.IdCardFrontResult;
import kd.hr.hspm.formplugin.web.schedule.utils.PercreFieldUtils;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.entity.PercreField;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.formplugin.mobile.file.base.AbstractMobileFormDrawEdit;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.ApCreateUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.FieldContainerViewService;

public class PercreMobEditPlugin
extends AbstractMobileFormDrawEdit {
    private static final Log logger = LogFactory.getLog(PercreMobEditPlugin.class);
    private static final Set<String> IMAGE_FIELD = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"faceimage", "reverseimage"}));
    private static final Set<String> FIRST_FIELD = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor"}));
    private static final String PERCRE_CONFIG_FIELD = "percreConfigField";
    private static final String PERCRE_AUDIT_FIELD = "percreAuditField";
    private static final String FIRST_FIELD_AP = "containerflex_0";
    private static final String SECOND_FIELD_AP = "containerflex_1";
    private static final String IMAGE_AP_ID = "containerflex_image";
    private static final String ATTACH_AP_ID = "containerflex_attach";
    private static final String IS_MAJOR = "ismajor";
    private static final String REVERSE_IMAGE = "reverseimagebigpic";
    private static final String PERCRE_TYPE_NUMBER = "credentialstype.number";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_percre");
    private static final FieldContainerViewService fieldContainerViewService = new FieldContainerViewService();

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        if ("cus_edit".equals(status)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"credentialstype"});
        } else {
            if ("cus_addnew".equals(status)) {
                this.getView().setStatus(OperationStatus.ADDNEW);
                return;
            }
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.setValueFromDb(this.getView().getFormShowParameter(), "hrpi_percre", null);
        this.setAttachment("hrpi_percre", this.getAttachmentKey());
        this.getModel().setDataChanged(false);
    }

    protected void dataFieldInputLimit() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        if ("cus_view".equals(status)) {
            return;
        }
        if (this.isFieldExist("birthday")) {
            DateEdit birthday = (DateEdit)this.getControl("birthday");
            birthday.setMaxDate(new Date());
        }
        if (this.isFieldExist("issuedate")) {
            DateEdit issueDay = (DateEdit)this.getControl("issuedate");
            issueDay.setMaxDate(new Date());
        }
    }

    protected void drawMainFlex(List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, String groupNumber) {
        List list = this.formatFlexFields(groups.get(0));
        HashSet fieldSet = Sets.newHashSetWithExpectedSize((int)list.size());
        HashSet auditFieldSet = Sets.newHashSetWithExpectedSize((int)list.size());
        boolean isAudit = false;
        for (DrawFormFieldDto drawFormFieldDto : list) {
            fieldSet.add(drawFormFieldDto.getField());
            if (!drawFormFieldDto.isIsAudit()) continue;
            auditFieldSet.add(drawFormFieldDto.getField());
            isAudit = true;
        }
        this.getPageCache().put(PERCRE_CONFIG_FIELD, SerializationUtils.toJsonString((Object)fieldSet));
        this.getPageCache().put(PERCRE_AUDIT_FIELD, SerializationUtils.toJsonString((Object)auditFieldSet));
        if (isAudit) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipslabelap"});
        }
        this.drawFormTitleFlex(0, groups, flexPanelAp, false);
        ArrayList firstFieldList = new ArrayList(FIRST_FIELD.size());
        ArrayList<DrawFormFieldDto> attachList = new ArrayList<DrawFormFieldDto>(1);
        ArrayList<DrawFormFieldDto> imageList = new ArrayList<DrawFormFieldDto>(IMAGE_FIELD.size());
        ArrayList secondFieldList = new ArrayList(list.size());
        list.forEach(fieldDto -> {
            if (FIRST_FIELD.contains(fieldDto.getField())) {
                firstFieldList.add(fieldDto);
            } else if (IMAGE_FIELD.contains(fieldDto.getField())) {
                fieldDto.setWidth("295px");
                fieldDto.setHeight("160px");
                imageList.add((DrawFormFieldDto)fieldDto);
            } else if ("attachmentpanelap_std".equals(fieldDto.getField())) {
                fieldDto.setName(ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PercreDrawPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                attachList.add((DrawFormFieldDto)fieldDto);
            } else {
                secondFieldList.add(fieldDto);
            }
        });
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry((IFormView)this.getView());
        Long dataId = this.getDataId(((DrawFormFieldDto)list.get(0)).getOrigPageId(), null);
        FlexPanelAp firstFieldAp = this.getGroupAp(firstFieldList, (String)groups.get(0).get("gname"), groupNumber, 0L, this.getDataId(((DrawFormFieldDto)list.get(0)).getOrigPageId(), null), currentEntry);
        firstFieldAp.getStyle().getMargin().setBottom("");
        flexPanelAp.getItems().add(firstFieldAp);
        if (imageList.size() > 0) {
            flexPanelAp.getItems().add(this.drawImageFlex(imageList, dataId, groupNumber, currentEntry));
        }
        if (attachList.size() > 0) {
            flexPanelAp.getItems().add(this.drawAttachFlex(attachList));
        }
        FlexPanelAp secondFieldAp = this.getGroupAp(secondFieldList, (String)groups.get(0).get("gname"), groupNumber, 1L, this.getDataId(((DrawFormFieldDto)list.get(0)).getOrigPageId(), null), currentEntry);
        secondFieldAp.getStyle().getMargin().setBottom("");
        flexPanelAp.getItems().add(secondFieldAp);
    }

    private FlexPanelAp drawImageFlex(List<DrawFormFieldDto> imageList, Long dataId, String groupNumber, DynamicObject[] currentEntry) {
        String typeName = ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PercreDrawPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        FlexPanelAp flexPanelAp = fieldContainerViewService.redrawAdconApForPic(currentEntry, imageList, IMAGE_AP_ID, typeName, "perattach", this.diffMap, this.getView(), null, dataId, groupNumber);
        flexPanelAp.setDirection("column");
        flexPanelAp.setJustifyContent("center");
        flexPanelAp.setAlignContent("center");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setBackColor("#FFFFFF");
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setTop("12px");
        style.setMargin(margin);
        style.setPadding(padding);
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    private FlexPanelAp drawAttachFlex(List<DrawFormFieldDto> attachList) {
        String typeName = ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PercreDrawPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        FlexPanelAp flexPanelAp = ApCreateUtils.createOriginalFlexAp((String)ATTACH_AP_ID, (String)typeName);
        flexPanelAp.setGrow(1);
        flexPanelAp.setShrink(1);
        flexPanelAp.setDirection("column");
        flexPanelAp.setBackColor("#FFFFFF");
        flexPanelAp.setWidth(new LocaleString("100%"));
        flexPanelAp.setOverflow("visible");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("1px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        for (DrawFormFieldDto attach : attachList) {
            flexPanelAp.getItems().add(fieldContainerViewService.drawAttachmentAp(attach, ClientTypeEnum.EMPLOYEE_MOBILE.getCode()));
        }
        return flexPanelAp;
    }

    public void afterBindData(EventObject eventObject) {
        Long person;
        DynamicObject[] info;
        if (this.getAuditFieldSet().contains("isnofixedterm")) {
            this.getView().getPageCache().put("isnofixedterm_audit", "1");
        } else {
            this.getView().getPageCache().remove("isnofixedterm_audit");
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pkId = (String)formShowParameter.getCustomParam("pkid");
        if (HRStringUtils.isNotEmpty((String)pkId) && (info = this.getInfo(person = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person")))).length == 1 && pkId.equals(info[0].getString("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{IS_MAJOR});
        }
        long type = this.getModel().getDataEntity().getLong("credentialstype.id");
        HashSet<String> igSet = new HashSet<String>(16);
        Set allFields = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERCRE_CONFIG_FIELD), Set.class);
        this.setVisibleByType(type, igSet, allFields);
        BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)true);
        this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
        this.setAttachment("hrpi_percre", this.getAttachmentKey());
        this.getModel().setDataChanged(false);
        super.afterBindData(eventObject);
    }

    private void setVisibleByType(long type, Set<String> ignoreSet, Set<String> allFields) {
        if (type != 0L && !PercreFieldUtils.TYPE_FIELD_MAP.containsKey(type)) {
            type = HspmCommonConstants.NUMBER_1150_ID;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{SECOND_FIELD_AP, IMAGE_AP_ID, REVERSE_IMAGE});
        PercreField percreField = PercreFieldUtils.TYPE_FIELD_MAP.get(type);
        Set showList = percreField != null ? percreField.getFieldSet() : PercreFieldUtils.DEFAULT_SHOW;
        this.getPageCache().put("showlist", SerializationUtils.toJsonString(allFields));
        this.hiddenAndShow(allFields, showList, HspmCommonConstants.NUMBER_1150_ID.equals(type));
        if (type == HspmCommonConstants.NUMBER_1010_ID) {
            String imageName = ResManager.loadKDString((String)"\u8bf7\u62cd\u6444/\u4e0a\u4f20\u8eab\u4efd\u8bc1\u5934\u50cf\u9762\u3002", (String)"PercreMobEditPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            String resImageName = ResManager.loadKDString((String)"\u8bf7\u62cd\u6444/\u4e0a\u4f20\u8eab\u4efd\u8bc1\u56fd\u5fbd\u9762\u3002", (String)"PercreMobEditPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(imageName, resImageName, percreField != null ? percreField.getMobileFaceUrl() : null, percreField != null ? percreField.getMobileReverseUrl() : null);
        } else if (type == HspmCommonConstants.NUMBER_1150_ID) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_AP_ID});
        } else if (percreField != null) {
            String imaLab = null;
            if (percreField.getMobileReverseUrl() == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REVERSE_IMAGE});
                imaLab = ResManager.loadKDString((String)"\u8bf7\u62cd\u6444/\u4e0a\u4f20\u8bc1\u4ef6\u4e3b\u9875\u3002", (String)"PercreMobEditPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            }
            this.showDiffBackImg(imaLab, null, percreField.getMobileFaceUrl(), percreField.getMobileReverseUrl());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SECOND_FIELD_AP, IMAGE_AP_ID});
        }
        ignoreSet.addAll(allFields.stream().filter(item -> !showList.contains(item)).collect(Collectors.toSet()));
    }

    private void showDiffBackImg(String imgLab, String resImgLab, String imgUrl, String resImgUrl) {
        HashMap<String, HashMap<String, String>> item;
        HashMap<String, String> map;
        if (HRStringUtils.isEmpty((String)imgLab)) {
            imgLab = ResManager.loadKDString((String)"\u8bf7\u62cd\u6444/\u4e0a\u4f20\u8bc1\u4ef6\u6b63\u9762\u3002", (String)"PercreMobEditPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp labelAp = ApCreateUtils.createLabelAp((String)"faceimageshowlabel", (String)imgLab);
        this.getView().updateControlMetadata(labelAp.getKey(), labelAp.createControl());
        if (HRStringUtils.isEmpty((String)resImgLab)) {
            resImgLab = ResManager.loadKDString((String)"\u8bf7\u62cd\u6444/\u4e0a\u4f20\u8bc1\u4ef6\u53cd\u9762\u3002", (String)"PercreMobEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp resLabelAp = ApCreateUtils.createLabelAp((String)"reverseimageshowlabel", (String)resImgLab);
        this.getView().updateControlMetadata(resLabelAp.getKey(), resLabelAp.createControl());
        if (HRStringUtils.isNotEmpty((String)imgUrl)) {
            map = new HashMap<String, String>(16);
            item = new HashMap<String, HashMap<String, String>>(16);
            map.put("dik", imgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("faceimage", item);
        }
        if (HRStringUtils.isNotEmpty((String)resImgUrl)) {
            map = new HashMap(16);
            item = new HashMap(16);
            map.put("dik", resImgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("reverseimage", item);
        }
    }

    private void hiddenAndShow(Set<String> allFields, Set<String> showList, boolean showAttachment) {
        this.getView().setVisible(Boolean.TRUE, (String[])showList.stream().map(field -> (FIRST_FIELD.contains(field) ? FIRST_FIELD_AP : SECOND_FIELD_AP) + field).toArray(String[]::new));
        String[] hiddenArr = (String[])allFields.stream().filter(field -> !showList.contains(field)).map(field -> (FIRST_FIELD.contains(field) ? FIRST_FIELD_AP : SECOND_FIELD_AP) + field).toArray(String[]::new);
        this.visibleAttachment(showAttachment, "attachmentpanelap_std");
        this.getView().setVisible(Boolean.FALSE, hiddenArr);
    }

    private void visibleAttachment(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> visableMap = new HashMap<String, Object>(16);
        visableMap.put("policy", "");
        visableMap.put("visible", value);
        visableMap.put("keys", ctlKeys);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setVisible", visableMap);
    }

    public void click(EventObject evt) {
        DynamicObject dy;
        boolean isHighestDegree;
        Control source = (Control)evt.getSource();
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkid");
        if (BTN_DELETE.equals(source.getKey()) && (isHighestDegree = (dy = this.serviceHelper.queryOne("ismajor,datastatus", (Object)Long.valueOf(pkId))).getBoolean(IS_MAJOR)) && !"-3".equals(dy.getString("datastatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u8bc1\u4ef6\u4e0d\u53ef\u5220\u9664\u3002", (String)"PercreCardPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        super.click(evt);
        if ("btn_edit".equals(source.getKey())) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().getFormShowParameter().setCustomParam("cus_status", (Object)"cus_edit");
            this.getView().invokeOperation("refresh");
        } else if ("btn_save".equals(source.getKey())) {
            if (HRStringUtils.isNotEmpty((String)pkId)) {
                this.editSave();
            } else {
                this.addSave();
            }
        }
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("attachmentpanelap_std", "attachmentpanelap_std");
        return diffMap;
    }

    public void remove(UploadEvent evt) {
        this.defaultRemoveAttachment(evt);
    }

    public void upload(UploadEvent evt) {
        this.defaultUploadAttachment(evt);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("btn_save".equals(source.getKey())) {
            Date birthday = this.getDateIfExist("birthday");
            Date midnight = HspmDateUtils.getMidnight();
            if (birthday != null && !birthday.before(midnight)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Date issueDate = this.getDateIfExist("issuedate");
            if (issueDate != null && !issueDate.before(midnight)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long typeId = dataEntity.getLong("credentialstype.id");
            String number = null;
            if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"number")) {
                number = dataEntity.getString("number");
            }
            if (HspmCommonConstants.NUMBER_1010_ID.equals(typeId)) {
                if (number != null && !PercreFieldUtils.validNumber(number, this.getView()).booleanValue()) {
                    evt.setCancel(true);
                    return;
                }
                if (this.isMultiIdCard(typeId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
            if (this.isPercreNumberRepeat(number, typeId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercreDrawPlugin_34", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private boolean isMultiIdCard(Long typeId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        String pkId = (String)formShowParameter.getCustomParam("pkid");
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and("credentialstype", "=", (Object)typeId);
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            qFilter.and(new QFilter("id", "!=", (Object)Long.parseLong(pkId)));
        }
        return this.serviceHelper.count("hrpi_percre", new QFilter[]{qFilter}) > 0;
    }

    private boolean isPercreNumberRepeat(String number, Long typeId) {
        if (HRStringUtils.isNotEmpty((String)number) && typeId != null && typeId > 0L) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String pkId = (String)formShowParameter.getCustomParam("pkid");
            Long percreId = HRStringUtils.isNotEmpty((String)pkId) ? Long.parseLong(pkId) : 0L;
            Tuple checkResult = UniquenessCheckUtil.checkCardNo((Long)percreId, (Long)typeId, (String)number, (boolean)false);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return true;
            }
        }
        return false;
    }

    private void addSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        DynamicObject[] info = this.getInfo(personId);
        DynamicObject[] tempInfo = this.getTempInfo(personId);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (this.isFieldExist(IS_MAJOR)) {
            boolean isMajor = dataEntity.getBoolean(IS_MAJOR);
            if (info.length == 0) {
                dataEntity.set(IS_MAJOR, (Object)true);
            } else if (!isMajor || !this.existsAuditField(dataEntity.getLong("credentialstype.id"), dataEntity)) {
                // empty if block
            }
        }
        Map resultMap = this.addAttachData("0", "hrpi_percre", this.getView(), dataEntity, dynamicObjects, false);
        this.successAfterSave(0L, resultMap, this.getAttachmentKey(), "hrpi_percre");
        PageCacheUtils.updateTempData((DynamicObject[])tempInfo, (Map)resultMap, (String)IS_MAJOR, (Object)false, (String)"hrpi_percre", (IFormView)this.getView(), (HRBaseServiceHelper)this.serviceHelper);
        this.closeView(this.getView(), resultMap, this.getView().getParentView());
    }

    private void editSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        String pkId = (String)formShowParameter.getCustomParam("pkid");
        DynamicObject[] info = this.getInfo(personId);
        DynamicObject[] tempInfo = this.getTempInfo(personId);
        Map<Boolean, List<DynamicObject>> isThisDyList = Stream.of(info).collect(Collectors.partitioningBy(dy -> pkId.equals(dy.getString("id"))));
        List<DynamicObject> thisDyList = isThisDyList.get(Boolean.TRUE);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (thisDyList.size() > 0 && dataEntity.getDataEntityType().getProperties().containsKey((Object)IS_MAJOR)) {
            DynamicObject currentDbDy = thisDyList.get(0);
            boolean dbMajor = currentDbDy.getBoolean(IS_MAJOR);
            boolean isMajor = dataEntity.getBoolean(IS_MAJOR);
            if (dbMajor && !isMajor) {
                String id = PageCacheUtils.getHomePageCache((IFormView)this.getView()).get("preMajorId");
                PageCacheUtils.getHomePageCache((IFormView)this.getView()).put("unableDelete", id);
            }
            if (dbMajor && isMajor) {
                PageCacheUtils.getHomePageCache((IFormView)this.getView()).remove("unableDelete");
            }
            if (isMajor && !dbMajor && !this.getAuditFieldSet().contains(IS_MAJOR)) {
                this.openMajor(isThisDyList.get(Boolean.FALSE), dynamicObjects);
            } else if (!isMajor && dbMajor && !this.getAuditFieldSet().contains(IS_MAJOR)) {
                this.closeMajor(isThisDyList.get(Boolean.FALSE), dynamicObjects);
            }
        }
        dynamicObjects.add((Object)this.createCurrentDy("hrpi_percre", this.getView(), null, null));
        Map stringObjectMap = this.updateAttachData("hrpi_percre", this.getView(), dynamicObjects, false);
        this.successAfterSave(0L, stringObjectMap, this.getAttachmentKey(), "hrpi_percre");
        PageCacheUtils.updateTempData((DynamicObject[])tempInfo, (Map)stringObjectMap, (String)IS_MAJOR, (Object)false, (String)"hrpi_percre", (IFormView)this.getView(), (HRBaseServiceHelper)this.serviceHelper);
        this.closeView(this.getView(), stringObjectMap, this.getView().getParentView());
    }

    private Set<String> getAuditFieldSet() {
        return (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERCRE_AUDIT_FIELD), Set.class);
    }

    private boolean existsAuditField(long typeId, DynamicObject dataEntity) {
        Set<String> auditFieldSet = this.getAuditFieldSet();
        Set allFieldSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERCRE_CONFIG_FIELD), Set.class);
        if (!PercreFieldUtils.TYPE_FIELD_MAP.containsKey(typeId)) {
            typeId = HspmCommonConstants.NUMBER_1150_ID;
        }
        Set showFieldSet = PercreFieldUtils.TYPE_FIELD_MAP.get(typeId).getFieldSet();
        List<String> stringList = Arrays.asList("attachmentpanelap_std", "faceimage", "reverseimage");
        boolean allMatch = auditFieldSet.stream().filter(field -> showFieldSet.contains(field)).allMatch(field -> stringList.contains(field) && dataEntity.get(field) == null);
        if (allMatch) {
            return false;
        }
        for (String field2 : auditFieldSet) {
            if (!allFieldSet.contains(field2) || !showFieldSet.contains(field2)) continue;
            return true;
        }
        return false;
    }

    private void closeMajor(List<DynamicObject> info, DynamicObjectCollection dynamicObjects) {
        DynamicObject otherDy;
        if (CollectionUtils.isEmpty(info)) {
            return;
        }
        if (info.size() == 1) {
            otherDy = info.get(0);
        } else if (info.size() > 1) {
            otherDy = (DynamicObject)info.stream().max((dy1, dy2) -> {
                Date dy2Time;
                Date dy1Time = dy1.getDate("createtime");
                if (HRDateTimeUtils.dayAfter((Date)dy1Time, (Date)(dy2Time = dy2.getDate("createtime")))) {
                    return 1;
                }
                return -1;
            }).get();
        } else {
            return;
        }
        otherDy.set(IS_MAJOR, (Object)true);
        dynamicObjects.add((Object)this.getNewDynamicObject(otherDy));
        if (dynamicObjects.getDynamicObjectType() != null) {
            dynamicObjects.getDynamicObjectType().setExtendName("hrpi_percre");
        }
    }

    private DynamicObject getNewDynamicObject(DynamicObject otherDy) {
        DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)otherDy, (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private void openMajor(List<DynamicObject> info, DynamicObjectCollection dynamicObjects) {
        info.stream().filter(dy -> (Boolean)dy.get(IS_MAJOR)).forEach(dy -> {
            dy.set(IS_MAJOR, (Object)Boolean.FALSE);
            dynamicObjects.add((Object)this.getNewDynamicObject((DynamicObject)dy));
        });
        if (dynamicObjects.getDynamicObjectType() != null) {
            dynamicObjects.getDynamicObjectType().setExtendName("hrpi_percre");
        }
    }

    private DynamicObject[] getInfo(Long person) {
        QFilter personFilter = new QFilter("person", "=", (Object)person);
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, curFilter, statusFilter});
    }

    private DynamicObject[] getTempInfo(Long person) {
        QFilter personFilter = new QFilter("person", "=", (Object)person);
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"-3");
        Object pkId = this.getView().getFormShowParameter().getCustomParam("pkid");
        long id = 0L;
        if (pkId != null) {
            id = Long.parseLong(pkId + "");
        }
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, curFilter, statusFilter, new QFilter("id", "!=", (Object)id)});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        this.getView().setVisible(Boolean.FALSE, new String[]{"percretips", "percrebanner"});
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        long type = this.getModel().getDataEntity().getLong("credentialstype.id");
        switch (key) {
            case "credentialstype": {
                DynamicObject typeDy = (DynamicObject)newValue;
                Long typeId = typeDy.getLong("id");
                if (HspmCommonConstants.NUMBER_1010_ID.equals(typeId) && this.isMultiIdCard(typeId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                }
                if (this.isFieldExist("reverseimage")) {
                    this.getModel().setValue("reverseimage", (Object)"");
                }
                if (this.isFieldExist("faceimage")) {
                    this.getModel().setValue("faceimage", (Object)"");
                }
                HashSet<String> igSet = new HashSet<String>(16);
                Set allFields = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERCRE_CONFIG_FIELD), Set.class);
                this.setVisibleByType(typeId, igSet, allFields);
                this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
                for (String field : allFields) {
                    if ("credentialstype".equals(field) || !this.isFieldExist(field)) continue;
                    this.getModel().setValue(field, null);
                }
                boolean isIdentity = typeDy.getBoolean("isidentity");
                if (this.isFieldExist("isidentity")) {
                    this.getModel().setValue("isidentity", (Object)(isIdentity ? "1" : "0"));
                }
                PercreFieldUtils.setInfo(this.getView());
                break;
            }
            case "ismajor": {
                Long personId;
                QFilter qFilter;
                DynamicObject dy;
                Long pkId;
                DynamicObject updateDy;
                if (Boolean.TRUE.equals(Boolean.parseBoolean(newValue.toString()))) {
                    String typeName = this.getModel().getDataEntity().getString("credentialstype.name");
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c06\u6210\u4e3a\u65b0\u7684\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_32", (String)"hr-hspm-formplugin", (Object[])new Object[0]), typeName));
                    break;
                }
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String pkIdStr = (String)formShowParameter.getCustomParam("pkid");
                if (!HRStringUtils.isNotEmpty((String)pkIdStr) || !(updateDy = this.serviceHelper.loadSingle((Object)(pkId = Long.valueOf(Long.parseLong(pkIdStr))))).getBoolean(IS_MAJOR) || !"1".equals(updateDy.getString("datastatus")) || (dy = this.serviceHelper.queryOne("credentialstype", new QFilter[]{qFilter = new QFilter("person", "=", (Object)(personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person")))).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("id", "!=", (Object)pkId))}, "createtime desc")) == null) break;
                PageCacheUtils.getHomePageCache((IFormView)this.getView()).put("preMajorId", dy.getString("id"));
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c06\u6210\u4e3a\u65b0\u7684\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_32", (String)"hr-hspm-formplugin", (Object[])new Object[0]), dy.getString("credentialstype.name")));
                break;
            }
            case "faceimage": {
                if (!HRStringUtils.isNotEmpty((String)((String)newValue)) || !HspmCommonConstants.NUMBER_1010_ID.equals(type) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromFaceOcr(newValue.toString());
                break;
            }
            case "reverseimage": {
                if (!HRStringUtils.isNotEmpty((String)((String)newValue)) || !HspmCommonConstants.NUMBER_1010_ID.equals(type) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromReverseOcr(newValue.toString());
                break;
            }
            case "birthday": {
                if (((Date)newValue).before(HspmDateUtils.getMidnight())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "issuedate": {
                if (((Date)newValue).before(HspmDateUtils.getMidnight())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "number": {
                DynamicObject dy = this.getModel().getDataEntity();
                this.isPercreNumberRepeat(dy.getString("number"), dy.getLong("credentialstype.id"));
                PercreFieldUtils.parseNumber(dy.getString("number"), this.getView());
                break;
            }
            case "isnofixedterm": {
                BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromFaceOcr(String url) {
        block15: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                QFilter qFilter;
                HRBaseServiceHelper sexServiceHelper;
                DynamicObject sex;
                AlgoResultData data = ((IHspmOcrService)ServiceFactory.getService(IHspmOcrService.class)).distinguishOcrImage(this.getView().getEntityId(), "OPM-IdCardBack", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    break block15;
                }
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block15;
                }
                IdCardBackResult result = (IdCardBackResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardBackResult.class);
                if (this.isFieldExist("percardname") && HRStringUtils.isNotEmpty((String)result.getName())) {
                    this.getModel().setValue("percardname", (Object)result.getName());
                }
                if (this.isFieldExist("gender") && HRStringUtils.isNotEmpty((String)result.getSex()) && (sex = (sexServiceHelper = new HRBaseServiceHelper("hbss_sex")).loadDynamicObject(qFilter = new QFilter("name", "=", (Object)result.getSex()).and("enable", "=", (Object)"1").and("status", "=", (Object)"C"))) != null) {
                    this.getModel().setValue("gender", (Object)sex);
                }
                if (this.isFieldExist("folk") && HRStringUtils.isNotEmpty((String)result.getNation())) {
                    HRBaseServiceHelper flokServiceHelper = new HRBaseServiceHelper("hbss_flok");
                    String suffix = ResManager.loadKDString((String)"\u65cf", (String)"PercreDrawPlugin_36", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    QFilter qFilter2 = new QFilter("name", "=", (Object)(result.getNation() + suffix)).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
                    DynamicObject folk = flokServiceHelper.loadDynamicObject(qFilter2);
                    if (folk != null) {
                        this.getModel().setValue("folk", (Object)folk);
                    }
                }
                if (this.isFieldExist("birthday") && HRStringUtils.isNotEmpty((String)result.getBirth())) {
                    Date birthday = null;
                    try {
                        birthday = HspmDateUtils.parseDate((String)result.getBirth(), (String)"yyyy-MM-dd");
                    }
                    catch (ParseException parseException) {
                        logger.error("parse date error, birthday: {}", (Object)result.getBirth(), (Object)parseException);
                    }
                    if (birthday != null) {
                        this.getModel().setValue("birthday", (Object)birthday);
                    }
                }
                if (this.isFieldExist("idcardaddress") && HRStringUtils.isNotEmpty((String)result.getAddress())) {
                    this.getModel().setValue("idcardaddress", (Object)result.getAddress());
                }
                if (this.isFieldExist("number") && HRStringUtils.isNotEmpty((String)result.getIdNum())) {
                    this.getModel().setValue("number", (Object)result.getIdNum());
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromReverseOcr(String url) {
        block10: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                int sepIndex;
                boolean isNeedSet;
                AlgoResultData data = ((IHspmOcrService)ServiceFactory.getService(IHspmOcrService.class)).distinguishOcrImage(this.getView().getEntityId(), "OPM-IDCardFront", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    break block10;
                }
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block10;
                }
                IdCardFrontResult result = (IdCardFrontResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardFrontResult.class);
                if (HRStringUtils.isNotEmpty((String)result.getAuthority()) && this.isFieldExist("issuingauthor")) {
                    this.getModel().setValue("issuingauthor", (Object)result.getAuthority());
                }
                boolean bl = isNeedSet = HRStringUtils.isNotEmpty((String)result.getValidDate()) && (this.isFieldExist("issuedate") || this.isFieldExist("expirationdate"));
                if (!isNeedSet || (sepIndex = result.getValidDate().indexOf(45)) <= 0) break block10;
                Date issueDate = null;
                Date expirationDate = null;
                try {
                    issueDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(0, sepIndex), (String)"yyyy.MM.dd");
                    expirationDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(sepIndex + 1), (String)"yyyy.MM.dd");
                }
                catch (ParseException parseException) {
                    logger.error("parse date error, validDate: {}", (Object)result.getValidDate(), (Object)parseException);
                }
                if (issueDate != null && this.isFieldExist("issuedate")) {
                    this.getModel().setValue("issuedate", (Object)issueDate);
                }
                if (expirationDate != null && this.isFieldExist("expirationdate")) {
                    this.getModel().setValue("expirationdate", (Object)expirationDate);
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    protected boolean isFieldHidden(DrawFormFieldDto dto) {
        Set showList;
        long type = this.getModel().getDataEntity().getLong("credentialstype.id");
        if (type != 0L && !PercreFieldUtils.TYPE_FIELD_MAP.containsKey(type)) {
            type = HspmCommonConstants.NUMBER_1150_ID;
        }
        if (HspmCommonConstants.NUMBER_1150_ID.equals(type) && dto.getClassSimpleName().equals(ATTACHMENT_PROP)) {
            return false;
        }
        PercreField percreField = PercreFieldUtils.TYPE_FIELD_MAP.get(type);
        Set set = showList = percreField != null ? percreField.getFieldSet() : PercreFieldUtils.DEFAULT_SHOW;
        return !showList.contains(dto.getField());
    }

    protected Map<String, String> getRenameFields() {
        long type = this.getModel().getDataEntity().getLong("credentialstype.id");
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        if (!HspmCommonConstants.NUMBER_1010_ID.equals(type) && !HspmCommonConstants.NUMBER_1050_ID.equals(type)) {
            hashMap.put("faceimage", ResManager.loadKDString((String)"\u8bc1\u4ef6\u4e3b\u9875", (String)"PercreMobEditPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return hashMap;
    }

    protected Set<String> shouldNotIgnoreField() {
        HashSet<String> set = new HashSet<String>();
        set.add("isidentity");
        return set;
    }
}

