/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.mobile.updaterecord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.changerecord.ChangeRecordHelper;
import kd.hr.hspm.business.mobile.ChangeRecordDrawHelper;
import kd.sdk.hr.hspm.business.helper.CardDrawElyMobHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

public class ChangeRecordMobPlugin
extends AbstractMobFormPlugin
implements TabSelectListener {
    protected List<Map<String, Object>> infoGroups = null;
    private static final String TABINFO_MAP = "tabInfoMap";
    private static final String TABPAGENAME_MAP = "tabPageNameMap";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.analysisConfigParams();
        this.handleConfigParams();
        this.draw();
    }

    private void draw() {
        TabAp tabap = new TabAp();
        tabap.setId("changeTabap");
        tabap.setKey(tabap.getId());
        tabap.setGrow(1);
        tabap.setShrink(0);
        tabap.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbnNwYW4uXzJxbzQ5djk2e1xuICBtYXgtd2lkdGg6MTgwcHghaW1wb3J0YW50O1xufSJ9");
        Map tabPageNameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABPAGENAME_MAP), Map.class);
        Map tabInfoMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_MAP), Map.class);
        for (Map.Entry entry : tabInfoMap.entrySet()) {
            List<Map<String, Object>> list = this.getChangeRecord((List)entry.getValue(), true);
            if (CollectionUtils.isEmpty(list)) continue;
            String tabName = (String)tabPageNameMap.get(entry.getKey());
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setId((String)entry.getKey());
            tabPageAp.setKey((String)entry.getKey());
            tabPageAp.setName(new LocaleString(tabName));
            tabap.getItems().add(tabPageAp);
        }
        FlexPanelAp containerFlex = ChangeRecordDrawHelper.createContainer((String)"changecontent");
        if (CollectionUtils.isEmpty((Collection)tabap.getItems())) {
            FlexPanelAp noDataFlex = CardDrawElyMobHelper.createNotDataFlext((String)"changecontent");
            this.getView().updateControlMetadata("changecontent", noDataFlex.createControl());
        } else {
            containerFlex.getItems().add(tabap);
            this.getView().updateControlMetadata("changecontent", containerFlex.createControl());
            Tab tab = (Tab)this.getControl("changeTabap");
            tab.selectTab(((ControlAp)tabap.getItems().get(0)).getKey());
        }
    }

    private void analysisConfigParams() {
        Map infoGroupConfig;
        String cnfStr;
        if (this.getView().getParentView() != null && HRStringUtils.isNotEmpty((String)(cnfStr = this.getView().getParentView().getPageCache().get("cnfjson"))) && (infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class)) != null) {
            this.infoGroups = (List)infoGroupConfig.get("mainentry");
            if (this.infoGroups != null) {
                this.handleConfigParams();
                return;
            }
        }
        throw new KDBizException("not infoGroupConfig param");
    }

    private void handleConfigParams() {
        LinkedHashMap<String, List<String>> tabInfoMap = new LinkedHashMap<String, List<String>>(this.infoGroups.size());
        LinkedHashMap<String, String> tabPageNameMap = new LinkedHashMap<String, String>(this.infoGroups.size());
        for (Map<String, Object> group : this.infoGroups) {
            List subGroups = ParamAnalysisUtil.getGroups(group);
            String mappingFromId = (String)group.get("mappingFormid");
            String groupName = (String)group.get("groupname");
            if ("hrpi_pereduexp".equals(mappingFromId) || "hrpi_pereduexpcert".equals(mappingFromId)) {
                tabInfoMap.put(groupName.toLowerCase(), Arrays.asList("hrpi_pereduexp", "hrpi_pereduexpcert"));
                tabPageNameMap.put(groupName.toLowerCase(), groupName);
                continue;
            }
            if (InfoGroupHelper.isSingleRowTpl((String)mappingFromId)) {
                HashSet<String> pageNumbers = new HashSet<String>();
                for (Map subGroup : subGroups) {
                    List fields = ParamAnalysisUtil.getFields((Map)subGroup);
                    if (CollectionUtils.isEmpty((Collection)fields)) continue;
                    for (Map field : fields) {
                        pageNumbers.add((String)field.get("pnumber"));
                    }
                }
                tabInfoMap.put(groupName.toLowerCase(), new ArrayList(pageNumbers));
                tabPageNameMap.put(groupName.toLowerCase(), groupName);
                continue;
            }
            for (Map subGroup : subGroups) {
                List fields = ParamAnalysisUtil.getFields((Map)subGroup);
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                String gName = (String)subGroup.get("gname");
                String key = groupName + "!@#" + gName;
                tabInfoMap.put(key.toLowerCase(), Collections.singletonList((String)((Map)fields.get(0)).get("pnumber")));
                tabPageNameMap.put(key.toLowerCase(), gName);
            }
        }
        this.getPageCache().put(TABINFO_MAP, SerializationUtils.toJsonString(tabInfoMap));
        this.getPageCache().put(TABPAGENAME_MAP, SerializationUtils.toJsonString(tabPageNameMap));
    }

    private List<Map<String, Object>> getChangeRecord(List<String> entityName, boolean onlyCheck) {
        Map<String, Object> values = this.getUserInfo();
        return ChangeRecordHelper.getChangeRecord(entityName, values, (boolean)true, (boolean)onlyCheck);
    }

    private Map<String, Object> getUserInfo() {
        HashMap<String, Object> values;
        if (HRStringUtils.isEmpty((String)this.getPageCache().get("userInfo"))) {
            values = new HashMap(4);
            String personId = this.getView().getParentView().getPageCache().get("personId");
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)Long.valueOf(personId));
            if (erFileDy != null) {
                values.put("person", erFileDy.getLong("person.id"));
                values.put("employee", erFileDy.getLong("employee.id"));
                values.put("depemp", erFileDy.getLong("depemp.id"));
                values.put("cmpemp", erFileDy.getLong("cmpemp.id"));
                this.getPageCache().put("userInfo", SerializationUtils.toJsonString(values));
            }
        } else {
            values = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("userInfo"), Map.class);
        }
        return values;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Map tabPageNameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABPAGENAME_MAP), Map.class);
        Map tabInfoMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(TABINFO_MAP), Map.class);
        String tabKey = tabSelectEvent.getTabKey();
        List pageNumbers = (List)tabInfoMap.get(tabKey);
        List<Map<String, Object>> list = this.getChangeRecord(pageNumbers, false);
        long sum = System.currentTimeMillis();
        if (!CollectionUtils.isEmpty(list)) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setId(tabKey);
            tabPageAp.setKey(tabKey);
            tabPageAp.setName(new LocaleString((String)tabPageNameMap.get(tabKey)));
            for (Map<String, Object> changeMap : list) {
                FlexPanelAp cardContent = ChangeRecordDrawHelper.createCardContainer((String)(tabKey + sum++));
                FlexPanelAp titleContainer = ChangeRecordDrawHelper.createTitleContainer((String)(tabKey + sum++), changeMap);
                FlexPanelAp ardContentContainer = ChangeRecordDrawHelper.createCardContentContainer((String)(tabKey + sum++), changeMap, (IFormView)this.getView());
                cardContent.getItems().add(titleContainer);
                cardContent.getItems().add(ardContentContainer);
                tabPageAp.getItems().add(cardContent);
            }
            this.getView().updateControlMetadata(tabKey, tabPageAp.createControl());
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if ("changeTabap".equalsIgnoreCase(key)) {
            Tab tab = new Tab();
            tab.setKey(key);
            tab.setView(this.getView());
            tab.addTabSelectListener((TabSelectListener)this);
            args.setControl((Control)tab);
        }
    }
}

