/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ReportPlanRepository;
import kd.hr.hspm.formplugin.web.report.helper.EmpReportHelper;
import kd.sdk.hr.hspm.common.enums.ReportTypeEnum;

public class QuitEmpReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(QuitEmpReportPlugin.class);
    private static final String LABLE_LBL_COUNT = "lbl_count";
    private static final String KEY_FILTER_GRID_AP = "filtergridap";
    private static final String IMG_CHART = "img_chart";
    private static final String IMG_REPORT = "img_report";
    private static final String CACHE_IS_REPORT = "cache_isreport";
    private static final String COLOR_SELECT = "#5582F3";
    private static final String FONT_REPORT = "kdfont kdfont-chakanbaobiao";
    private static final String FONT_CHART = "kdfont kdfont-chakantubiao";
    private static final String FIELD_ADMINIORG = "hrpi_empposorgrel.adminorg";
    private static final String FIELD_POSITION = "hrpi_empposorgrel.position";
    private static final String FIELD_JOB = "hrpi_empjobrel.job";
    private static final String FIELD_JOBGRADE = "hrpi_empjobrel.jobgrade";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MulBasedataEdit adminOrg = (MulBasedataEdit)this.getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit org = (MulBasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit laborRelTypeCls = (MulBasedataEdit)this.getControl("laborreltypecls");
        laborRelTypeCls.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit position = (MulBasedataEdit)this.getControl("position");
        position.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit report = (BasedataEdit)this.getControl("report");
        MulBasedataEdit job = (MulBasedataEdit)this.getControl("job");
        if (job != null) {
            job.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        report.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{IMG_CHART, IMG_REPORT});
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        formShowParameter.setCustomParam("customHREntityNumber", (Object)"hspm_quitreportquery");
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)FIELD_ADMINIORG);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IReportView view = this.getView();
        view.addCustomControls(new String[]{"reportlistap"});
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        filterGrid.setEntityNumber("hspm_quitreportquery");
        EmpReportHelper.setFilterFields("hspm_quitreportquery", filterGrid);
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        ReportList billList = (ReportList)this.getView().getControl("reportlistap");
        ArrayList selRows = (ArrayList)billList.getEntryState().get("selRows");
        if (!data.isEmpty() && !CollectionUtils.isEmpty((Collection)selRows)) {
            Iterator arg5 = data.iterator();
            while (arg5.hasNext()) {
                DynamicObject dyo = (DynamicObject)arg5.next();
                int fseq = (Integer)dyo.get("fseq");
                if (selRows.contains(fseq)) continue;
                arg5.remove();
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        DynamicObject report;
        super.afterCreateNewData(evt);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)dataModel.getValue("org");
        if (CollectionUtils.isEmpty((Collection)org)) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(RequestContext.getOrCreate().getOrgId());
            dataModel.setValue("org", (Object)orgIds.toArray());
        }
        if ((report = (DynamicObject)dataModel.getValue("report")) == null && (report = ReportPlanRepository.getDefaultPlan((String)ReportTypeEnum.QUITEMP.getType())) != null) {
            dataModel.setValue("report", (Object)report.getLong("id"));
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        DynamicObject displayPlan = (DynamicObject)this.getModel().getValue("report");
        if (displayPlan != null) {
            EmpReportHelper.getFilterGrid((FilterGrid)this.getControl(KEY_FILTER_GRID_AP), displayPlan.getLong("id"));
        }
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("date");
        dateRangeEdit.setMaxDate(new Date());
        String headdatestart = dateRangeEdit.getStartDateFieldKey();
        String headdateend = dateRangeEdit.getEndDateFieldKey();
        this.getModel().setValue(headdatestart, (Object)HRDateTimeUtils.getFirstDayOfCurrentMonth());
        this.getModel().setValue(headdateend, (Object)new Date());
        this.getView().updateView("date");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "img_chart": {
                this.setChartView(Boolean.FALSE);
                break;
            }
            case "img_report": {
                this.setChartView(Boolean.TRUE);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        ArrayList<String> errorInfo = new ArrayList<String>();
        if (filterInfo.getLong("report") == 0L) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u62a5\u8868\u663e\u793a\u65b9\u6848\u201d", (String)"QuitEmpReportPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        if (!errorInfo.isEmpty()) {
            String errorMsg = String.join((CharSequence)"\u3001", errorInfo.toArray(new String[0]));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"QuitEmpReportPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), errorMsg));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        if (queryParam != null) {
            Map<String, Object> paramMap = this.transQueryParam(queryParam);
            this.getPageCache().put("qingFilter", SerializationUtils.toJsonString(paramMap));
        }
        super.beforeQuery(queryParam);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.setHasSettingRow(false);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("empRptPageId", this.getView().getPageId());
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filterRow = filterCondition.getFilterRow();
        HashMap basedataIdMap = new HashMap(16);
        for (SimpleFilterRow simpleFilterRow : filterRow) {
            List baseDataIds = simpleFilterRow.getBaseDataIds();
            if (CollectionUtils.isEmpty((Collection)baseDataIds)) continue;
            List baseDataIdList = baseDataIds.stream().map(filterValue -> Long.parseLong(String.valueOf(filterValue.getValue()))).collect(Collectors.toList());
            basedataIdMap.put(simpleFilterRow.getFieldName(), baseDataIdList);
        }
        map.put("empCommonfilterBasedataId", basedataIdMap);
        this.getQueryParam().setCustomParam(map);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportView view = (ReportView)this.getView();
        HRPageCache pageCache = new HRPageCache((IFormView)view);
        Boolean flag = (Boolean)pageCache.get(CACHE_IS_REPORT, Boolean.class);
        this.setChartView(flag);
        int rowCount = EmpReportHelper.getRowCount((ReportList)this.getControl("reportlistap"));
        Label label = (Label)view.getControl(LABLE_LBL_COUNT);
        label.setText(MessageFormat.format(ResManager.loadKDString((String)"\uff08\u603b\u6761\u6570\uff1a{0}\uff09", (String)"QuitEmpReportPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), rowCount));
        LOGGER.info(MessageFormat.format("QuitEmpReportPlugin.afterQuery---end rowCount={0}", rowCount));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        if (HRStringUtils.equals((String)fieldKey, (String)"report")) {
            filters.add(ReportPlanRepository.getPlanFilter((String)ReportTypeEnum.QUITEMP.getType()));
            showParameter.setCustomParam("type", (Object)ReportTypeEnum.QUITEMP.getType());
        } else if (HRStringUtils.equals((String)fieldKey, (String)"adminorg")) {
            EmpReportHelper.addAdminOrgFilter(evt.getSourceMethod(), filters, "structlongnumber", "boid");
            Date date = this.getModel().getDataEntity().getDate("enddate");
            showParameter.setCustomParam("searchdate", (Object)date);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"position")) {
            EmpReportHelper.addAdminOrgFilter(evt.getSourceMethod(), filters, "adminorg.structlongnumber", "adminorg.id");
        } else if (HRStringUtils.equals((String)fieldKey, (String)"org")) {
            this.addOrgFilter(filters, "id");
        } else if (HRStringUtils.equals((String)fieldKey, (String)"job")) {
            this.addSeniorFilter(filters, FIELD_JOB);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldKey = evt.getFieldName();
        List filters = evt.getQfilters();
        if (fieldKey.startsWith("org")) {
            this.addOrgFilter(filters, "id");
        } else if (fieldKey.startsWith(FIELD_ADMINIORG)) {
            Date date = this.getModel().getDataEntity().getDate("enddate");
            evt.addCustomParam("searchdate", (Object)date);
            MulBasedataEdit adminorgEdit = (MulBasedataEdit)this.getView().getControl("adminorg");
            MulBasedataProp property = (MulBasedataProp)adminorgEdit.getProperty();
            evt.setRefEntityId(property.getBaseEntityId());
        } else if (fieldKey.startsWith(FIELD_POSITION)) {
            LOGGER.info("QuitEmpReportPlugin#beforeF7Select hrpi_empposorgrel.position");
        } else {
            this.addSeniorFilter(filters, fieldKey);
        }
        if (fieldKey.startsWith(FIELD_JOBGRADE)) {
            this.addCurrentVersionFilter(filters, "jobgradescm.iscurrentversion");
            this.addCurrentVersionFilter(filters, "jobgradescm.datastatus");
        }
    }

    private void addCurrentVersionFilter(List<QFilter> filters, String fieldName) {
        filters.add(new QFilter(fieldName, "=", (Object)"1"));
    }

    private void addSeniorFilter(List<QFilter> filters, String fieldName) {
        QFilter dataRuleFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "1WXBPN7+OHJZ", "hspm_quitreportquery", fieldName, "47150e89000000ac", Collections.emptyMap()});
        if (dataRuleFilter != null) {
            filters.add(dataRuleFilter);
        }
    }

    private void addOrgFilter(List<QFilter> filters, String fieldName) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"1WXBPN7+OHJZ", (String)"hspm_quitreportquery", (String)"47150e89000000ac");
        if (result == null) {
            return;
        }
        if (!result.hasAllOrgPerm()) {
            filters.add(new QFilter(fieldName, "in", (Object)result.getHasPermOrgs()));
        }
    }

    private Map<String, Object> transQueryParam(ReportQueryParam param) {
        List filterItemInfos = param.getFilter().getFilterItems();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)filterItemInfos.size());
        for (FilterItemInfo filterItem : filterItemInfos) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    private void setChartView(Boolean flag) {
        VectorAp chartAp;
        VectorAp reportAp;
        if (flag == null) {
            return;
        }
        this.getView().setVisible(flag, new String[]{"reportlistap"});
        if (flag.booleanValue()) {
            reportAp = QuitEmpReportPlugin.createVectorAp(IMG_REPORT, null, null, FONT_REPORT, COLOR_SELECT);
            chartAp = QuitEmpReportPlugin.createVectorAp(IMG_CHART, "5px", "10px", FONT_CHART, "#CCCCCC");
        } else {
            reportAp = QuitEmpReportPlugin.createVectorAp(IMG_REPORT, null, null, FONT_REPORT, "#CCCCCC");
            chartAp = QuitEmpReportPlugin.createVectorAp(IMG_CHART, "5px", "10px", FONT_CHART, COLOR_SELECT);
        }
        this.getView().updateControlMetadata(IMG_REPORT, reportAp.createControl());
        this.getView().updateControlMetadata(IMG_CHART, chartAp.createControl());
        HRPageCache pageCache = new HRPageCache((IFormView)this.getView());
        pageCache.put(CACHE_IS_REPORT, (Object)flag);
    }

    private static VectorAp createVectorAp(String key, String left, String right, String font, String color) {
        VectorAp imageAp = new VectorAp();
        imageAp.setKey(key);
        imageAp.setfontClass(font);
        imageAp.setForeColor(color);
        Margin imageMargin = new Margin();
        if (HRStringUtils.isNotEmpty((String)left)) {
            imageMargin.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            imageMargin.setRight(right);
        }
        Style imgStyle = new Style();
        imgStyle.setMargin(imageMargin);
        imageAp.setStyle(imgStyle);
        return imageAp;
    }
}

