/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.business.domian.repository.ReportPlanRepository;
import kd.hr.hspm.formplugin.web.report.helper.ReportDisplayHelper;
import kd.sdk.hr.hspm.common.enums.ReportTypeEnum;

public class ReportConfigPlugin
extends HRDynamicFormBasePlugin {
    private static final String FLEX_DETAIL = "flexdetail";
    private static final String KEY_USERPLAN_FLEX = "flexuserplan";
    private static final String KEY_CONTENT_FLEX = "flex_content";
    private static final String KEY_PLAN_FLEX = "flex_plan";
    private static final String KEY_PLAN_LABEL = "lbl_plan";
    private static final String KEY_ADDPLAN_FLEX = "flexaddplan";
    private static final String KEY_ISSYSPRESET = "issyspreset";
    private static final String KEY_ISDEFAULT = "isdefault";
    private static final String KEY_DELETE_IMG = "img_delete";
    private static final String KEY_DELETE_FLEX = "flex_delete";
    private static final String KEY_ADD_IMG = "img_add";
    private static final String KEY_ADD_LABEL = "lbl_add";
    private static final String KEY_MORE_IMG = "imgmore";
    private static final String KEY_MORE_LABEL = "lblmore";
    private static final String KEY_MORE_FLEX = "flexmore";
    private static final String KEY_TAG = "tag";
    private static final String CACHE_SELECTID = "cache_selectid";
    private static final String CACHE_PLANINFO = "cache_planinfo";
    private static final String CACHE_GROUP = "cache_group";
    private static final String COLOR_GRAY = "color_gray";
    private static final String COLOR_BLUE = "color_blue";
    private static final String FONT_RIGHT = "kdfont kdfont-right";
    private static final String FONT_BOTTOM = "kdfont kdfont-bottom";
    private static final String FONT_DELETE = "kdfont kdfont-shanchu-s";
    private static final String URL_ADD = "/icons/pc/other/add_16_16.png";
    private static final String EVENT_DELETE = "event_delete";
    private static final String KEY_DETAIL_EVENT = "detail_event";
    private static final String BODER_SOLID = "_solid_";
    private static final String BODER_DASHED = "_dashed_";
    private static final String OP_ADD = "donothing_add";
    private static final String OP_DELETE = "donothing_delete";
    private static final int MAX_COUNT = 4;
    private static final int FONT_LIMIT_COUNT = 8;
    private static final int MAX_PLAN_COUNT = 9;
    private static final SchemeQuery SCHEME_QUERY = new SchemeQuery();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{KEY_MORE_IMG, KEY_MORE_LABEL, KEY_MORE_FLEX});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Container container = (Container)this.getView().getControl(KEY_USERPLAN_FLEX);
        FlexPanelAp flexAp = this.buildUserPlans();
        container.getItems().addAll(((Container)flexAp.buildRuntimeControl()).getItems());
        IFormView view = this.getView();
        view.createControlIndex(container.getItems());
        view.updateControlMetadata(KEY_USERPLAN_FLEX, flexAp.createControl());
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
        this.initMorePanel(pageCache, planInfo);
        this.initSelectedPlan(pageCache, planInfo);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.contains(KEY_PLAN_LABEL) || KEY_ADD_LABEL.equals(key)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            if (KEY_ADD_LABEL.equals(key)) {
                label.setOperationKey(OP_ADD);
            }
            args.setControl((Control)label);
        }
        if (key.contains(KEY_DELETE_IMG) || KEY_ADD_IMG.equals(key)) {
            Image img = new Image();
            img.setKey(key);
            img.setView(this.getView());
            img.addClickListener((ClickListener)this);
            if (key.contains(KEY_DELETE_IMG)) {
                img.setOperationKey(OP_DELETE);
            }
            args.setControl((Control)img);
        }
        if (KEY_ADDPLAN_FLEX.equals(key) || key.contains(KEY_PLAN_FLEX) || key.contains(KEY_CONTENT_FLEX)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            if (key.contains(KEY_ADDPLAN_FLEX)) {
                container.setOperationKey(OP_ADD);
            }
            args.setControl((Control)container);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        HRPageCache pageCache = new HRPageCache(this.getView());
        this.handleSelectPlan(key, pageCache);
        this.handleMorePanel(key, pageCache);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        this.checkAddPlan(key, args);
        this.checkDeletePlan(key, args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        this.handleAddPlan(key);
        this.handleDeletePlan(key);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() == MessageBoxResult.Yes && HRStringUtils.equals((String)EVENT_DELETE, (String)evt.getCallBackId())) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
            ReportPlanRepository.delete((Long)Long.valueOf(currentId));
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_DETAIL_EVENT)) {
            this.getView().close();
        }
    }

    private void updateLabel(String color, String message, String key) {
        LabelAp labelAp = new LabelAp();
        labelAp.setForeColor(color);
        labelAp.setHidden(true);
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(message));
        this.getView().updateControlMetadata(key, labelAp.createControl());
    }

    private FlexPanelAp createPlanFlexPanel(String key, String boderColor, String boderType) {
        FlexPanelAp planAp = new FlexPanelAp();
        planAp.setClickable(true);
        planAp.setKey(key);
        planAp.setWidth(new LocaleString("160px"));
        planAp.setHeight(new LocaleString("30px"));
        planAp.setWrap(false);
        planAp.setGrow(0);
        planAp.setAlignItems("center");
        planAp.setJustifyContent("center");
        Padding padding = new Padding();
        padding.setTop("1px");
        padding.setBottom("1px");
        Margin imageMargin = new Margin();
        imageMargin.setRight("12px");
        Style flexStyle = new Style();
        flexStyle.setMargin(imageMargin);
        Border border = new Border();
        String borderType = "1px" + boderType + boderColor;
        border.setTop(borderType);
        border.setBottom(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        flexStyle.setBorder(border);
        planAp.setStyle(flexStyle);
        return planAp;
    }

    private FlexPanelAp buildUserPlans() {
        IFormView view = this.getView();
        HRPageCache pageCache = new HRPageCache(view);
        DynamicObject[] userPlans = ReportPlanRepository.getUserPlan((String)ReportDisplayHelper.getType(view));
        int length = userPlans.length;
        FlexPanelAp totalAp = new FlexPanelAp();
        totalAp.setKey(KEY_USERPLAN_FLEX);
        totalAp.setWrap(true);
        totalAp.setGrow(0);
        totalAp.setAlignItems("center");
        totalAp.setJustifyContent("flex-start");
        int group = (length + 1) / 4 + 1;
        HashMap<String, DynamicObject> planInfo = new HashMap<String, DynamicObject>(length);
        int currentIndex = 0;
        pageCache.put(CACHE_GROUP, (Object)group);
        for (int index = 0; index < group; ++index) {
            FlexPanelAp userPlanAp = new FlexPanelAp();
            userPlanAp.setKey(KEY_USERPLAN_FLEX + index);
            userPlanAp.setWrap(true);
            userPlanAp.setGrow(0);
            userPlanAp.setAlignItems("center");
            userPlanAp.setJustifyContent("flex-start");
            Style style = new Style();
            if (index != 0) {
                Margin margin = new Margin();
                margin.setTop("10px");
                style.setMargin(margin);
            }
            userPlanAp.setStyle(style);
            if (index == 0) {
                FlexPanelAp addPlanAp = this.createAddPlanAp();
                userPlanAp.getItems().add(addPlanAp);
            }
            for (int index1 = 0; index1 <= 4 && currentIndex < length && (index != 0 || index1 != 4); ++index1, ++currentIndex) {
                Long id = userPlans[currentIndex].getLong("id");
                String name = userPlans[currentIndex].getString("name");
                Boolean isSystem = userPlans[currentIndex].getBoolean(KEY_ISSYSPRESET);
                FlexPanelAp planAp = this.createPlanAp(id, name, isSystem, COLOR_GRAY);
                planInfo.put(String.valueOf(id), userPlans[currentIndex]);
                userPlanAp.getItems().add(planAp);
            }
            totalAp.getItems().add(userPlanAp);
        }
        pageCache.put(CACHE_PLANINFO, planInfo);
        return totalAp;
    }

    private FlexPanelAp createAddPlanAp() {
        FlexPanelAp addPlanAp = this.createPlanFlexPanel(KEY_ADDPLAN_FLEX, "#5E80EB", BODER_DASHED);
        addPlanAp.setOperationKey(OP_ADD);
        ImageAp addImageAp = new ImageAp();
        addImageAp.setClickable(true);
        addImageAp.setOperationKey(OP_ADD);
        addImageAp.setKey(KEY_ADD_IMG);
        addImageAp.setImageKey(URL_ADD);
        LabelAp addLabel = ReportConfigPlugin.createLabelAp(KEY_ADD_LABEL, ResManager.loadKDString((String)"\u6dfb\u52a0\u65b9\u6848", (String)"ReportConfigPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), "#5E80EB", "5px", null);
        addLabel.setWidth(new LocaleString("60"));
        addLabel.setOperationKey(OP_ADD);
        addPlanAp.getItems().add(addImageAp);
        addPlanAp.getItems().add(addLabel);
        return addPlanAp;
    }

    private void updatePlanAp(Map<String, LinkedHashMap<String, Object>> planInfo, String currentId, String type) {
        LinkedHashMap<String, Object> obj = planInfo.get(currentId);
        String name = (String)obj.get("name");
        Boolean isSystem = (Boolean)obj.get(KEY_ISSYSPRESET);
        FlexPanelAp planFlexAp = this.createPlanAp(Long.valueOf(currentId), name, isSystem, type);
        this.getView().updateControlMetadata(KEY_PLAN_FLEX + currentId, planFlexAp.createControl());
    }

    private FlexPanelAp createPlanAp(Long id, String name, Boolean isSystem, String type) {
        String color = "";
        String boderColor = "";
        switch (type) {
            case "color_gray": {
                color = "#666666";
                boderColor = "#bbbbbb";
                break;
            }
            case "color_blue": {
                color = "#5E80EB";
                boderColor = "#5E80EB";
                break;
            }
        }
        FlexPanelAp planAp = this.createPlanFlexPanel(KEY_PLAN_FLEX + id, boderColor, BODER_SOLID);
        FlexPanelAp contentAp = new FlexPanelAp();
        contentAp.setClickable(true);
        contentAp.setKey(KEY_CONTENT_FLEX + id);
        contentAp.setWrap(false);
        contentAp.setGrow(1);
        Style contentStyle = new Style();
        Margin contentMargin = new Margin();
        contentMargin.setRight("5px");
        contentMargin.setLeft("5px");
        contentStyle.setMargin(contentMargin);
        contentAp.setStyle(contentStyle);
        contentAp.setAlignItems("center");
        contentAp.setJustifyContent("center");
        planAp.getItems().add(contentAp);
        LabelAp label = ReportConfigPlugin.createLabelAp(KEY_PLAN_LABEL + id, name, color, null, null);
        contentAp.getItems().add(label);
        if (!isSystem.booleanValue()) {
            FlexPanelAp delAp = new FlexPanelAp();
            delAp.setClickable(true);
            delAp.setKey(KEY_DELETE_FLEX + id);
            delAp.setWrap(true);
            delAp.setGrow(0);
            delAp.setJustifyContent("flex-end");
            VectorAp deleteVectorAp = new VectorAp();
            deleteVectorAp.setKey(KEY_DELETE_IMG + id);
            deleteVectorAp.setClickable(true);
            deleteVectorAp.setOperationKey(OP_DELETE);
            Margin imageMargin = new Margin();
            imageMargin.setRight("5px");
            Style imgStyle = new Style();
            imgStyle.setMargin(imageMargin);
            deleteVectorAp.setStyle(imgStyle);
            deleteVectorAp.setfontClass(FONT_DELETE);
            deleteVectorAp.setForeColor("#F5F6F8");
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DELETE_IMG + id});
            delAp.getItems().add(deleteVectorAp);
            planAp.getItems().add(delAp);
        } else {
            LabelAp tag = this.createDefaultLabelAp(KEY_TAG + id, ResManager.loadKDString((String)"\u9884\u7f6e", (String)"ReportConfigPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), color, boderColor);
            contentAp.getItems().add(tag);
        }
        return planAp;
    }

    private LabelAp createDefaultLabelAp(String apKey, String text, String color, String boderColor) {
        return ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(apKey).setName(text).setFontSize(10).setForeColor(color).setGrow(0).setShrink(1).setWidth(new LocaleString("40px")).setRadius("10px").setMarginLeft("5px")).setPaddingLeft("5px")).setPaddingRight("5px")).setBorderBottom("1px_solid_" + boderColor)).setBorderLeft("1px_solid_" + boderColor)).setBorderRight("1px_solid_" + boderColor)).setBorderTop("1px_solid_" + boderColor)).setTextAlign("center").build();
    }

    private static LabelAp createLabelAp(String key, String name, String color, String marginLeft, String marginRight) {
        LabelAp lblName = new LabelAp();
        lblName.setKey(key);
        lblName.setClickable(true);
        lblName.setName(new LocaleString(name));
        if (name.length() > 8) {
            lblName.setWidth(new LocaleString("100px"));
        }
        if (HRStringUtils.isNotEmpty((String)color)) {
            lblName.setForeColor(color);
        }
        lblName.setFontSize(12);
        Style style = new Style();
        Margin margin = new Margin();
        if (HRStringUtils.isNotEmpty((String)marginLeft)) {
            margin.setLeft(marginLeft);
        }
        if (HRStringUtils.isNotEmpty((String)marginRight)) {
            margin.setRight(marginRight);
        }
        style.setMargin(margin);
        lblName.setStyle(style);
        return lblName;
    }

    private void setBasePamaterShow(String targetKey, String formId, Long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        if (pkId != null) {
            baseShowParameter.setPkId((Object)pkId);
            baseShowParameter.setStatus(OperationStatus.EDIT);
        }
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DETAIL_EVENT));
        baseShowParameter.getOpenStyle().setTargetKey(targetKey);
        baseShowParameter.setFormId(formId);
        baseShowParameter.setCustomParam("type", (Object)ReportDisplayHelper.getType(this.getView()));
        baseShowParameter.setSendToClient(true);
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void initMorePanel(HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo) {
        boolean isHide;
        Boolean isNeedMore = planInfo.size() > 4;
        this.getView().setVisible(isNeedMore, new String[]{KEY_MORE_FLEX});
        Integer isMore = (Integer)pageCache.get(KEY_MORE_LABEL, Integer.class);
        boolean bl = isHide = isNeedMore != false && (isMore == null || 1 == isMore);
        if (isHide) {
            int group = (Integer)pageCache.get(CACHE_GROUP, Integer.class);
            for (int index = 1; index < group; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_USERPLAN_FLEX + index});
            }
            pageCache.put(KEY_MORE_LABEL, (Object)1);
        }
    }

    private void handleSelectPlan(String key, HRPageCache pageCache) {
        if (key.contains(KEY_PLAN_LABEL) || key.contains(KEY_PLAN_FLEX) || key.contains(KEY_CONTENT_FLEX)) {
            String id = key.replace(KEY_PLAN_LABEL, "");
            id = id.replace(KEY_PLAN_FLEX, "");
            id = id.replace(KEY_CONTENT_FLEX, "");
            String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
            Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
            if (HRStringUtils.isNotEmpty((String)currentId)) {
                this.updatePlanAp(planInfo, currentId, COLOR_GRAY);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DELETE_IMG + currentId});
            }
            this.setSelectedPlan(pageCache, planInfo, id);
        }
    }

    private void initSelectedPlan(HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo) {
        Long id;
        String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
        if (HRStringUtils.isEmpty((String)currentId) || !planInfo.containsKey(currentId)) {
            DynamicObject obj = ReportPlanRepository.getDefaultPlan((String)ReportDisplayHelper.getType(this.getView()));
            id = obj.getLong("id");
            pageCache.put(CACHE_SELECTID, (Object)String.valueOf(id));
        } else {
            id = Long.valueOf(currentId);
        }
        this.setSelectedPlan(pageCache, planInfo, String.valueOf(id));
    }

    private void setSelectedPlan(HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo, String id) {
        this.updatePlanAp(planInfo, id, COLOR_BLUE);
        String deleteKey = KEY_DELETE_IMG + id;
        this.getView().setVisible(Boolean.TRUE, new String[]{deleteKey});
        pageCache.put(CACHE_SELECTID, (Object)id);
        this.setBasePamaterShow(FLEX_DETAIL, ((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(ReportDisplayHelper.getType(this.getView()))).getPlan(), Long.valueOf(id));
    }

    private void handleMorePanel(String key, HRPageCache pageCache) {
        block4: {
            if (!KEY_MORE_IMG.equals(key) && !KEY_MORE_LABEL.equals(key) && !KEY_MORE_FLEX.equals(key)) break block4;
            Vector imgMore = (Vector)this.getControl(KEY_MORE_IMG);
            int group = (Integer)pageCache.get(CACHE_GROUP, Integer.class);
            Integer more = (Integer)pageCache.get(KEY_MORE_LABEL, Integer.class);
            if (more == null || 1 == more) {
                this.updateLabel("#5E80EB", ResManager.loadKDString((String)"\u6536\u8d77", (String)"ReportConfigPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), KEY_MORE_LABEL);
                imgMore.setFontClass(FONT_BOTTOM);
                pageCache.put(KEY_MORE_LABEL, (Object)0);
                for (int index = 1; index < group; ++index) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_USERPLAN_FLEX + index});
                }
            } else {
                this.updateLabel("#5E80EB", ResManager.loadKDString((String)"\u5c55\u5f00", (String)"ReportConfigPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), KEY_MORE_LABEL);
                imgMore.setFontClass(FONT_RIGHT);
                pageCache.put(KEY_MORE_LABEL, (Object)1);
                for (int index = 1; index < group; ++index) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_USERPLAN_FLEX + index});
                }
            }
        }
    }

    private void checkAddPlan(String key, BeforeDoOperationEventArgs args) {
        DynamicObject[] planDys;
        if (OP_ADD.equals(key) && (planDys = ReportPlanRepository.getUserPlan((String)ReportDisplayHelper.getType(this.getView()))).length >= 9) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff1a\u663e\u793a\u65b9\u6848\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", (String)"ReportConfigPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkDeletePlan(String key, BeforeDoOperationEventArgs args) {
        if (OP_DELETE.equals(key)) {
            IFormView view = this.getView();
            List schemes = SCHEME_QUERY.getSchemeList(((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(ReportDisplayHelper.getType(view))).getPage());
            HRPageCache pageCache = new HRPageCache(this.getView());
            if (!schemes.isEmpty()) {
                Long currentId = HRJSONUtils.getLongValOfCustomParam((Object)pageCache.get(CACHE_SELECTID, String.class));
                schemes.stream().forEach(item -> {
                    Object reportId = HRJSONUtils.convertJSONObjectToMap(HRJSONUtils.convertJSONObjectToMap((Object)item.getScheme()).get("custfilters")).get("report_id");
                    if (currentId.equals(reportId)) {
                        String warnTip = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u5f53\u524d\u7ed3\u6784\u65b9\u6848\u5df2\u88ab\u5f15\u7528\u3002", (String)"ReportConfigPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                        view.showTipNotification(warnTip);
                        args.setCancel(true);
                    }
                });
            }
        }
    }

    private void handleAddPlan(String key) {
        if (OP_ADD.equals(key)) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
            if (HRStringUtils.isNotEmpty((String)currentId)) {
                Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
                this.updatePlanAp(planInfo, currentId, COLOR_GRAY);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DELETE_IMG + currentId});
                pageCache.remove(currentId);
            }
            this.setBasePamaterShow(FLEX_DETAIL, ((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(ReportDisplayHelper.getType(this.getView()))).getPlan(), null);
        }
    }

    private void handleDeletePlan(String key) {
        if (OP_DELETE.equals(key)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(EVENT_DELETE, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u540e\u7684\u201c\u62a5\u8868\u663e\u793a\u65b9\u6848\u201d\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"ReportConfigPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }
}

