/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.common.constants.report.enums.SortRuleEnum;
import kd.hr.hspm.formplugin.web.report.ReportPlanPlugin;
import kd.hr.hspm.formplugin.web.report.helper.ReportDisplayHelper;
import net.sf.json.JSONObject;

public class ReportDisplayPlugin
extends ReportPlanPlugin
implements TreeNodeCheckListener,
SearchEnterListener {
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_ROOT = "billheadnode";
    private static final String MAINCODE = "main";
    private static final String CACHE_TREE = "tree";
    private static final String CACHE_ROOTNODE = "rootnode";
    private static final String FIELD_PARENTID = "parentid";
    private static final String FIELD_TEXT = "text";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        IFormView view = this.getView();
        Boolean isSys = (Boolean)this.getModel().getValue("issyspreset");
        if (!isSys.booleanValue()) {
            TreeView treeView = (TreeView)view.getControl("treeviewap");
            treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        }
        Search search = (Search)view.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IFormView view = this.getView();
        String page = ReportDisplayHelper.getQueryPage(view);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)page);
        List fields = queryEntityType.getSelectFields();
        List joinEntityList = queryEntityType.getJoinEntitys();
        Map<String, String> joinEntityAliasMap = joinEntityList.stream().collect(Collectors.toMap(JoinEntity::getAlias, JoinEntity::getDisplayName));
        List<QueryEntityTreeNode> queryEntityList = ReportDisplayPlugin.convertListType(joinEntityAliasMap, fields);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)page);
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainType, queryEntityList);
        parameter.setIncludePKField(true);
        TreeView treeView = (TreeView)view.getControl("treeviewap");
        this.buildBillTreeNodes(treeView, parameter);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            IFormView view = this.getView();
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            HRPageCache pageCache = new HRPageCache(view);
            Map nodeMap = (Map)pageCache.get(CACHE_TREE, Map.class);
            ReportDisplayHelper.DEFAULT_NODE_SET.forEach(item -> {
                JSONObject nodeJson = JSONObject.fromObject(nodeMap.get(item));
                ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
                TreeNode treeNode = (TreeNode)JSONObject.toBean((JSONObject)nodeJson, TreeNode.class);
                nodeList.add(treeNode);
                treeView.checkNodes(nodeList);
                this.handleNodeCheck(treeView, (String)item);
            });
        }
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        boolean flag;
        String searchText = evt.getText();
        IFormView view = this.getView();
        TreeView control = (TreeView)this.getControl("treeviewap");
        HRPageCache hrPageCache = new HRPageCache(view);
        TreeNode rootNode = (TreeNode)hrPageCache.get(CACHE_ROOTNODE, TreeNode.class);
        IPageCache pageCache = this.getPageCache();
        String searchNodesCacheKey = view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !HRStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeView = pageCache.get(searchNodesCacheKey);
            treeNodes = HRStringUtils.isEmpty((String)treeView) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeView, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"ReportDisplayPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        } else {
            if (HRStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    control.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    control.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"ReportDisplayPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                control.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                control.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView treeView = (TreeView)evt.getSource();
        if (HRStringUtils.equals((String)"treeviewap", (String)treeView.getKey())) {
            boolean isUncheckDefaultField;
            List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
            boolean bl = isUncheckDefaultField = ReportDisplayHelper.DEFAULT_NODE_SET.contains(nodeId) || ReportDisplayHelper.DEFAULT_PARENT_NODE_SET.contains(nodeId) && !selectNodeIds.contains(nodeId);
            if (isUncheckDefaultField) {
                HRPageCache pageCache = new HRPageCache(this.getView());
                Map nodeMap = (Map)pageCache.get(CACHE_TREE, Map.class);
                JSONObject nodeJson = JSONObject.fromObject(nodeMap.get(nodeId));
                TreeNode treeNode = (TreeNode)JSONObject.toBean((JSONObject)nodeJson, TreeNode.class);
                ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
                nodeList.add(treeNode);
                treeView.checkNodes(nodeList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5b57\u6bb5\u4e0d\u53ef\u79fb\u9664\u3002", (String)"ReportDisplayPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.handleNodeCheck(treeView, nodeId);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String propertyName = evt.getProperty().getName();
        Object newValue = evt.getChangeSet()[0].getNewValue();
        if ("sortrule".equals(propertyName) && SortRuleEnum.NONE.getType().equals(newValue)) {
            this.getModel().setValue("sortnum", (Object)0);
        }
        if ("displayalias".equals(propertyName) && newValue != null) {
            this.handleDisplayNameChange(ResManager.loadKDString((String)"%s\u663e\u793a\u540d\u79f0\u91cd\u590d\u3002", (String)"ReportDisplayPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]), newValue);
        }
    }

    private void handleDisplayNameChange(String errMsg, Object value) {
        String addDisplayAlias = "";
        if (value instanceof ILocaleString) {
            addDisplayAlias = ((ILocaleString)value).getLocaleValue();
        } else if (value instanceof LocaleDynamicObjectCollection) {
            DynamicObject dy2 = ((LocaleDynamicObjectCollection)value).getOrCreateItemByLocaleId(RequestContext.get().getLang().name());
            addDisplayAlias = dy2.getString("displayalias");
        } else {
            addDisplayAlias = (String)value;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity("detailshowentity");
        Map<String, List<DynamicObject>> displayAliasListMap = entity.stream().collect(Collectors.groupingBy(dy -> dy.getLocaleString("displayalias").getLocaleValue()));
        for (Map.Entry<String, List<DynamicObject>> entry : displayAliasListMap.entrySet()) {
            String displayAlias;
            List<DynamicObject> dyList = entry.getValue();
            if (dyList.size() <= 1 || !HRStringUtils.equals((String)addDisplayAlias, (String)(displayAlias = entry.getKey()))) continue;
            this.getView().showTipNotification(String.format(errMsg, displayAlias));
        }
    }

    private void handleNodeCheck(TreeView treeView, String nodeId) {
        IFormView view = this.getView();
        HRPageCache pageCache = new HRPageCache(view);
        Map nodeMap = (Map)pageCache.get(CACHE_TREE, Map.class);
        Map checkMap = (Map)pageCache.get("check", Map.class);
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (selectNodeIds.isEmpty() || !selectNodeIds.contains(nodeId)) {
            this.unCheckNode(selectNodeIds, checkMap, pageCache);
        } else {
            this.checkNode(selectNodeIds, nodeMap, checkMap);
        }
        ReportDisplayHelper.setLblTotal(view, checkMap.size());
        pageCache.put("check", (Object)checkMap);
    }

    private void checkNode(List<String> selectNodeIds, Map<String, LinkedHashMap<String, Object>> nodeMap, Map<String, Integer> checkMap) {
        IDataModel model = this.getModel();
        for (String selectNodeId : selectNodeIds) {
            LinkedHashMap<String, Object> selectNode = nodeMap.get(selectNodeId);
            if (KEY_ROOT.equals(selectNodeId) || KEY_ROOT.equals(selectNode.get(FIELD_PARENTID)) || checkMap.containsKey(selectNodeId)) continue;
            int detailIndex = model.createNewEntryRow("detailshowentity");
            model.setValue("systemalias", selectNode.get(FIELD_TEXT), detailIndex);
            model.beginInit();
            String displayAlias = (String)selectNode.get(FIELD_TEXT);
            model.setValue("displayalias", (Object)displayAlias, detailIndex);
            model.endInit();
            model.setValue("shownodeid", (Object)selectNodeId, detailIndex);
            int index = model.createNewEntryRow("showentity");
            model.setValue("systemalias1", selectNode.get(FIELD_TEXT), index);
            model.setValue("shownodeid1", (Object)selectNodeId, index);
            checkMap.put(selectNodeId, detailIndex);
            ReportDisplayHelper.hideDel(this.getView(), selectNodeId, index);
            this.handleDisplayNameChange(ResManager.loadKDString((String)"%s\u663e\u793a\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u524d\u5f80\u9ad8\u7ea7\u8bbe\u7f6e\u4fee\u6539\u5b57\u6bb5\u663e\u793a\u540d\u3002", (String)"ReportDisplayPlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]), displayAlias);
        }
    }

    private void unCheckNode(List<String> selectNodeIds, Map<String, Integer> checkMap, HRPageCache pageCache) {
        Iterator<Map.Entry<String, Integer>> it = checkMap.entrySet().iterator();
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)selectNodeIds.size());
        while (it.hasNext()) {
            Map.Entry<String, Integer> entry = it.next();
            if (selectNodeIds.contains(entry.getKey())) continue;
            rows.add(entry.getValue());
        }
        IDataModel dataModel = this.getModel();
        int[] removeRows = rows.stream().mapToInt(Integer::valueOf).toArray();
        dataModel.deleteEntryRows("showentity", removeRows);
        dataModel.deleteEntryRows("detailshowentity", removeRows);
        ReportDisplayHelper.buildCheckMap(this.getView(), checkMap, pageCache);
    }

    private void buildBillTreeNodes(TreeView treeView, QueryEntityTreeBuildParameter parameter) {
        TreeNode billNode = new TreeNode("", KEY_ROOT, "");
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = this.createNode(parameter.getQueryEntityList(), KEY_ROOT);
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)fldNodes.size());
        HashMap<String, Integer> checkMap = new HashMap<String, Integer>(16);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(checkMap.size());
        Iterator<TreeNode> var7 = fldNodes.iterator();
        HRPageCache pageCache = new HRPageCache(this.getView());
        ReportDisplayHelper.buildCheckMap(this.getView(), checkMap, pageCache);
        while (var7.hasNext()) {
            TreeNode node = var7.next();
            nodeMap.put(node.getId(), node);
            if (!checkMap.containsKey(node.getId())) continue;
            checkNodes.add(node);
        }
        pageCache.put(CACHE_TREE, (Object)nodeMap);
        ReportDisplayHelper.setLblTotal(this.getView(), checkNodes.size());
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        treeView.addNode(billNode);
        pageCache.put(CACHE_ROOTNODE, (Object)billNode);
        treeView.checkNodes(checkNodes);
    }

    private List<TreeNode> createNode(List<QueryEntityTreeNode> queryEntityList, String parentId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (queryEntityList != null) {
            for (QueryEntityTreeNode queryEntity : queryEntityList) {
                List nextNodes = queryEntity.getChildList();
                String displayName = queryEntity.getEntityName();
                if (nextNodes != null) {
                    List<TreeNode> childNode = this.createNode(nextNodes, queryEntity.getEntityAlias());
                    nodes.addAll(childNode);
                    displayName = MessageFormat.format(ResManager.loadKDString((String)"{0}({1}\u4e2a)", (String)"ReportDisplayPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), displayName, childNode.size());
                } else {
                    displayName = displayName.split("\\.")[0];
                }
                TreeNode queryentityNode = new TreeNode(parentId, queryEntity.getEntityAlias(), displayName);
                nodes.add(queryentityNode);
            }
        }
        return nodes;
    }

    private static List<QueryEntityTreeNode> convertListType(Map<String, String> joinEntityAliasMap, List<QuerySelectField> list) {
        ArrayList<QueryEntityTreeNode> secondList = new ArrayList<QueryEntityTreeNode>();
        HashMap pages = new HashMap(32);
        for (QuerySelectField querySelectField : list) {
            String page = MAINCODE;
            String entityName = ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848", (String)"ReportDisplayPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            String name = querySelectField.getLocaleDisplayName().getLocaleValue();
            String entityAlias = querySelectField.getAlias().split("\\.")[0];
            if (joinEntityAliasMap.containsKey(entityAlias)) {
                page = entityAlias;
                entityName = joinEntityAliasMap.get(entityAlias);
                name = name.replaceFirst(entityName + "\\.", "");
            }
            if (!pages.containsKey(page)) {
                QueryEntityTreeNode secondEntityTreeNode = new QueryEntityTreeNode();
                secondEntityTreeNode.setEntityNumber(querySelectField.getId());
                String basePage = ResManager.loadKDString((String)"\u57fa\u7840\u9875\u9762", (String)"ReportDisplayPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                if (entityName.endsWith(basePage)) {
                    entityName = entityName.replace(basePage, "");
                }
                secondEntityTreeNode.setEntityName(entityName);
                secondEntityTreeNode.setEntityAlias(page);
                ArrayList queryList = new ArrayList(list.size());
                secondEntityTreeNode.setChildList(queryList);
                secondList.add(secondEntityTreeNode);
                pages.put(page, queryList);
            }
            List queryList = (List)pages.get(page);
            QueryEntityTreeNode childEntityTreeNode = new QueryEntityTreeNode();
            childEntityTreeNode.setEntityNumber(querySelectField.getId());
            childEntityTreeNode.setEntityName(name);
            childEntityTreeNode.setEntityAlias(querySelectField.getAlias());
            queryList.add(childEntityTreeNode);
        }
        return secondList;
    }

    @Override
    protected void handleOtherSave() {
        super.handleOtherSave();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("detailshowentity");
        ReportDisplayHelper.addLinkInfoPage(this.getView(), entity);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        formOperate.getOption().setVariableValue("reportpage", ReportDisplayHelper.getQueryPage(this.getView()));
    }
}

