/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.business.domian.repository.ReportPlanRepository;
import kd.hr.hspm.formplugin.web.report.helper.ReportDisplayHelper;
import kd.sdk.hr.hspm.common.enums.ReportTypeEnum;

public class ReportPlanConfigPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(ReportPlanConfigPlugin.class);
    private static final String FLEX_DETAIL = "flex_detail";
    private static final String FLEX_NEW = "flex_new";
    private static final String KEY_USERPLAN_FLEX = "flex_userplan";
    private static final String KEY_PLAN_FLEX = "flex_plan";
    private static final String KEY_PLAN_LABEL = "lbl_plan";
    private static final String KEY_ADDPLAN_FLEX = "flex_add";
    private static final String KEY_ADD_LABEL = "lbl_add";
    private static final String KEY_TAG = "tag";
    private static final String CACHE_SELECTID = "cache_selectid";
    private static final String CACHE_PLANINFO = "cache_planinfo";
    private static final String CACHE_FIRST = "cache_first";
    private static final String CACHE_ISINITIALIZED = "cache_isinitialized";
    private static final String COLOR_LABEL_BLACK = "#212121";
    private static final String KEY_DETAIL_EVENT = "detail_event";
    private static final String BODER_SOLID = "_solid_";
    private static final String OP_ADD = "donothing_add";
    private static final String OP_TYPE = "op_type";
    private static final String CLOSE_CALLBACK = "close_callback";
    private static final String SELECT_CALLBACK = "select_callback";
    private static final String CHILD_PAGE_ID = "childpageid";
    private static final String CLICK_KEY = "clickKey";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{KEY_ADDPLAN_FLEX, KEY_ADD_LABEL});
        Container addContainer = (Container)this.getControl(KEY_ADDPLAN_FLEX);
        addContainer.setOperationKey(OP_ADD);
        Label label = (Label)this.getControl(KEY_ADD_LABEL);
        label.setOperationKey(OP_ADD);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IFormView view = this.getView();
        Container container = (Container)view.getControl(KEY_USERPLAN_FLEX);
        FlexPanelAp flexAp = this.buildUserPlans();
        container.getItems().addAll(((Container)flexAp.buildRuntimeControl()).getItems());
        view.createControlIndex(container.getItems());
        view.updateControlMetadata(KEY_USERPLAN_FLEX, flexAp.createControl());
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
        this.initSelectedPlan(pageCache, planInfo);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.contains(KEY_PLAN_LABEL)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            args.setControl((Control)label);
        }
        if (key.contains(KEY_PLAN_FLEX)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        try {
            if ((key.contains(KEY_PLAN_LABEL) || key.contains(KEY_PLAN_FLEX)) && this.isChildViewChanged()) {
                evt.setCancel(true);
                this.getPageCache().put(CLICK_KEY, key);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u65b9\u6848\u6682\u672a\u4fdd\u5b58\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u8981\u5207\u6362\u81f3\u5176\u4ed6\u65b9\u6848?", (String)"ReportPlanConfigPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SELECT_CALLBACK, (IFormPlugin)this));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u70b9\u51fb\u9891\u7387\u8fc7\u5feb\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u5b8c\u6210\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportPlanConfigPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        HRPageCache pageCache = new HRPageCache(this.getView());
        this.handleSelectPlan(key, pageCache);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        this.handleAddPlan(key);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        if (this.isChildViewChanged()) {
            evt.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"ReportPlanConfigPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_CALLBACK, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CLOSE_CALLBACK, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().remove(CHILD_PAGE_ID);
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)SELECT_CALLBACK, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            String key = this.getPageCache().get(CLICK_KEY);
            this.getPageCache().remove(CLICK_KEY);
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.handleSelectPlan(key, new HRPageCache(this.getView()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_DETAIL_EVENT)) {
            this.getView().close();
        }
    }

    private FlexPanelAp buildUserPlans() {
        IFormView view = this.getView();
        HRPageCache pageCache = new HRPageCache(view);
        DynamicObject[] userPlans = ReportPlanRepository.getUserPlan((String)ReportDisplayHelper.getType(this.getView()));
        int length = userPlans.length;
        FlexPanelAp totalAp = new FlexPanelAp();
        totalAp.setKey(KEY_USERPLAN_FLEX);
        totalAp.setWrap(false);
        totalAp.setGrow(0);
        totalAp.setDirection("column");
        totalAp.setAlignItems("stretch");
        totalAp.setJustifyContent("flex-start");
        if (length > 0) {
            pageCache.put(CACHE_FIRST, (Object)String.valueOf(userPlans[0].getLong("id")));
        }
        HashMap<String, DynamicObject> planInfo = new HashMap<String, DynamicObject>(length);
        for (DynamicObject dy : userPlans) {
            Long id = dy.getLong("id");
            String name = dy.getString("name");
            Boolean isSystem = dy.getBoolean("issyspreset");
            FlexPanelAp planAp = this.createPlanAp(id, name, isSystem, Boolean.FALSE);
            planInfo.put(String.valueOf(id), dy);
            totalAp.getItems().add(planAp);
        }
        pageCache.put(CACHE_PLANINFO, planInfo);
        return totalAp;
    }

    private FlexPanelAp createPlanAp(Long id, String name, Boolean isSystem, Boolean isSelected) {
        String fontColor;
        String leftPadding;
        FlexPanelAp planAp = new FlexPanelAp();
        planAp.setClickable(true);
        planAp.setKey(KEY_PLAN_FLEX + id);
        planAp.setHeight(new LocaleString("40px"));
        planAp.setWrap(false);
        planAp.setGrow(0);
        planAp.setDirection("row");
        planAp.setJustifyContent("space-between");
        planAp.setAlignItems("center");
        Style contentStyle = new Style();
        Border border = new Border();
        if (isSelected.booleanValue()) {
            leftPadding = "18px";
            border.setLeft("2px_solid_themeColor");
            border.setTop("1px_solid_#d9d9d9");
            border.setBottom("1px_solid_#d9d9d9");
            planAp.setBackColor("#ffffff");
            fontColor = "#5582f3";
        } else {
            border.setLeft("0px_solid_themeColor");
            border.setTop("0px_solid_#d9d9d9");
            border.setBottom("0px_solid_#d9d9d9");
            planAp.setBackColor("#fafafa");
            leftPadding = "20px";
            fontColor = COLOR_LABEL_BLACK;
        }
        contentStyle.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft(leftPadding);
        padding.setRight("20px");
        contentStyle.setPadding(padding);
        planAp.setStyle(contentStyle);
        LabelAp label = ReportPlanConfigPlugin.createLabelAp(KEY_PLAN_LABEL + id, name, fontColor);
        planAp.getItems().add(label);
        String tagColor = "#666666";
        if (isSystem.booleanValue()) {
            LabelAp tag = this.createTypeLabelAp(KEY_TAG + id, ResManager.loadKDString((String)"\u9884\u7f6e", (String)"ReportPlanConfigPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), tagColor, tagColor);
            planAp.getItems().add(tag);
        }
        return planAp;
    }

    private static LabelAp createLabelAp(String key, String name, String color) {
        LabelAp lblName = new LabelAp();
        lblName.setKey(key);
        lblName.setClickable(true);
        lblName.setName(new LocaleString(name));
        if (HRStringUtils.isNotEmpty((String)color)) {
            lblName.setForeColor(color);
        }
        lblName.setFontSize(12);
        return lblName;
    }

    private LabelAp createTypeLabelAp(String apKey, String text, String color, String boderColor) {
        return ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(apKey).setName(text).setFontSize(12).setForeColor(color).setGrow(0).setShrink(1).setRadius("10px").setPaddingTop("2px")).setPaddingBottom("2px")).setPaddingLeft("8px")).setPaddingRight("8px")).setBorderBottom("1px_solid_" + boderColor)).setBorderLeft("1px_solid_" + boderColor)).setBorderRight("1px_solid_" + boderColor)).setBorderTop("1px_solid_" + boderColor)).setShrink(0).build();
    }

    private void handleSelectPlan(String key, HRPageCache pageCache) {
        if (key.contains(KEY_PLAN_LABEL) || key.contains(KEY_PLAN_FLEX)) {
            String id = key.replace(KEY_PLAN_LABEL, "");
            id = id.replace(KEY_PLAN_FLEX, "");
            String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
            Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
            if (HRStringUtils.isNotEmpty((String)currentId)) {
                this.updatePlanAp(planInfo, currentId, Boolean.FALSE);
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NEW});
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_ADDPLAN_FLEX});
                this.updateLabel(COLOR_LABEL_BLACK, ResManager.loadKDString((String)"+ \u65b0\u589e\u65b9\u6848", (String)"ReportPlanConfigPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), KEY_ADD_LABEL);
            }
            this.setSelectedPlan(pageCache, planInfo, id);
        }
    }

    private void updatePlanAp(Map<String, LinkedHashMap<String, Object>> planInfo, String currentId, Boolean isSelected) {
        LinkedHashMap<String, Object> obj = planInfo.get(currentId);
        String name = (String)obj.get("name");
        Boolean isSystem = (Boolean)obj.get("issyspreset");
        FlexPanelAp planFlexAp = this.createPlanAp(Long.valueOf(currentId), name, isSystem, isSelected);
        this.getView().updateControlMetadata(KEY_PLAN_FLEX + currentId, planFlexAp.createControl());
    }

    private void setSelectedPlan(HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo, String id) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NEW});
        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_ADDPLAN_FLEX});
        this.updateLabel(COLOR_LABEL_BLACK, ResManager.loadKDString((String)"+ \u65b0\u589e\u65b9\u6848", (String)"ReportPlanConfigPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), KEY_ADD_LABEL);
        this.updatePlanAp(planInfo, id, Boolean.TRUE);
        pageCache.put(CACHE_SELECTID, (Object)id);
        this.setBasePamaterShow(FLEX_DETAIL, ((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(ReportDisplayHelper.getType(this.getView()))).getPlan(), Long.valueOf(id));
    }

    private void setBasePamaterShow(String targetKey, String formId, Long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        if (pkId != null) {
            baseShowParameter.setPkId((Object)pkId);
            baseShowParameter.setStatus(OperationStatus.EDIT);
        }
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DETAIL_EVENT));
        baseShowParameter.getOpenStyle().setTargetKey(targetKey);
        baseShowParameter.setFormId(formId);
        baseShowParameter.setCustomParam("type", (Object)ReportDisplayHelper.getType(this.getView()));
        baseShowParameter.setSendToClient(true);
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getPageCache().put(CHILD_PAGE_ID, baseShowParameter.getPageId());
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void handleAddPlan(String key) {
        if (OP_ADD.equals(key)) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
            if (HRStringUtils.isNotEmpty((String)currentId)) {
                Map planInfo = (Map)pageCache.get(CACHE_PLANINFO, Map.class);
                this.updatePlanAp(planInfo, currentId, Boolean.FALSE);
                pageCache.remove(currentId);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_NEW});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ADDPLAN_FLEX});
            this.updateLabel("#B2B2B2", ResManager.loadKDString((String)"+ \u65b0\u589e\u65b9\u6848", (String)"ReportPlanConfigPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), KEY_ADD_LABEL);
            this.setBasePamaterShow(FLEX_DETAIL, ((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(ReportDisplayHelper.getType(this.getView()))).getPlan(), null);
        }
    }

    private void updateLabel(String color, String message, String key) {
        LabelAp labelAp = new LabelAp();
        labelAp.setForeColor(color);
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(message));
        this.getView().updateControlMetadata(key, labelAp.createControl());
    }

    private void initSelectedPlan(HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo) {
        String currentId = (String)pageCache.get(CACHE_SELECTID, String.class);
        if (CollectionUtils.isEmpty(planInfo)) {
            this.handleAddPlan(OP_ADD);
            return;
        }
        Long id = this.getCurrentId(currentId, pageCache, planInfo);
        if (id == null) {
            this.handleAddPlan(OP_ADD);
            return;
        }
        this.setSelectedPlan(pageCache, planInfo, String.valueOf(id));
    }

    private Long getCurrentId(String currentId, HRPageCache pageCache, Map<String, LinkedHashMap<String, Object>> planInfo) {
        Long id = null;
        if (HRStringUtils.isEmpty((String)currentId) || !planInfo.containsKey(currentId)) {
            String opType = (String)this.getView().getFormShowParameter().getCustomParam(OP_TYPE);
            String isInitialized = (String)pageCache.get(CACHE_ISINITIALIZED, String.class);
            if (!"1".equals(isInitialized)) {
                pageCache.put(CACHE_ISINITIALIZED, (Object)"1");
                if ("new".equals(opType)) {
                    return null;
                }
                if ("modify".equals(opType)) {
                    id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
                }
            }
            if (id == null) {
                DynamicObject obj = ReportPlanRepository.getDefaultPlan((String)ReportDisplayHelper.getType(this.getView()));
                id = obj != null ? HRJSONUtils.getLongValOfCustomParam((Object)obj.get("id")) : HRJSONUtils.getLongValOfCustomParam((Object)pageCache.get(CACHE_FIRST, String.class));
            }
        } else {
            id = Long.valueOf(currentId);
        }
        return id;
    }

    private boolean isChildViewChanged() {
        String childPageId = this.getPageCache().get(CHILD_PAGE_ID);
        IFormView childView = StringUtils.isNotBlank((CharSequence)childPageId) ? this.getView().getViewNoPlugin(childPageId) : null;
        return childView != null && childView.getModel().getDataChanged() && (Boolean)childView.getModel().getValue("issyspreset") == false;
    }
}

