/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report.func;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class EmpReportCalculateMapFunction
extends MapFunction {
    private static final long serialVersionUID = -947693555489046503L;
    private final RowMeta sourceRowMeta;
    private final Map<String, Object> paramMap;

    public EmpReportCalculateMapFunction(RowMeta sourceRowMeta, Map<String, Object> paramMap) {
        this.sourceRowMeta = sourceRowMeta;
        this.paramMap = paramMap;
    }

    public Object[] map(Row row) {
        Field[] fields = this.sourceRowMeta.getFields();
        Object[] result = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ("hrpi_pernontsprop.age".equals(field.getAlias())) {
                this.calculateAge(row, result, i);
                continue;
            }
            if ("hrpi_empjobrel.jobclass.name".equals(field.getAlias())) {
                this.calculateJobclassName(row, result, i);
                continue;
            }
            result[i] = row.get(i);
        }
        return result;
    }

    private void calculateJobclassName(Row row, Object[] result, int i) {
        Long jobBoid;
        String jobClassLongName;
        Map jobClassLongNameMap = (Map)this.paramMap.get("hrpi_empjobrel.jobclass.name");
        if (!CollectionUtils.isEmpty((Map)jobClassLongNameMap) && (jobClassLongName = (String)jobClassLongNameMap.get(jobBoid = row.getLong("hrpi_empjobrel.job.boid"))) != null) {
            result[i] = jobClassLongName;
        }
    }

    private void calculateAge(Row row, Object[] result, int i) {
        Date queryDate = (Date)this.paramMap.get("hrpi_pernontsprop.age");
        Date birthday = row.getDate("hrpi_pernontsprop.birthday");
        if (birthday != null) {
            long age = HRDateTimeUtils.dateDiff((String)"yyyy", (Date)birthday, (Date)queryDate);
            result[i] = age;
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

