/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.hr.hspm.common.constants.report.enums.AlignTypeEnum;

public class CreateReportColumn {
    public static ReportColumn createColumnByType(EntityItem<?> item, String mapKey, DynamicObject mapValue) {
        if (item == null) {
            return null;
        }
        ReportColumn column = null;
        if (item instanceof ComboField) {
            ComboField comboField = (ComboField)item;
            List comboItemList = comboField.getItems();
            column = CreateReportColumn.createComboColumn(mapValue, mapKey, comboItemList);
        } else if (item instanceof CheckBoxField) {
            column = CreateReportColumn.createCheckBoxColumn(mapValue, mapKey);
        } else if (item instanceof BasedataField) {
            String basePage = MetadataDao.getNumberById((String)((BasedataField)item).getBaseEntityId());
            column = CreateReportColumn.createBasedataColumn(mapValue, mapKey, basePage);
        } else if (item instanceof DateField) {
            column = CreateReportColumn.createDateColumn(mapValue, mapKey);
        } else if (item instanceof PictureField) {
            column = CreateReportColumn.createPictureColumn(mapValue, mapKey);
        } else if (item instanceof AdminDivisionField) {
            column = CreateReportColumn.createAdminDivisionColumn(mapValue, mapKey);
        } else if (item instanceof DecimalField) {
            column = item instanceof IntegerField ? CreateReportColumn.createIntegerColumn(mapValue, mapKey) : CreateReportColumn.createDecimalColumn(mapValue, mapKey);
        }
        return column;
    }

    public static void setReportColumnValue(ReportColumn column, DynamicObject columnDy, String fieldKey) {
        column.setFieldKey(fieldKey);
        if (columnDy == null) {
            column.setCaption(new LocaleString("id"));
            return;
        }
        column.setCaption(new LocaleString(columnDy.getString("displayalias")));
        AlignTypeEnum alignType = (AlignTypeEnum)AlignTypeEnum.TYPE_CACHE.get(columnDy.getString("aligntype"));
        if (alignType != null) {
            ColumnStyle style = new ColumnStyle();
            style.setTextAlign(alignType.getStyle());
            column.setStyle(style);
        }
    }

    public static ReportColumn createTextColumn(DynamicObject columnDy, String fieldKey, String id) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("text");
        column.setEntityId(id);
        return column;
    }

    public static ReportColumn createCheckBoxColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("checkbox");
        column.setCheckBoxReportShowStyle(1);
        return column;
    }

    public static ReportColumn createDateColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("date");
        return column;
    }

    public static ReportColumn createAdminDivisionColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("text");
        AdminDivisionProp adminDivisionProp = new AdminDivisionProp();
        column.setFieldProperty((DynamicProperty)adminDivisionProp);
        return column;
    }

    public static ReportColumn createPictureColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setPicture(true);
        column.setFieldType("picture");
        PictureProp pictureProp = new PictureProp();
        column.setFieldProperty((DynamicProperty)pictureProp);
        return column;
    }

    public static ReportColumn createDecimalColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("decimal");
        column.setScale(1);
        return column;
    }

    public static ReportColumn createIntegerColumn(DynamicObject columnDy, String fieldKey) {
        ReportColumn column = new ReportColumn();
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("integer");
        return column;
    }

    public static ComboReportColumn createComboColumn(DynamicObject columnDy, String fieldKey, List<ComboItem> comboItemList) {
        ComboReportColumn column = new ComboReportColumn();
        CreateReportColumn.setReportColumnValue((ReportColumn)column, columnDy, fieldKey);
        column.setComboShowStyle(0);
        column.setFieldType("combofield");
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(comboItemList.size());
        for (ComboItem item : comboItemList) {
            ValueMapItem valueItem = new ValueMapItem();
            valueItem.setName(item.getCaption());
            valueItem.setValue(item.getValue());
            comboItems.add(valueItem);
        }
        column.setComboItems(comboItems);
        return column;
    }

    public static ReportColumn createBasedataColumn(DynamicObject columnDy, String fieldKey, String entity) {
        ReportColumn column = ReportColumn.createBaseDataColumn((String)fieldKey, (String)entity);
        CreateReportColumn.setReportColumnValue(column, columnDy, fieldKey);
        column.setFieldType("basedata");
        return column;
    }
}

