/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ReportDisplayRepository;

public class EmpReportHelper {
    private static final Log LOGGER = LogFactory.getLog(EmpReportHelper.class);
    private static final String FIELD_CAPTION = "fieldCaption";
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_ADMINIORG = "hrpi_empposorgrel.adminorg";

    @Deprecated
    public static Tuple<String, EntityItem<?>> getFieldItem(Set<String> joinEntityAliasSet, String fieldName, Map<String, EntityMetadata> metaMap) {
        EntityMetadata metadata;
        String page = "hspm_ermanfile";
        String entityAlias = fieldName.split("\\.")[0];
        if (joinEntityAliasSet.contains(entityAlias)) {
            page = entityAlias;
            fieldName = fieldName.replaceFirst(page + "\\.", "");
        }
        if ((metadata = metaMap.get(page)) == null) {
            String id = MetadataDao.getIdByNumber((String)page, (MetaCategory)MetaCategory.Entity);
            metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
            metaMap.put(page, metadata);
        }
        List list = metadata.getItems();
        EntityItem item = null;
        for (EntityItem entityItem : list) {
            if (!fieldName.equals(entityItem.getKey())) continue;
            item = entityItem;
            break;
        }
        return Tuple.create((Object)page, item);
    }

    public static Tuple<String, EntityItem<?>> getFieldItem(Map<String, String> joinEntityAliasMap, String fieldName, Map<String, EntityMetadata> metaMap) {
        EntityMetadata metadata;
        String page = "hspm_ermanfile";
        String entityAlias = fieldName.split("\\.")[0];
        if (joinEntityAliasMap.containsKey(entityAlias)) {
            page = entityAlias;
            fieldName = fieldName.replaceFirst(page + "\\.", "");
        }
        if ((metadata = metaMap.get(page)) == null) {
            String entityName = joinEntityAliasMap.getOrDefault(page, "hspm_ermanfile");
            String id = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Entity);
            metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
            metaMap.put(page, metadata);
        }
        List list = metadata.getItems();
        EntityItem item = null;
        for (EntityItem entityItem : list) {
            if (!fieldName.equals(entityItem.getKey())) continue;
            item = entityItem;
            break;
        }
        return Tuple.create((Object)page, item);
    }

    public static void setFilterFields(String entityName, FilterGrid filterGrid) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        List fields = queryEntityType.getSelectFields();
        ArrayList<String> filterFileds = new ArrayList<String>(fields.size());
        for (QuerySelectField field : fields) {
            String alias = field.getAlias();
            filterFileds.add(alias);
        }
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public static void getFilterGrid(FilterGrid filterGrid, Long displayPlanId) {
        List fieldColumns = filterGrid.getFilterColumns();
        Map selectMap = ReportDisplayRepository.getField((Long)displayPlanId);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
        List querySelectFieldList = queryEntityType.getSelectFields();
        Map<String, String> querySelectFieldMap = querySelectFieldList.stream().collect(Collectors.toMap(QuerySelectField::getAlias, querySelectField -> querySelectField.getLocaleDisplayName().getLocaleValue()));
        for (int i = fieldColumns.size() - 1; i >= 0; --i) {
            Map fieldColumnMap = (Map)fieldColumns.get(i);
            String fieldCaption = (String)fieldColumnMap.get(FIELD_CAPTION);
            String fieldName = (String)fieldColumnMap.get(FIELD_NAME);
            String name = (String)selectMap.get(fieldName);
            if (HRStringUtils.isNotEmpty((String)name)) {
                fieldColumnMap.put(FIELD_CAPTION, name);
                continue;
            }
            if (!HRStringUtils.isNotEmpty((String)(fieldCaption = querySelectFieldMap.getOrDefault(fieldName, fieldCaption)))) continue;
            fieldColumnMap.put(FIELD_CAPTION, fieldCaption);
        }
    }

    public static int getRowCount(ReportList reportList) {
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        ReportBatchQueryInfo reportBatchQueryInfo = (ReportBatchQueryInfo)reportModel.getReportQueryParam().byBatchInfo();
        return reportBatchQueryInfo.getMaxRowCountCached();
    }

    public static void addAdminOrgFilter(String sourceMethod, List<QFilter> filters, String structlongnumberField, String adminorgIdField) {
        if ("getLookUpList".equals(sourceMethod) || "setItemByNumber".equals(sourceMethod)) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsF7WithSub", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "1WXBPN7+OHJZ", "hspm_reportquery", "47150e89000000ac", FIELD_ADMINIORG, EmpReportHelper.getStructProjectCustomInParam(FIELD_ADMINIORG)});
            LOGGER.info("EmpReportHelper#addAdminOrgFilter permOrgResultWithSub.isHasAllOrgPerm():{}", (Object)permOrgResultWithSub.isHasAllOrgPerm());
            if (!permOrgResultWithSub.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
                List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(OrgSubInfo::getOrgId).collect(Collectors.toList());
                List orgStructLongNumberList = permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(OrgSubInfo::isContainsSub).map(OrgSubInfo::getLongStructNumber).collect(Collectors.toList());
                QFilter authQF = null;
                if (!CollectionUtils.isEmpty(orgStructLongNumberList)) {
                    for (String structNumber : orgStructLongNumberList) {
                        if (authQF == null) {
                            authQF = new QFilter(structlongnumberField, "like", (Object)("%" + structNumber + "%"));
                            continue;
                        }
                        authQF.or(new QFilter(structlongnumberField, "like", (Object)("%" + structNumber + "%")));
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    if (authQF == null) {
                        authQF = new QFilter(adminorgIdField, "in", orgIds);
                    } else {
                        authQF.or(new QFilter(adminorgIdField, "in", orgIds));
                    }
                }
                LOGGER.info("EmpReportHelper#addAdminOrgFilter authQF:{}", authQF);
                filters.add(authQF);
            }
        }
    }

    private static Map<String, Object> getStructProjectCustomInParam(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("hr_dataperm_structprojectid_prop_" + prop, Lists.newArrayList((Object[])new Long[]{1010L}));
        return map;
    }
}

