/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report.helper;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.enums.ReportTypeEnum;

public class ReportDisplayHelper {
    public static final Set<String> DEFAULT_NODE_SET = new HashSet<String>(Arrays.asList("hrpi_person.name", "hrpi_person.number"));
    public static final Set<String> DEFAULT_PARENT_NODE_SET = Collections.singleton("hrpi_person");

    public static String getType(IFormView view) {
        String type = (String)view.getFormShowParameter().getCustomParam("type");
        if (HRStringUtils.isEmpty((String)type)) {
            type = ReportTypeEnum.EMP.getType();
        }
        return type;
    }

    public static String getQueryPage(IFormView view) {
        String type = (String)view.getFormShowParameter().getCustomParam("type");
        if (HRStringUtils.isEmpty((String)type)) {
            type = view.getModel().getDataEntity().getString("type");
        }
        return ((ReportTypeEnum)ReportTypeEnum.STATUS_CACHE.get(type)).getQueryPage();
    }

    public static void buildCheckMap(IFormView view, Map<String, Integer> checkMap, HRPageCache pageCache) {
        pageCache.remove("check");
        checkMap.clear();
        IDataModel model = view.getModel();
        DynamicObjectCollection entity = model.getEntryEntity("detailshowentity");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject obj = (DynamicObject)entity.get(i);
            String nodeid = obj.getString("shownodeid");
            checkMap.put(nodeid, i);
        }
        pageCache.put("check", checkMap);
        ReportDisplayHelper.addLinkInfoPage(view, entity);
    }

    public static void addLinkInfoPage(IFormView view, DynamicObjectCollection linkEntrys) {
        IDataModel model = view.getModel();
        if (linkEntrys == null || linkEntrys.size() < 1) {
            return;
        }
        model.deleteEntryData("showentity");
        model.getDataEntity(true);
        for (int i = 0; i < linkEntrys.size(); ++i) {
            DynamicObject dy = (DynamicObject)linkEntrys.get(i);
            int index = model.createNewEntryRow("showentity");
            model.setValue("systemalias1", (Object)dy.getString("systemalias"), index);
            String nodeId = dy.getString("shownodeid");
            model.setValue("shownodeid1", (Object)nodeId, index);
            ReportDisplayHelper.hideDel(view, nodeId, index);
        }
    }

    public static void setLblTotal(IFormView view, int size) {
        Label labelTotal = (Label)view.getControl("lbltotal");
        Label labelTotal1 = (Label)view.getControl("lbltotal1");
        String text = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u663e\u793a\u5b57\u6bb5\uff08\u603b\u6570\uff1a{0}\uff09", (String)"ReportDisplayHelper_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), size);
        labelTotal.setText(text);
        labelTotal1.setText(text);
    }

    public static void hideDel(IFormView view, String key, int index) {
        if (DEFAULT_NODE_SET.contains(key)) {
            EntryGrid grid = (EntryGrid)view.getControl("showentity");
            grid.hideOperateItems("operationcolumnap", index, Collections.singletonList("donothing_entrydel"));
        }
    }
}

