/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.revise;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.handler.CalServiceLengthHandler;
import kd.hr.hspm.formplugin.web.revise.PersonReviseDetailEdit;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class EmpEntrelReviseDetailPlugin
extends PersonReviseDetailEdit
implements BeforeF7SelectListener {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setServiceLength();
        DynamicObject laborRelTypeDyn = this.getModel().getDataEntity().getDynamicObject("laborreltype");
        if (Objects.isNull(laborRelTypeDyn)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"laborrelstatus"});
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    protected List<String> getData2999Field() {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)16);
        fieldList.add("enddate");
        fieldList.add("lastworkdate");
        return fieldList;
    }

    private void setServiceLength() {
        DynamicObject empEntDy = this.queryEmpEntRelDy();
        BigDecimal adjustLength = new BigDecimal(0);
        Date startDate = null;
        startDate = !this.getModel().getDataEntityType().getAllFields().containsKey("startdate") ? empEntDy.getDate("startdate") : (Date)this.getModel().getValue("startdate");
        adjustLength = !this.getModel().getDataEntityType().getAllFields().containsKey("adjustlength") ? empEntDy.getBigDecimal("adjustlength") : (BigDecimal)this.getModel().getValue("adjustlength");
        if (startDate == null) {
            if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength")) {
                this.getModel().setValue("servicelength", (Object)0);
            }
        } else {
            String scheme = empEntDy.getString("serviceagescheme");
            if ("2".equals(scheme)) {
                BigDecimal serLen;
                Map serLenMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(empEntDy), (String)"0", (String)"1");
                if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength") && (serLen = (BigDecimal)serLenMap.get(empEntDy.getLong("employee.mid"))) != null) {
                    BigDecimal serAdd = serLen.add(adjustLength);
                    this.getModel().setValue("servicelength", (Object)serAdd);
                    this.getView().getPageCache().put("servicelengthcache", String.valueOf(serAdd));
                }
            } else {
                Date endDate = new Date();
                long statusPro = empEntDy.getLong("labrelstatusprd.id");
                if (statusPro == 1020L) {
                    endDate = empEntDy.getDate("enddate");
                }
                BigDecimal serLength = BusinessUtils.calcYearsDiff((Date)endDate, (Date)new Date(startDate.getTime())).add(adjustLength);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength")) {
                    this.getView().getPageCache().put("servicelengthcache", String.valueOf(serLength));
                    this.getModel().setValue("servicelength", (Object)serLength);
                }
            }
        }
    }

    private DynamicObject queryEmpEntRelDy() {
        HRBaseServiceHelper empServiceHelper = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter idFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("boid"));
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return empServiceHelper.queryOne("serviceagescheme,servicelength,adjustlength,startdate,enddate,boid,employee.id,labrelstatusprd", new QFilter[]{qFilter, idFilter});
    }

    @Override
    protected String getEntityName() {
        return "hrpi_empentrel";
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject laborRelTypeDyn;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (HRStringUtils.equals((String)fieldKey, (String)"laborrelstatus") && Objects.nonNull(laborRelTypeDyn = this.getModel().getDataEntity().getDynamicObject("laborreltype"))) {
            QFilter qFilter = new QFilter("laborreltype.fbasedataid", "=", (Object)laborRelTypeDyn.getLong("id"));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit laborRelStatusEdit = (BasedataEdit)this.getView().getControl("laborrelstatus");
        laborRelStatusEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (HRStringUtils.equals((String)fieldKey, (String)"laborrelstatus")) {
            if (Objects.nonNull(newValue)) {
                DynamicObject laborRelTypeDyn = (DynamicObject)((DynamicObject)newValue).getDynamicObjectCollection("laborreltype").get(0);
                this.getModel().setValue("laborreltype", (Object)laborRelTypeDyn);
                DynamicObject labRelStatusPrdDyn = ((DynamicObject)newValue).getDynamicObject("labrelstatusprd");
                this.getModel().setValue("labrelstatusprd", (Object)labRelStatusPrdDyn);
            } else {
                this.getModel().setValue("labrelstatusprd", null);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"laborreltype")) {
            this.getModel().setValue("laborrelstatus", null);
            if (Objects.isNull(newValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"laborrelstatus"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"laborrelstatus"});
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"adjustlength")) {
            this.setServiceLength();
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey) {
            case "saveconfirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    Date endDate = dataEntity.getDate("enddate");
                    if (Objects.nonNull(endDate)) {
                        this.getView().invokeOperation("revisesave");
                    } else {
                        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u586b\u5199", (String)"EmpEntrelReviseDetailPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EmpEntrelReviseDetailPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u8fd8\u672a\u586b\u5199\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\uff1a", (String)"EmpEntrelReviseDetailPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                        String msgDetail = MessageFormat.format(ResManager.loadKDString((String)"\u82e5\u4e0d\u586b\u5199\u7528\u5de5\u7ed3\u675f\u65e5\u671f\uff0c\u8868\u793a\u8be5\u7528\u5de5\u4fe1\u606f\u8fd8\u5728\u8fdb\u884c\u4e2d:{0}\u6216\u6682\u65f6\u8fd8\u4e0d\u786e\u5b9a\u7528\u5de5\u7ed3\u675f\u65e5\u671f\uff0c\u9700\u786e\u5b9a\u540e\u518d\u586b\u5199", (String)"EmpEntrelReviseDetailPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]), System.lineSeparator());
                        this.getView().showConfirm(msg, msgDetail, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("saveconfirm", (IFormPlugin)this), btnNameMaps);
                    }
                }
                return;
            }
        }
        super.afterDoOperation(eventArgs);
    }

    @Override
    protected boolean isNeedShowAfterSave(String fieldName, DynamicObject curDyn, DynamicObject newHisDyn) {
        List<String> specialFieldList = Collections.singletonList("laborrelstatus");
        return specialFieldList.contains(fieldName);
    }
}

