/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.revise;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.revise.PersonReviseService;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class PersonRevisePlugin
extends AbstractFormPlugin
implements PersonReviseConstants {
    String entityName;
    Long employeeId;
    Long ermanFileId;
    Long personId;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
        this.employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employeeid");
        this.ermanFileId = (Long)this.getView().getFormShowParameter().getCustomParam("ermanfileid");
        this.personId = (Long)this.getView().getFormShowParameter().getCustomParam("personid");
        PersonReviseService personReviseService = new PersonReviseService(true, this.entityName);
        DynamicObject[] hisVersions = personReviseService.getHisVersions(this.entityName, this.employeeId, this.ermanFileId, this.personId, false, false, true);
        if (hisVersions.length == 0) {
            this.showNoDataFlex(this.getView());
            String reviseEntityName = (String)this.getView().getFormShowParameter().getCustomParam("reviseentityname");
            Long newId = ORM.create().genLongId(this.entityName);
            customParams.put("formSource", "nodatanewbo");
            personReviseService.openDetailEditRevise(String.valueOf(newId), reviseEntityName, this.getView(), customParams);
            personReviseService.customControlInitData(hisVersions, "", "", "updatelist", this.getView());
        } else {
            this.showDataFlex(this.getView());
            String selectedBoId = hisVersions[0].getString("boid");
            List<DynamicObject> curSelectBoDataList = this.sortDynList(hisVersions, selectedBoId);
            String selectedHisId = curSelectBoDataList.get(0).getString("id");
            hisVersions = personReviseService.getHisVersions(this.entityName, this.employeeId, this.ermanFileId, this.personId, false, true, true);
            personReviseService.customControlInitData(hisVersions, selectedBoId, selectedHisId, "updatelist", this.getView());
            customParams.put("id", selectedHisId);
            personReviseService.openDetailViewRevise(selectedHisId, (String)customParams.get("reviseentityname"), this.getView(), customParams);
        }
    }

    private List<DynamicObject> sortDynList(DynamicObject[] hisVersions, String selectedBoId) {
        List<DynamicObject> curSelectBoDataList = Arrays.stream(hisVersions).filter(version -> selectedBoId.equals(version.getString("boid"))).collect(Collectors.toList());
        Collections.sort(curSelectBoDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getDate("bsed").compareTo(o1.getDate("bsed"));
            }
        });
        return curSelectBoDataList;
    }

    private void setNewBoLabel(Map<String, Object> customParams) {
        String groupName = (String)customParams.get("groupname");
        Label newBoLabel = (Label)this.getControl("newbolabel");
        String text = String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"PersonRevisePlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName);
        newBoLabel.setText(text);
    }

    private void setNoDataLeftLabel(Map<String, Object> customParams) {
        String groupName = (String)customParams.get("groupname");
        Label newBoLabel = (Label)this.getControl("nodataleftlabelap");
        String text = String.format(ResManager.loadKDString((String)"\u6682\u65e0%s", (String)"PersonRevisePlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName);
        newBoLabel.setText(text);
    }

    private void showDataFlex(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"dataflex"});
        view.setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        view.setVisible(Boolean.FALSE, new String[]{"nodataleftlabelap"});
    }

    private void showNewDataFlex(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"customcontrolfelx"});
        view.setVisible(Boolean.FALSE, new String[]{"nodataleftlabelap"});
        view.setVisible(Boolean.TRUE, new String[]{"revise_info"});
        view.setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        PersonReviseService personReviseService = new PersonReviseService();
        Map customParams = view.getFormShowParameter().getCustomParams();
        personReviseService.customControlNewBo(this.getView(), (String)customParams.get("groupname"));
    }

    private void showNoDataFlex(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object source = customParams.get("formSource");
        if (Objects.nonNull(source) && HRStringUtils.equals((String)((String)source), (String)"nodata_from_ermafile")) {
            customParams.put("revisetype", "newbo");
            customParams.remove("formSource");
            this.getView().cacheFormShowParameter();
            view.setVisible(Boolean.TRUE, new String[]{"customcontrolfelx"});
            view.setVisible(Boolean.FALSE, new String[]{"nodataleftlabelap"});
            view.setVisible(Boolean.TRUE, new String[]{"revise_info"});
            view.setVisible(Boolean.FALSE, new String[]{"nodataflex"});
            PersonReviseService personReviseService = new PersonReviseService();
            personReviseService.customControlNewBo(this.getView(), (String)customParams.get("groupname"));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"customcontrolfelx"});
            view.setVisible(Boolean.TRUE, new String[]{"nodataleftlabelap"});
            view.setVisible(Boolean.FALSE, new String[]{"revise_info"});
            view.setVisible(Boolean.TRUE, new String[]{"nodataflex"});
            customParams.put("no_data_page_show", "1");
        }
        this.setNoDataLeftLabel(customParams);
        this.setNewBoLabel(customParams);
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        if (!HRStringUtils.equals((String)customEventArgs.getKey(), (String)"customcontrolap") || !HRStringUtils.equals((String)customEventArgs.getEventName(), (String)"changeselect")) {
            return;
        }
        Map paramsMap = (Map)JSONObject.parseObject((String)customEventArgs.getEventArgs(), Map.class);
        if (paramsMap == null) {
            return;
        }
        String hisId = paramsMap.get("id").toString();
        String baseEntityName = (String)this.getView().getFormShowParameter().getCustomParams().get("entityname");
        DynamicObject curDyn = CommonQueryRepository.getInstance().queryDataByHisId(baseEntityName, Long.valueOf(hisId));
        this.getPageCache().put("toChangeHisid", hisId);
        String isEditing = this.getPageCache().get("isediting");
        PersonReviseService reviseService = new PersonReviseService();
        if (Objects.isNull(curDyn) || HRStringUtils.equals((String)curDyn.getString("datastatus"), (String)"-2")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PersonRevisePlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)isEditing, (String)"1")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_change", (IFormPlugin)this);
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u662f\u5426\u5207\u6362\uff1f{0}\u82e5\u5207\u6362\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PersonRevisePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), System.lineSeparator());
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        } else {
            reviseService.customControlChangeSelect(hisId, this.getView());
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            reviseService.openDetailViewRevise(hisId, (String)customParams.get("reviseentityname"), this.getView(), customParams);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("continue_change".equals(callBackId)) {
            PersonReviseService reviseService = new PersonReviseService(false, this.entityName);
            if (evt.getResult() == MessageBoxResult.Yes) {
                String hisId = this.getPageCache().get("toChangeHisid");
                this.getPageCache().remove("toChangeHisid");
                this.getPageCache().remove("isediting");
                reviseService.customControlChangeSelect(hisId, this.getView());
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                reviseService.openDetailViewRevise(hisId, (String)customParams.get("reviseentityname"), this.getView(), customParams);
            } else {
                reviseService.customControlChangeSelect(null, this.getView());
            }
        }
    }

    public void pageRelease(EventObject e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("reviseendandnotice".equals(operateKey)) {
            String isEditing = this.getView().getPageCache().get("isediting");
            if (HRStringUtils.equals((String)isEditing, (String)"1")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8fd8\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"PersonRevisePlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
                Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employeeid");
                Long ermanFileId = (Long)this.getView().getFormShowParameter().getCustomParam("ermanfileid");
                Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("personid");
                String groupName = (String)this.getView().getFormShowParameter().getCustomParam("groupname");
                operate.getOption().setVariableValue("entityname", entityName);
                operate.getOption().setVariableValue("employeeid", String.valueOf(employeeId));
                operate.getOption().setVariableValue("ermanfileid", String.valueOf(ermanFileId));
                operate.getOption().setVariableValue("personid", String.valueOf(personId));
                operate.getOption().setVariableValue("groupname", groupName);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("nodatanewbo".equals(operateKey)) {
            this.showNewDataFlex(this.getView());
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("formSource", "nodatanewbo");
            customParams.put("revisetype", "newbo");
            String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
            String reviseEntityName = (String)this.getView().getFormShowParameter().getCustomParam("reviseentityname");
            PersonReviseService personReviseService = new PersonReviseService();
            Long newId = ORM.create().genLongId(entityName);
            personReviseService.openDetailEditRevise(String.valueOf(newId), reviseEntityName, this.getView(), customParams);
        } else if ("reviseendandnotice".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            long reviseRecordId = ORM.create().genLongId("hrpi_reviserecord");
            this.getView().getFormShowParameter().getCustomParams().put("reviserecordid", reviseRecordId);
            this.getView().cacheFormShowParameter();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f", (String)"PersonRevisePlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView view = this.getView();
        view.getParentView().updateView();
        view.sendFormAction(view.getParentView());
    }
}

