/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.revise;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.inforevise.EmployeeRepository;
import kd.hr.hspm.business.revise.PersonReviseService;
import kd.hr.hspm.formplugin.web.revise.PersonReviseDetailEdit;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class TrialPeriodReviseDetailPlugin
extends PersonReviseDetailEdit
implements PersonReviseConstants {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("newbo".equals(customParams.get("revisetype")) || "nodatanewbo".equals(customParams.get("formSource")) || "nodata_from_ermafile".equals(customParams.get("formSource"))) {
            Long employeeId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("employeeid");
            DynamicObject employeeDyn = EmployeeRepository.getInstance().queryByPkId(employeeId);
            if (Objects.isNull(employeeDyn)) {
                return;
            }
            Date workStartDate = employeeDyn.getDate("startdate");
            this.getModel().beginInit();
            this.getModel().setValue("entrydate", (Object)workStartDate);
            this.getModel().setValue("startdate", (Object)workStartDate);
            this.getModel().endInit();
            this.getView().updateView("entrydate");
            this.getView().updateView("startdate");
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    protected List<String> getData2999Field() {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)16);
        fieldList.add("enddate");
        return fieldList;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long personId;
        Long ermanFileId;
        Long employeeId;
        String entityName;
        PersonReviseService personReviseService;
        DynamicObject[] hisVersions;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("revisesave".equals(operateKey)) {
            Long personId2 = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("personid");
            Long employeeId2 = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("employeeid");
            this.getView().getModel().setValue("employee", (Object)employeeId2);
            this.getView().getModel().setValue("person", (Object)personId2);
        } else if ("revisenewbo".equals(operateKey) && (hisVersions = (personReviseService = new PersonReviseService(true, entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname"))).getHisVersions(entityName, employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employeeid"), ermanFileId = (Long)this.getView().getFormShowParameter().getCustomParam("ermanfileid"), personId = (Long)this.getView().getFormShowParameter().getCustomParam("personid"), false, false, true)).length > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u8bd5\u7528\u671f\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"TrialPeriodReviseDetailPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    protected String getEntityName() {
        return "hrpi_trialperiod";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        Object oldValue = args.getChangeSet()[0].getOldValue();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("probation".equals(name)) {
            String probationUnit;
            Date entryDate = dataEntity.getDate("entrydate");
            if (this.determineIsNeedSetDate(entryDate, oldValue, probationUnit = dataEntity.getString("probationunit")) && Objects.nonNull(entryDate) && HRStringUtils.isNotEmpty((String)probationUnit)) {
                this.treatPreRegularDate(entryDate, (Integer)newValue, probationUnit, newValue);
            }
        } else if ("probationunit".equals(name)) {
            Date entryDate = dataEntity.getDate("entrydate");
            String probationUnit = dataEntity.getString("probationunit");
            DynamicProperty probationProp = dataEntity.getDynamicObjectType().getProperty("probation");
            Object probationPropValue = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)probationProp);
            if (this.determineIsNeedSetDate(entryDate, probationPropValue, oldValue) && Objects.nonNull(entryDate) && !HRObjectUtils.isEmpty((Object)probationPropValue)) {
                this.treatPreRegularDate(entryDate, (Integer)probationPropValue, probationUnit, newValue);
            }
        } else if ("entrydate".equals(name)) {
            String probationUnit;
            Date entryDate = dataEntity.getDate("entrydate");
            DynamicProperty probationProp = dataEntity.getDynamicObjectType().getProperty("probation");
            Object probationPropValue = dataEntity.getDataStorage().getLocalValue((IDataEntityProperty)probationProp);
            if (this.determineIsNeedSetDate((Date)oldValue, probationPropValue, probationUnit = dataEntity.getString("probationunit")) && HRStringUtils.isNotEmpty((String)probationUnit) && !HRObjectUtils.isEmpty((Object)probationPropValue)) {
                this.treatPreRegularDate(entryDate, (Integer)probationPropValue, probationUnit, newValue);
            }
        }
    }

    private boolean determineIsNeedSetDate(Date entryDate, Object probationPropValue, Object probationUnit) {
        boolean allNotNullFlag;
        Object preRegularDate = this.getModel().getValue("preregulardate");
        if (Objects.isNull(preRegularDate)) {
            return true;
        }
        boolean bl = allNotNullFlag = Objects.nonNull(entryDate) && Objects.nonNull(probationPropValue) && Objects.nonNull(probationUnit);
        if (allNotNullFlag) {
            Date resultDate = new Date();
            if ("1".equals(probationUnit)) {
                resultDate = HRDateTimeUtils.addMonth((Date)entryDate, (int)((Integer)probationPropValue));
            } else if ("2".equals(probationUnit)) {
                resultDate = HRDateTimeUtils.addDay((Date)entryDate, (long)((long)((Integer)probationPropValue).intValue() * 7L));
            } else if ("3".equals(probationUnit)) {
                resultDate = HRDateTimeUtils.addDay((Date)entryDate, (long)((Integer)probationPropValue * 1));
            }
            return HRDateTimeUtils.dayEquals((Date)resultDate, (Date)((Date)preRegularDate));
        }
        return false;
    }

    private void treatPreRegularDate(Date entryDate, Integer probation, String probationUnit, Object newValue) {
        Date resultDate = new Date();
        if (Objects.isNull(newValue)) {
            resultDate = null;
        } else if ("1".equals(probationUnit)) {
            resultDate = HRDateTimeUtils.addMonth((Date)entryDate, (int)probation);
        } else if ("2".equals(probationUnit)) {
            resultDate = HRDateTimeUtils.addDay((Date)entryDate, (long)((long)probation.intValue() * 7L));
        } else if ("3".equals(probationUnit)) {
            resultDate = HRDateTimeUtils.addDay((Date)entryDate, (long)(probation * 1));
        }
        this.getModel().beginInit();
        this.getModel().setValue("preregulardate", (Object)resultDate);
        this.getModel().endInit();
        this.getView().updateView("preregulardate");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        switch (operateKey) {
            case "saveconfirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    super.afterDoOperation(eventArgs);
                }
                return;
            }
            case "revisedeletebo": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    super.afterDoOperation(eventArgs);
                }
                return;
            }
        }
        super.afterDoOperation(eventArgs);
    }

    @Override
    protected boolean isNeedShowAfterSave(String fieldName, DynamicObject curDyn, DynamicObject newHisDyn) {
        List<String> specialFieldList = Collections.singletonList("regstatus");
        return specialFieldList.contains(fieldName);
    }
}

