/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.absbase;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.multiview.AttacheHandlerService;
import kd.hr.hspm.business.multiview.MultiViewTemplateService;
import kd.hr.hspm.business.multiview.PageRegConfigService;
import kd.hr.hspm.business.util.ParamAnalysisUtil;
import kd.hr.hspm.business.util.PersonModelUtil;
import kd.hr.hspm.common.constants.FieldTypeEnum;
import kd.hr.hspm.common.constants.PersonModelClassificationEnum;
import kd.hr.hspm.common.constants.attach.AttachConstants;
import kd.hr.hspm.common.constants.attachenum.BaseRefEnum;
import kd.hr.hspm.common.constants.cardvo.AfterCreatVo;
import kd.hr.hspm.common.constants.cardvo.BeforeCreatVo;
import kd.hr.hspm.common.constants.cardvo.CardViewCompareVo;
import kd.hr.hspm.common.constants.cardvo.CardViewVo;
import kd.hr.hspm.common.constants.cardvo.ContentApVo;
import kd.hr.hspm.common.constants.cardvo.DefineSpecialVo;
import kd.hr.hspm.common.constants.cardvo.FieldTransVo;
import kd.hr.hspm.common.constants.cardvo.PreBindDataVo;
import kd.hr.hspm.common.constants.cardvo.QueryDbVo;
import kd.hr.hspm.common.constants.cardvo.TextColorVo;
import kd.hr.hspm.common.constants.cardvo.TimeApVo;
import kd.hr.hspm.common.constants.utils.CommonUtil;
import kd.hr.hspm.common.constants.utils.PropertyHelper;
import kd.hr.hspm.formplugin.web.schedule.utils.ApCreateUtils;

@Deprecated
public class AbstractCardDrawEdit
extends AbstractFormPlugin
implements AttachConstants {
    private static final Log logger = LogFactory.getLog(AbstractCardDrawEdit.class);
    private CardViewVo cardViewVo = new CardViewVo();
    private List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
    private Map<String, Object> timeMap = new HashMap<String, Object>();

    public void beforeBindData(EventObject args) {
        this.prefixHandlerBeforeBindData(args);
        String contentApStr = this.childPlanAp();
        FlexPanelAp contentAp = ApCreateUtils.createFlexAp("contentap" + contentApStr, "contentap" + contentApStr);
        this.loadCardAp(this.dataList, contentAp, contentApStr, 0, 0);
        this.suffixHandlerBeforeBindData(args, this.dataList);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String businessStatus = (String)formShowParameter.getCustomParam("businessstatus");
        if (HRStringUtils.equals((String)businessStatus, (String)"-1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"oppanelap"});
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"button_add"});
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.contains("content")) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        } else if (key.contains("shamedit_") || key.contains("shamdel_") || key.contains("image") || key.contains("shamview_contract_") || key.contains("attach")) {
            Label label = new Label();
            label.setKey(key);
            if (key.contains("shamedit_")) {
                label.setOperationKey("do_edit");
            } else if (key.contains("shamdel_")) {
                label.setOperationKey("do_del");
            } else if (key.contains("shamview_contract_")) {
                label.setOperationKey("do_viewcontract");
            }
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            args.setControl((Control)label);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (evt.getSource() instanceof Label) {
            this.checkPerm(evt, ((Label)evt.getSource()).getKey());
        } else if (evt.getSource() instanceof Button) {
            this.checkPerm(evt, ((Button)evt.getSource()).getKey());
        }
    }

    private void checkPerm(BeforeClickEvent evt, String operateKey) {
        boolean validatePerm = false;
        String permItemId = null;
        if (operateKey.contains("shamedit_")) {
            validatePerm = true;
            permItemId = "4715a0df000000ac";
        } else if (operateKey.contains("shamdel_")) {
            validatePerm = true;
            permItemId = "4715e1f1000000ac";
        } else if (operateKey.contains("button_add")) {
            validatePerm = true;
            permItemId = "47156aff000000ac";
        } else if (operateKey.contains("button_adjust")) {
            validatePerm = true;
            permItemId = "2JJAYR7AWAX=";
        } else if (operateKey.contains("shamview_contract_")) {
            validatePerm = true;
            permItemId = "2PAWSCYV2YAE";
        }
        if (validatePerm) {
            CommonUtil.permShowClickError((IFormView)this.getView(), (String)permItemId, (BeforeClickEvent)evt, (String)"1");
        }
        if (operateKey.contains("shamdel_")) {
            String pkIdStr = operateKey.split("_")[operateKey.split("_").length - 1];
            long id = Long.parseLong(pkIdStr);
            boolean permData = AttacheHandlerService.getInstance().checkPkId(this.getView(), Long.valueOf(id), "cardpkidset");
            if (permData) {
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Label) {
            Label label = (Label)evt.getSource();
            this.handleClickEvent(label.getKey(), label.getOperationKey());
        } else if (evt.getSource() instanceof Button) {
            Button button = (Button)evt.getSource();
            this.handleClickEvent(button.getKey(), button.getOperationKey());
        }
    }

    private void handleClickEvent(String key, String operationKey) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        StringBuilder errMsg = new StringBuilder();
        if ("do_edit".equals(operationKey) || "do_del".equals(operationKey)) {
            int index = key.lastIndexOf(95);
            String pkId = key.substring(index + 1);
            boolean isSuccess = MutexHelper.require((IFormView)this.getView(), (String)formShowParameter.getFormId(), (Object)pkId, (String)"do_edit", (boolean)true, (StringBuilder)errMsg);
            if (!isSuccess) {
                this.getView().showErrorNotification(errMsg.toString());
                return;
            }
        }
        if (key.contains("shamedit_")) {
            this.handlerEdit(formShowParameter, key);
        } else if (key.contains("shamdel_")) {
            this.handlerDel(key);
        } else if (key.contains("button_add") || key.equals("button_adjust")) {
            this.showModuleAddFrom(formShowParameter, key);
        } else if (key.contains("attach")) {
            this.showAttachmentForm(key);
        }
    }

    protected PreBindDataVo prefixHandlerBeforeBindData(EventObject args) {
        FormView view = (FormView)args.getSource();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map paramMap = AttacheHandlerService.getInstance().getPageCustomParam(formShowParameter, this.getView().getEntityId());
        String preView = (String)formShowParameter.getCustomParam("preview");
        if (HRStringUtils.isNotEmpty((String)preView)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"button_add"});
        }
        return new PreBindDataVo(paramMap, view, formShowParameter);
    }

    protected void suffixHandlerBeforeBindData(EventObject args, List<Map<String, Object>> dataList) {
        try {
            Set pkIds = dataList.stream().map(map -> (Long)map.get("id")).collect(Collectors.toSet());
            if (pkIds.size() > 0) {
                this.getView().getPageCache().put("cardpkidset", SerializationUtils.toJsonString(pkIds));
            }
        }
        catch (Exception esc) {
            logger.error("suffixHandlerBeforeBindData", (Throwable)esc);
        }
    }

    protected void handlerEdit(FormShowParameter formShowParameter, String labelName) {
        this.showModuleFrom(formShowParameter, labelName);
    }

    protected void handlerDel(String labelName) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d,\u786e\u5b9a\u5220\u9664\uff1f", (String)"AbstractCardDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(labelName, (IFormPlugin)this));
    }

    private void showModuleFrom(FormShowParameter oldForm, String labelName) {
        FormShowParameter form = MultiViewTemplateService.getInstance().showFormType("3");
        if (form == null) {
            return;
        }
        String pkIdStr = labelName.split("_")[labelName.split("_").length - 1];
        String formId = AttacheHandlerService.getInstance().getRealFormId(this.getView(), "dialogpagenumber", true);
        logger.info(MessageFormat.format("inputEditPkId===={0}===={1}", formId, labelName));
        MultiViewTemplateService.getInstance().commonForm(form, formId, null, ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, labelName));
        form.setCustomParam("pkid", (Object)pkIdStr);
        if ("hspm_empsuprel_dv".equals(this.getView().getEntityId())) {
            String reportType = labelName.split("_")[labelName.split("_").length - 2];
            form.setCustomParam("reporttype", (Object)reportType);
        }
        form.setCustomParam("params", oldForm.getCustomParam("params"));
        form.setCustomParam("erfileid", oldForm.getCustomParam("erfileid"));
        form.setCustomParam("cus_status", (Object)"cus_edit");
        form.setStatus(OperationStatus.EDIT);
        PageRegConfigService.getInstance().setCommonCustomParam(form, this.getView());
        this.getView().showForm(form);
    }

    private void showModuleAddFrom(FormShowParameter oldForm, String labelName) {
        FormShowParameter form = MultiViewTemplateService.getInstance().showFormType("3");
        if (form == null) {
            return;
        }
        String formId = AttacheHandlerService.getInstance().getRealFormId(this.getView(), "dialogpagenumber", true);
        logger.info(MessageFormat.format("inputEditPkId===={0}===={1}", formId, labelName));
        MultiViewTemplateService.getInstance().commonForm(form, formId, null, ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, labelName));
        form.setCustomParam("params", oldForm.getCustomParam("params"));
        form.setCustomParam("erfileid", oldForm.getCustomParam("erfileid"));
        form.setCustomParam("cus_status", (Object)"cus_addnew");
        form.setStatus(OperationStatus.ADDNEW);
        if ("button_adjust".equals(labelName)) {
            form.setCustomParam("opKey", (Object)labelName);
        }
        PageRegConfigService.getInstance().setCommonCustomParam(form, this.getView());
        this.getView().showForm(form);
    }

    private void showAttachmentForm(String labelName) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId("hspm_attachment_dyview");
        form.setStatus(OperationStatus.VIEW);
        form.getOpenStyle().setShowType(ShowType.Modal);
        String[] paramArr = labelName.split("-");
        form.setCustomParam("type", (Object)paramArr[0]);
        form.setCustomParam("formid", (Object)paramArr[1]);
        form.setCustomParam("pkid", (Object)paramArr[2]);
        form.setCustomParam("attach", (Object)paramArr[3]);
        IPageCache pageCache = this.getView().getPageCache();
        form.setCustomParam("imagetypeface" + paramArr[2], (Object)pageCache.get("imagetypeface" + paramArr[2]));
        String typeStr = paramArr[0];
        String[] relType = typeStr.split("_");
        if ("1".equals(relType[0])) {
            form.setCustomParam("typenumber", (Object)pageCache.get(relType[1] + paramArr[2] + relType[1]));
        }
        form.setCustomParam("imagetypeface" + paramArr[2], (Object)pageCache.get("imagetypeface" + paramArr[2]));
        form.setCustomParam("imagetypeback" + paramArr[2], (Object)pageCache.get("imagetypeback" + paramArr[2]));
        form.setHasRight(true);
        this.getView().showForm(form);
    }

    protected void loadCardAp(List<Map<String, Object>> dataList, FlexPanelAp contentAp, String contentApStr, int outIndex, int maxsize) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String preView = (String)formShowParameter.getCustomParam("preview");
        if (HRStringUtils.isNotEmpty((String)preView)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oppanelap"});
        }
        AttacheHandlerService.containFlex((IFormView)this.getView(), (String)("contentap" + contentApStr));
        if (dataList == null || dataList.size() == 0) {
            FlexPanelAp noDataPanel = this.createNoDataPanel();
            FlexPanelAp tempContentAp = ApCreateUtils.createFlexAp("contentap" + contentApStr, "contentap" + contentApStr);
            tempContentAp.getItems().add(noDataPanel);
            MultiViewTemplateService.getInstance().setApToView(tempContentAp, "contentap" + contentApStr, this.getView());
            return;
        }
        String top = null;
        String marginTop = (String)this.getDefineSpecial("margintop");
        if (HRStringUtils.isNotEmpty((String)marginTop)) {
            top = marginTop;
            if ("empposorgrel".equals(contentApStr) || "managingscope".equals(contentApStr) || "empentrel".equals(contentApStr)) {
                top = "4px";
            }
        }
        boolean main = AttacheHandlerService.getInstance().judgeIsMain(this.getView().getFormShowParameter());
        String left = "12px";
        if (main) {
            left = null;
        }
        AttacheHandlerService.getInstance().setMargin(contentAp, top, null, left, "10px");
        contentAp.setGrow(0);
        contentAp.setAlignItems("stretch");
        int dataSize = dataList.size();
        for (int index = 0; index < dataList.size(); ++index) {
            Map<String, Object> dataMap = dataList.get(index);
            if (((Boolean)this.getDefineSpecial("timeflex")).booleanValue()) {
                this.drawTimeHeadFlex(new TimeApVo(dataMap, contentAp, index, outIndex));
            }
            this.drawMainFlex(new ContentApVo(dataMap, contentAp, index, dataSize, outIndex));
        }
        if (HRStringUtils.isNotEmpty((String)((String)this.getDefineSpecial("card")))) {
            contentAp.setDirection("row");
        } else {
            contentAp.setDirection("column");
            contentAp.setWrap(false);
        }
        if (outIndex != maxsize) {
            return;
        }
        if (contentAp.getItems().size() == 0) {
            FlexPanelAp noDataPanel = this.createNoDataPanel();
            MultiViewTemplateService.getInstance().setApToView(noDataPanel, "contentap" + contentApStr, this.getView());
        } else {
            MultiViewTemplateService.getInstance().setApToView(contentAp, "contentap" + contentApStr, this.getView());
        }
    }

    protected String childPlanAp() {
        Map tabList = ParamAnalysisUtil.getParams((FormShowParameter)this.getView().getFormShowParameter());
        String mappingFormId = ParamAnalysisUtil.getMappingFormId((Map)tabList);
        if (HRStringUtils.isNotEmpty((String)mappingFormId)) {
            if ("hrpi_pereduexpcert".equals(mappingFormId)) {
                mappingFormId = "hrpi_pereduexp";
            }
            int lastIndex = mappingFormId.lastIndexOf(95);
            return mappingFormId.substring(lastIndex + 1);
        }
        return null;
    }

    private FlexPanelAp getMainSubAp(String forId, int index, FlexPanelAp mainAp, Map<String, Object> dataMap) {
        boolean reSetAp = (Boolean)this.getDefineSpecial("resetap");
        FlexPanelAp commonAp = this.createCommonAp("contentsuboneap" + forId + index, "contentsuboneap" + forId + index, mainAp, "all", index, dataMap);
        if (reSetAp) {
            commonAp.setDirection("column");
            commonAp.setAlignItems("stretch");
            commonAp.setRadius("2px");
            return commonAp;
        }
        return commonAp;
    }

    private FlexPanelAp getMainAp(String forId, int index) {
        boolean reSetAp = (Boolean)this.getDefineSpecial("resetap");
        FlexPanelAp mainAp = ApCreateUtils.createOriginalFlexAp("contentbigsubtwoap" + forId + index, "contentbigsubtwoap" + forId + index);
        if (reSetAp) {
            mainAp.setGrow(0);
            mainAp.setShrink(0);
            mainAp.setWidth(new LocaleString((String)this.getDefineSpecial("cardwidth")));
            mainAp.setHeight(new LocaleString((String)this.getDefineSpecial("cardheight")));
            return mainAp;
        }
        return mainAp;
    }

    protected void drawMainFlex(ContentApVo contentApVo) {
        FlexPanelAp contentAp = contentApVo.getContentAp();
        contentAp.setGrow(1);
        contentAp.setShrink(0);
        Map dataMap = contentApVo.getDataMap();
        int index = contentApVo.getIndex();
        String forId = (String)this.timeMap.get("formid");
        FlexPanelAp mainAp = this.getMainAp(forId, index);
        mainAp.setGrow(0);
        Style mainStyle = AttacheHandlerService.getInstance().setPadding(mainAp, null, "16px", null, null);
        mainAp.setDirection("row");
        FlexPanelAp mainSubAp = this.getMainSubAp(forId, index, mainAp, dataMap);
        this.setLeftTimeAxis(mainSubAp, mainStyle, index, contentApVo);
        FlexPanelAp topAp = this.createCommonAp("contentsubtopap" + forId + index, "contentsubtopap" + forId + index, mainSubAp, "top", index, dataMap);
        topAp.setWidth(new LocaleString("100%"));
        topAp.setHeight(new LocaleString("28px"));
        topAp.setGrow(0);
        topAp.setWrap(false);
        FlexPanelAp leftAp = this.createCommonAp("contentthreetopleftap" + forId + index, "contentthreetopleftap" + forId + index, topAp, "head", index, dataMap);
        leftAp.setGrow(0);
        leftAp.setWrap(false);
        AttacheHandlerService.getInstance().setMargin(leftAp, "4px", null, null, "4px");
        FlexPanelAp rightAp = this.createCommonAp("contentthreetoprightap" + forId + index, "contentthreetoprightap" + forId + index, topAp, "text", index, dataMap);
        Boolean timeFlex = (Boolean)this.getDefineSpecial("timeflex");
        Boolean timeOutBut = (Boolean)this.getDefineSpecial("timeOutBut");
        if (!timeFlex.booleanValue()) {
            if (rightAp.getItems().size() == 0) {
                leftAp.setWidth(new LocaleString("90%"));
            }
            this.addOperationAp(dataMap, index, forId, topAp);
            if (topAp.getItems().size() > 0) {
                topAp.setDirection("row");
                mainSubAp.getItems().add(topAp);
                mainSubAp.setAlignItems("stretch");
            }
        } else if (timeFlex.booleanValue() && !timeOutBut.booleanValue()) {
            this.addOperationAp(dataMap, index, forId, topAp);
            if (topAp.getItems().size() > 0) {
                topAp.setDirection("row");
                mainSubAp.getItems().add(topAp);
                mainSubAp.setAlignItems("stretch");
            }
        } else if (leftAp.getItems().size() > 0 || rightAp.getItems().size() > 0) {
            mainSubAp.getItems().add(topAp);
        }
        this.createCommonAp("contentsubcenterap" + forId + index, "contentsubcenterap" + forId + index, mainSubAp, "content", index, dataMap);
        List attachFields = this.cardViewVo.getAttachFields();
        if (((Boolean)this.getDefineSpecial("attach")).booleanValue() || attachFields != null && attachFields.size() > 0) {
            this.createAttachAp(mainSubAp, dataMap, index);
        }
        if (mainAp.getItems().size() != 0) {
            contentAp.getItems().add(mainAp);
        }
    }

    private void addOperationAp(Map<String, Object> dataMap, int index, String forId, FlexPanelAp topAp) {
        List<String> butCount = this.getButList();
        if (butCount != null && butCount.size() > 0) {
            FlexPanelAp opAp = this.createCommonAp("contenttthreeoperationap" + forId + index, "contenttthreeoperationap" + forId + index, topAp, "operation", index, dataMap);
            opAp.setGrow(1);
            opAp.setWrap(false);
            opAp.setWidth(new LocaleString("110px"));
            AttacheHandlerService.getInstance().setMargin(opAp, null, null, null, "11px");
            this.createOperationAp(opAp, (String)this.getDefineSpecial("formid"), butCount, dataMap);
            if (opAp.getItems().size() > 0) {
                topAp.getItems().add(opAp);
            }
        }
    }

    private List<String> getButList() {
        String viewContract = (String)this.getDefineSpecial("viewmapcontract");
        Boolean timeFlex = (Boolean)this.getDefineSpecial("timeflex");
        List butCount = null;
        butCount = timeFlex.booleanValue() ? (HRStringUtils.isEmpty((String)viewContract) ? (List)this.getDefineSpecial("timebut") : (List)this.getDefineSpecial("timeinbut")) : (List)this.getDefineSpecial("headbut");
        return butCount;
    }

    private FlexPanelAp createCommonAp(String key, String name, FlexPanelAp parentAp, String type, int index, Map<String, Object> dataMap) {
        FlexPanelAp mainSubAp = ApCreateUtils.createOriginalFlexAp(key, name);
        switch (type) {
            case "all": {
                mainSubAp.setDirection("column");
                mainSubAp.setBackColor("#F5F5F5");
                break;
            }
            case "top": {
                AttacheHandlerService.getInstance().setMargin(mainSubAp, null, "8px", null, null);
                break;
            }
            case "head": {
                this.setFieldView(this.cardViewVo.getHeadFields(), mainSubAp, dataMap, "head", index);
                break;
            }
            case "text": {
                this.setFieldView(this.cardViewVo.getTextFields(), mainSubAp, dataMap, "text", index);
                break;
            }
            case "content": {
                mainSubAp.setWidth(new LocaleString("98%"));
                this.setFieldView(this.cardViewVo.getContentFields(), mainSubAp, dataMap, "content", index);
                break;
            }
        }
        if ("all".equals(type)) {
            parentAp.getItems().add(mainSubAp);
        } else if (mainSubAp.getItems().size() > 0) {
            parentAp.getItems().add(mainSubAp);
        }
        return mainSubAp;
    }

    protected void setLeftTimeAxis(FlexPanelAp mainSubAp, Style style, int index, ContentApVo contentApVo) {
        int dataSize = contentApVo.getDataSize();
        Boolean timeFlag = (Boolean)this.getDefineSpecial("timeflex");
        String pad = "10px";
        if (HRStringUtils.isNotEmpty((String)((String)this.getDefineSpecial("specialcard")))) {
            pad = "16px";
        }
        if (!timeFlag.booleanValue()) {
            if (HRStringUtils.isNotEmpty((String)((String)this.getDefineSpecial("specialcard")))) {
                Style style1 = AttacheHandlerService.getInstance().setBorder(mainSubAp, "#D9D9D9 solid 1px", "#D9D9D9 solid 1px", "#D9D9D9 solid 1px", "#D9D9D9 solid 1px");
                this.setCommonStyle(mainSubAp, style1, pad);
                mainSubAp.setBackColor("#ffffff");
                mainSubAp.setRadius("4px");
                FlexPanelAp originalFlexAp = ApCreateUtils.createOriginalFlexAp("headap", "headap");
                AttacheHandlerService.getInstance().setMargin(originalFlexAp, null, "12px", null, null);
                Map dataMap = contentApVo.getDataMap();
                String pic = (String)dataMap.get("superior.headsculpture");
                ImageAp attachImageAp = new ImageAp();
                attachImageAp.setKey("image" + index);
                attachImageAp.setWidth(new LocaleString("40px"));
                attachImageAp.setHeight(new LocaleString("40px"));
                attachImageAp.setRadius("50%");
                attachImageAp.setImageKey(pic);
                originalFlexAp.getItems().add(attachImageAp);
                mainSubAp.getItems().add(originalFlexAp);
            } else {
                Style style1 = new Style();
                this.setCommonStyle(mainSubAp, style1, pad);
            }
            return;
        }
        Boolean drawLine = Boolean.TRUE;
        if (index == this.dataList.size() - 1) {
            drawLine = Boolean.FALSE;
        }
        Margin margin = new Margin();
        margin.setRight("6px");
        margin.setLeft("6px");
        if (drawLine.booleanValue() || dataSize == 1) {
            Border border = new Border();
            border.setLeft("#E5E5E5 solid 1px");
            style.setBorder(border);
        }
        style.setMargin(margin);
        Style style1 = new Style();
        Padding padding = new Padding();
        padding.setLeft(pad);
        padding.setTop(pad);
        Margin margin1 = new Margin();
        margin1.setLeft("14px");
        style1.setPadding(padding);
        style1.setMargin(margin1);
        mainSubAp.setStyle(style1);
    }

    private void setCommonStyle(FlexPanelAp mainSubAp, Style style1, String px) {
        Padding padding = new Padding();
        padding.setLeft(px);
        padding.setTop(px);
        Margin margin = new Margin();
        margin.setLeft("6px");
        margin.setRight("10px");
        style1.setMargin(margin);
        style1.setPadding(padding);
        mainSubAp.setStyle(style1);
    }

    private void setFieldView(List<Map<String, Object>> headField, FlexPanelAp topLeftMainAp, Map<String, Object> dataMap, String apType, int idx) {
        if (headField == null || headField.size() == 0) {
            return;
        }
        String ope = "";
        boolean preCreate = false;
        for (int index = 0; index < headField.size(); ++index) {
            Map<String, Object> filedMap = headField.get(index);
            ope = (String)filedMap.get("formid");
            String number = (String)filedMap.get("number");
            HashMap<String, String> valueMap = new HashMap<String, String>(16);
            valueMap.put(number, "");
            boolean createFlag = this.beforeCreateLabel(new BeforeCreatVo(filedMap, valueMap, apType, dataMap, idx));
            if (createFlag) continue;
            if (index != 0 && preCreate && "head".equals(apType)) {
                LabelAp cutAp = this.createCutAp("cut_" + ope + index, "|");
                topLeftMainAp.getItems().add(cutAp);
            }
            String labelName = (String)valueMap.get(number);
            if (CommonUtil.fullLineField().contains(number)) {
                labelName = labelName.replaceAll("\r\n|\r|\n", "");
            }
            LabelAp fieldAp = ApCreateUtils.createLabelAp(number + idx, labelName);
            this.afterCreateLabel(new AfterCreatVo(filedMap, fieldAp, apType, dataMap, topLeftMainAp));
            preCreate = true;
        }
    }

    protected boolean beforeCreateLabel(BeforeCreatVo beforeCreatVo) {
        Map labMap = beforeCreatVo.getLabMap();
        Map dataMap = beforeCreatVo.getDataMap();
        Map relMap = beforeCreatVo.getRelMap();
        String labType = beforeCreatVo.getLabType();
        String field = (String)labMap.get("number");
        String type = (String)labMap.get("type");
        String relStr = this.transferType(field, dataMap);
        relMap.put(field, relStr);
        boolean createFlag = false;
        switch (labType) {
            case "text": {
                createFlag = this.createLabel(beforeCreatVo);
                break;
            }
            case "head": {
                createFlag = this.createLabel(beforeCreatVo);
                if (createFlag || !FieldTypeEnum.COMBO.getType().equals(type)) break;
                this.handlerReallyWord(beforeCreatVo);
                break;
            }
            case "content": {
                Date endDate;
                if (FieldTypeEnum.COMBO.getType().equals(type)) {
                    this.handlerReallyWord(beforeCreatVo);
                    break;
                }
                if (FieldTypeEnum.BOOLEAN.getType().equals(type)) {
                    String displayName = (String)labMap.get("displayname");
                    String number = (String)labMap.get("number");
                    String value = HRStringUtils.isEmpty((String)relStr) ? "-" : ("0".equals(relStr) ? ResManager.loadKDString((String)"\u5426", (String)"AbstractCardDrawEdit_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"AbstractCardDrawEdit_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    String relLabStr = displayName + "\uff1a" + value;
                    relMap.put(number, relLabStr);
                    break;
                }
                String displayName = (String)labMap.get("displayname");
                String number = (String)labMap.get("number");
                String value = HRStringUtils.isEmpty((String)relStr) ? "-" : relStr;
                Object dateObj = dataMap.get(field);
                if (dateObj instanceof Date && CommonUtil.getMaxDate((Date)(endDate = (Date)dateObj))) {
                    value = "-";
                }
                String relLabStr = displayName + "\uff1a" + value;
                relMap.put(number, relLabStr);
                break;
            }
        }
        if (createFlag) {
            return true;
        }
        createFlag = this.customChangeLabelValue(beforeCreatVo);
        return createFlag;
    }

    private void handlerReallyWord(BeforeCreatVo beforeCreatVo) {
        Map labMap = beforeCreatVo.getLabMap();
        String labType = beforeCreatVo.getLabType();
        String number = (String)labMap.get("number");
        String pnumber = (String)labMap.get("pnumber");
        if (HRStringUtils.isNotEmpty((String)number) && HRStringUtils.isNotEmpty((String)pnumber) && FieldTypeEnum.COMBO.getType().equals(labType)) {
            IDataEntityProperty property = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)pnumber).getAllFields().get(number);
            this.handlerShow(beforeCreatVo, property);
        }
    }

    protected void handlerShow(BeforeCreatVo beforeCreatVo, IDataEntityProperty property) {
        if (!(property instanceof ComboProp)) {
            return;
        }
        Map dataMap = beforeCreatVo.getDataMap();
        Map labMap = beforeCreatVo.getLabMap();
        String number = (String)labMap.get("number");
        Map relMap = beforeCreatVo.getRelMap();
        ComboProp comboProp = (ComboProp)property;
        List values = comboProp.getComboItems();
        for (ValueMapItem item : values) {
            String pageValue = item.getValue();
            String dbValue = (String)dataMap.get(number);
            if (HRStringUtils.isEmpty((String)dbValue)) {
                return;
            }
            if (HRStringUtils.isEmpty((String)pageValue) || !pageValue.equals(dbValue)) continue;
            relMap.put(number, item.getName().getLocaleValue());
        }
    }

    protected boolean customChangeLabelValue(BeforeCreatVo beforeCreatVo) {
        return false;
    }

    protected void afterCreateLabel(AfterCreatVo afterCreatVo) {
        String labType = afterCreatVo.getLabType();
        LabelAp fieldAp = afterCreatVo.getFieldAp();
        Style style = new Style();
        afterCreatVo.setStyle(style);
        switch (labType) {
            case "head": {
                fieldAp.setForeColor("#212121");
                fieldAp.setFontWeight("600");
                fieldAp.setFontSize(14);
                fieldAp.setTextAlign("center");
                fieldAp.setAlignSelf("center");
                break;
            }
            case "text": {
                this.setLabelColorStyle(new TextColorVo(style, fieldAp, null, null, "100px"));
                break;
            }
            case "content": {
                boolean createWidth = true;
                if (HRStringUtils.isNotEmpty((String)((String)this.getDefineSpecial("dyfield")))) {
                    createWidth = this.dyCreateNewField(afterCreatVo);
                }
                if (createWidth) {
                    String width = (String)this.getDefineSpecial("margincontent");
                    fieldAp.setWidth(new LocaleString(width));
                }
                Margin margin = new Margin();
                margin.setBottom("10px");
                style.setMargin(margin);
                fieldAp.setStyle(style);
                break;
            }
        }
        this.customChangeLabelStyle(afterCreatVo);
        afterCreatVo.getMainAp().getItems().add(fieldAp);
    }

    protected boolean dyCreateNewField(AfterCreatVo afterCreatVo) {
        return true;
    }

    protected void customChangeLabelStyle(AfterCreatVo afterCreatVo) {
    }

    protected boolean createLabel(BeforeCreatVo beforeCreatVo) {
        DynamicObject dy;
        String field;
        Map labMap = beforeCreatVo.getLabMap();
        Map dataMap = beforeCreatVo.getDataMap();
        Object obj = dataMap.get(field = (String)labMap.get("number"));
        if (obj instanceof DynamicObject && PropertyHelper.existProperty((DynamicObject)(dy = (DynamicObject)obj), (String)"name")) {
            return HRStringUtils.isEmpty((String)dy.getString("name"));
        }
        return CommonUtil.objIsEmpty(obj);
    }

    protected Boolean isImageAttachment(Map<String, Object> dataMap) {
        return Boolean.FALSE;
    }

    private void createAttachAp(FlexPanelAp mainAp, Map<String, Object> dataMap, int idx) {
        List attachFields = this.cardViewVo.getAttachFields();
        Boolean isImageAttachment = this.isImageAttachment(dataMap);
        if (attachFields == null || attachFields.size() == 0) {
            return;
        }
        List<Map<String, Object>> attTotal = new ArrayList<Map<String, Object>>();
        FlexPanelAp attachPanelAp = new FlexPanelAp();
        for (int index = 0; index < attachFields.size(); ++index) {
            Map filedMap = (Map)attachFields.get(index);
            String page = (String)filedMap.get("pnumber");
            if (index == 0) {
                if (isImageAttachment == null) {
                    this.initAttachAp(mainAp, attachPanelAp, page, idx, true);
                    return;
                }
                Long pkId = (Long)dataMap.get("id");
                if (pkId == null || pkId == 0L) {
                    return;
                }
                attTotal = AttachmentServiceHelper.getAttachments((String)page, (Object)pkId, (String)this.getAttachmentApName(page));
                this.initAttachAp(mainAp, attachPanelAp, page, idx, false);
            }
            this.createAttContentAp(index, attachPanelAp, attTotal, filedMap, idx, isImageAttachment, page, dataMap);
        }
    }

    private void initAttachAp(FlexPanelAp mainAp, FlexPanelAp attachPanelAp, String page, int idx, boolean emptyAtt) {
        String forId = (String)this.timeMap.get("formid");
        FlexPanelAp botMainAp = ApCreateUtils.createOriginalFlexAp("contentsubbottomap" + forId + idx, "contentsubbottomap" + forId + idx);
        AttacheHandlerService.getInstance().setMargin(botMainAp, null, null, "4px", null);
        botMainAp.setDirection("column");
        botMainAp.setHeight(new LocaleString("39px"));
        if (emptyAtt) {
            botMainAp.setBackColor("#F5F5F5");
        } else {
            Style style = new Style();
            Border border = new Border();
            border.setTop("#E5E5E5 solid 1px");
            style.setBorder(border);
            botMainAp.setStyle(style);
        }
        mainAp.getItems().add(botMainAp);
        attachPanelAp.setKey(page + idx);
        attachPanelAp.setWidth(new LocaleString("100%"));
        attachPanelAp.setWrap(false);
        attachPanelAp.setGrow(0);
        attachPanelAp.setDirection("row");
        attachPanelAp.setAlignItems("flex-start");
        attachPanelAp.setJustifyContent("flex-start");
        AttacheHandlerService.getInstance().setMargin(attachPanelAp, "10px", null, null, null);
        botMainAp.getItems().add(attachPanelAp);
    }

    public void createAttContentAp(int index, FlexPanelAp attachPanelAp, List<Map<String, Object>> attachments, Map<String, Object> filedMap, int idx, Boolean isImageAttachment, String page, Map<String, Object> dataMap) {
        Object id = dataMap.get("id");
        String key = (String)filedMap.get("formid");
        if ("hspm_percre_dv".equals(key) && isImageAttachment.booleanValue()) {
            String imageStr = this.hideImageUrl(filedMap, dataMap);
            String displayName = (String)filedMap.get("displayname");
            Tuple<Boolean, String> cardTp = this.setCardName(imageStr, dataMap, displayName, id);
            if (((Boolean)cardTp.item1).booleanValue()) {
                this.attacheImage(index, attachPanelAp, key);
                String labelKey = "1_" + imageStr + "-" + page + "-" + id + "-" + this.getAttachmentApName(page) + "-" + key + "attach" + index + "_" + idx;
                LabelAp attachAp = AbstractCardDrawEdit.createLabelAp(labelKey, (String)cardTp.item2, null, "7px", 12);
                attachPanelAp.getItems().add(attachAp);
            }
        } else {
            if (index != 0) {
                return;
            }
            if (attachments.size() == 0) {
                return;
            }
            this.attacheImage(index, attachPanelAp, key);
            String attKey = "0-" + page + "-" + id + "-" + this.getAttachmentApName(page) + "-" + key + "attach" + index + "_" + idx;
            LabelAp attachAp = AbstractCardDrawEdit.createLabelAp(attKey, String.format(ResManager.loadKDString((String)"\u9644\u4ef6(%s)", (String)"AbstractCardDrawEdit_14", (String)"hr-hspm-formplugin", (Object[])new Object[0]), attachments.size()), null, "7px", 12);
            attachPanelAp.getItems().add(attachAp);
        }
    }

    private Tuple<Boolean, String> setCardName(String imageStr, Map<String, Object> dataMap, String displayName, Object id) {
        Object typeObj = dataMap.get("credentialstype");
        if (typeObj == null) {
            return Tuple.create((Object)Boolean.TRUE, (Object)displayName);
        }
        if (typeObj instanceof DynamicObject) {
            DynamicObject typeDy = (DynamicObject)typeObj;
            String number = typeDy.getString("number");
            if (HRStringUtils.isEmpty((String)number)) {
                return Tuple.create((Object)Boolean.TRUE, (Object)displayName);
            }
            this.getView().getPageCache().put(imageStr + id + imageStr, number);
            Tuple imgName = AttacheHandlerService.getInstance().getCardCNByEN(imageStr, displayName, number);
            if (imgName != null) {
                return imgName;
            }
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)displayName);
    }

    private String hideImageUrl(Map<String, Object> filedMap, Map<String, Object> dataMap) {
        IPageCache pageCache = this.getView().getPageCache();
        Object id = dataMap.get("id");
        String field = (String)filedMap.get("number");
        String imageTypeFace = (String)this.getDefineSpecial("imagetypeface");
        String imageTypeBack = (String)this.getDefineSpecial("imagetypeback");
        if (imageTypeFace.equals(field)) {
            pageCache.put("imagetypeface" + id, (String)dataMap.get(field));
            return "faceimage";
        }
        if (imageTypeBack.equals(field)) {
            pageCache.put("imagetypeback" + id, (String)dataMap.get(field));
            return "reverseimage";
        }
        return "";
    }

    private void attacheImage(int index, FlexPanelAp attachPanelAp, String key) {
        ImageAp attachImageAp = new ImageAp();
        attachImageAp.setKey(key + "_" + "image" + index);
        attachImageAp.setWidth(new LocaleString("13px"));
        attachImageAp.setHeight(new LocaleString("16px"));
        attachImageAp.setImageKey("/icons/mobile/other/icon_attachment.png");
        attachPanelAp.getItems().add(attachImageAp);
        Margin imageMargin = new Margin();
        imageMargin.setBottom("7px");
        imageMargin.setRight("4px");
        Style imageStyle = new Style();
        imageStyle.setMargin(imageMargin);
        attachImageAp.setStyle(imageStyle);
    }

    protected String getAttachmentApName(String page) {
        if ("hrpi_percre".equals(page)) {
            return "attachmentpanelap_std";
        }
        if ("hrpi_perocpqual".equals(page)) {
            return "attachmentpanelap";
        }
        return "attachmentpanelap_std";
    }

    private static LabelAp createLabelAp(String key, String name, String marginLeft, String marginBottom, int fontSize) {
        LabelAp lblName = new LabelAp();
        lblName.setKey(key);
        lblName.setName(new LocaleString(name));
        lblName.setForeColor("#5E80EB");
        lblName.setFontSize(fontSize);
        lblName.setClickable(true);
        Style style = new Style();
        Margin margin = new Margin();
        if (HRStringUtils.isNotEmpty((String)marginLeft)) {
            margin.setLeft(marginLeft);
        }
        margin.setRight("25px");
        margin.setBottom(marginBottom);
        style.setMargin(margin);
        lblName.setStyle(style);
        return lblName;
    }

    protected void drawTimeHeadFlex(TimeApVo timeApVo) {
        List<String> butList = this.getButList();
        int index = timeApVo.getIndex();
        FlexPanelAp contentAp = timeApVo.getContentAp();
        Map dataMap = timeApVo.getDataMap();
        FlexPanelAp headContentAp = ApCreateUtils.createOriginalFlexAp("contentbigsubap" + this.timeMap.get("formid") + index, "contentbigsubap" + this.timeMap.get("formid") + index);
        headContentAp.setJustifyContent("center");
        headContentAp.setAlignItems("center");
        headContentAp.setAlignContent("center");
        headContentAp.setOverflow("hidden");
        headContentAp.setGrow(0);
        AttacheHandlerService.getInstance().setMargin(headContentAp, "3px", "8px", null, "12px");
        this.setTimeHeadDetail(headContentAp, dataMap, butList, index);
        if (headContentAp.getItems().size() != 0) {
            contentAp.getItems().add(headContentAp);
        }
    }

    private void setTimeHeadDetail(FlexPanelAp headContentAp, Map<String, Object> dataMap, List<String> butList, int idx) {
        String ope = (String)this.getDefineSpecial("formid");
        List timeFields = this.cardViewVo.getTimeFields();
        if (timeFields == null || timeFields.size() == 0) {
            FlexPanelAp rightAp = ApCreateUtils.createOriginalFlexAp("contentbigthreerightap" + idx, "contentbigthreerightap" + idx);
            this.createOperationAp(rightAp, ope, butList, dataMap);
            if (butList == null || butList.size() == 0) {
                return;
            }
            headContentAp.getItems().add(rightAp);
            return;
        }
        LabelAp labelAp = this.getTimeLabelAp(idx);
        headContentAp.getItems().add(labelAp);
        FlexPanelAp leftAp = ApCreateUtils.createOriginalFlexAp("contentbigthreeeleftap" + idx, "contentbigthreeeleftap" + idx);
        leftAp.setAlignItems("center");
        leftAp.setAlignContent("center");
        headContentAp.getItems().add(leftAp);
        FlexPanelAp rightAp = ApCreateUtils.createOriginalFlexAp("contentbigthreerightap" + idx, "contentbigthreerightap" + idx);
        headContentAp.getItems().add(rightAp);
        for (int index = 0; index < timeFields.size(); ++index) {
            Map filedMap = (Map)timeFields.get(index);
            String number = (String)filedMap.get("number");
            String relStr = this.transferType(number, dataMap);
            boolean maxJudge = false;
            if ("sysenddate".equals(number) || "enddate".equals(number)) {
                Tuple<String, Boolean> tuple = this.handlerDate(filedMap, dataMap, number, relStr);
                relStr = (String)tuple.item1;
                maxJudge = (Boolean)tuple.item2;
            }
            LabelAp fieldAp = ApCreateUtils.createLabelAp(number + "fixtimeid" + idx, relStr);
            if (maxJudge) {
                Style fieldStyle = new Style();
                Margin fieldMargin = new Margin();
                fieldStyle.setMargin(fieldMargin);
                fieldMargin.setLeft("-10px");
                fieldAp.setStyle(fieldStyle);
            }
            leftAp.getItems().add(fieldAp);
            if (index != 0) continue;
            String tody = ResManager.loadKDString((String)"\u81f3", (String)"AbstractCardDrawEdit_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            LabelAp fixAp = ApCreateUtils.createLabelAp(number + "fix" + idx, tody);
            Style style = new Style();
            Margin margin = new Margin();
            style.setMargin(margin);
            margin.setLeft("10px");
            margin.setRight("10px");
            fixAp.setStyle(style);
            leftAp.getItems().add(fixAp);
        }
        this.createOperationAp(rightAp, ope, butList, dataMap);
    }

    private Tuple<String, Boolean> handlerDate(Map<String, Object> filedMap, Map<String, Object> dataMap, String number, String relStr) {
        Tuple tuple = Tuple.create((Object)relStr, (Object)false);
        Object dateObj = dataMap.get(number);
        if (dateObj != null) {
            Date date = (Date)dateObj;
            String dbDateStr = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            String currDateStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date dbDate = null;
            Date currDate = null;
            try {
                dbDate = HRDateTimeUtils.parseDate((String)dbDateStr, (String)"yyyy-MM-dd");
                currDate = HRDateTimeUtils.parseDate((String)currDateStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException exc) {
                logger.error("handlerDateException", (Throwable)exc);
            }
            String pageNumber = (String)filedMap.get("pnumber");
            PersonModelClassificationEnum classification = PersonModelUtil.getClassification((String)pageNumber);
            if (PersonModelClassificationEnum.PERATTACHED != classification) {
                if (dbDate != null && (HRDateTimeUtils.dayAfter((Date)dbDate, (Date)currDate) || CommonUtil.getMaxDate((Date)dbDate))) {
                    if ("hrpi_empjobrel".equals(pageNumber) && "2".equals(dataMap.get("businessstatus"))) {
                        return Tuple.create((Object)dbDateStr, (Object)false);
                    }
                    relStr = ResManager.loadKDString((String)"\u4eca", (String)"AbstractCardDrawEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    return Tuple.create((Object)relStr, (Object)true);
                }
                return Tuple.create((Object)dbDateStr, (Object)false);
            }
        }
        return tuple;
    }

    private void createOperationAp(FlexPanelAp rightAp, String ope, List<String> butList, Map<String, Object> dataMap) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String preView = (String)formShowParameter.getCustomParam("preview");
        if (HRStringUtils.isNotEmpty((String)preView)) {
            return;
        }
        String businessStatus = (String)formShowParameter.getCustomParam("businessstatus");
        if (butList == null || butList.size() == 0 || HRStringUtils.equals((String)businessStatus, (String)"-1")) {
            return;
        }
        int actButCount = butList.size();
        for (int index = 0; index < butList.size(); ++index) {
            String mappingFormId;
            PersonModelClassificationEnum classification;
            String but = butList.get(index);
            if ("shamedit_".equals(but) && "2".equals(dataMap.get("businessstatus")) && ((classification = PersonModelUtil.getClassification((String)(mappingFormId = ParamAnalysisUtil.getMappingFormId((Map)ParamAnalysisUtil.getParams((FormShowParameter)formShowParameter))))) == PersonModelClassificationEnum.EMPATTACHED || classification == PersonModelClassificationEnum.DEPEMPATTACHED)) {
                --actButCount;
                continue;
            }
            Long pkStr = (Long)dataMap.get("id");
            String labelKey = ope + "_" + but + pkStr;
            LabelAp editAp = ApCreateUtils.createLabelAp(labelKey, this.getRelButCn(but));
            if ("shamedit_".equals(but)) {
                editAp.setOperationKey("do_edit");
            } else if ("shamdel_".equals(but)) {
                editAp.setOperationKey("do_del");
            } else if ("shamview_contract_".equals(but)) {
                editAp.setOperationKey("do_viewcontract");
            }
            editAp.setFontSize(12);
            editAp.setClickable(true);
            editAp.setForeColor("themeColor");
            rightAp.getItems().add(editAp);
            if (actButCount != 2 || index >= butList.size() - 1) continue;
            LabelAp cutAp = this.createCutAp("cut_" + ope, "|");
            rightAp.getItems().add(cutAp);
        }
        rightAp.setJustifyContent("flex-end");
        rightAp.setDirection("row");
    }

    private String getRelButCn(String but) {
        if ("shamedit_".equals(but)) {
            return ResManager.loadKDString((String)"\u4fee\u6539", (String)"AbstractCardDrawEdit_15", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        if ("shamdel_".equals(but)) {
            return ResManager.loadKDString((String)"\u5220\u9664", (String)"AbstractCardDrawEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        if ("shamview_contract_".equals(but)) {
            return ResManager.loadKDString((String)"\u67e5\u770b\u6700\u65b0\u5408\u540c\u534f\u8bae", (String)"AbstractCardDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private LabelAp createCutAp(String cut, String value) {
        LabelAp cutAp = ApCreateUtils.createLabelAp(cut, value);
        cutAp.setHeight(new LocaleString("8px"));
        cutAp.setTextAlign("center");
        cutAp.setAlignSelf("center");
        Style style = new Style();
        Margin margin = new Margin();
        style.setMargin(margin);
        margin.setLeft("8px");
        margin.setRight("8px");
        cutAp.setStyle(style);
        return cutAp;
    }

    protected String transferType(String number, Map<String, Object> dataMap) {
        Object data = dataMap.get(number);
        if (data == null) {
            return " ";
        }
        Object realData = this.getRealData(data, number);
        if (realData == null) {
            return " ";
        }
        return String.valueOf(realData);
    }

    private Object getRealData(Object data, String number) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof ILocaleString) {
            return ((ILocaleString)data).getLocaleValue();
        }
        if (data instanceof Number) {
            NumberFormat format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(1);
            return format.format(data);
        }
        if (data instanceof Date) {
            return HRDateTimeUtils.format((Date)((Date)data), (String)"yyyy-MM-dd");
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? "1" : "0";
        }
        if (data instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)data;
            if (PropertyHelper.existProperty((DynamicObject)dy, (String)"name")) {
                return ((DynamicObject)data).getString("name");
            }
            if (PropertyHelper.existProperty((DynamicObject)dy, (String)"number")) {
                return ((DynamicObject)data).getString("number");
            }
            BaseRefEnum fieldTypeByCode = BaseRefEnum.getFieldTypeByCode((String)number);
            if (fieldTypeByCode != null) {
                long baseId = dy.getLong("id");
                if (baseId == 0L) {
                    return "";
                }
                String relField = fieldTypeByCode.getField();
                String findField = number + "." + relField;
                if (PropertyHelper.existProperty((DynamicObject)dy, (String)findField)) {
                    return this.getBaseNameOrNumber(dy.get(findField));
                }
                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(fieldTypeByCode.getBaseEntity());
                DynamicObject dynamicObject = baseServiceHelper.queryOne(relField, (Object)baseId);
                if (dynamicObject != null) {
                    return this.getBaseNameOrNumber(dynamicObject.get(relField));
                }
            }
        }
        return " ";
    }

    private String getBaseNameOrNumber(Object subData) {
        if (subData instanceof DynamicObject) {
            DynamicObject subDataDy = (DynamicObject)subData;
            if (PropertyHelper.existProperty((DynamicObject)subDataDy, (String)"name")) {
                return subDataDy.getString("name");
            }
            if (PropertyHelper.existProperty((DynamicObject)subDataDy, (String)"number")) {
                return subDataDy.getString("number");
            }
        }
        return "";
    }

    private LabelAp getTimeLabelAp(int index) {
        LabelAp labelAp = ApCreateUtils.createLabelAp(" " + index, " ");
        labelAp.setWidth(new LocaleString("13px"));
        labelAp.setHeight(new LocaleString("13px"));
        labelAp.setRadius("10px");
        labelAp.setBackColor("#ffffff");
        labelAp.setForeColor("#ffffff");
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "2px_solid_themeColor";
        border.setBottom(borderStyle);
        border.setTop(borderStyle);
        border.setLeft(borderStyle);
        border.setRight(borderStyle);
        style.setBorder(border);
        Margin margin = new Margin();
        style.setMargin(margin);
        margin.setRight("10px");
        labelAp.setStyle(style);
        return labelAp;
    }

    protected Object getDefineSpecial(String key) {
        return this.timeMap.get(key);
    }

    protected Map<String, Object> defineSpecial(DefineSpecialVo dsVo) {
        String viewContractBut = dsVo.getViewContractBut();
        if (dsVo.getTimeFlag()) {
            if (HRStringUtils.isEmpty((String)viewContractBut)) {
                this.putButCount(dsVo.getTimeEdit(), dsVo.getTimeDel(), this.timeMap, "timebut", true, dsVo);
            } else {
                this.putButCount(dsVo.getTimeEdit(), dsVo.getViewContractBut(), this.timeMap, "timeinbut", true, dsVo);
            }
        } else {
            this.putButCount(dsVo.getHeadEdit(), dsVo.getHeadDel(), this.timeMap, "headbut", false, dsVo);
        }
        this.timeMap.put("timeOutBut", dsVo.isTimeOutBut());
        this.timeMap.put("attach", Boolean.FALSE);
        this.timeMap.put("margincontent", "24%");
        this.timeMap.put("formid", this.getView().getEntityId());
        this.timeMap.put("resetap", Boolean.FALSE);
        this.timeMap.put("margintop", "12px");
        return this.timeMap;
    }

    private void putButCount(String edit, String del, Map<String, Object> timeMap, String headBut, boolean timeFlag, DefineSpecialVo dsVo) {
        String viewContractBut = dsVo.getViewContractBut();
        if (HRStringUtils.isNotEmpty((String)edit) || HRStringUtils.isNotEmpty((String)del)) {
            ArrayList<String> butList = new ArrayList<String>();
            if (HRStringUtils.isEmpty((String)viewContractBut)) {
                if (HRStringUtils.isNotEmpty((String)edit)) {
                    butList.add(edit);
                }
                if (HRStringUtils.isNotEmpty((String)del)) {
                    butList.add(del);
                }
            } else {
                if (HRStringUtils.isNotEmpty((String)del)) {
                    butList.add(del);
                }
                if (HRStringUtils.isNotEmpty((String)edit)) {
                    butList.add(edit);
                }
            }
            timeMap.put(headBut, butList);
        }
        timeMap.put("timeflex", timeFlag);
    }

    protected List<String> setChildFieldVo(FieldTransVo fieldTransVo) {
        Map tabMap = fieldTransVo.getTabMap();
        CardViewCompareVo compareVo = fieldTransVo.getCompareVo();
        CardViewVo cardViewVo = new CardViewVo();
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> timeFields = new ArrayList<String>();
        ArrayList<String> headFields = new ArrayList<String>();
        ArrayList<String> textFields = new ArrayList<String>();
        ArrayList<String> contentFields = new ArrayList<String>();
        ArrayList<String> attFields = new ArrayList<String>();
        String formId = (String)tabMap.get("pagenumber");
        List groups = (List)tabMap.get("groups");
        for (Map filedMap : groups) {
            List fields = (List)filedMap.get("fields");
            for (Map field : fields) {
                String number = (String)field.get("number");
                BaseRefEnum fieldTypeByCode = BaseRefEnum.getFieldTypeByCode((String)number);
                if (fieldTypeByCode != null) {
                    String relField = fieldTypeByCode.getField();
                    fieldList.add(number + "." + relField);
                }
                fieldList.add(number);
                if (HRStringUtils.isNotEmpty((String)compareVo.getTimeFields())) {
                    this.setDataToVoList(compareVo.getTimeFields(), field, timeFields, "time", cardViewVo, formId);
                }
                if (HRStringUtils.isNotEmpty((String)compareVo.getHeadFields())) {
                    this.setDataToVoList(compareVo.getHeadFields(), field, headFields, "head", cardViewVo, formId);
                }
                if (HRStringUtils.isNotEmpty((String)compareVo.getTextFields())) {
                    this.setDataToVoList(compareVo.getTextFields(), field, textFields, "text", cardViewVo, formId);
                }
                if (HRStringUtils.isNotEmpty((String)compareVo.getContentFields())) {
                    this.setDataToVoList(compareVo.getContentFields(), field, contentFields, "content", cardViewVo, formId);
                }
                if (!HRStringUtils.isNotEmpty((String)compareVo.getAttachFields())) continue;
                this.setDataToVoList(compareVo.getAttachFields(), field, attFields, "attach", cardViewVo, formId);
            }
        }
        logger.info(MessageFormat.format("setChildVoToDataMap--{0}", fieldList));
        fieldList.add("id");
        String mappingFormId = ParamAnalysisUtil.getMappingFormId((Map)tabMap);
        if (HRStringUtils.isNotEmpty((String)mappingFormId) && MetadataServiceHelper.getDataEntityType((String)mappingFormId).getAllFields().containsKey("businessstatus")) {
            fieldList.add("businessstatus");
        }
        this.setCardViewVo(cardViewVo);
        return fieldList;
    }

    private void setDataToVoList(String field, Map<String, Object> fieldMap, List<String> fieldCompare, String type, CardViewVo tempCardViewVo, String formId) {
        List<Map<String, Object>> list = this.setFields(field, fieldMap, fieldCompare, formId);
        if (list != null && list.size() > 0) {
            if ("time".equals(type)) {
                List timeFields = tempCardViewVo.getTimeFields();
                String startStr = (String)fieldMap.get("number");
                if (timeFields != null && timeFields.size() > 0 && "startdate".equals(startStr)) {
                    timeFields.addAll(0, list);
                } else {
                    tempCardViewVo.setTimeFields(list);
                }
            } else if ("head".equals(type)) {
                tempCardViewVo.setHeadFields(list);
            } else if ("text".equals(type)) {
                tempCardViewVo.setTextFields(list);
            } else if ("content".equals(type)) {
                tempCardViewVo.setContentFields(list);
            } else if ("attach".equals(type)) {
                tempCardViewVo.setAttachFields(list);
            }
        }
    }

    private List<Map<String, Object>> setFields(String field, Map<String, Object> filedMap, List<String> fields, String formId) {
        String number;
        ArrayList<Map<String, Object>> tempGroups = new ArrayList<Map<String, Object>>();
        List<String> fieldList = Arrays.asList(field.split(","));
        if (!fieldList.contains(number = (String)filedMap.get("number")) || fields.contains(number)) {
            return null;
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
        tempMap.put("number", filedMap.get("number"));
        tempMap.put("type", filedMap.get("type"));
        tempMap.put("displayname", filedMap.get("displayname"));
        tempMap.put("pnumber", filedMap.get("pnumber"));
        tempMap.put("formid", formId);
        tempGroups.add(tempMap);
        fields.add(number);
        return tempGroups;
    }

    protected void setLabelColorStyle(TextColorVo textColorVo) {
        String radius = textColorVo.getRadius();
        LabelAp labelAp = textColorVo.getLabelAp();
        String forColor = textColorVo.getForColor();
        String backColor = textColorVo.getBackColor();
        Style style = textColorVo.getStyle();
        if (HRStringUtils.isNotEmpty((String)radius)) {
            labelAp.setRadius(radius);
        }
        labelAp.setTextAlign("center");
        labelAp.setAlignSelf("center");
        if (HRStringUtils.isEmpty((String)forColor)) {
            forColor = "#666666";
        }
        if (HRStringUtils.isEmpty((String)backColor)) {
            backColor = "rgba(255,255,255,0.1)";
        }
        labelAp.setBackColor(backColor);
        labelAp.setForeColor(forColor);
        labelAp.setFontSize(12);
        String borderColor = forColor + " " + "solid" + " " + "1px";
        Border border = new Border();
        border.setBottom(borderColor);
        border.setTop(borderColor);
        border.setLeft(borderColor);
        border.setRight(borderColor);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("8px");
        padding.setRight("8px");
        padding.setBottom("2px");
        padding.setTop("2px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setLeft("10px");
        margin.setTop("2px");
        margin.setBottom("2px");
        style.setMargin(margin);
        labelAp.setStyle(style);
    }

    protected FlexPanelAp createNoDataPanel() {
        FlexPanelAp parentPanelAp = new FlexPanelAp();
        parentPanelAp.setKey("emptyap");
        parentPanelAp.setDirection("column");
        parentPanelAp.setAlignItems("stretch");
        parentPanelAp.setWrap(false);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("nodatapanel");
        flexPanelAp.setWrap(false);
        flexPanelAp.setGrow(1);
        flexPanelAp.setDirection("column");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setJustifyContent("center");
        FlexPanelAp showCharacterPanel = new FlexPanelAp();
        showCharacterPanel.setKey("showcharactorap");
        showCharacterPanel.setJustifyContent("center");
        showCharacterPanel.setGrow(1);
        showCharacterPanel.setShrink(0);
        showCharacterPanel.setAlignSelf("stretch");
        showCharacterPanel.setWidth(new LocaleString("220px"));
        LabelAp textLbl = new LabelAp();
        textLbl.setKey("textlblap");
        textLbl.setName(new LocaleString(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"AbstractCardDrawEdit_16", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        textLbl.setFontSize(14);
        textLbl.setForeColor("#666");
        textLbl.setTextAlign("center");
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("imageap");
        imageAp.setImageKey("images/pc/emotion/fxjd_no_data.png");
        flexPanelAp.getItems().add(imageAp);
        flexPanelAp.getItems().add(textLbl);
        parentPanelAp.getItems().add(flexPanelAp);
        String top = "16px";
        if (!AttacheHandlerService.getInstance().judgeIsMain(this.getView().getFormShowParameter())) {
            top = "10%";
        }
        AttacheHandlerService.getInstance().setMargin(parentPanelAp, top, null, null, null);
        return parentPanelAp;
    }

    protected List<Map<String, Object>> queryAndAssDataFromDb(QueryDbVo queryDbVo) {
        String entityId = queryDbVo.getEntityId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String fieldStr = CommonUtil.listToString((List)queryDbVo.getFields(), (char)',');
        if (HRStringUtils.isEmpty((String)fieldStr)) {
            return result;
        }
        QFilter[] filters = queryDbVo.getFilters();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        filterList.add(curFilter);
        filterList.add(dataFilter);
        QFilter[] qFilters = filterList.toArray(new QFilter[filterList.size()]);
        DynamicObject[] query = null;
        try {
            query = "preview".equals(this.getView().getFormShowParameter().getCustomParam("preview")) ? new DynamicObject[]{this.getPreViewData(serviceHelper)} : (HRStringUtils.isEmpty((String)queryDbVo.getOrderBy()) ? serviceHelper.query(fieldStr, qFilters) : serviceHelper.query(fieldStr, qFilters, queryDbVo.getOrderBy()));
        }
        catch (Exception err) {
            logger.error(entityId + "queryAndAssDataFromDbExceptio" + err);
        }
        if (HRObjectUtils.isEmpty(query)) {
            return result;
        }
        boolean isLanguageSkills = entityId.equals("hrpi_languageskills");
        boolean isEduExp = entityId.equals("hrpi_pereduexp");
        for (DynamicObject dynamicObject : query) {
            Map allFields = ((MainEntityType)query[0].getDataEntityType()).getAllFields();
            if (allFields.containsKey("otherlanguagecert") && allFields.containsKey("languagecert")) {
                String otherValue = dynamicObject.getString("otherlanguagecert");
                if (isLanguageSkills && !otherValue.equals("-") && !otherValue.equals("")) {
                    dynamicObject.set("languagecert", (Object)otherValue);
                }
            }
            if (allFields.containsKey("schoolrecord") && allFields.containsKey("graduateschool")) {
                String otherSchool = dynamicObject.getString("schoolrecord");
                String school = dynamicObject.getString("graduateschool.number");
                if (isEduExp && HRStringUtils.equals((String)school, (String)"30000010_S")) {
                    dynamicObject.set("graduateschool", (Object)otherSchool);
                }
            }
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            try {
                resultList.add(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
                result.addAll(resultList);
                if (!queryDbVo.getSetToList().booleanValue()) continue;
                this.setDataList(resultList);
            }
            catch (Exception err) {
                logger.error(entityId + "setDataToMapCardViewVoError" + err);
            }
        }
        return result;
    }

    private DynamicObject getPreViewData(HRBaseServiceHelper serviceHelper) {
        List fields;
        List groups;
        Map tabList = ParamAnalysisUtil.getParams((FormShowParameter)this.getView().getFormShowParameter());
        if (tabList != null && !CollectionUtils.isEmpty((Collection)(groups = ParamAnalysisUtil.getGroups((Map)tabList))) && !CollectionUtils.isEmpty((Collection)(fields = ParamAnalysisUtil.getFields((Map)((Map)groups.get(0)))))) {
            Map<String, Map<String, Object>> map = fields.stream().collect(Collectors.toMap(val -> (String)val.get("number"), val -> val));
            return this.creatVirtualData(serviceHelper, map);
        }
        return serviceHelper.generateEmptyDynamicObject();
    }

    private DynamicObject creatVirtualData(HRBaseServiceHelper serviceHelper, Map<String, Map<String, Object>> fieldMap) {
        DynamicObject virtualData = serviceHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection collection = virtualData.getDynamicObjectType().getProperties();
        Map<String, Object> fieldInfo = null;
        for (IDataEntityProperty dataEntityProperty : collection) {
            if (!CollectionUtils.isEmpty(fieldMap) && (fieldInfo = fieldMap.get(dataEntityProperty.getName())) != null) continue;
            this.fillField(virtualData, dataEntityProperty, fieldInfo);
        }
        return virtualData;
    }

    private void fillField(DynamicObject virtualData, IDataEntityProperty dataEntityProperty, Map<String, Object> fieldInfo) {
        String propName = dataEntityProperty.getName();
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            String entityName = basedataProp.getBaseEntityId();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            if (entityName.contains("hrpi")) {
                virtualData.set(propName, (Object)this.creatVirtualData(helper, null));
            } else if (fieldInfo != null && HRStringUtils.isNotEmpty((String)((String)fieldInfo.get("displayname")))) {
                DynamicObject dy = helper.generateEmptyDynamicObject();
                dy.set("id", (Object)1111L);
                if (PropertyHelper.existProperty((String)entityName, (String)"number")) {
                    dy.set("number", (Object)"1010_S");
                }
                if (PropertyHelper.existProperty((String)entityName, (String)"name")) {
                    dy.set("name", fieldInfo.get("displayname"));
                }
                virtualData.set(propName, (Object)dy);
            } else {
                DynamicObject[] dys;
                QFilter filter = new QFilter("id", ">", (Object)0L);
                if (PropertyHelper.existProperty((String)entityName, (String)"enable")) {
                    filter.and("enable", "=", (Object)"1");
                }
                if ((dys = helper.query("id,number,name", new QFilter[]{filter}, "id", 1)) != null && dys.length > 0) {
                    virtualData.set(propName, (Object)dys[0]);
                }
            }
        } else if (dataEntityProperty instanceof DateProp || dataEntityProperty instanceof DateTimeProp) {
            if (dataEntityProperty.getName().contains("end")) {
                virtualData.set(propName, (Object)new Timestamp(HRDateTimeUtils.getSysMaxDate().getTime()));
            } else {
                virtualData.set(propName, (Object)new Timestamp(System.currentTimeMillis()));
            }
        } else if (dataEntityProperty instanceof ComboProp) {
            virtualData.set(propName, (Object)"1");
        } else if (dataEntityProperty instanceof TextProp) {
            String entityId = virtualData.getDynamicObjectType().getName();
            if ("schoolrecord".equals(propName) && "hrpi_pereduexp".equals(entityId)) {
                return;
            }
            if ("otherlanguagecert".equals(propName) && "hrpi_languageskills".equals(entityId)) {
                return;
            }
            if (fieldInfo != null && HRStringUtils.isNotEmpty((String)((String)fieldInfo.get("displayname")))) {
                virtualData.set(propName, fieldInfo.get("displayname"));
            } else {
                LocaleString localeString = dataEntityProperty.getDisplayName();
                if (localeString != null) {
                    virtualData.set(propName, (Object)localeString.getLocaleValue());
                }
            }
        }
    }

    public CardViewVo getCardViewVo() {
        return this.cardViewVo;
    }

    public void setCardViewVo(CardViewVo cardViewVo) {
        this.cardViewVo = cardViewVo;
    }

    public AbstractCardDrawEdit() {
    }

    public AbstractCardDrawEdit(CardViewVo cardViewVo) {
        this.cardViewVo = cardViewVo;
    }

    public Map<String, Object> getTimeMap() {
        return this.timeMap;
    }

    public void setTimeMap(Map<String, Object> timeMap) {
        this.timeMap = timeMap;
    }

    public List<Map<String, Object>> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<Map<String, Object>> dataList) {
        if (this.dataList == null) {
            this.dataList = dataList;
        } else {
            this.dataList.addAll(dataList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            MutexHelper.release((IFormView)this.getView());
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        String[] split = key.split("_");
        String pkStr = split[split.length - 1];
        String curEntity = "hrpi_" + split[1];
        if (HRStringUtils.isNotEmpty((String)key)) {
            PersonModelClassificationEnum classification = PersonModelUtil.getClassification((String)curEntity);
            if (classification == null) {
                Map pageCustomParam = AttacheHandlerService.getInstance().getPageCustomParam(this.getView().getFormShowParameter(), this.getView().getEntityId());
                curEntity = (String)pageCustomParam.get("mappingFormid");
                classification = PersonModelUtil.getClassification((String)curEntity);
            }
            DynamicObject[] dyArr = null;
            if (PersonModelClassificationEnum.PERATTACHED == classification || "hrpi_empjobrel".equals(curEntity)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(curEntity);
                dyArr = serviceHelper.queryOriginalArray("person.id,boid,sourcevid", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(pkStr))});
            }
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            HashMap<Long, Long> pkPersonIdMap = new HashMap<Long, Long>(16);
            pkPersonIdMap.put(Long.parseLong(pkStr), personId);
            List personIds = AttacheHandlerService.getInstance().validateSyncFieldsDelChange(curEntity, pkPersonIdMap);
            Map resultMap = AttacheHandlerService.getInstance().invokeDel(Collections.singletonList(Long.parseLong(pkStr)), curEntity, Boolean.TRUE);
            if (AttacheHandlerService.isSuccess((Map)resultMap)) {
                if (personIds != null && personIds.size() > 0) {
                    AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(personIds);
                }
                if (dyArr != null && dyArr.length > 0) {
                    String realFormId = AttacheHandlerService.getInstance().getRealFormId(this.getView(), "pagenumber", false);
                    AttacheHandlerService.getInstance().sendHpfsChgDeleteRecord(dyArr, curEntity, realFormId);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AbstractCardDrawEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
                this.delAttachMent(pkStr);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"AbstractCardDrawEdit_17", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
        }
        MutexHelper.release((IFormView)this.getView());
    }

    private void delAttachMent(String pkStr) {
        String attKey = (String)this.getDefineSpecial("delattach");
        String delAttForm = (String)this.getDefineSpecial("delattachform");
        if (HRStringUtils.isNotEmpty((String)attKey)) {
            try {
                List attachments = AttachmentServiceHelper.getAttachments((String)delAttForm, (Object)pkStr, (String)attKey);
                if (attachments == null || attachments.size() == 0) {
                    return;
                }
                Set<String> uidSet = attachments.stream().map(tem -> (String)tem.get("uid")).collect(Collectors.toSet());
                uidSet.forEach(uid -> AttacheHandlerService.getInstance().invokeRemoveAttachment(delAttForm, (Object)pkStr, uid));
            }
            catch (Exception esc) {
                logger.error("delAttachFailPkIdIs", (Object)pkStr);
                logger.error("delAttachFail", (Throwable)esc);
            }
        }
    }
}

