/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.cardview;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.multiview.AttacheHandlerService;
import kd.hr.hspm.common.constants.cardvo.AfterCreatVo;
import kd.hr.hspm.common.constants.cardvo.BeforeCreatVo;
import kd.hr.hspm.common.constants.cardvo.CardViewCompareVo;
import kd.hr.hspm.common.constants.cardvo.DefineSpecialVo;
import kd.hr.hspm.common.constants.cardvo.FieldTransVo;
import kd.hr.hspm.common.constants.cardvo.PreBindDataVo;
import kd.hr.hspm.common.constants.cardvo.QueryDbVo;
import kd.hr.hspm.common.constants.cardvo.TextColorVo;
import kd.hr.hspm.common.constants.utils.CommonUtil;
import kd.hr.hspm.formplugin.web.schedule.absbase.AbstractCardDrawEdit;

public class EmpOrgRelOutCardPlugin
extends AbstractCardDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(EmpOrgRelOutCardPlugin.class);
    private static final String TIME_FIELDS = "startdate,enddate,";
    private static final String HEAD_FIELDS = "company,position,adminorg,stdposition";
    private static final String TEXT_FIELDS = "islatestrecord,postype";
    private static final String CONTENT_FIELDS = "cmpemp,variationtype,variationreason,job,isexistprobation,startprobation,endprobation,description";

    @Override
    protected PreBindDataVo prefixHandlerBeforeBindData(EventObject args) {
        PreBindDataVo preBindDataVo = super.prefixHandlerBeforeBindData(args);
        FormShowParameter formShowParameter = preBindDataVo.getFormShowParameter();
        boolean main = AttacheHandlerService.getInstance().judgeIsMain(formShowParameter);
        if (main) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "topflexpanelap"});
        }
        String filterStr = this.getView().getPageCache().get("recordfilter");
        QFilter qFilter = null;
        if (HRStringUtils.isNotEmpty((String)filterStr)) {
            qFilter = new QFilter("islatestrecord", "=", (Object)filterStr);
        }
        this.handlerBeforeBindData(preBindDataVo.getFormShowParameter(), qFilter, preBindDataVo.getDataMap());
        return preBindDataVo;
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String key = changedArgs.getProperty().getName();
        if ("empnewrecord".equals(key)) {
            Boolean record = (Boolean)this.getModel().getValue("empnewrecord");
            if (record.booleanValue()) {
                this.getView().getPageCache().put("recordfilter", "1");
            } else {
                this.getView().getPageCache().put("recordfilter", null);
            }
            this.getView().updateView();
        }
    }

    private void handlerBeforeBindData(FormShowParameter formShowParameter, QFilter qFilter, Map<String, Object> tabMap) {
        List<String> fields = this.assessAbleFields(tabMap);
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        if (personId == null || personId == 0L) {
            return;
        }
        QFilter idFilter = new QFilter("person", "=", (Object)personId);
        QFilter isSysFilter = new QFilter("isinsystem", "=", (Object)"0");
        QFilter[] conFilter = new QFilter[]{idFilter, isSysFilter};
        if (qFilter != null) {
            idFilter.and(qFilter);
        }
        fields.add("iscurrentversion");
        if (!fields.contains("islatestrecord")) {
            fields.add("islatestrecord");
        }
        this.queryAndAssDataFromDb(new QueryDbVo(conFilter, fields, "hrpi_emporgrelall", "startdate desc,sysenddate desc,createtime desc"));
        QFilter idFilters = new QFilter("person", "=", (Object)personId);
        QFilter[] conFilters = new QFilter[]{idFilters};
        this.setTotalAndNew(fields, conFilters);
        this.defineSpecial(new DefineSpecialVo(true, "shamedit_", "shamdel_", null, null));
    }

    private void setTotalAndNew(List<String> fields, QFilter[] conFilter) {
        List<Map<String, Object>> list;
        String filterStr;
        List<Map<String, Object>> dataList = this.getDataList();
        String totalTimeStr = "0";
        if (dataList != null && dataList.size() > 0) {
            totalTimeStr = dataList.size() + "";
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filterdatapanelap"});
        }
        if (HRStringUtils.isNotEmpty((String)(filterStr = this.getView().getPageCache().get("recordfilter"))) && (list = this.queryAndAssDataFromDb(new QueryDbVo(conFilter, fields, "hrpi_empposorgrel", Boolean.FALSE))).size() > 0) {
            totalTimeStr = list.size() + "";
        }
        this.getModel().setValue("totaltime", (Object)totalTimeStr);
    }

    private List<String> assessAbleFields(Map<String, Object> tabMap) {
        CardViewCompareVo compareVo = new CardViewCompareVo(TIME_FIELDS, HEAD_FIELDS, TEXT_FIELDS, CONTENT_FIELDS, null);
        return this.setChildFieldVo(new FieldTransVo(tabMap, compareVo));
    }

    @Override
    protected boolean createLabel(BeforeCreatVo beforeCreatVo) {
        boolean label = super.createLabel(beforeCreatVo);
        if (!label) {
            return label;
        }
        String labType = beforeCreatVo.getLabType();
        boolean flag = true;
        if ("text".equals(labType)) {
            flag = this.handlerSpecialWordShow(beforeCreatVo);
        }
        return flag;
    }

    private boolean handlerSpecialWordShow(BeforeCreatVo beforeCreatVo) {
        String field;
        Map dataMap = beforeCreatVo.getDataMap();
        Map relMap = beforeCreatVo.getRelMap();
        List<String> wordList = this.specialWord("0");
        if (!wordList.contains(field = (String)relMap.get("number"))) {
            return true;
        }
        Object recordObj = dataMap.get(field);
        if (recordObj == null) {
            return false;
        }
        return !"0".equals(recordObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean customChangeLabelValue(BeforeCreatVo beforeCreatVo) {
        super.customChangeLabelValue(beforeCreatVo);
        Map dataMap = beforeCreatVo.getDataMap();
        Map labMap = beforeCreatVo.getLabMap();
        Map relMap = beforeCreatVo.getRelMap();
        String labType = beforeCreatVo.getLabType();
        String field = (String)labMap.get("number");
        if ("text".equals(labType)) {
            List<String> wordList = this.specialWord("0");
            if (!wordList.contains(field)) {
                return false;
            }
            Object obj = dataMap.get(field);
            if (CommonUtil.objIsEmpty(obj)) {
                return false;
            }
            if (!(obj instanceof Boolean) || !"islatestrecord".equals(field)) return false;
            if (!((Boolean)obj).booleanValue()) return true;
            relMap.put(field, ResManager.loadKDString((String)"\u6700\u65b0\u8bb0\u5f55", (String)"EmpPosoRgRelCardPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        } else {
            if (!"content".equals(labType)) return false;
            Object obj = dataMap.get(field);
            if (CommonUtil.objIsEmpty(obj)) {
                return false;
            }
            if (!(obj instanceof Boolean) || !"isexistprobation".equals(field)) return false;
            return AttacheHandlerService.getInstance().transferBoolType(beforeCreatVo);
        }
    }

    @Override
    protected void customChangeLabelStyle(AfterCreatVo afterCreatVo) {
        String labType = afterCreatVo.getLabType();
        Map filedMap = afterCreatVo.getFiledMap();
        if ("text".equals(labType)) {
            String field;
            List<String> wordList = this.specialWord("1");
            if (!wordList.contains(field = (String)filedMap.get("number"))) {
                return;
            }
            afterCreatVo.setField(field);
            this.handlerSpecialWordStyle(afterCreatVo);
        }
    }

    private void handlerSpecialWordStyle(AfterCreatVo afterCreatVo) {
        Map dataMap = afterCreatVo.getDataMap();
        String field = afterCreatVo.getField();
        Style style = afterCreatVo.getStyle();
        LabelAp fieldAp = afterCreatVo.getFieldAp();
        Object data = dataMap.get(field);
        if (CommonUtil.objIsEmpty(data)) {
            return;
        }
        Map<Object, Object> posTypeColorMap = new HashMap(16);
        if ("postype".equals(field)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_postype");
            Long pkId = 0L;
            if (data instanceof DynamicObject) {
                pkId = ((DynamicObject)data).getLong("id");
            }
            if (pkId != 0L) {
                DynamicObject dynamicObject = serviceHelper.queryOne("postcategory.number", (Object)pkId);
                if (dynamicObject == null) {
                    return;
                }
                String pst = dynamicObject.getString("postcategory.number");
                posTypeColorMap = this.getPosTypeColorMap(pst);
            }
        } else if ("islatestrecord".equals(field)) {
            Boolean record = (Boolean)dataMap.get(field);
            posTypeColorMap = this.getRecordColorMap(record);
        }
        this.setLabelColorStyle(new TextColorVo(style, fieldAp, (String)posTypeColorMap.get("forColor"), (String)posTypeColorMap.get("backColor"), "100px"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        String entityId = this.getView().getEntityId();
        if (key.contains(entityId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getView().updateView();
        }
    }

    private List<String> specialWord(String type) {
        ArrayList<String> list = new ArrayList<String>();
        if ("1".equals(type)) {
            list.add("postype");
        }
        list.add("islatestrecord");
        return list;
    }

    private Map<String, String> getPosTypeColorMap(String posTypeId) {
        HashMap colorMap = new HashMap(16);
        HashMap<String, String> posTypeMap = new HashMap<String, String>(16);
        posTypeMap.put("forColor", "#1BA854");
        posTypeMap.put("backColor", "rgba(242,255,245,0.1)");
        colorMap.put("1010_S", posTypeMap);
        posTypeMap = new HashMap(16);
        posTypeMap.put("forColor", "#276FF5");
        posTypeMap.put("backColor", "rgba(133,184,255,0.1)");
        colorMap.put("1020_S", posTypeMap);
        posTypeMap = new HashMap(16);
        posTypeMap.put("forColor", "#ffb44a");
        posTypeMap.put("backColor", "rgba(255,180,74,0.1)");
        colorMap.put("1040_S", posTypeMap);
        Map rePosTypeMap = (Map)colorMap.get(posTypeId);
        if (rePosTypeMap == null) {
            return new HashMap<String, String>(16);
        }
        return rePosTypeMap;
    }

    private Map<String, String> getRecordColorMap(Boolean record) {
        HashMap recordMap = new HashMap(16);
        HashMap<String, String> posTypeMap = new HashMap<String, String>(16);
        posTypeMap.put("forColor", "#FB2323");
        posTypeMap.put("backColor", "rgba(255,242,244,0.1)");
        recordMap.put(Boolean.TRUE, posTypeMap);
        Map rePosTypeMap = (Map)recordMap.get(record);
        if (rePosTypeMap == null) {
            return new HashMap<String, String>(16);
        }
        return rePosTypeMap;
    }
}

