/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.cardview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.utils.HpfsPersonInfoParamUtil;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.ext.file.CardBindDataDTO;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.vo.AfterCreatVo;
import kd.sdk.hr.hspm.common.vo.BeforeCreatVo;
import kd.sdk.hr.hspm.common.vo.CardViewCompareVo;
import kd.sdk.hr.hspm.common.vo.DefineSpecialVo;
import kd.sdk.hr.hspm.common.vo.FieldTransVo;
import kd.sdk.hr.hspm.common.vo.PreBindDataVo;
import kd.sdk.hr.hspm.common.vo.QueryDbVo;
import kd.sdk.hr.hspm.common.vo.TextColorVo;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractCardDrawEdit;

public class EmpPosoRgRelCardPlugin
extends AbstractCardDrawEdit {
    private static final Log logger = LogFactory.getLog(EmpPosoRgRelCardPlugin.class);
    private static final String TIME_FIELDS = "startdate,enddate,";
    private static final String HEAD_FIELDS = "company,position,adminorg,stdposition";
    private static final String TEXT_FIELDS = "islatestrecord,postype";
    private static final String CONTENT_FIELDS = "cmpemp,variationtype,variationreason,job,isexistprobation,startprobation,endprobation,description";

    protected PreBindDataVo prefixHandlerBeforeBindData(EventObject args) {
        PreBindDataVo preBindDataVo = super.prefixHandlerBeforeBindData(args);
        FormShowParameter formShowParameter = preBindDataVo.getFormShowParameter();
        boolean main = AttacheHandlerService.getInstance().judgeIsMain(formShowParameter);
        if (main) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "topflexpanelap", "flexpanelap2"});
        }
        String filterStr = this.getView().getPageCache().get("recordfilter");
        QFilter qFilter = null;
        if (HRStringUtils.isNotEmpty((String)filterStr)) {
            qFilter = new QFilter("islatestrecord", "=", (Object)filterStr);
        }
        this.handlerBeforeBindData(preBindDataVo.getFormShowParameter(), qFilter, preBindDataVo.getDataMap(), args);
        return preBindDataVo;
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String key = changedArgs.getProperty().getName();
        if ("empnewrecord".equals(key)) {
            Boolean record = (Boolean)this.getModel().getValue("empnewrecord");
            if (record.booleanValue()) {
                this.getView().getPageCache().put("recordfilter", "1");
            } else {
                this.getView().getPageCache().put("recordfilter", null);
            }
            this.getView().updateView();
        }
    }

    private void handlerBeforeBindData(FormShowParameter formShowParameter, QFilter qFilter, Map<String, Object> tabMap, EventObject args) {
        Long erFileId;
        QueryDbVo queryDbVo = new QueryDbVo();
        queryDbVo.setEntityId("hrpi_empposorgrel");
        queryDbVo.setOrderBy("startdate desc,sysenddate desc,createtime desc");
        List<String> fields = this.assessAbleFields(tabMap, args, queryDbVo);
        Long employeeId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("employee"));
        if (employeeId == null || employeeId == 0L) {
            return;
        }
        QFilter idFilter = new QFilter("employee", "=", (Object)employeeId);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(idFilter);
        if (qFilter != null) {
            list.add(qFilter);
        }
        fields.add("iscurrentversion");
        if (!fields.contains("islatestrecord")) {
            fields.add("islatestrecord");
        }
        if ((erFileId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("erfileid"))) == null || erFileId == 0L) {
            return;
        }
        DynamicObject ermanfile = ErmanFileRepository.getErmanfile((Long)erFileId);
        Date startDate = ermanfile.getDate("startdate");
        Date endDate = ermanfile.getDate("enddate");
        if (endDate == null) {
            endDate = HspmDateUtils.getMaxEndDate();
        }
        Long orgId = ermanfile.getLong("org.id");
        logger.info("org===={}", (Object)orgId);
        Map paramMap = HpfsPersonInfoParamUtil.getEmpExpType((Long)orgId);
        logger.info("empExpType===={},isincludebefore===={}", paramMap.get("empexptype"), paramMap.get("isincludebefore"));
        this.queryDataByConfig(list, startDate, endDate, paramMap);
        this.appendDataForMoreEntry(formShowParameter, idFilter, list, paramMap);
        queryDbVo.setFilters(list.toArray(new QFilter[list.size()]));
        queryDbVo.setFields(fields);
        this.queryAndAssDataFromDb(queryDbVo);
        list.remove(qFilter);
        this.setTotalAndNew(fields, list.toArray(new QFilter[list.size()]));
        this.defineSpecial(new DefineSpecialVo(true, "shamedit_", null, null, null));
    }

    private void queryDataByConfig(List<QFilter> list, Date startDate, Date endDate, Map<String, Object> paramMap) {
        HpfsPersonInfoParamUtil.EmpExpTypeEnum empexptype = (HpfsPersonInfoParamUtil.EmpExpTypeEnum)paramMap.get("empexptype");
        if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_DEPT) {
            QFilter dateFilter = new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("startdate", "<=", (Object)endDate));
            list.add(dateFilter);
        } else if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_AND_AFTER_DEPT) {
            QFilter dateFilter = new QFilter("enddate", ">=", (Object)startDate);
            list.add(dateFilter);
        } else if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_AND_BEFORE_DEPT) {
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate);
            list.add(dateFilter);
        }
    }

    private void appendDataForMoreEntry(FormShowParameter formShowParameter, QFilter idFilter, List<QFilter> list, Map<String, Object> paramMap) {
        HRBaseServiceHelper helper;
        DynamicObject[] objects;
        Long personId;
        if (paramMap.get("isincludebefore") != null && Boolean.TRUE.equals(paramMap.get("isincludebefore")) && (personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"))) != null && personId != 0L && (objects = (helper = new HRBaseServiceHelper("hrpi_person")).query("personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)})) != null && objects.length > 0) {
            long pid = objects[0].getLong("personindexid");
            QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
            QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
            DynamicObject[] allPerson = helper.query("id", new QFilter[]{curFilter, initstatusFilter, dataFilter, new QFilter("personindexid", "=", (Object)pid)});
            Set collect = Arrays.stream(allPerson).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            QFilter personFilter = new QFilter("person", "in", collect);
            list.remove(idFilter);
            list.add(personFilter);
        }
    }

    protected Map<String, Object> defineSpecial(DefineSpecialVo dsVo) {
        Map defineMap = super.defineSpecial(dsVo);
        defineMap.put("viewshowdialog", "1");
        return defineMap;
    }

    private void setTotalAndNew(List<String> fields, QFilter[] conFilter) {
        List list;
        String filterStr;
        List dataList = this.getDataList();
        String totalTimeStr = "0";
        String reordStr = "0";
        if (dataList != null && dataList.size() > 0) {
            totalTimeStr = dataList.size() + "";
            List collect = dataList.stream().filter(map -> (Boolean)map.get("islatestrecord")).collect(Collectors.toList());
            if (collect.size() > 0) {
                reordStr = collect.size() + "";
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"filterdatapanelap"});
            }
        }
        if (HRStringUtils.isNotEmpty((String)(filterStr = this.getView().getPageCache().get("recordfilter"))) && (list = this.queryAndAssDataFromDb(new QueryDbVo(conFilter, fields, "hrpi_empposorgrel", Boolean.FALSE))).size() > 0) {
            totalTimeStr = list.size() + "";
        }
        if (this.getControl("totaltime") instanceof Label) {
            Label label = (Label)this.getControl("totaltime");
            label.setText(totalTimeStr);
        } else {
            this.getModel().setValue("totaltime", (Object)totalTimeStr);
        }
        if (this.getControl("empposnewrecord") instanceof Label) {
            Label empposnewrecord = (Label)this.getControl("empposnewrecord");
            empposnewrecord.setText(reordStr);
        } else {
            this.getModel().setValue("empposnewrecord", (Object)reordStr);
        }
    }

    private List<String> assessAbleFields(Map<String, Object> tabMap, EventObject args, QueryDbVo queryDbVo) {
        CardViewCompareVo compareVo = new CardViewCompareVo(TIME_FIELDS, HEAD_FIELDS, TEXT_FIELDS, CONTENT_FIELDS, null);
        this.childPointModify(new CardBindDataDTO(this.getModel(), this.getView(), args, compareVo, this.getTimeMap(), queryDbVo));
        return this.setChildFieldVo(new FieldTransVo(tabMap, compareVo));
    }

    protected boolean createLabel(BeforeCreatVo beforeCreatVo) {
        boolean label = super.createLabel(beforeCreatVo);
        if (!label) {
            return label;
        }
        String labType = beforeCreatVo.getLabType();
        boolean flag = true;
        if ("text".equals(labType)) {
            flag = this.handlerSpecialWordShow(beforeCreatVo);
        }
        return flag;
    }

    private boolean handlerSpecialWordShow(BeforeCreatVo beforeCreatVo) {
        String field;
        Map dataMap = beforeCreatVo.getDataMap();
        Map relMap = beforeCreatVo.getRelMap();
        List<String> wordList = this.specialWord("0");
        if (!wordList.contains(field = (String)relMap.get("number"))) {
            return true;
        }
        Object recordObj = dataMap.get(field);
        if (recordObj == null) {
            return false;
        }
        return !"0".equals(recordObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean customChangeLabelValue(BeforeCreatVo beforeCreatVo) {
        super.customChangeLabelValue(beforeCreatVo);
        Map dataMap = beforeCreatVo.getDataMap();
        Map labMap = beforeCreatVo.getLabMap();
        Map relMap = beforeCreatVo.getRelMap();
        String labType = beforeCreatVo.getLabType();
        String field = (String)labMap.get("number");
        if ("text".equals(labType)) {
            List<String> wordList = this.specialWord("0");
            if (!wordList.contains(field)) {
                return false;
            }
            Object obj = dataMap.get(field);
            if (CommonUtil.objIsEmpty(obj)) {
                return false;
            }
            if (!(obj instanceof Boolean) || !"islatestrecord".equals(field)) return false;
            if (!((Boolean)obj).booleanValue()) return true;
            relMap.put(field, ResManager.loadKDString((String)"\u6700\u65b0\u8bb0\u5f55", (String)"EmpPosoRgRelCardPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        } else {
            if (!"content".equals(labType)) return false;
            Object obj = dataMap.get(field);
            if (CommonUtil.objIsEmpty(obj)) {
                return false;
            }
            if (!(obj instanceof Boolean) || !"isexistprobation".equals(field)) return false;
            return AttacheHandlerService.getInstance().transferBoolType(beforeCreatVo);
        }
    }

    protected void customChangeLabelStyle(AfterCreatVo afterCreatVo) {
        String labType = afterCreatVo.getLabType();
        Map filedMap = afterCreatVo.getFiledMap();
        String field = (String)filedMap.get("number");
        if ("text".equals(labType)) {
            List<String> wordList = this.specialWord("1");
            if (!wordList.contains(field)) {
                return;
            }
            afterCreatVo.setField(field);
            this.handlerSpecialWordStyle(afterCreatVo);
        } else if ("head".equals(labType) && ("stdposition".equals(field) || "position".equals(field))) {
            this.setTips(afterCreatVo, field);
        }
    }

    private void setTips(AfterCreatVo afterCreatVo, String position) {
        LabelAp fieldAp = afterCreatVo.getFieldAp();
        Map dataMap = afterCreatVo.getDataMap();
        Object postObj = dataMap.get(position);
        if (postObj instanceof DynamicObject) {
            DynamicObject postDy = (DynamicObject)postObj;
            Tips ctlTips = new Tips();
            ctlTips.setShowIcon(false);
            ctlTips.setContent(new LocaleString(postDy.getString("number")));
            ctlTips.setType("text");
            fieldAp.setCtlTips(ctlTips);
        }
    }

    private void handlerSpecialWordStyle(AfterCreatVo afterCreatVo) {
        Map dataMap = afterCreatVo.getDataMap();
        String field = afterCreatVo.getField();
        Style style = afterCreatVo.getStyle();
        LabelAp fieldAp = afterCreatVo.getFieldAp();
        Object data = dataMap.get(field);
        if (CommonUtil.objIsEmpty(data)) {
            return;
        }
        Map<Object, Object> posTypeColorMap = new HashMap(16);
        if ("postype".equals(field)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_postype");
            Long pkId = 0L;
            if (data instanceof DynamicObject) {
                pkId = ((DynamicObject)data).getLong("id");
            }
            if (pkId != 0L) {
                DynamicObject dynamicObject = serviceHelper.queryOne("postcategory.number", (Object)pkId);
                if (dynamicObject == null) {
                    return;
                }
                String pst = dynamicObject.getString("postcategory.number");
                posTypeColorMap = this.getPosTypeColorMap(pst);
            }
        } else if ("islatestrecord".equals(field)) {
            Boolean record = (Boolean)dataMap.get(field);
            posTypeColorMap = this.getRecordColorMap(record);
        }
        this.setLabelColorStyle(new TextColorVo(style, fieldAp, (String)posTypeColorMap.get("forColor"), (String)posTypeColorMap.get("backColor"), "100px"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        String entityId = this.getView().getEntityId();
        if (key.contains(entityId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getView().updateView();
        }
    }

    private List<String> specialWord(String type) {
        ArrayList<String> list = new ArrayList<String>();
        if ("1".equals(type)) {
            list.add("postype");
        }
        list.add("islatestrecord");
        return list;
    }

    private Map<String, String> getPosTypeColorMap(String posTypeId) {
        HashMap colorMap = new HashMap(16);
        HashMap<String, String> posTypeMap = new HashMap<String, String>(16);
        posTypeMap.put("forColor", "#1BA854");
        posTypeMap.put("backColor", "rgba(242,255,245,0.1)");
        colorMap.put("1010_S", posTypeMap);
        posTypeMap = new HashMap(16);
        posTypeMap.put("forColor", "#276FF5");
        posTypeMap.put("backColor", "rgba(133,184,255,0.1)");
        colorMap.put("1020_S", posTypeMap);
        posTypeMap = new HashMap(16);
        posTypeMap.put("forColor", "#ffb44a");
        posTypeMap.put("backColor", "rgba(255,180,74,0.1)");
        colorMap.put("1040_S", posTypeMap);
        Map rePosTypeMap = (Map)colorMap.get(posTypeId);
        if (rePosTypeMap == null) {
            return new HashMap<String, String>(16);
        }
        return rePosTypeMap;
    }

    private Map<String, String> getRecordColorMap(Boolean record) {
        HashMap recordMap = new HashMap(16);
        HashMap<String, String> posTypeMap = new HashMap<String, String>(16);
        posTypeMap.put("forColor", "#FB2323");
        posTypeMap.put("backColor", "rgba(255,242,244,0.1)");
        recordMap.put(Boolean.TRUE, posTypeMap);
        Map rePosTypeMap = (Map)recordMap.get(record);
        if (rePosTypeMap == null) {
            return new HashMap<String, String>(16);
        }
        return rePosTypeMap;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FieldEdit fieldEdit = (FieldEdit)this.getControl("empnewrecord");
        fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ec5\u663e\u793a\u6700\u65b0\u8bb0\u5f55", (String)"EmpPosoRgRelCardPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
    }

    protected String getOpenPageName() {
        return "hspm_revempposorgrel";
    }

    protected String getEntityName() {
        return "hrpi_empposorgrel";
    }
}

