/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.cardview;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.ext.file.CardBindDataDTO;
import kd.sdk.hr.hspm.common.vo.CardViewCompareVo;
import kd.sdk.hr.hspm.common.vo.DefineSpecialVo;
import kd.sdk.hr.hspm.common.vo.FieldTransVo;
import kd.sdk.hr.hspm.common.vo.PreBindDataVo;
import kd.sdk.hr.hspm.common.vo.QueryDbVo;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractCardDrawEdit;

public class LaborRelRecordCardPlugin
extends AbstractCardDrawEdit {
    private static final Log logger = LogFactory.getLog(LaborRelRecordCardPlugin.class);

    protected PreBindDataVo prefixHandlerBeforeBindData(EventObject args) {
        PreBindDataVo preBindDataVo = super.prefixHandlerBeforeBindData(args);
        Long employeeId = HRJSONUtils.getLongValOfCustomParam((Object)preBindDataVo.getFormShowParameter().getCustomParam("employee"));
        if (employeeId == null || employeeId == 0L) {
            return null;
        }
        CardViewCompareVo compareVo = new CardViewCompareVo();
        compareVo.setTimeFields("startdate,enddate");
        compareVo.setHeadFields("org");
        compareVo.setContentFields("businessstatus,lawentity,description");
        QFilter[] conFilter = new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("iscurrentversion", "=", (Object)"1")};
        List fields = this.setChildFieldVo(new FieldTransVo(preBindDataVo.getDataMap(), compareVo));
        if (!fields.contains("org")) {
            fields.add("org");
        }
        fields.add("id");
        QueryDbVo queryDbVo = new QueryDbVo(conFilter, fields, "hrpi_laborrelrecord", "startdate desc,enddate desc,createtime desc");
        this.childPointModify(new CardBindDataDTO(this.getModel(), this.getView(), args, compareVo, this.getTimeMap(), queryDbVo));
        List extFields = this.setChildFieldVo(new FieldTransVo(preBindDataVo.getDataMap(), compareVo));
        queryDbVo.setFields(extFields);
        List list = this.queryAndAssDataFromDb(queryDbVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, String> collect = list.stream().collect(Collectors.toMap(tmp -> String.valueOf(tmp.get("id")), tmp -> String.valueOf(tmp.get("org_id"))));
            this.getView().getPageCache().put("orgCache", SerializationUtils.toJsonString(collect));
        }
        this.defineSpecial(new DefineSpecialVo(true, "shamedit_", "shamview_contract_"));
        return preBindDataVo;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Label label = (Label)evt.getSource();
        String key = label.getKey();
        if (key.contains("shamview_contract_")) {
            this.showContractInfo(key);
        }
    }

    private void showContractInfo(String key) {
        try {
            Object[] contractDys;
            IPageCache pageCache = this.getView().getPageCache();
            String cacheOrg = pageCache.get("orgCache");
            Map orgMap = new HashMap(16);
            if (HRStringUtils.isNotEmpty((String)cacheOrg)) {
                orgMap = (Map)SerializationUtils.fromJsonString((String)cacheOrg, Map.class);
            }
            String pkStr = key.substring(key.lastIndexOf(95) + 1);
            String orgStr = (String)orgMap.get(pkStr);
            long orgId = 0L;
            if (HRStringUtils.isNotEmpty((String)orgStr)) {
                orgId = Long.parseLong(orgStr);
            }
            if (HRArrayUtils.isEmpty((Object[])(contractDys = this.queryContractFile(orgId)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\u3002", (String)"LaborRelRecordCardPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            long pkId = 0L;
            String showFormId = null;
            for (Object dy : contractDys) {
                String protocolType = dy.getString("protocoltype");
                if ("1".equals(protocolType)) {
                    showFormId = "hlcm_contract";
                    pkId = dy.getLong("id");
                    break;
                }
                if (!"2".equals(protocolType)) continue;
                showFormId = "hlcm_contractfileemp";
                pkId = dy.getLong("id");
                break;
            }
            if (HRStringUtils.isEmpty(showFormId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u5408\u540c\u534f\u8bae\u7c7b\u578b\u4e0d\u4e3a\u7528\u5de5\u534f\u8bae\u6216\u8005\u52b3\u52a8\u5408\u540c", (String)"LaborRelRecordCardPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter form = new BaseShowParameter();
            form.setSendToClient(false);
            form.setPkId((Object)pkId);
            form.setFormId(showFormId);
            form.setStatus(OperationStatus.VIEW);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setHasRight(true);
            this.getView().showForm((FormShowParameter)form);
        }
        catch (Exception esc) {
            logger.error("showContractInfoError", (Throwable)esc);
            this.getView().showErrorNotification("click error");
        }
    }

    private DynamicObject[] queryContractFile(long orgId) {
        QFilter orgFilter = new QFilter("ermanorg", "=", (Object)orgId);
        QFilter cFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter pFilter = new QFilter("protocoltype", "in", (Object)new String[]{"1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        logger.info("showContractInfoId-->{},{}", (Object)orgId, (Object)personId);
        return BusinessDataServiceHelper.load((String)"hlcm_contractfileemp", (String)"protocoltype,id", (QFilter[])new QFilter[]{personFilter, cFilter, orgFilter, pFilter, initStatusFilter}, (String)"startdate desc", (int)1);
    }

    protected Map<String, Object> defineSpecial(DefineSpecialVo defineSpecialVo) {
        Map timeMap = super.defineSpecial(defineSpecialVo);
        timeMap.put("viewmapcontract", "viewmapcontract");
        timeMap.put("viewshowdialog", "1");
        return timeMap;
    }
}

