/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class BasicInfoDrawPlugin
extends AbstractFormDrawEdit {
    private static final Log logger = LogFactory.getLog(BasicInfoDrawPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hspm_basicinfo");
        super.loadCustomControlMetas(args);
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        super.beforeBindData(eventObject);
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        this.setValueFromDb(formShowParameter, "hspm_basicinfo", "person");
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, true);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), (HRDataBaseEdit)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey()) || "edit_label".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btnsave".equals(source.getKey()) || "btnsave_label".equals(source.getKey())) {
            if (BusinessUtils.checkBirthday((IFormView)this.getView(), (boolean)false)) {
                return;
            }
            if (BusinessUtils.checkWorkage((String)String.join((CharSequence)"-", "hrpi_pernontsprop", "beginservicedate"), (IFormView)this.getView())) {
                return;
            }
            this.acrossEntitySaveOrUpdate();
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        } else if ("btncancel".equals(source.getKey()) || "btncancel_label".equals(source.getKey())) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String mainType = (String)formShowParameter.getCustomParam("type");
                this.clickCancelChanged(mainType);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public List<DrawFormFieldDto> formatFlexFields(Map<String, Object> group, Map<String, Object> tabList) {
        List list = super.formatFlexFields(group, tabList);
        Object type = this.getView().getFormShowParameter().getCustomParam("tabentry");
        for (int i = 0; i < list.size(); ++i) {
            if (!((DrawFormFieldDto)list.get(i)).getField().equals("headsculpture")) continue;
            list.add(0, list.remove(i));
        }
        if ("tabentry".equals(type)) {
            List<DrawFormFieldDto> dtoList = list.stream().filter(arg -> !arg.getField().equals("headsculpture")).collect(Collectors.toList());
            return dtoList;
        }
        return list;
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)key, (String)"hrpi_pernontsprop-birthday")) {
            BusinessUtils.checkBirthday((IFormView)this.getView(), (boolean)true);
        }
    }
}

