/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class ContactDrawPlugin
extends AbstractFormDrawEdit {
    private static Log logger = LogFactory.getLog(ContactDrawPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hrpi_percontact");
        super.loadCustomControlMetas(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        this.setValueFromDb(formShowParameter, "hrpi_percontact", "person");
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), (HRDataBaseEdit)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey()) || "edit_label".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btncancel".equals(source.getKey()) || "btncancel_label".equals(source.getKey())) {
            if (this.getModel().getDataChanged()) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                this.clickCancelChanged((String)formShowParameter.getCustomParam("type"));
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnsave".equals(source.getKey()) || "btnsave_label".equals(source.getKey())) {
            String peremail;
            String phone;
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"hrpi_percontact-phone") && !this.checkPhone(phone = dynamicObject.getString("hrpi_percontact-phone"))) {
                return;
            }
            if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"hrpi_percontact-peremail") && !this.checkPeremail(peremail = dynamicObject.getString("hrpi_percontact-peremail"))) {
                return;
            }
            this.acrossEntitySaveOrUpdate();
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, true);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeProperty = args.getProperty().getName();
        if ("hrpi_percontact-phone".equals(changeProperty)) {
            this.checkPhone((String)args.getChangeSet()[0].getNewValue());
        } else if ("hrpi_percontact-peremail".equals(changeProperty)) {
            this.checkPeremail((String)args.getChangeSet()[0].getNewValue());
        }
    }

    private boolean checkPhone(String phone) {
        if (HRStringUtils.isNotEmpty((String)phone)) {
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            Tuple checkResult = UniquenessCheckUtil.checkPhone((long)personId, (String)phone, (boolean)true);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return false;
            }
        }
        return true;
    }

    private boolean checkPeremail(String perEmail) {
        if (HRStringUtils.isNotEmpty((String)perEmail)) {
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            Tuple checkResult = UniquenessCheckUtil.checkPerEmail((long)personId, (String)perEmail, (boolean)true);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return false;
            }
        }
        return true;
    }
}

