/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class EduAttachPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(EduAttachPlugin.class);
    private static final String ATTACHMAP = "attachmap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl("btnok");
        btnok.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hasAttachEducerttype = (String)formShowParameter.getCustomParam("hasAttachEducerttype");
        HashSet<String> educerttypeIdSet = HRStringUtils.isEmpty((String)hasAttachEducerttype) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)hasAttachEducerttype, Set.class);
        this.setAttType(educerttypeIdSet);
        String allowAttachSize = (String)formShowParameter.getCustomParam("allowAttachSize");
        LOGGER.info("allowAttachSize: {}", (Object)allowAttachSize);
        if (!HRStringUtils.isEmpty((String)allowAttachSize)) {
            AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachmentfield");
            AttachmentProp attachmentProp = (AttachmentProp)attachmentEdit.getProperty();
            attachmentProp.setMaxAtmCount(Integer.parseInt(allowAttachSize));
            LOGGER.info("attachmentProp.getMaxAtmCount(): {}", (Object)attachmentProp.getMaxAtmCount());
        }
    }

    private void setAttType(Set<String> educerttypeIdSet) {
        DynamicObject[] allCerttype;
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        if (!CollectionUtils.isEmpty(educerttypeIdSet)) {
            qFilter.and("id", "not in", educerttypeIdSet.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        if ((allCerttype = BusinessDataServiceHelper.load((String)"hbss_educerttype", (String)"id", (QFilter[])qFilter.toArray(), (String)"id")) == null || allCerttype.length == 0) {
            return;
        }
        HashMap<String, String> certIdAndIndexMap = new HashMap<String, String>(16);
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", allCerttype.length);
        for (int i = 0; i < rowIndex.length; ++i) {
            this.getModel().setValue("atttype", (Object)allCerttype[i], rowIndex[i]);
            certIdAndIndexMap.put(String.valueOf(i + 1), String.valueOf(allCerttype[i].getLong("id")));
        }
        this.getPageCache().put("idandindexmapstr", SerializationUtils.toJsonString(certIdAndIndexMap));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (!HRStringUtils.equals((String)name, (String)"attachmentfield")) {
            return;
        }
        String attachMapStr = this.getPageCache().get(ATTACHMAP);
        Map attachMap = HRStringUtils.isNotEmpty((String)attachMapStr) ? (Map)SerializationUtils.fromJsonString((String)attachMapStr, Map.class) : new HashMap(16);
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        DynamicObjectCollection attachDys = (DynamicObjectCollection)newValue;
        int rowIndex = changeData.getRowIndex();
        int index = rowIndex + 1;
        String key = String.valueOf(index);
        if (attachDys.size() > 0) {
            List attachMapList = attachDys.stream().map(attachDy -> attachDy.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            attachMap.put(key, attachMapList);
        } else {
            attachMap.put(key, new ArrayList());
        }
        if (((MulBasedataDynamicObjectCollection)newValue).size() > 0) {
            this.ifAttachChanged(changeData);
        } else {
            this.getModel().setValue("uploader", (Object)"", rowIndex);
            this.getModel().setValue("uploadtime", (Object)"", rowIndex);
            this.getView().getPageCache().put("attaChanged-" + rowIndex, "1");
        }
        this.getPageCache().put(ATTACHMAP, SerializationUtils.toJsonString(attachMap));
    }

    private void ifAttachChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection entryentityNow = this.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)entryentityNow.get(rowIndex);
        row.set("uploader", UserServiceHelper.getUserInfoByID((long)RequestContext.get().getCurrUserId()).get("name"));
        row.set("uploadtime", (Object)new Date());
        this.getView().getPageCache().put("attaChanged-" + rowIndex, "1");
        this.getView().updateView("entryentity");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.getView().getPageCache().put("ok", "1");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String ok = this.getView().getPageCache().get("ok");
        if (HRStringUtils.isNotEmpty((String)ok)) {
            String attachMapStr = this.getPageCache().get(ATTACHMAP);
            this.getView().getParentView().getPageCache().put(ATTACHMAP, HRStringUtils.isNotEmpty((String)attachMapStr) ? attachMapStr : SerializationUtils.toJsonString(new HashMap(16)));
            this.getView().getParentView().getPageCache().put("idandindexmapstr", this.getPageCache().get("idandindexmapstr"));
        } else {
            this.getView().getParentView().getPageCache().put(ATTACHMAP, SerializationUtils.toJsonString(new HashMap(16)));
        }
    }
}

