/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.infogroup.InfoGroupFieldHelper;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class EmpJobRelEditPlugin
extends AbstractFormDrawEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(EmpJobRelEditPlugin.class);
    private static final Set<String> FILTER_FIELD_OF_HRPI_EMPEJOBREL = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"hrbu", "joblevel", "jobgrade", "job", "variationtype", "company", "adminorg", "position", "employee", "businessstatus", "jobscm", "jobclass", "jobfamily", "jobseq", "joblevelscm", "jobgradescm"}));
    private static final String separator = ",";
    private static final HRBaseServiceHelper EMPEJOBREL_HELPER = new HRBaseServiceHelper("hrpi_empjobrel");
    private static final HRBaseServiceHelper EMPPOSORGREL_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParameter;
        super.beforeBindData(eventObject);
        this.getActionPersonalChangeAndCached();
        DateEdit endDate = (DateEdit)this.getControl("enddate");
        if (endDate != null) {
            endDate.setMaxDate(HspmDateUtils.getMaxEndDate());
        }
        if (OperationStatus.EDIT.equals((Object)(formShowParameter = this.getView().getFormShowParameter()).getStatus()) || OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
            this.setValueFromDb(formShowParameter, "hrpi_empjobrel", null);
            this.setAttachment(this.getPageMappingFormId(), this.getAttachmentKey());
            this.setJobClassLongName();
        } else {
            List fields;
            this.setRedundancyField();
            List groups = ParamAnalysisUtil.getGroups((Map)ParamAnalysisUtil.getParams((FormShowParameter)this.getView().getFormShowParameter()));
            if (!CollectionUtils.isEmpty((Collection)groups) && !CollectionUtils.isEmpty((Collection)(fields = ParamAnalysisUtil.getFields((Map)((Map)groups.get(0)))))) {
                Optional<Map> startDateOpt;
                Map field;
                DynamicObject recentlyDy = this.findRecentlyEffective();
                if (!HRObjectUtils.isEmpty((Object)recentlyDy)) {
                    this.copyRecentDyInfo(recentlyDy);
                }
                this.jobRelationInfo();
                this.changeEditStatus("job");
                this.setEditWhenJoblevelscmAndJobgradescm();
                Optional<Map> opt = fields.stream().filter(val -> "enddate".equals(val.get("number"))).findFirst();
                if (opt.isPresent() && Boolean.FALSE.equals((field = opt.get()).get("isedit"))) {
                    ArrayList<String> cacheFieldList = new ArrayList<String>(2);
                    cacheFieldList.add("enddate");
                    this.getPageCache().put("fieldlist", SerializationUtils.toJsonString(cacheFieldList));
                    this.getPageCache().put("enddate", "0_" + HRDateTimeUtils.format((Date)HspmDateUtils.getMaxEndDate()));
                }
                if ((startDateOpt = fields.stream().filter(val -> "startdate".equals(val.get("number"))).findFirst()).isPresent()) {
                    Date recentlyEndDate;
                    if (recentlyDy != null && (recentlyEndDate = recentlyDy.getDate("enddate")) != null && recentlyEndDate.before(HspmDateUtils.getMaxEndDate())) {
                        this.setValueIfExist("startdate", HspmDateUtils.addDay((Date)recentlyEndDate, (long)1L));
                    }
                    if (this.getValueIfExist("startdate") == null) {
                        this.setValueIfExist("startdate", HspmDateUtils.getMidnight((Date)new Date()));
                    }
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void setJobClassLongName() {
        DynamicObject dy = this.getModel().getDataEntity();
        if (!this.isFieldExist("job")) {
            return;
        }
        DynamicObject jobDy = dy.getDynamicObject("job");
        if (!HRObjectUtils.isEmpty((Object)jobDy)) {
            long jobId = jobDy.getLong("id");
            ArrayList<Long> jobIds = new ArrayList<Long>();
            jobIds.add(jobId);
            Map<Long, String> invokeSelectJobClassResultMap = this.invokeSelectJobClass(jobIds, jobDy.getDate("bsed"));
            this.setValueIfExist("jobclasslongname", CollectionUtils.isEmpty(invokeSelectJobClassResultMap) ? null : invokeSelectJobClassResultMap.get(jobId));
        }
    }

    private void getActionPersonalChangeAndCached() {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        Long empJobRelActionId = BusinessUtils.queryEmpJobRelActionId();
        params.put("chgActionId", empJobRelActionId);
        Map resultMap = null;
        try {
            resultMap = AttacheHandlerService.getInstance().getActionPersonalChange(params);
            if (((Boolean)resultMap.get("success")).booleanValue()) {
                this.getPageCache().put("hspm_empjobrel_dg", SerializationUtils.toJsonString(resultMap.get("data")));
            } else {
                this.getView().showErrorNotification((String)resultMap.get("errorMsg"));
            }
            LOGGER.info("getActionPersonalChangeAndCached#chgActionId={},resultMap={}", (Object)SerializationUtils.toJsonString(params), (Object)resultMap);
        }
        catch (Exception exception) {
            LOGGER.error("getActionPersonalChangeAndCached is exception:", (Throwable)exception);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u64cd\u4f5c\u578b\u4e8b\u52a1\u67e5\u8be2\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EmpJobRelEditPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
    }

    private void copyRecentDyInfo(DynamicObject recentlyDy) {
        DynamicObject jobDy = recentlyDy.getDynamicObject("job");
        if (!HRObjectUtils.isEmpty((Object)jobDy)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"hrbu")) {
                this.setValueIfExist("hrbu", jobDy.getDynamicObject("createorg"));
            }
            if (PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"job")) {
                this.setValueIfExist("job", jobDy);
            }
        }
    }

    private void setEditWhenJoblevelscmAndJobgradescm() {
        boolean isEditable;
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"joblevelscm")) {
            DynamicObject joblevelscm = dynamicObject.getDynamicObject("joblevelscm");
            isEditable = !HRObjectUtils.isEmpty((Object)joblevelscm);
            this.getView().setEnable(Boolean.valueOf(isEditable), new String[]{"joblevel"});
        }
        if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"jobgradescm")) {
            DynamicObject jobgradescm = dynamicObject.getDynamicObject("jobgradescm");
            isEditable = !HRObjectUtils.isEmpty((Object)jobgradescm);
            this.getView().setEnable(Boolean.valueOf(isEditable), new String[]{"jobgrade"});
        }
    }

    private void changeEditStatus(String ... fields) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"hrbu")) {
            DynamicObject hrBuDy = dynamicObject.getDynamicObject("hrbu");
            boolean isEditable = !HRObjectUtils.isEmpty((Object)hrBuDy);
            this.getView().setEnable(Boolean.valueOf(isEditable), fields);
        }
    }

    private void setRedundancyField() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (!PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"company") && !PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"adminorg")) {
            return;
        }
        DynamicObject primaryEmpposorgrel = this.findPrimaryEmpposorgrel();
        if (primaryEmpposorgrel != null) {
            if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"company")) {
                this.setValueIfExist("company", primaryEmpposorgrel.get("company"));
            }
            if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"adminorg")) {
                this.setValueIfExist("adminorg", primaryEmpposorgrel.get("adminorg"));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String jobName;
        super.beforeClick(evt);
        if (this.isFieldExist("jobclasslongname") && HRStringUtils.isNotEmpty((String)(jobName = (String)this.getModel().getValue("jobclasslongname"))) && jobName.length() > 2000) {
            this.getModel().setValue("jobclasslongname", null);
        }
        this.validateFieldMust(evt);
    }

    private void validateFieldMust(BeforeClickEvent evt) {
        DynamicObject dataEntity;
        StringBuilder err = new StringBuilder();
        int count = 0;
        Map fields = MetadataServiceHelper.getDataEntityType((String)"hrpi_empjobrel").getAllFields();
        for (Map.Entry field : fields.entrySet()) {
            boolean isMust;
            String key = (String)field.getKey();
            IDataEntityProperty value = (IDataEntityProperty)field.getValue();
            if ("bsed".equals(key) || "enddate".equals(key) || !(isMust = InfoGroupFieldHelper.getMustInput((IDataEntityProperty)value))) continue;
            LocaleString displayName = value.getDisplayName();
            String localeValue = displayName.getLocaleValue();
            boolean existField = this.getModel().getDataEntity().containsProperty(key);
            if (!existField) {
                err.append(localeValue);
                if (++count <= 1) continue;
                err.append("\u3001");
                continue;
            }
            Object value1 = this.getModel().getValue(key);
            if (!Objects.isNull(value1)) continue;
            err.append(localeValue);
            if (++count <= 1) continue;
            err.append("\u3001");
        }
        if (HRStringUtils.isNotEmpty((String)err.toString())) {
            err.append(ResManager.loadKDString((String)"\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u9700\u8981\u6dfb\u52a0\u5230\u9875\u9762\u4e14\u503c\u4e0d\u53ef\u4e3a\u7a7a", (String)"EmpJobRelEditPlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            this.getView().showTipNotification(err.toString());
        }
        if (!PropertyHelper.existProperty((DynamicObject)(dataEntity = this.getModel().getDataEntity()), (String)"joblevel") && !PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"jobgrade")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u7ea7\u548c\u804c\u7b49\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u4e2a\u5b57\u6bb5\u5230\u9875\u9762\uff0c\u804c\u7ea7\u548c\u804c\u7b49\u81f3\u5c11\u586b\u4e00\u4e2a", (String)"EmpJobRelEditPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            Map result;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String status = (String)formShowParameter.getCustomParam("cus_status");
            if (!this.checkDate() || !this.checkJoblevelAndJobgrade()) {
                return;
            }
            if ("cus_addnew".equals(status)) {
                DynamicObject recentlyEffectiveDy;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                if ("button_adjust".equals(formShowParameter.getCustomParam("opKey")) && !HRObjectUtils.isEmpty((Object)(recentlyEffectiveDy = this.findRecentlyEffective()))) {
                    Map<String, Object> objectMap = this.adjust(recentlyEffectiveDy, dataEntity);
                    this.saveAttachment(objectMap);
                } else {
                    Map result2 = this.addAttachData("hrpi_empjobrel", this.getView(), dataEntity, true);
                    this.saveAttachment(result2);
                }
            } else if ("cus_edit".equals(status) && ((Boolean)(result = this.updateAttachData("hrpi_empjobrel", this.getView(), true, null)).get("success")).booleanValue()) {
                Object pkId = this.getView().getFormShowParameter().getCustomParam("pkid");
                this.successAfterSave(pkId, result, this.getAttachmentKey(), this.getPageMappingFormId());
            }
        }
    }

    private void saveAttachment(Map<String, Object> objectMap) {
        if (objectMap == null) {
            LOGGER.info("objectMap isnull");
            return;
        }
        if (!((Boolean)objectMap.get("success")).booleanValue()) {
            LOGGER.info("objectMap isfail");
            return;
        }
        PerChgBizResult perChgBizResultData = (PerChgBizResult)objectMap.get("data");
        if (perChgBizResultData == null) {
            LOGGER.info("perChgBizResultData isnull");
            return;
        }
        Long recordId = perChgBizResultData.getRecordId();
        if (recordId == null || recordId == 0L) {
            LOGGER.info("recordId isnull");
            return;
        }
        Map result = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
        if (!((Boolean)result.get("success")).booleanValue()) {
            LOGGER.info("getChgInfoDetailByRecordId isfail");
            return;
        }
        HashMap data = (HashMap)result.get("data");
        if (data == null) {
            LOGGER.info("getChgInfoDetailByRecordId data is null");
            return;
        }
        ArrayList arrayList = (ArrayList)data.get("data");
        if (arrayList == null || arrayList.size() == 0) {
            LOGGER.info("getChgInfoDetailByRecordId arrayList is null");
            return;
        }
        Set newIds = arrayList.stream().filter(arg -> arg.get("entity").equals("hrpi_empjobrel") && arg.get("chgmode").equals("0")).map(arg -> (Long)arg.get("idafter")).collect(Collectors.toSet());
        if (newIds == null || newIds.size() == 0) {
            LOGGER.info("newIds is null");
            return;
        }
        this.saveAttachments(this.getPageMappingFormId(), (Long)newIds.toArray()[0], this.getAttachmentKey());
    }

    private boolean checkJoblevelAndJobgrade() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"joblevel") || PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"jobgrade")) {
            if (!PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"joblevel")) {
                if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("jobgrade"))) {
                    this.setOrClearMaxDate("0");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7b49\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpJobRelEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else if (!PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"jobgrade")) {
                if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("joblevel"))) {
                    this.setOrClearMaxDate("0");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpJobRelEditPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                if ((PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"joblevelscm") || PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"jobgradescm")) && this.getValueIfExist("joblevelscm") == null && this.getValueIfExist("jobgradescm") == null) {
                    this.setOrClearMaxDate("0");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u804c\u7ea7\u65b9\u6848\u6216\u804c\u7b49\u65b9\u6848\u3002", (String)"EmpJobRelEditPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("jobgrade")) && HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("joblevel"))) {
                    this.setOrClearMaxDate("0");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u7ea7\u548c\u804c\u7b49\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"EmpJobRelEditPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    protected void operateBeforeUpdateAttachData(Map<String, DynamicObjectCollection> attachMap) {
        super.operateBeforeUpdateAttachData(attachMap);
        DynamicObjectCollection dynamicObjects = attachMap.get("hrpi_empjobrel");
        Date startDate = HspmDateUtils.getMidnight((Date)((DynamicObject)dynamicObjects.get(0)).getDate("startdate"));
        String startDateStr = this.getView().getPageCache().get("startdate");
        if (HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd").equals(startDateStr)) {
            return;
        }
        QFilter qFilter = new QFilter("employee", "=", (Object)this.getEmployee()).and("iscurrentversion", "=", (Object)Boolean.TRUE).and("businessstatus", "=", (Object)"2");
        DynamicObject[] dyArray = EMPEJOBREL_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (dyArray != null && dyArray.length > 0) {
            DynamicObject recentDy = dyArray[0];
            for (int index = 1; index < dyArray.length; ++index) {
                Date date = recentDy.getDate("enddate");
                Date date2 = dyArray[index].getDate("enddate");
                if (date == null || date2 == null || !date.before(date2)) continue;
                recentDy = dyArray[index];
            }
            DynamicObject updateDy = EMPEJOBREL_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)recentDy, (DynamicObject)updateDy);
            Date newEndDate = HRDateTimeUtils.addDay((Date)startDate, (long)-1L);
            updateDy.set("enddate", (Object)newEndDate);
            dynamicObjects.add((Object)updateDy);
        }
    }

    protected void operateBeforeAddAttachData(Map<String, DynamicObjectCollection> attachMap) {
        super.operateBeforeAddAttachData(attachMap);
        DynamicObjectCollection dynamicObjects = attachMap.get("hrpi_empjobrel");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects.forEach(val -> {
                val.set("businessstatus", (Object)"1");
                val.set("variationtype", (Object)HspmCommonConstants.VARIATION_TYPE_101240);
                if (val.getDate("enddate") == null) {
                    val.set("enddate", (Object)HspmDateUtils.getMaxEndDate());
                }
                val.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
            });
        }
    }

    private Map<String, Object> adjust(DynamicObject recentlyEffectiveDy, DynamicObject newDy) {
        Date startDate = null;
        if (PropertyHelper.existProperty((DynamicObject)newDy, (String)"startdate")) {
            startDate = newDy.getDate("startdate");
        }
        if (startDate == null) {
            startDate = new Date();
        }
        startDate = HspmDateUtils.getMidnight((Date)startDate);
        Date startDate2 = recentlyEffectiveDy.getDate("startdate");
        if (startDate2 != null && HspmDateUtils.getMidnight((Date)startDate2).compareTo(startDate) >= 0) {
            this.setOrClearMaxDate("0");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u804c\u4f4d\u901a\u9053\u4e0b\uff0c\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u6bb5\u804c\u7ea7\u804c\u7b49\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpJobRelEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        Map attachMap = this.buildAddSingleAttachData("hrpi_empjobrel", this.getView(), newDy, dynamicObjects, null);
        DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
        dynamicObject.set("businessstatus", (Object)"1");
        dynamicObject.set("variationtype", (Object)HspmCommonConstants.VARIATION_TYPE_101240);
        dynamicObject.set("startdate", (Object)startDate);
        if (dynamicObject.getDate("enddate") == null) {
            dynamicObject.set("enddate", (Object)HspmDateUtils.getMaxEndDate());
        }
        dynamicObject.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
        DynamicObject updateDy = EMPEJOBREL_HELPER.generateEmptyDynamicObject();
        recentlyEffectiveDy = EMPEJOBREL_HELPER.loadSingle(recentlyEffectiveDy.getPkValue());
        HRDynamicObjectUtils.copy((DynamicObject)recentlyEffectiveDy, (DynamicObject)updateDy);
        updateDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)startDate, (long)-1L));
        updateDy.set("businessstatus", (Object)"2");
        dynamicObjects.add((Object)updateDy);
        return AttacheHandlerService.getInstance().invokeSaveOrUpdate(this.getView(), attachMap, true, "hrpi_empjobrel", "-1");
    }

    private DynamicObject findRecentlyEffective() {
        QFilter employeQFilter = new QFilter("employee", "=", (Object)this.getEmployee()).and("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        return EMPEJOBREL_HELPER.loadDynamicObject(new QFilter[]{employeQFilter, statusFilter});
    }

    private DynamicObject findPrimaryEmpposorgrel() {
        QFilter employeQFilter = new QFilter("employee", "=", (Object)this.getEmployee()).and("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter primaryFilter = new QFilter("isprimary", "=", (Object)"1");
        return EMPPOSORGREL_HELPER.loadDynamicObject(new QFilter[]{employeQFilter, primaryFilter});
    }

    private Long getEmployee() {
        Long employee = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("employee"));
        if (employee == null || employee == 0L) {
            LOGGER.error("employee is null");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"EmpJobRelEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return employee;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && "startdate".equals(key)) {
            Date oldValue = (Date)args.getChangeSet()[0].getOldValue();
            IPageCache pageCache = this.getView().getPageCache();
            if (oldValue == null) {
                pageCache.put("startdate", " ");
            } else if (pageCache.get("startdate") == null) {
                pageCache.put("startdate", HRDateTimeUtils.format((Date)oldValue, (String)"yyyy-MM-dd"));
            }
        }
        if ("startdate".equals(key) || "enddate".equals(key)) {
            this.checkDate();
        } else if ("job".equals(key)) {
            this.jobRelationInfo();
        } else if ("hrbu".equals(key)) {
            this.setValueIfExist("job", null);
            this.setValueIfExist("joblevelscm", null);
            this.setValueIfExist("jobgradescm", null);
            this.changeEditStatus("job", "joblevelscm", "jobgradescm");
        } else if ("joblevelscm".equals(key) || "jobgradescm".equals(key)) {
            this.setEditWhenJoblevelscmAndJobgradescm();
            if ("joblevelscm".equals(key)) {
                this.setValueIfExist("joblevel", null);
            }
            if ("jobgradescm".equals(key)) {
                this.setValueIfExist("jobgrade", null);
            }
        }
    }

    private void jobRelationInfo() {
        DynamicObject dy = this.getModel().getDataEntity();
        if (!this.isFieldExist("job")) {
            return;
        }
        DynamicObject jobDy = dy.getDynamicObject("job");
        if (HRObjectUtils.isEmpty((Object)jobDy)) {
            this.setValueIfExist("jobgradescm", null);
            this.setValueIfExist("joblevelscm", null);
            this.changeEditStatus("jobgradescm", "joblevelscm");
            this.setValueIfExist("jobscm", null);
            this.setValueIfExist("jobseq", null);
            this.setValueIfExist("jobfamily", null);
            this.setValueIfExist("jobclass", null);
        } else {
            long jobId = jobDy.getLong("id");
            Map<String, Object> invokeResult = this.invokeSelectJobHisinfo(Collections.singletonList(jobId));
            if (!CollectionUtils.isEmpty(invokeResult) && invokeResult.get("code") instanceof Integer && invokeResult.get("code").equals(200) && !CollectionUtils.isEmpty((Collection)((Collection)invokeResult.get("data")))) {
                List data = (List)invokeResult.get("data");
                Map jobInfo = (Map)data.get(0);
                long jobGradeScmId = (Long)jobInfo.get("jobgradescmid");
                long jobLevelScmId = (Long)jobInfo.get("joblevelscmid");
                if (jobGradeScmId > 0L) {
                    this.setValueIfExist("jobgradescm", jobGradeScmId);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"jobgradescm"});
                } else {
                    this.setValueIfExist("jobgradescm", null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"jobgradescm"});
                }
                if (jobLevelScmId > 0L) {
                    this.setValueIfExist("joblevelscm", jobLevelScmId);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"joblevelscm"});
                } else {
                    this.setValueIfExist("joblevelscm", null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"joblevelscm"});
                }
            } else {
                this.setValueIfExist("jobgradescm", null);
                this.setValueIfExist("joblevelscm", null);
            }
            this.setValueIfExist("jobscm", jobDy.getDynamicObject("jobscm"));
            this.setValueIfExist("jobseq", jobDy.getDynamicObject("jobseq"));
            this.setValueIfExist("jobfamily", jobDy.getDynamicObject("jobfamily"));
            this.setValueIfExist("jobclass", jobDy.getDynamicObject("jobclass"));
            this.setValueIfExist("joblevel", null);
            this.setValueIfExist("jobgrade", null);
            ArrayList<Long> jobIds = new ArrayList<Long>();
            jobIds.add(jobId);
            Map<Long, String> invokeSelectJobClassResultMap = this.invokeSelectJobClass(jobIds, jobDy.getDate("bsed"));
            this.setValueIfExist("jobclasslongname", CollectionUtils.isEmpty(invokeSelectJobClassResultMap) ? null : invokeSelectJobClassResultMap.get(jobId));
        }
    }

    private boolean checkDate() {
        DynamicObject dy = this.getModel().getDataEntity();
        if (!PropertyHelper.existProperty((DynamicObject)dy, (String)"startdate") || !PropertyHelper.existProperty((DynamicObject)dy, (String)"enddate")) {
            return true;
        }
        Date startDate = dy.getDate("startdate");
        Date endDate = dy.getDate("enddate");
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            this.setOrClearMaxDate("0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"EmpJobRelEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (startDate != null && startDate.after(new Date())) {
            this.setOrClearMaxDate("0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"EmpJobRelEditPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public Map<String, Object> invokeSelectJobHisinfo(List<Long> jobIds) {
        Map invokeResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMHisVerService", (String)"selectJobHisinfo", (Object[])new Object[]{jobIds, new Date()});
        return invokeResult;
    }

    private Map<Long, String> invokeSelectJobClass(List<Long> boids, Date bsed) {
        Map invokeResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMJobClassService", (String)"getJobClassLongNameByJobAndBsed", (Object[])new Object[]{boids, bsed});
        return invokeResult;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List data;
        String errMsg;
        Integer code;
        Map result;
        List<Long> boids;
        DynamicObject job;
        DynamicObject hrBuDy;
        super.beforeF7Select(beforeF7SelectEvent);
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        IFormView view = this.getView();
        QFilter qFilter = null;
        if (("job".equals(key) || "joblevelscm".equals(key) || "jobgradescm".equals(key)) && (hrBuDy = (DynamicObject)this.getValueIfExist("hrbu")) != null) {
            qFilter = new QFilter("createorg", "=", (Object)hrBuDy.getLong("id"));
        }
        if ("joblevel".equals(key)) {
            job = (DynamicObject)this.getValueIfExist("job");
            ArrayList<Long> jobLevelIdList = new ArrayList<Long>();
            if (job != null) {
                boids = Collections.singletonList(job.getLong("id"));
                result = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobLevelRangeByJobId", (Object[])new Object[]{boids, new Date()});
                code = (Integer)result.get("code");
                errMsg = (String)result.get("ErrMsg");
                if (code != 200) {
                    LOGGER.error(String.format("EmpJobRelEditPlugin#beforeF7Select IHBJMJobLevelGradeService.getJobLevelRangeByJobId error!, msg: %s", errMsg));
                } else {
                    data = (List)result.get("data");
                    for (Map dataMap : data) {
                        List jobLevelRange = (List)dataMap.get("jobLevelRange");
                        for (Map jobLevelRangeMap : jobLevelRange) {
                            Long jobLevelId = (Long)jobLevelRangeMap.get("jobLevelId");
                            jobLevelIdList.add(jobLevelId);
                        }
                    }
                }
            }
            LOGGER.info("EmpJobRelEditPlugin#beforeF7Select IHBJMJobLevelGradeService.getJobLevelRangeByJobId jobLevelIdList: {}", jobLevelIdList);
            if (!jobLevelIdList.isEmpty()) {
                qFilter = new QFilter("id", "in", jobLevelIdList);
            } else {
                DynamicObject joblevelscm = (DynamicObject)this.getValueIfExist("joblevelscm");
                if (joblevelscm != null) {
                    qFilter = new QFilter("joblevelscm", "=", (Object)joblevelscm.getLong("id"));
                }
            }
        }
        if ("jobgrade".equals(key)) {
            job = (DynamicObject)this.getValueIfExist("job");
            ArrayList<Long> jobGradeIdList = new ArrayList<Long>();
            if (job != null) {
                boids = Collections.singletonList(job.getLong("id"));
                result = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobGradeRangeByJobId", (Object[])new Object[]{boids, new Date()});
                code = (Integer)result.get("code");
                errMsg = (String)result.get("ErrMsg");
                if (code != 200) {
                    LOGGER.error(String.format("EmpJobRelEditPlugin#beforeF7Select IHBJMJobLevelGradeService.getJobGradeRangeByJobId error!, msg: %s", errMsg));
                } else {
                    data = (List)result.get("data");
                    for (Map dataMap : data) {
                        List jobGradeRange = (List)dataMap.get("jobGradeRange");
                        for (Map jobGradeRangeMap : jobGradeRange) {
                            Long jobGradeId = (Long)jobGradeRangeMap.get("jobGradeId");
                            jobGradeIdList.add(jobGradeId);
                        }
                    }
                }
            }
            LOGGER.info("EmpJobRelEditPlugin#beforeF7Select IHBJMJobLevelGradeService.getJobGradeRangeByJobId jobGradeIdList: {}", jobGradeIdList);
            if (!jobGradeIdList.isEmpty()) {
                qFilter = new QFilter("id", "in", jobGradeIdList);
            } else {
                DynamicObject jobgradescm = (DynamicObject)this.getValueIfExist("jobgradescm");
                if (jobgradescm != null) {
                    qFilter = new QFilter("jobgradescm", "=", (Object)jobgradescm.getLong("id"));
                }
            }
        }
        if ("hrbu".equals(key)) {
            MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            properties.forEach(entityProperty -> {
                if (!(entityProperty instanceof OrgProp)) {
                    return;
                }
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("orgFuncId", (Object)"21");
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("orgViewSchemeNumber", (Object)"21");
            });
        }
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilterList = listShowParameter.getListFilterParameter().getQFilters();
        Map<String, QFilter> qFilterMap = this.addActionChangeQFilter(key);
        if (qFilterMap != null) {
            QFilter valueRangeTagFilter;
            QFilter valueFixedFilter = qFilterMap.get("valuefixed");
            if (valueFixedFilter != null) {
                qFilterList.add(valueFixedFilter);
                beforeF7SelectEvent.setCancel(true);
                view.setEnable(Boolean.FALSE, new String[]{key});
                return;
            }
            QFilter valueRangeFilter = qFilterMap.get("valrange");
            if (valueRangeFilter != null) {
                qFilterList.add(valueRangeFilter);
            }
            if ((valueRangeTagFilter = qFilterMap.get("valrange_tag")) != null) {
                qFilterList.add(valueRangeTagFilter);
            }
            if (qFilterMap.containsKey("chgtype")) {
                QFilter valueChgTypeFilter = qFilterMap.get("chgtype");
                if (valueChgTypeFilter == null) {
                    this.setModelEmptyVal(key);
                    beforeF7SelectEvent.setCancel(true);
                    view.setEnable(Boolean.FALSE, new String[]{key});
                    return;
                }
                qFilterList.add(valueChgTypeFilter);
                beforeF7SelectEvent.setCancel(true);
                view.setEnable(Boolean.FALSE, new String[]{key});
                return;
            }
        }
        if (qFilter != null) {
            qFilterList.add(qFilter);
        }
    }

    private Map<String, QFilter> addActionChangeQFilter(String key) {
        Map resultMap;
        HashMap<String, QFilter> qFilterMap = new HashMap<String, QFilter>(16);
        String dataString = this.getPageCache().get("hspm_empjobrel_dg");
        LOGGER.info("traceId={},addActionChangeQFilter#dataString={}", (Object)RequestContext.get().getTraceId(), (Object)dataString);
        if (HRStringUtils.isEmpty((String)dataString)) {
            return null;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)dataString, Map.class);
        Map empJobRelMap = (Map)data.get("hrpi_empjobrel");
        LOGGER.info("traceId={},addActionChangeQFilter#empJobRelMap={}", (Object)RequestContext.get().getTraceId(), (Object)empJobRelMap);
        if (!CollectionUtils.isEmpty((Map)empJobRelMap) && FILTER_FIELD_OF_HRPI_EMPEJOBREL.contains(key) && !CollectionUtils.isEmpty((Map)(resultMap = (Map)empJobRelMap.get(key)))) {
            String limitType = (String)resultMap.get("limittype");
            LOGGER.info("addActionChangeQFilter#limitType={}", (Object)limitType);
            switch (limitType) {
                case "0": {
                    return this.getValueRangeOfField(resultMap, qFilterMap, key);
                }
                case "1": {
                    return this.getValueByChgType(resultMap, qFilterMap, key);
                }
            }
        }
        return null;
    }

    private Map<String, QFilter> getValueByChgType(Map<String, Object> resultMap, Map<String, QFilter> qFilterMap, String key) {
        String chgType = (String)resultMap.get("chgtype");
        if (HRStringUtils.isNotEmpty((String)chgType)) {
            switch (chgType) {
                case "0": 
                case "2": {
                    DynamicObject dynamicObject;
                    DynamicObject recentlyEffective = this.findRecentlyEffective();
                    LOGGER.info("getValueByChgType#recentlyEffective={}", (Object)recentlyEffective);
                    if (recentlyEffective == null || (dynamicObject = recentlyEffective.getDynamicObject(key)) == null) break;
                    qFilterMap.put("chgtype", new QFilter("id", "=", dynamicObject.getPkValue()));
                    break;
                }
                case "1": {
                    qFilterMap.put("chgtype", null);
                    break;
                }
            }
        }
        return qFilterMap;
    }

    private Map<String, QFilter> getValueRangeOfField(Map<String, Object> resultMap, Map<String, QFilter> qFilterMap, String key) {
        String valRangeTag;
        String valueRange;
        String valueFixed = (String)resultMap.get("valuefixed");
        if (HRStringUtils.isNotEmpty((String)valueFixed)) {
            qFilterMap.put("valuefixed", new QFilter("id", "=", (Object)Long.parseLong(valueFixed)));
        }
        if (HRStringUtils.isNotEmpty((String)(valueRange = (String)resultMap.get("valrange")))) {
            List valueRangeList = CollectionUtils.arrayToList((Object)Arrays.stream(HRStringUtils.split((String)valueRange, (String)separator)).mapToLong(Long::parseLong).toArray());
            LOGGER.info("getValueRangeOfField#VALUE_RANGE#key={},valueRangeList={}", (Object)key, (Object)valueRangeList);
            qFilterMap.put("valrange", new QFilter("id", "in", (Object)valueRangeList));
        }
        if (HRStringUtils.isNotEmpty((String)(valRangeTag = (String)resultMap.get("valrange_tag")))) {
            LOGGER.info("getValueRangeOfField#VALUE_RANGE_TAG#key={},valRangeTag={}", (Object)key, (Object)QFilter.fromSerializedString((String)valRangeTag));
            qFilterMap.put("valrange_tag", QFilter.fromSerializedString((String)valRangeTag));
        }
        return qFilterMap;
    }

    protected void adjustTabList(Map<String, Object> tabList) {
        List fields;
        List groups;
        super.adjustTabList(tabList);
        if (!CollectionUtils.isEmpty(tabList) && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && !CollectionUtils.isEmpty((Collection)(groups = ParamAnalysisUtil.getGroups(tabList))) && !CollectionUtils.isEmpty((Collection)(fields = ParamAnalysisUtil.getFields((Map)((Map)groups.get(0)))))) {
            for (Map field : fields) {
                if ("description".equals(field.get("number")) || FieldTypeEnum.ATTACHMENT.getType().equals(field.get("type"))) continue;
                field.put("isedit", Boolean.FALSE);
            }
        }
    }

    private Object getValueIfExist(String key) {
        if (PropertyHelper.existProperty((DynamicObject)this.getModel().getDataEntity(), (String)key)) {
            return this.getModel().getValue(key);
        }
        return null;
    }
}

