/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.hr.metadata.edit.MulPersonEdit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ERMFileRepository;
import kd.hr.hspm.common.constants.common.CommonConstants;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.ErManFileQfilter;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.ext.file.EmpSupRelDTO;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.card.CardExtCommon;

public class EmpSupRelEditPlugin
extends AbstractFormDrawEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(EmpSupRelEditPlugin.class);
    private Long REP_ID = 1010L;
    private String SUPERIOR_ID = "superior.id";
    private String REPORTTYPE_ID = "reporttype.id";
    private static HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
    private List<String> TOTAL_FIXED_FIELDS = Arrays.asList("reporttype", "newsuperior", "newsuperior_1010", "superior", "superior_1010", "startdate", "enddate");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        this.fitFormTitle(formShowParameter, status);
    }

    private void fitFormTitle(FormShowParameter formShowParameter, String status) {
        if ("cus_addnew".equals(status)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6c47\u62a5\u5173\u7cfb", (String)"EmpSupRelEditPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        } else if ("cus_edit".equals(status)) {
            String reportTypeStr = (String)formShowParameter.getCustomParam("reporttype");
            String showTypeStr = "";
            if (HRStringUtils.isNotEmpty((String)reportTypeStr)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportcoreltype");
                DynamicObject query = serviceHelper.queryOne("id,name,number", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(reportTypeStr))});
                if (query != null) {
                    showTypeStr = query.getString("name");
                }
            }
            formShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u4fee\u6539\u6c47\u62a5\u5173\u7cfb-{0}", (String)"EmpSupRelEditPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]), showTypeStr));
        } else if ("cus_expire".equals(status)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5931\u6548\u6c47\u62a5\u5173\u7cfb", (String)"EmpSupRelEditPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        super.beforeBindData(eventObject);
        DateEdit startDate = (DateEdit)this.getControl("startdate");
        if (startDate != null) {
            startDate.setMaxDate(new Date());
        }
        this.setCompareField();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        if (!this.isNewVersion(this.diffMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior", "newsuperior_1010", "enddate"});
            if ("cus_edit".equals(status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            }
        } else {
            Long employeeId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("employee"));
            Object[] fileDys = ERMFileRepository.queryByEmployeeId((String)"id", (Long)employeeId);
            if (!HRArrayUtils.isEmpty((Object[])fileDys)) {
                List fileIds = Arrays.stream(fileDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                this.getView().getPageCache().put("fileids", SerializationUtils.toJsonString(fileIds));
            }
        }
        if ("cus_addnew".equals(status)) {
            this.getModel().setValue("startdate", (Object)HspmDateUtils.getMidnight());
            if (!this.isNewVersion(this.diffMap)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior", "superior_1010", "startdate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior", "superior_1010", "newsuperior_1010", "enddate"});
            }
        } else {
            if (OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
                this.setViewDataStatus(formShowParameter);
                this.getModel().setDataChanged(false);
                return;
            }
            if ("cus_edit".equals(status) && this.isNewVersion(this.diffMap)) {
                if (this.isNewVersion(this.diffMap)) {
                    this.getModel().setValue("startdate", (Object)HspmDateUtils.getMidnight());
                    this.getView().setVisible(Boolean.FALSE, new String[]{"superior", "superior_1010", "newsuperior", "enddate"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
                }
            }
            this.setValueFromDb(formShowParameter, "hrpi_empsuprel", null);
            if ("cus_expire".equals(status) && this.isNewVersion(this.diffMap)) {
                DateEdit endDate = (DateEdit)this.getControl("enddate");
                if (endDate != null) {
                    endDate.setMaxDate(new Date());
                }
                this.getModel().setValue("enddate", (Object)HspmDateUtils.getMidnight());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"newsuperior", "newsuperior_1010", "startdate"});
            }
            this.matchHideWord("init", null);
        }
        this.getModel().setDataChanged(false);
    }

    private void setCompareField() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("startdate");
        fields.add("newsuperior_1010");
        fields.add("newsuperior");
        fields.add("enddate");
        this.getView().getPageCache().put("comparefield", SerializationUtils.toJsonString(fields));
    }

    private void setViewDataStatus(FormShowParameter formShowParameter) {
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("pkid"));
        HRBaseServiceHelper supHelper = new HRBaseServiceHelper("hrpi_empsuprel");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)pkId)};
        DynamicObject dynamicObject = supHelper.queryOne("startdate,superior,reporttype,businessstatus,superiordepemp.id,enddate", filters);
        if (dynamicObject != null) {
            long repId = dynamicObject.getLong(this.REPORTTYPE_ID);
            long superId = dynamicObject.getLong(this.SUPERIOR_ID);
            Long[] pkIdArr = Collections.singletonList(superId).toArray(new Long[0]);
            long superDepId = dynamicObject.getLong("superiordepemp.id");
            HashSet<Long> ids = new HashSet<Long>(4);
            ids.add(superDepId);
            Object[] dynamicObjects = this.queryMainFileDys(ids);
            Long[] pkNewIdArr = new Long[]{};
            if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                long erFileId = dynamicObjects[0].getLong("id");
                pkNewIdArr = Collections.singletonList(erFileId).toArray(new Long[0]);
            }
            if (this.REP_ID == repId) {
                this.getModel().setValue("reporttype", (Object)this.REP_ID);
                this.getModel().setValue("superior_1010", (Object)pkIdArr);
                this.getModel().setValue("newsuperior_1010", (Object)pkNewIdArr);
                if (this.isNewVersion(this.diffMap)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"superior_1010"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior"});
            } else {
                this.getModel().setValue("reporttype", (Object)repId);
                this.getModel().setValue("superior", (Object)pkIdArr);
                this.getModel().setValue("newsuperior", (Object)pkNewIdArr);
                if (this.isNewVersion(this.diffMap)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"superior"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior_1010"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior_1010"});
            }
            Date date = null;
            Date date1 = dynamicObject.getDate("enddate");
            if (!"2999-12-31".equals(HRDateTimeUtils.format((Date)date1, (String)"yyyy-MM-dd"))) {
                date = dynamicObject.getDate("enddate");
            }
            this.getModel().setValue("enddate", (Object)date);
            this.getModel().setValue("startdate", (Object)dynamicObject.getDate("startdate"));
        }
    }

    protected void setValueFromDb(FormShowParameter formShowParameter, String entityId, String typeConstant) {
        List startDataList;
        Object[] fileDys;
        HashSet<String> igSet = new HashSet<String>(16);
        IPageCache oldDbData = this.getView().getPageCache();
        ArrayList<String> fieldList = new ArrayList<String>(10);
        HashMap<String, Object> oldObj = new HashMap<String, Object>(16);
        Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
        Long reportType = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("reporttype"));
        ArrayList<Long> depIds = new ArrayList<Long>(10);
        depIds.add(origDepId);
        DynamicObject[] dys = this.queryEffectDys(depIds, reportType, "depemp", "=", null, "0");
        if (dys == null || dys.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6c47\u62a5\u5173\u7cfb\u5df2\u5931\u6548,\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"EmpSupRelEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> personIds = Arrays.stream(dys).map(dy -> dy.getLong("superior.id")).collect(Collectors.toList());
        Set<Long> superiorDepId = Arrays.stream(dys).filter(dy -> dy.getLong("superiordepemp.id") != 0L).map(dy -> dy.getLong("superiordepemp.id")).collect(Collectors.toSet());
        if (this.isNewVersion(this.diffMap) && HRArrayUtils.isNotEmpty((Object[])(fileDys = this.queryMainFileDys(superiorDepId)))) {
            List<Long> fileIds = Arrays.stream(fileDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            if (1010L == reportType) {
                this.putCacheAndSet(igSet, oldObj, fileIds, "newsuperior_1010");
            } else {
                this.putCacheAndSet(igSet, oldObj, fileIds, "newsuperior");
            }
        }
        if ((startDataList = Arrays.stream(dys).map(dy -> dy.getDate("startdate")).collect(Collectors.toList())).size() > 0) {
            oldObj.put("startdate", startDataList.get(0));
            if (this.isNewVersion(this.diffMap)) {
                this.getModel().setValue("startdate", startDataList.get(0));
            }
        } else {
            if (this.isNewVersion(this.diffMap)) {
                this.getModel().setValue("startdate", (Object)HspmDateUtils.getMidnight());
            }
            oldObj.put("startdate", HspmDateUtils.getMidnight());
        }
        this.getModel().setValue("reporttype", (Object)reportType);
        if (1010L == reportType) {
            this.putCacheAndSet(igSet, oldObj, personIds, "superior_1010");
        } else {
            this.putCacheAndSet(igSet, oldObj, personIds, "superior");
        }
        oldObj.put("reporttype", String.valueOf(reportType));
        fieldList.add("reporttype");
        if (igSet.size() > 0) {
            this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
        }
        oldDbData.put(entityId + "oldDbData", SerializationUtils.toJsonString(oldObj));
        oldDbData.put(entityId + "queryFields", SerializationUtils.toJsonString(fieldList));
        this.getView().getPageCache().put("cachepagedepid", SerializationUtils.toJsonString(superiorDepId));
        List pkId = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        oldDbData.put("cachepkid", SerializationUtils.toJsonString(pkId));
    }

    private void putCacheAndSet(Set<String> igSet, Map<String, Object> oldObj, List<Long> personIds, String superior1010) {
        Long[] pkId = personIds.toArray(new Long[0]);
        igSet.add(superior1010);
        this.getModel().setValue(superior1010, (Object)pkId);
        oldObj.put(superior1010, personIds);
    }

    protected void changeShowFormData(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Map confParams = AttacheHandlerService.getInstance().getPageCustomParam(formShowParameter, "hrpi_empsuprel");
        this.cleanAndProFixedField(formShowParameter, confParams, args);
        super.changeShowFormData(args);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
        MulPersonEdit supEdit = (MulPersonEdit)this.getControl("superior");
        supEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulPersonEdit superEdit = (MulPersonEdit)this.getControl("superior_1010");
        superEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit supNewEdit = (MulBasedataEdit)this.getControl("newsuperior");
        supNewEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit superNewEdit = (MulBasedataEdit)this.getControl("newsuperior_1010");
        superNewEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void cleanAndProFixedField(FormShowParameter formShowParameter, Map<String, Object> confParams, LoadCustomControlMetasArgs args) {
        ArrayList<Map> fields = new ArrayList<Map>(10);
        Map metaFields = MetadataServiceHelper.getDataEntityType((String)"hrpi_empsuprel").getAllFields();
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>(16);
        for (Map.Entry tmpField : metaFields.entrySet()) {
            String status;
            IDataEntityProperty field = (IDataEntityProperty)tmpField.getValue();
            String number = field.getName();
            if (!this.TOTAL_FIXED_FIELDS.contains(number) || ("cus_addnew".equals(status = (String)formShowParameter.getCustomParam("cus_status")) || "cus_edit".equals(status)) && "enddate".equals(number)) continue;
            if ("superior".equals(number) || "newsuperior".equals(number)) {
                for (int i = 0; i < 2; ++i) {
                    String suffix = null;
                    String cnStr = null;
                    if (i == 0) {
                        suffix = "_1010";
                        cnStr = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"EmpSupRelEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    } else {
                        cnStr = ResManager.loadKDString((String)"\u6c47\u62a5\u4e0a\u7ea7", (String)"EmpSupRelEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    }
                    this.buildOneFixedField(cacheMap, field, number, suffix, cnStr, Boolean.TRUE);
                }
                continue;
            }
            Boolean flag = Boolean.TRUE;
            if ("reporttype".equals(number) && ("cus_edit".equals(status) || "cus_expire".equals(status))) {
                flag = Boolean.FALSE;
            }
            this.buildOneFixedField(cacheMap, field, number, null, null, flag);
        }
        for (String field : this.TOTAL_FIXED_FIELDS) {
            Map fieldMap = (Map)cacheMap.get(field);
            if (fieldMap == null || fieldMap.size() <= 0) continue;
            fields.add(fieldMap);
        }
        HashMap<String, Object> groupMap = new HashMap<String, Object>(16);
        groupMap.put("fields", fields);
        groupMap.put("gname", ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb", (String)"EmpSupRelEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        ArrayList<HashMap<String, Object>> groupList = new ArrayList<HashMap<String, Object>>(10);
        groupList.add(groupMap);
        confParams.put("groups", groupList);
        formShowParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(confParams));
    }

    private void buildOneFixedField(Map<String, Map<String, Object>> cacheMap, IDataEntityProperty field, String number, String suffix, String cnStr, Boolean edit) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        LocaleString displayName = field.getDisplayName();
        fieldMap.put("maxcount", 1);
        fieldMap.put("isedit", edit);
        fieldMap.put("max", "");
        fieldMap.put("precision", 0);
        fieldMap.put("scale", 0);
        if (field instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)field;
            fieldMap.put("refkey", basedataProp.getBaseEntityId());
        }
        fieldMap.put("pnumber", "hrpi_empsuprel");
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldTypeByCode((String)field.getClass().getName());
        if (fieldTypeEnum != null) {
            fieldMap.put("type", fieldTypeEnum.getType());
        }
        if (number.contains("superior")) {
            fieldMap.put("type", "25");
        }
        fieldMap.put("isrequired", Boolean.TRUE);
        if (HRStringUtils.isNotEmpty((String)suffix)) {
            fieldMap.put("number", number + suffix);
        } else {
            fieldMap.put("number", number);
        }
        fieldMap.put("min", "");
        if (HRStringUtils.isNotEmpty((String)cnStr)) {
            fieldMap.put("pname", cnStr);
            fieldMap.put("displayname", cnStr);
        } else {
            fieldMap.put("pname", displayName.getLocaleValue());
            fieldMap.put("displayname", displayName.getLocaleValue());
        }
        if (HRStringUtils.isNotEmpty((String)suffix) && HRStringUtils.isNotEmpty((String)cnStr)) {
            cacheMap.put(number + suffix, fieldMap);
        } else {
            cacheMap.put(number, fieldMap);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        if ("reporttype".equals(name)) {
            this.matchHideWord("change", evt);
        }
        this.setHideValue(name, evt);
    }

    private void setHideValue(String name, PropertyChangedArgs evt) {
        ChangeData[] changeSet = evt.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        try {
            if ("newsuperior".equals(name)) {
                if (newValue == null) {
                    this.getModel().setValue("superior", null);
                    return;
                }
                this.setHideFieldValue("newsuperior", "superior", "newsuperior_1010");
            } else if ("newsuperior_1010".equals(name)) {
                if (newValue == null) {
                    this.getModel().setValue("superior_1010", null);
                    return;
                }
                this.setHideFieldValue("newsuperior_1010", "superior_1010", "newsuperior");
            }
        }
        catch (Exception es) {
            LOGGER.error("setHideValueError");
        }
    }

    private void setHideFieldValue(String field, String hideField, String noChangeField) {
        List depEmpIds;
        MulBasedataDynamicObjectCollection personDys = (MulBasedataDynamicObjectCollection)this.getModel().getValue(field);
        List<Long> erManFileIds = personDys.stream().map(dy -> (Long)dy.getPkValue()).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.queryManFileDys(erManFileIds);
        List personIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        int mulOrdinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty(field).getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(mulOrdinal, true);
        int noOrdinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty(noChangeField).getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(noOrdinal, false);
        if (!CollectionUtils.isEmpty(personIds)) {
            this.getModel().beginInit();
            this.getModel().setValue(hideField, (Object)personIds.toArray());
            this.getModel().endInit();
            int ordinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty(hideField).getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
            for (DynamicObject next : personDys) {
                DataEntityPropertyCollection properties = next.getDataEntityType().getProperties();
                properties.forEach(pro -> {
                    int ordinal1 = pro.getOrdinal();
                    next.getDataEntityState().setBizChanged(ordinal1, false);
                });
            }
        }
        if (!CollectionUtils.isEmpty(depEmpIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("depemp.id")).collect(Collectors.toList()))) {
            this.getView().getPageCache().put("cachepagedepid", SerializationUtils.toJsonString(depEmpIds));
        }
    }

    private boolean matchHideWord(String type, PropertyChangedArgs evt) {
        boolean flag = false;
        HashSet<String> igSet = new HashSet<String>(16);
        DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
        long typeId = 0L;
        if (repDy == null && evt != null && "change".equals(type)) {
            ChangeData[] changeSet = evt.getChangeSet();
            DynamicObject oldDy = (DynamicObject)changeSet[0].getOldValue();
            if (oldDy != null) {
                typeId = oldDy.getLong("id");
            }
        } else if (repDy != null) {
            typeId = repDy.getLong("id");
        }
        if (!this.isNewVersion(this.diffMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior", "newsuperior_1010"});
            igSet.add("newsuperior");
            igSet.add("newsuperior_1010");
        }
        if (typeId == 1010L) {
            if ("clicksave".equals(type)) {
                return true;
            }
            if ("change".equals(type)) {
                this.getModel().beginInit();
                this.getModel().setValue("superior_1010", null);
                this.getModel().endInit();
                int mulOrdinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty("superior").getOrdinal();
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(mulOrdinal, false);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"superior_1010", "startdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"superior"});
            igSet.add("superior");
            if (this.isNewVersion(this.diffMap)) {
                igSet.add("superior_1010");
                igSet.add("newsuperior");
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior_1010", "newsuperior"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"newsuperior_1010"});
            }
        } else {
            if ("clicksave".equals(type)) {
                return flag;
            }
            if ("change".equals(type)) {
                this.getModel().beginInit();
                this.getModel().setValue("superior", null);
                this.getModel().endInit();
                int mulOrdinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty("superior").getOrdinal();
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(mulOrdinal, false);
            }
            igSet.add("superior_1010");
            this.getView().setVisible(Boolean.TRUE, new String[]{"superior", "startdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"superior_1010"});
            if (this.isNewVersion(this.diffMap)) {
                igSet.add("newsuperior_1010");
                igSet.add("superior");
                this.getView().setVisible(Boolean.FALSE, new String[]{"superior", "newsuperior_1010"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"newsuperior"});
            }
        }
        if ("init".equals(type)) {
            String repType = (String)this.getView().getFormShowParameter().getCustomParam("reporttype");
            if (HRStringUtils.isNotEmpty((String)repType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"reporttype", "superior", "superior_1010"});
                igSet.add("startdate");
                if (1010L == Long.parseLong(repType)) {
                    igSet.add("superior");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"superior", "startdate"});
                    if (this.isNewVersion(this.diffMap)) {
                        igSet.add("superior_1010");
                        this.getView().setVisible(Boolean.TRUE, new String[]{"startdate"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior", "superior_1010"});
                    }
                } else {
                    igSet.add("superior_1010");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"superior_1010", "startdate"});
                    if (this.isNewVersion(this.diffMap)) {
                        igSet.add("superior");
                        this.getView().setVisible(Boolean.TRUE, new String[]{"startdate"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"newsuperior_1010", "superior"});
                    }
                }
            } else {
                this.getView().showErrorNotification("error reportTye");
            }
        }
        if (igSet.size() > 0) {
            String igSetStr = this.getView().getPageCache().get("cacheingore");
            if (HRStringUtils.isNotEmpty((String)igSetStr)) {
                Set igCacheSet = (Set)SerializationUtils.fromJsonString((String)igSetStr, Set.class);
                igSet.addAll(igCacheSet);
            }
            this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
        }
        return flag;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            if ("cus_addnew".equals(status)) {
                ArrayList<Long> origDepIds = new ArrayList<Long>(10);
                DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
                if (repDy == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpSupRelEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.toValidateDate(evt, status, origDepId);
                origDepIds.add(origDepId);
                DynamicObject[] dynamicObjects = this.queryEffectDys(origDepIds, repDy.getLong("id"), "depemp", "=", null, "0");
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    String err = String.format(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"EmpSupRelEditPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), repDy.getString("name"));
                    this.getView().showErrorNotification(err);
                    evt.setCancel(true);
                }
            } else if ("cus_edit".equals(status)) {
                this.toValidateDate(evt, status, origDepId);
            } else if ("cus_expire".equals(status)) {
                this.validateStartAndEndDate(evt);
            }
        }
    }

    private void validateStartAndEndDate(BeforeClickEvent evt) {
        boolean existEndDate;
        String noPermStr = this.getView().getPageCache().get("hasPerm");
        if ("0".equals(noPermStr)) {
            return;
        }
        StringBuilder build = new StringBuilder();
        boolean existDate = this.getModel().getDataEntityType().getAllFields().containsKey("startdate");
        if (!existDate) {
            build.append(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f00\u59cb\u65e5\u671f", (String)"EmpSupRelEditPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        if (!(existEndDate = this.getModel().getDataEntityType().getAllFields().containsKey("enddate"))) {
            build.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5458\u5de5\u5f53\u524d\u4efb\u804c\u5f00\u59cb\u65e5\u671f\uff08%s\uff09\u3002", (String)"EmpSupRelEditPlugin_15", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        Date pageStartDate = (Date)this.getModel().getValue("startdate");
        Date pageEndDate = (Date)this.getModel().getValue("enddate");
        if (pageStartDate != null && pageEndDate != null && pageStartDate.compareTo(pageEndDate) > 0) {
            String error = String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u5173\u7cfb\u7684\u5f00\u59cb\u65e5\u671f\uff08%s\uff09\u3002", (String)"EmpSupRelEditPlugin_16", (String)"hr-hspm-formplugin", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)"hrpi_empsuprel", (String)"startdate", (Date)pageStartDate));
            build.append(error);
        }
        if (HRStringUtils.isNotEmpty((String)build.toString())) {
            this.getView().showErrorNotification(build.toString());
            evt.setCancel(true);
            try {
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "EmpSupRelEditPlugin_9", "hr-hspm-formplugin");
                MultiLangEnumBridge desc = new MultiLangEnumBridge(build.toString(), "EmpSupRelEditPlugin_15", "hr-hspm-formplugin");
                String appId = this.getView().getFormShowParameter().getAppId();
                OperateLogService.commonWriteLog((String)appId, (String)this.getView().getEntityId(), (String)"do_save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)desc, (String[])new String[0]);
            }
            catch (Exception ex) {
                LOGGER.error("validateStartAndEndDateError", (Throwable)ex);
            }
            return;
        }
        evt.setCancel(true);
        DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
        if (repDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpSupRelEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String tip = ResManager.loadKDString((String)"\u5173\u7cfb\u5931\u6548\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5931\u6548\uff1f", (String)"EmpSupRelEditPlugin_20", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        long repId = repDy.getLong("id");
        if (this.REP_ID.equals(repId)) {
            tip = ResManager.loadKDString((String)"\u5173\u7cfb\u5931\u6548\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5931\u6548\uff1f\u5931\u6548\u540e\uff0c\u5c06\u83b7\u53d6\u5458\u5de5\u4e0a\u7ea7\u5c97\u4f4d\u7684\u4eba\u5458\u6216\u8005\u90e8\u95e8\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e3a\u5176\u4e0a\u7ea7\uff0c\u53ef\u5237\u65b0\u6863\u6848\u540e\u8fdb\u884c\u67e5\u770b\u3002", (String)"EmpSupRelEditPlugin_17", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delcallbacksuperiorok", (IFormPlugin)this));
    }

    private boolean validateModelValueChange() {
        boolean valueEquals = true;
        try {
            String oldCacheData = this.getView().getPageCache().get("hrpi_empsupreloldDbData");
            if (HRStringUtils.isEmpty((String)oldCacheData)) {
                return false;
            }
            String fieldStr = this.getView().getPageCache().get("comparefield");
            if (HRStringUtils.isEmpty((String)fieldStr)) {
                return false;
            }
            String ignoreStr = this.getView().getPageCache().get("ignorecomparefield");
            Set ignoreFields = new HashSet(4);
            if (HRStringUtils.isNotEmpty((String)ignoreStr)) {
                ignoreFields = (Set)SerializationUtils.fromJsonString((String)ignoreStr, Set.class);
            }
            Set fields = (Set)SerializationUtils.fromJsonString((String)fieldStr, Set.class);
            for (String field : fields) {
                boolean key = this.getModel().getDataEntityType().getProperties().containsKey((Object)field);
                if (ignoreFields.contains(field) || !key) continue;
                Map oldObj = (Map)SerializationUtils.fromJsonString((String)oldCacheData, Map.class);
                Object oldObjValue = oldObj.get(field);
                Object pageValue = this.getModel().getValue(field);
                if ("newsuperior_1010".equals(field) || "newsuperior".equals(field)) {
                    Long reportType = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("reporttype"));
                    if (this.REP_ID.equals(reportType)) {
                        Object supNew = oldObj.get("newsuperior_1010");
                        if (this.compareListEquals(supNew, "newsuperior_1010")) continue;
                        valueEquals = false;
                    } else {
                        Object superObj = oldObj.get("newsuperior");
                        if (this.compareListEquals(superObj, "newsuperior")) continue;
                        valueEquals = false;
                    }
                } else {
                    if (CommonUtil.customObjectEquals((Object)pageValue, oldObjValue, (String)"yyyy-MM-dd")) continue;
                    valueEquals = false;
                }
                return valueEquals;
            }
        }
        catch (Exception es) {
            LOGGER.error("compareError", (Throwable)es);
            return false;
        }
        return true;
    }

    private boolean compareListEquals(Object supNew, String field) {
        if (supNew instanceof List) {
            boolean equList;
            List supNew1 = (List)supNew;
            MulBasedataDynamicObjectCollection personDys = (MulBasedataDynamicObjectCollection)this.getModel().getValue(field);
            List erManFileIds = personDys.stream().map(dy -> (Long)dy.getPkValue()).collect(Collectors.toList());
            boolean bl = equList = supNew1.containsAll(erManFileIds) && erManFileIds.containsAll(supNew1);
            if (equList) {
                return true;
            }
        }
        return false;
    }

    private void toValidateDate(BeforeClickEvent evt, String status, Long origDepId) {
        if (this.isNewVersion(this.diffMap)) {
            String noPermStr = this.getView().getPageCache().get("hasPerm");
            if ("0".equals(noPermStr)) {
                return;
            }
            String validate = this.checkStartDate(origDepId);
            if (HRStringUtils.isNotEmpty((String)validate)) {
                this.getView().showErrorNotification(validate);
                evt.setCancel(true);
                try {
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "EmpSupRelEditPlugin_9", "hr-hspm-formplugin");
                    MultiLangEnumBridge desc = new MultiLangEnumBridge(validate, "EmpSupRelEditPlugin_15", "hr-hspm-formplugin");
                    String appId = this.getView().getFormShowParameter().getAppId();
                    OperateLogService.commonWriteLog((String)appId, (String)this.getView().getEntityId(), (String)"do_save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)desc, (String[])new String[0]);
                }
                catch (Exception ex) {
                    LOGGER.error("toValidateDateError", (Throwable)ex);
                }
                return;
            }
            String validateStr = this.checkBusStartDate(origDepId, status);
            if (HRStringUtils.isNotEmpty((String)validateStr)) {
                evt.setCancel(true);
                this.getView().showConfirm(validateStr, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callbacksuperiorok", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        if ("callbacksuperiorok".equals(key)) {
            this.saveOrUpdatePageData(this.getView().getFormShowParameter(), true);
        } else if ("delcallbacksuperiorok".equals(key)) {
            this.saveOrUpdatePageData(this.getView().getFormShowParameter(), true);
        }
    }

    private String checkStartDate(Long origDepId) {
        Date dbStartDate;
        boolean existDate = this.getModel().getDataEntityType().getAllFields().containsKey("startdate");
        if (!existDate) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f00\u59cb\u65e5\u671f", (String)"EmpSupRelEditPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        Date pageStartDate = (Date)this.getModel().getValue("startdate");
        DynamicObject dynamicObject = this.queryDepempDy(origDepId);
        if (dynamicObject != null && HRDateTimeUtils.dayBefore((Date)pageStartDate, (Date)(dbStartDate = dynamicObject.getDate("startdate")))) {
            return String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5458\u5de5\u5f53\u524d\u4efb\u804c\u5f00\u59cb\u65e5\u671f\uff08%s\uff09\u3002", (String)"EmpSupRelEditPlugin_15", (String)"hr-hspm-formplugin", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)"hrpi_empsuprel", (String)"startdate", (Date)dbStartDate));
        }
        return null;
    }

    private String checkBusStartDate(Long origDepId, String status) {
        boolean existReport = this.getModel().getDataEntityType().getAllFields().containsKey("reporttype");
        if (!existReport) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b", (String)"EmpSupRelEditPlugin_11", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        DynamicObject repTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
        if (repTypeDy == null) {
            return ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"EmpSupRelEditPlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        long repTypeId = repTypeDy.getLong("id");
        Date pageStartDate = (Date)this.getModel().getValue("startdate");
        QFilter qFilter = new QFilter("reporttype", "=", (Object)repTypeId);
        boolean dataChanged = this.getModel().getDataChanged();
        if ("cus_addnew".equals(status)) {
            qFilter.and(new QFilter("businessstatus", "=", (Object)"2"));
            Object[] dynamicObjects = this.queryEffectReportDys(origDepId, qFilter);
            if (dataChanged && HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                return this.validateHasSup(repTypeDy, pageStartDate, (DynamicObject[])dynamicObjects, status);
            }
        } else if ("cus_edit".equals(status)) {
            Object[] dynamicObjects = this.queryEffectReportDys(origDepId, qFilter);
            if (dataChanged && HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                return this.validateHasSup(repTypeDy, pageStartDate, (DynamicObject[])dynamicObjects, status);
            }
        }
        return null;
    }

    private String validateHasSup(DynamicObject repTypeDy, Date pageStartDate, DynamicObject[] dynamicObjects, String status) {
        List<DynamicObject> rangeDys = Arrays.stream(dynamicObjects).filter(dy -> pageStartDate.compareTo(dy.getDate("startdate")) < 0).sorted(Comparator.comparing(dy -> dy.getDate("startdate"))).collect(Collectors.toList());
        List<DynamicObject> partDys = Arrays.stream(dynamicObjects).filter(dy -> "2".equals(dy.getString("businessstatus")) && pageStartDate.compareTo(dy.getDate("startdate")) >= 0 && pageStartDate.compareTo(dy.getDate("enddate")) <= 0).sorted(Comparator.comparing(dy -> dy.getDate("startdate"))).collect(Collectors.toList());
        StringBuilder build = new StringBuilder();
        if (!CollectionUtils.isEmpty(rangeDys)) {
            this.timeRangeDys(rangeDys, build, repTypeDy, null);
        }
        if (!CollectionUtils.isEmpty(partDys)) {
            this.timeRangeDys(partDys, build, repTypeDy, pageStartDate);
        }
        if (HRStringUtils.isNotEmpty((String)build.toString())) {
            return String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\uff0c\u4fdd\u5b58\u540e\u4f1a\u8986\u76d6\u539f\u6c47\u62a5\u5173\u7cfb\uff0c\u662f\u5426\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"EmpSupRelEditPlugin_14", (String)"hr-hspm-formplugin", (Object[])new Object[0]), build.toString());
        }
        return null;
    }

    private void timeRangeDys(List<DynamicObject> rangeDys, StringBuilder build, DynamicObject repTypeDy, Date pageStartDate) {
        HashMap<String, String> tipMap = new HashMap<String, String>(rangeDys.size());
        for (DynamicObject dy : rangeDys) {
            String startDate = HRDateTimeUtils.format((Date)dy.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = HRDateTimeUtils.format((Date)dy.getDate("enddate"), (String)"yyyy-MM-dd");
            String key = startDate + "_" + endDate;
            String oldName = (String)tipMap.get(key);
            String personName = dy.getString("superior.name");
            if (HRStringUtils.isEmpty((String)oldName)) {
                tipMap.put(key, personName);
                continue;
            }
            oldName = oldName + "\u3001" + personName;
            tipMap.put(key, oldName);
        }
        int count = 0;
        for (Map.Entry entry : tipMap.entrySet()) {
            Object[] splitArr;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (HRStringUtils.isEmpty((String)key) || !HRArrayUtils.isNotEmpty((Object[])(splitArr = key.split("_")))) continue;
            Object startDate = splitArr[0];
            if (pageStartDate != null) {
                startDate = HRDateTimeUtils.format((Date)pageStartDate, (String)"yyyy-MM-dd");
            }
            Object endDate = splitArr[1];
            if (count > 0 || HRStringUtils.isNotEmpty((String)build.toString())) {
                build.append("\uff0c");
            }
            String tip = ResManager.loadKDString((String)"%1$s~%2$s\u5b58\u5728%3$s%4$s", (String)"EmpSupRelEditPlugin_18", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            ++count;
            String superType = "";
            if (repTypeDy != null) {
                long repId = repTypeDy.getLong("id");
                superType = this.REP_ID == repId ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7\uff1a", (String)"EmpSupRelCardPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6c47\u62a5\u4e0a\u7ea7\uff1a", (String)"EmpSupRelCardPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                try {
                    Date date = HRDateTimeUtils.parseDate((String)startDate);
                    startDate = HRInteDateTimeUtil.formatDate((String)"hrpi_empsuprel", (String)"startdate", (Date)date);
                }
                catch (ParseException ex) {
                    LOGGER.error("parseError", (Throwable)ex);
                }
            }
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                if ("2999-12-31".equals(endDate)) {
                    endDate = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"EmpSupRelEditPlugin_19", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                } else {
                    try {
                        Date date = HRDateTimeUtils.parseDate((String)endDate);
                        endDate = HRInteDateTimeUtil.formatDate((String)"hrpi_empsuprel", (String)"startdate", (Date)date);
                    }
                    catch (ParseException ex) {
                        LOGGER.error("parseError", (Throwable)ex);
                    }
                }
            }
            build.append(String.format(tip, startDate, endDate, superType, value));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = (String)formShowParameter.getCustomParam("cus_status");
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            Long origPersonId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
            Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
            boolean superFlag = this.matchHideWord("clicksave", null);
            if (this.isNewVersion(this.diffMap)) {
                this.saveOrUpdatePageData(formShowParameter, false);
                return;
            }
            LOGGER.info("EmpSupRelEditPlugin->click save by old version");
            if ("cus_addnew".equals(status)) {
                MulBasedataDynamicObjectCollection personDys = superFlag ? (MulBasedataDynamicObjectCollection)this.getModel().getValue("superior_1010") : (MulBasedataDynamicObjectCollection)this.getModel().getValue("superior");
                if (personDys == null || personDys.size() == 0) {
                    this.getView().showErrorNotification("empty superior.");
                    return;
                }
                List<Long> personIds = personDys.stream().map(dy -> (Long)dy.getPkValue()).collect(Collectors.toList());
                Map<String, DynamicObjectCollection> dyMap = this.handleAddSuperior(personIds, formShowParameter, null);
                Map retMap = AttacheHandlerService.getInstance().invokeSaveOrUpdate(this.getView(), dyMap, true, "hrpi_empsuprel", "1");
                if (superFlag && ((Boolean)retMap.get("success")).booleanValue()) {
                    AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(origPersonId));
                }
            } else if ("cus_edit".equals(status)) {
                IPageCache oldDbData = this.getView().getPageCache();
                String oldDataStr = oldDbData.get("hrpi_empsupreloldDbData");
                Map oldMap = (Map)SerializationUtils.fromJsonString((String)oldDataStr, Map.class);
                String repTypeStr = (String)oldMap.get("reporttype");
                DynamicObject repTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
                if (HRStringUtils.isNotEmpty((String)repTypeStr)) {
                    long reportTypeId;
                    long oldReportType = Long.parseLong(repTypeStr);
                    if (oldReportType != (reportTypeId = repTypeDy.getLong("id"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\u3002", (String)"EmpSupRelEditPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u5173\u7cfb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmpSupRelEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                }
                if (superFlag) {
                    this.handleDelAndAddSuper(oldMap, "superior_1010", origPersonId, origDepId);
                } else {
                    this.handleDelAndAddSuper(oldMap, "superior", origPersonId, origDepId);
                }
            }
        }
    }

    private void saveOrUpdatePageData(FormShowParameter formShowParameter, boolean setDataNotChange) {
        String status = (String)formShowParameter.getCustomParam("cus_status");
        Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
        HrApiResponse<Map<String, Object>> response = new HrApiResponse<Map<String, Object>>();
        String depEmpIdStr = this.getView().getPageCache().get("cachepagedepid");
        if ("cus_addnew".equals(status)) {
            response = this.invokeSuperiorSave(origDepId, depEmpIdStr, "addSuperior", response);
        } else if ("cus_edit".equals(status)) {
            boolean valueEqual = this.validateModelValueChange();
            if (valueEqual) {
                response.setSuccess(true);
                LOGGER.warn("EmpSupRelEditPlugin->data not change");
                DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
                this.validateDataExist(origDepId, response, repDy);
            } else {
                response = this.invokeSuperiorSave(origDepId, depEmpIdStr, "updateSuperior", response);
            }
        } else if ("cus_expire".equals(status)) {
            boolean valueEqual = this.validateModelValueChange();
            if (valueEqual) {
                response.setSuccess(true);
                LOGGER.warn("EmpSupRelEditPlugin->data not change");
                DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
                this.validateDataExist(origDepId, response, repDy);
            } else {
                response = this.invokeSuperiorSave(origDepId, depEmpIdStr, "expireSuperior", response);
            }
        }
        if (setDataNotChange) {
            this.getModel().setDataChanged(false);
        }
        if (response.isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InfoClassifyListPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else {
            this.getView().showErrorNotification(response.getErrorMessage());
        }
    }

    private HrApiResponse<Map<String, Object>> invokeSuperiorSave(Long origDepId, String depEmpIdStr, String methodName, HrApiResponse<Map<String, Object>> response) {
        boolean delData;
        if (HRStringUtils.isEmpty((String)depEmpIdStr)) {
            this.getView().showErrorNotification("depemp id is null");
            response.setSuccess(false);
            return response;
        }
        Set depEmpIds = (Set)SerializationUtils.fromJsonString((String)depEmpIdStr, Set.class);
        ArrayList addSuperiorList = new ArrayList();
        HashMap<String, Object> saveMap = new HashMap<String, Object>(4);
        ArrayList depEmpIdList = new ArrayList(depEmpIds);
        saveMap.put("depemp", origDepId);
        DynamicObject repDy = (DynamicObject)this.getModel().getValue("reporttype");
        saveMap.put("reporttype", repDy.getLong("id"));
        if ("expireSuperior".equals(methodName)) {
            saveMap.put("enddate", this.getModel().getValue("enddate"));
        } else {
            saveMap.put("superiordepemp", depEmpIdList);
            saveMap.put("startdate", this.getModel().getValue("startdate"));
        }
        addSuperiorList.add(saveMap);
        String status = (String)this.getView().getFormShowParameter().getCustomParam("cus_status");
        if (("cus_edit".equals(status) || "cus_expire".equals(status)) && (delData = this.validateDataExist(origDepId, response, repDy))) {
            return response;
        }
        response = (HrApiResponse)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)methodName, (Object[])new Object[]{addSuperiorList});
        return response;
    }

    private boolean validateDataExist(Long origDepId, HrApiResponse<Map<String, Object>> response, DynamicObject repDy) {
        String cacheId = this.getView().getPageCache().get("cachepkid");
        if (HRStringUtils.isEmpty((String)cacheId)) {
            return false;
        }
        List pkId = (List)SerializationUtils.fromJsonString((String)cacheId, List.class);
        QFilter qFilter = new QFilter("id", "in", (Object)pkId);
        Object[] dys = this.queryEffectReportDys(origDepId, qFilter);
        if (HRArrayUtils.isEmpty((Object[])dys)) {
            response.setSuccess(false);
            response.setErrorMessage(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractFormDrawEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void handleDelAndAddSuper(Map<String, Object> oldMap, String field, Long origPersonId, Long origDepId) {
        List oldPersonIds;
        MulBasedataDynamicObjectCollection personDys = (MulBasedataDynamicObjectCollection)this.getModel().getValue(field);
        List pagePersonIds = personDys.stream().map(dy -> (Long)dy.getPkValue()).collect(Collectors.toList());
        if (CommonUtil.listEquals(pagePersonIds, (List)(oldPersonIds = (List)oldMap.get(field)))) {
            this.getView().close();
        } else {
            DynamicObjectCollection delDys;
            Date startDate = null;
            String startDateStr = (String)oldMap.get("startdate");
            if (HRStringUtils.isNotEmpty((String)startDateStr)) {
                try {
                    startDate = HRDateTimeUtils.parseDate((String)startDateStr);
                }
                catch (ParseException e) {
                    LOGGER.error("handleDelAndAddSuper", (Object)startDate);
                }
            } else {
                startDate = HspmDateUtils.getMidnight();
            }
            List<Long> addPersonIds = pagePersonIds.stream().filter(item -> !oldPersonIds.contains(item)).collect(Collectors.toList());
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map<String, DynamicObjectCollection> addSuperiorMap = this.handleAddSuperior(addPersonIds, formShowParameter, startDate);
            List<Long> delPersonIds = oldPersonIds.stream().filter(item -> !pagePersonIds.contains(item)).collect(Collectors.toList());
            Map<String, DynamicObjectCollection> delSuperior = this.handleDelSuperior(delPersonIds);
            new CardExtCommon().handleExpireData(new EmpSupRelDTO(delSuperior));
            DynamicObjectCollection addDys = addSuperiorMap.get("hrpi_empsuprel");
            if (delSuperior != null && delSuperior.size() > 0 && (delDys = delSuperior.get("hrpi_empsuprel")) != null && delDys.size() > 0) {
                if (addDys != null && addDys.size() > 0) {
                    addDys.addAll((Collection)delDys);
                    addSuperiorMap.put("hrpi_empsuprel", addDys);
                } else {
                    addSuperiorMap.put("hrpi_empsuprel", delDys);
                }
            }
            Map retMap = AttacheHandlerService.getInstance().invokeSaveOrUpdate(this.getView(), addSuperiorMap, true, "hrpi_empsuprel", "1");
            if ("superior_1010".equals(field) && ((Boolean)retMap.get("success")).booleanValue()) {
                try {
                    this.syncSuper(origPersonId, origDepId, delPersonIds);
                }
                catch (Exception ex) {
                    LOGGER.error("syncSuperError", (Throwable)ex);
                }
            }
        }
    }

    private void syncSuper(Long origPersonId, Long origDepId, List<Long> delPersonIds) {
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>();
        personIdMap.put("person", Collections.singletonList(origPersonId));
        Long userId = this.getUserIdOrPersonId(origPersonId, personIdMap, "user", null);
        if (userId == 0L) {
            return;
        }
        List positionList = UserServiceHelper.getPosition(Collections.singletonList(userId));
        if (!CollectionUtils.isEmpty((Collection)positionList)) {
            HashMap<String, Long> groupMap = new HashMap<String, Long>(positionList.size());
            for (Map postList : positionList) {
                List entityList = (List)postList.get("entryentity");
                for (Map postMap : entityList) {
                    Object supDy;
                    Object postLang;
                    Object depDy = postMap.get("dpt");
                    long orgId = 0L;
                    long superUserId = 0L;
                    String localeValue = null;
                    if (depDy instanceof DynamicObject) {
                        orgId = ((DynamicObject)depDy).getLong("id");
                    }
                    if ((postLang = postMap.get("position")) instanceof OrmLocaleValue) {
                        OrmLocaleValue postLocalValue = (OrmLocaleValue)postLang;
                        localeValue = postLocalValue.getLocaleValue();
                    }
                    if ((supDy = postMap.get("superior")) instanceof DynamicObject) {
                        superUserId = ((DynamicObject)supDy).getLong("id");
                    }
                    groupMap.put(orgId + localeValue, superUserId);
                }
            }
            Object[] empposerel = EmpSupRelEditPlugin.getEmpposerel(origDepId);
            if (HRArrayUtils.isNotEmpty((Object[])empposerel)) {
                String localeValue = null;
                Object empPose = empposerel[0];
                long adminOrgId = empPose.getLong("adminorg");
                long positionLong = empPose.getLong("position");
                if (positionLong == 0L) {
                    positionLong = empPose.getLong("stdposition");
                    localeValue = this.getPostDy("hbpm_stposition", positionLong);
                } else {
                    localeValue = this.getPostDy("hbpm_positionhr", positionLong);
                }
                Long superId = (Long)groupMap.get(adminOrgId + localeValue);
                Long personId = this.getUserIdOrPersonId(superId, personIdMap, "person", superId);
                if (!delPersonIds.contains(personId)) {
                    return;
                }
            }
        }
        AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(origPersonId));
    }

    private String getPostDy(String entityName, long pkId) {
        HRBaseServiceHelper postHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        DynamicObject postDy = postHelper.queryOriginalOne("id,name", new QFilter[]{qFilter});
        if (postDy != null) {
            return postDy.getString("name");
        }
        return null;
    }

    private Long getUserIdOrPersonId(Long key, Map<String, List<Long>> personIdMap, String field, Long superId) {
        Object retObj;
        Map userMap = "person".equals(field) ? (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{superId}) : (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{personIdMap});
        Long userId = 0L;
        if (!HRMapUtils.isEmpty((Map)userMap) && ((Boolean)userMap.get("success")).booleanValue() && (retObj = userMap.get("data")) instanceof Map) {
            Map retDataMap = (Map)retObj;
            if ("person".equals(field)) {
                userId = (Long)retDataMap.get(field);
            } else {
                Object retDtaObj = retDataMap.get(key);
                if (retDtaObj instanceof Map) {
                    Map dataMap = (Map)retDtaObj;
                    userId = (Long)dataMap.get(field);
                }
            }
        }
        return userId;
    }

    private Map<String, DynamicObjectCollection> handleDelSuperior(List<Long> delPersonIds) {
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        if (delPersonIds.size() == 0) {
            return retMap;
        }
        DynamicObject repTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
        long reportTypeId = repTypeDy.getLong("id");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
        QFilter qFilter = new QFilter("depemp", "=", (Object)origDepId);
        DynamicObject[] effDys = this.queryEffectDys(delPersonIds, reportTypeId, "superior", "in", qFilter, "1");
        if (effDys == null || effDys.length == 0) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empsuprel");
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        for (DynamicObject effDy : effDys) {
            effDy.set("businessstatus", (Object)"2");
            effDy.set("enddate", (Object)HspmDateUtils.getMidnight());
            effDy.set("sysenddate", (Object)HRDateTimeUtils.addDay((Date)HspmDateUtils.getMidnight(), (long)1L));
            DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
            DynamicObject sendDy = serviceHelper.generateEmptyDynamicObject();
            this.setCopyUpdateDy(dy, null, sendDy, null, effDy);
            rtDys.add((Object)sendDy);
        }
        if (rtDys.size() > 0) {
            retMap.put("hrpi_empsuprel", rtDys);
        }
        return retMap;
    }

    private Map<String, DynamicObjectCollection> handleAddSuperior(List<Long> personIds, FormShowParameter formShowParameter, Date startDate) {
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        if (personIds.size() == 0) {
            return retMap;
        }
        DynamicObjectCollection rtDys = new DynamicObjectCollection();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empsuprel");
        DynamicObject[] mainFiles = EmpSupRelEditPlugin.getBatchPrimaryErmanFile("person.id,employee.id,cmpemp.id,depemp.id,adminorg.id,position.id,stdposition.id,darkposition.id", personIds);
        Map<Long, DynamicObject> personModelMap = Arrays.stream(mainFiles).collect(Collectors.toMap(appDy -> appDy.getLong("person.id"), appDy -> appDy, (v1, v2) -> v1));
        List<Long> postIds = Arrays.stream(mainFiles).filter(dy -> dy.getLong("position.id") != 0L).map(dy -> dy.getLong("position.id")).collect(Collectors.toList());
        List stfPostIds = Arrays.stream(mainFiles).filter(dy -> dy.getLong("darkposition.id") != 0L).map(dy -> dy.getLong("darkposition.id")).collect(Collectors.toList());
        if (stfPostIds.size() > 0) {
            postIds.addAll(stfPostIds);
        }
        Long origPersonId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        Long origDepId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
        Long origEmpId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("employee"));
        Map<Long, DynamicObject> postMap = EmpSupRelEditPlugin.getBaseDataMap(postIds, "hbpm_positionhr");
        for (Long superiorId : personIds) {
            DynamicObject roleDy;
            DynamicObject fileDy = personModelMap.get(superiorId);
            if (fileDy == null) {
                LOGGER.info("handleAddSuperiorMainFileIsEmpty:", (Object)superiorId);
                continue;
            }
            DynamicObject dbDy = serviceHelper.generateEmptyDynamicObject();
            Object typeObj = this.getModel().getValue("reporttype");
            if (typeObj instanceof DynamicObject) {
                DynamicObject typeDy = (DynamicObject)typeObj;
                dbDy.set("reporttype", (Object)typeDy.getLong("id"));
            }
            dbDy.set("person", (Object)origPersonId);
            dbDy.set("employee", (Object)origEmpId);
            dbDy.set("depemp", (Object)origDepId);
            dbDy.set("businessstatus", (Object)"1");
            if (startDate == null) {
                dbDy.set("startdate", this.getModel().getValue("startdate"));
            } else {
                dbDy.set("startdate", (Object)startDate);
            }
            try {
                dbDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
                dbDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
            }
            catch (Exception exc) {
                LOGGER.error("handleAddSuperior", (Throwable)exc);
            }
            long supIds = fileDy.getLong("person.id");
            long postId = fileDy.getLong("position.id");
            if (postId == 0L) {
                postId = fileDy.getLong("darkposition.id");
            }
            if ((roleDy = postMap.get(postId)) == null) {
                LOGGER.info(MessageFormat.format("handleAddSuperiorSuperEmpty--{0}", origPersonId));
            } else {
                dbDy.set("superiorrole", (Object)roleDy.getLong("workrole"));
            }
            dbDy.set("iscurrentversion", (Object)"1");
            dbDy.set("superiordepemp", fileDy.get("depemp.id"));
            dbDy.set("superior", (Object)supIds);
            dbDy.set("superioremployee", fileDy.get("employee.id"));
            dbDy.set("superioradminorg", fileDy.get("adminorg.id"));
            dbDy.set("initstatus", (Object)"2");
            rtDys.add((Object)dbDy);
        }
        if (rtDys.size() > 0) {
            retMap.put("hrpi_empsuprel", rtDys);
        }
        return retMap;
    }

    private DynamicObject queryDepempDy(Long depEmpId) {
        HRBaseServiceHelper depHelper = new HRBaseServiceHelper("hrpi_depemp");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter depFilter = new QFilter("id", "=", (Object)depEmpId);
        return depHelper.queryOne("id,startdate", new QFilter[]{depFilter, initFilter, dataFilter, curFilter});
    }

    private DynamicObject[] queryManFileDys(List<Long> erManFileIds) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter qFilter = new QFilter("id", "in", erManFileIds);
        return fileHelper.queryOriginalArray("person.id,depemp.id", new QFilter[]{qFilter});
    }

    private DynamicObject[] queryMainFileDys(Set<Long> depEmpIds) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter depFilter = new QFilter("depemp", "in", depEmpIds);
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return fileHelper.query("depemp.id,id", new QFilter[]{depFilter, statusFilter, curFilter, initFilter, dataFilter});
    }

    private DynamicObject[] queryEffectReportDys(Long depEmpId, QFilter qFilter) {
        HRBaseServiceHelper supHelper = new HRBaseServiceHelper("hrpi_empsuprel");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter depFilter = new QFilter("depemp", "=", (Object)depEmpId);
        if (qFilter != null) {
            depFilter.and(qFilter);
        }
        return supHelper.query("id,reporttype,startdate,enddate,superior.name,businessstatus", new QFilter[]{depFilter, curFilter, initFilter, dataFilter});
    }

    private DynamicObject[] queryEffectDys(List<Long> origDepId, Long reportType, String filterField, String cpStr, QFilter dFilter, String loadAll) {
        HRBaseServiceHelper supHelper = new HRBaseServiceHelper("hrpi_empsuprel");
        QFilter depFilter = null;
        if ("depemp".equals(filterField)) {
            depFilter = new QFilter(filterField, cpStr, (Object)origDepId.get(0));
        } else if ("superior".equals(filterField)) {
            depFilter = new QFilter(filterField, cpStr, origDepId);
            depFilter.and(dFilter);
        }
        if (depFilter == null) {
            return null;
        }
        QFilter reportTypeFilter = new QFilter("reporttype", "=", (Object)reportType);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        if ("1".equals(loadAll)) {
            return supHelper.loadDynamicObjectArray(new QFilter[]{depFilter, reportTypeFilter, statusFilter, curFilter, initFilter, dataFilter});
        }
        return supHelper.query("description,startdate,enddate,sysenddate,superior,reporttype,businessstatus,boid,bsed,bsled,datastatus,iscurrentversion,superiordepemp", new QFilter[]{depFilter, reportTypeFilter, statusFilter, curFilter, initFilter, dataFilter});
    }

    public static DynamicObject[] getEmpposerel(Long depId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter empQf = new QFilter("depemp", "=", (Object)depId);
        QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("id,adminorg,position,stdposition", new QFilter[]{empQf, currentQf, initFilter, dataFilter});
    }

    public static DynamicObject[] getBatchPrimaryErmanFile(String props, List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter bussQf = new QFilter("businessstatus", "=", (Object)"1");
        QFilter primaryStatusQf = new QFilter("isprimary", "=", (Object)"1");
        QFilter empQf = new QFilter("person.id", "in", personIds);
        QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        return serviceHelper.queryOriginalArray(props, new QFilter[]{bussQf, empQf, primaryStatusQf, currentQf, initFilter, dataFilter});
    }

    public static Map<Long, DynamicObject> getBaseDataMap(List<Long> postIds, String entityName) {
        HRBaseServiceHelper postHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "in", postIds);
        DynamicObject[] dynamicObjects = postHelper.queryOriginalArray("id,workrole", new QFilter[]{qFilter});
        return EmpSupRelEditPlugin.buildDataMap(dynamicObjects);
    }

    private static Map<Long, DynamicObject> buildDataMap(DynamicObject[] employeeDys) {
        if (employeeDys != null && employeeDys.length > 0) {
            return Arrays.stream(employeeDys).collect(Collectors.toMap(appDy -> appDy.getLong("id"), appDy -> appDy, (v1, v2) -> v1));
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map spMap = super.diffDialogOrForm();
        Object newVerObj = spMap.get("cachenewversion");
        if (newVerObj instanceof String) {
            String newVer = (String)newVerObj;
            if (HRStringUtils.isEmpty((String)newVer)) {
                spMap.put("mapnewversion", "1");
            }
        } else {
            spMap.put("mapnewversion", "1");
        }
        if (!this.isNewVersion(spMap)) {
            spMap.put("specialcard", "specialcard");
        } else {
            spMap.put("specialcard", "newspecialcard");
            spMap.put("pleanwidth", "50%");
        }
        return spMap;
    }

    private boolean isNewVersion(Map<String, Object> diffMap) {
        String oldVer;
        String mapVersionInfo = "1";
        String cacheVersionInfo = "1";
        Object newVerObj = diffMap.get("mapnewversion");
        if (newVerObj instanceof String) {
            mapVersionInfo = (String)diffMap.get("mapnewversion");
        }
        if (this.getView() != null && HRStringUtils.isNotEmpty((String)(oldVer = (String)this.getView().getFormShowParameter().getCustomParam("formnewversion")))) {
            cacheVersionInfo = oldVer;
        }
        return "1".equals(mapVersionInfo) && "1".equals(cacheVersionInfo);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("superior".equals(name) || "superior_1010".equals(name)) {
            Long origPersonId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
            QFilter filter = new QFilter("id", "!=", (Object)origPersonId);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        } else if ("reporttype".equals(name)) {
            QFilter statusFilter;
            Long depEmpId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("depemp"));
            Object[] repDys = this.queryEffectReportDys(depEmpId, statusFilter = new QFilter("businessstatus", "=", (Object)"1"));
            if (HRArrayUtils.isNotEmpty((Object[])repDys)) {
                Set repIds = Arrays.stream(repDys).map(dy -> dy.getLong(this.REPORTTYPE_ID)).collect(Collectors.toSet());
                QFilter filter = new QFilter("id", "not in", repIds);
                beforeF7SelectEvent.getCustomQFilters().add(filter);
            }
        } else if ("newsuperior".equals(name) || "newsuperior_1010".equals(name)) {
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            QFilter filter = new QFilter("businessstatus", "=", (Object)"1");
            customQFilters.add(filter);
            QFilter pFilter = new QFilter("empentrel.labrelstatusprd.id", "=", (Object)CommonConstants.ON_PRD);
            customQFilters.add(pFilter);
            String fileCachedStr = this.getView().getPageCache().get("fileids");
            if (HRStringUtils.isEmpty((String)fileCachedStr)) {
                return;
            }
            List fileIds = (List)SerializationUtils.fromJsonString((String)fileCachedStr, List.class);
            if (!CollectionUtils.isEmpty((Collection)fileIds)) {
                QFilter idFilter = new QFilter("id", "not in", (Object)fileIds);
                customQFilters.add(idFilter);
            }
            this.queryLat(beforeF7SelectEvent, "affiliateadminorg", "affiliateadminorg");
            this.queryLat(beforeF7SelectEvent, "empgroup", "empgroup");
            this.queryLat(beforeF7SelectEvent, "managingscope", "hbsscmpemp");
        }
    }

    private void queryLat(BeforeF7SelectEvent beforeF7SelectEvent, String perField, String dbField) {
        if ("affiliateadminorg".equals(perField)) {
            AuthorizedOrgResult result = ErManFileQfilter.getAdminOrgAuth((String)"hspm_erfilequery", (String)perField);
            if (result != null && !result.isHasAllOrgPerm()) {
                QFilter filter1 = new QFilter(dbField, "in", (Object)result.getHasPermOrgs());
                beforeF7SelectEvent.getCustomQFilters().add(filter1);
            }
        } else {
            DimValueResult fieldMapQFilter = ErManFileQfilter.getFieldMapQFilter((String)"hspm_erfilequery", (String)perField);
            if (fieldMapQFilter.isAll()) {
                return;
            }
            Set dimValues = fieldMapQFilter.getDimValueIds();
            if (dimValues.size() > 0) {
                HashSet<Long> pkIds = new HashSet<Long>(dimValues.size());
                for (String dimValue : dimValues) {
                    if (!HRStringUtils.isNotEmpty((String)dimValue)) continue;
                    pkIds.add(Long.parseLong(dimValue));
                }
                if (!CollectionUtils.isEmpty(pkIds)) {
                    QFilter filter = new QFilter(dbField, "in", pkIds);
                    beforeF7SelectEvent.getCustomQFilters().add(filter);
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        super.afterF7Select(afterF7SelectEvent);
        Control source = (Control)afterF7SelectEvent.getSource();
        String name = source.getKey();
        if (!this.getModel().getDataEntityType().getProperties().containsKey((Object)name)) {
            return;
        }
        if (!"superior".equals(name) && !"superior_1010".equals(name)) {
            return;
        }
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection(name);
        if (collection == null || collection.size() == 0) {
            return;
        }
        Set collect = collection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toSet());
        QFilter empFilter = new QFilter("laborrelstatus.labrelstatusprd", "!=", (Object)HspmCommonConstants.NUMBER_1010_ID);
        QFilter idFilter = new QFilter("person.id", "in", collect);
        QFilter lastRecordFilter = new QFilter("islatestrecord", "=", (Object)"1");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] objects = employeeHelper.query("person.id", new QFilter[]{empFilter, idFilter, versionFilter, lastRecordFilter, QFilterUtil.getInitStatusFinish(), dataFilter});
        if (objects != null && objects.length > 0) {
            Set longSet = Arrays.stream(objects).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                long aLong = next.getDynamicObject("fbasedataid").getLong("id");
                if (!longSet.contains(aLong)) continue;
                iterator.remove();
            }
            this.getModel().setValue(name, (Object)collection);
            this.getView().updateView(name);
        }
    }
}

