/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.edit.PersonEdit;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hspm.formplugin.web.schedule.draw.dialogform.EmpSupRelEditPlugin;
import kd.hr.hspm.formplugin.web.schedule.service.BusinessService;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class EmpTutorEditPlugin
extends AbstractFormDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(EmpSupRelEditPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
        PersonEdit tutorEdit = (PersonEdit)this.getControl("tutor");
        tutorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)formShowParameter.getStatus()) || OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
            this.setValueFromDb(formShowParameter, "hrpi_emptutor", null);
            this.setAttachment(this.getPageMappingFormId(), this.getAttachmentKey());
            this.setMainInfo();
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
        if ("tutor".equals(name)) {
            this.setMainInfo();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object tutorObj;
        super.beforeF7Select(beforeF7SelectEvent);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("tutor".equals(name) && (tutorObj = formShowParameter.getCustomParam("tutors")) instanceof List) {
            List tutorList = (List)tutorObj;
            if (CollectionUtils.isEmpty((Collection)tutorList)) {
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter().getShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "not in", (Object)tutorList));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnsave".equals(key)) {
            DynamicObject personDy = (DynamicObject)this.getModelVal("tutor");
            if (personDy == null) {
                return;
            }
            long personId = personDy.getLong("id");
            Map checkMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{Collections.singletonList(personId), "person"});
            Boolean onBrd = (Boolean)checkMap.get(personId);
            if (!onBrd.booleanValue()) {
                String tip = ResManager.loadKDString((String)"\u5bfc\u5e08\u5df2\u79bb\u804c\uff0c\u8bf7\u4fee\u6539\u5bfc\u5e08\u4fe1\u606f\u3002", (String)"EmpTutorEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tip);
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.commonSaveClickEvent(evt);
    }

    private void setMainInfo() {
        DynamicObject personDy = (DynamicObject)this.getModelVal("tutor");
        if (personDy == null) {
            return;
        }
        long personId = personDy.getLong("id");
        Map<String, Map<String, Object>> mainDyMap = BusinessService.getInstance().queryMainInfo(Collections.singletonList(personId));
        Map<String, Object> mainEmpPosMap = mainDyMap.get(String.valueOf(personId));
        if (HRMapUtils.isEmpty(mainEmpPosMap)) {
            LOGGER.warn("getPersonInfoFilterEmpty");
            return;
        }
        String postType = (String)mainEmpPosMap.get("apositiontype");
        String postText = "";
        if ("1".equals(postType)) {
            postText = (String)mainEmpPosMap.get("position");
        } else if ("2".equals(postType)) {
            postText = (String)mainEmpPosMap.get("job");
        } else if ("0".equals(postType)) {
            postText = (String)mainEmpPosMap.get("stdposition");
        }
        if (this.isFieldExist("companytext")) {
            this.setModelVal("companytext", mainEmpPosMap.get("company"));
        }
        if (this.isFieldExist("adminorgtext")) {
            this.setModelVal("adminorgtext", mainEmpPosMap.get("adminorg"));
        }
        if (this.isFieldExist("positiontext")) {
            this.setModelVal("positiontext", postText);
        }
    }
}

