/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class LanguageSkillsEditPlugin
extends AbstractFormDrawEdit
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(LanguageSkillsEditPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            this.setValueFromDb(formShowParameter, "hrpi_languageskills", null);
            this.setAttachment("hrpi_languageskills", "attachmentpanelap_std");
            if (this.isFieldExist("language")) {
                DynamicObject language = dataEntity.getDynamicObject("language");
                if (language != null) {
                    this.getPageCache().put("language", language.getString("id"));
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"languagecert"});
                }
            }
        } else if (status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"languagecert"});
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (key.equals("btnsave")) {
            Map result;
            if (status.equals((Object)OperationStatus.EDIT)) {
                Map result2 = this.updateAttachData("hrpi_languageskills", this.getView(), true, null);
                if (((Boolean)result2.get("success")).booleanValue()) {
                    Object pkId = this.getView().getFormShowParameter().getCustomParam("pkid");
                    this.successAfterSave(pkId, result2, "attachmentpanelap_std", "hrpi_languageskills");
                }
            } else if (status.equals((Object)OperationStatus.ADDNEW) && ((Boolean)(result = this.addAttachData("hrpi_languageskills", this.getView(), this.getModel().getDataEntity(), true)).get("success")).booleanValue()) {
                Long newInsertSkillId = (Long)((List)((HashMap)((List)result.get("data")).get(0)).get("ids")).get(0);
                this.successAfterSave(newInsertSkillId, result, "attachmentpanelap_std", "hrpi_languageskills");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (newValue != null) {
            switch (fieldKey) {
                case "language": {
                    DynamicObject language = (DynamicObject)newValue;
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"languagecert"});
                    this.setValueIfExist("languagecert", "");
                    this.getPageCache().put("language", language.getString("id"));
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"language")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"languagecert"});
            this.setValueIfExist("languagecert", "");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
        BasedataEdit control = (BasedataEdit)this.getControl("languagecert");
        if (control == null) {
            return;
        }
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void remove(UploadEvent evt) {
        Object[] attachs = evt.getUrls();
        Map attachment = (Map)attachs[0];
        Object removeUid = attachment.get("uid");
        String removeUidString = this.getPageCache().get("removeUid");
        Set<String> removeUidSet = new HashSet<String>(attachs.length);
        if (!HRStringUtils.isEmpty((String)removeUidString)) {
            removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
        }
        removeUidSet.add(removeUid.toString());
        String attachJsonString = this.getPageCache().get(evt.getCallbackKey());
        this.getPageCache().put("removeUid", SerializationUtils.toJsonString(removeUidSet));
        List attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        List saveAttachments = attachments.stream().filter(attach -> !attach.get("uid").equals(removeUid)).collect(Collectors.toList());
        this.getPageCache().put("attachmentpanelap_std", SerializationUtils.toJsonString(saveAttachments));
        this.getPageCache().put("isAttachChanged", "1");
    }

    public void upload(UploadEvent evt) {
        Object[] attachs = evt.getUrls();
        List attachments = new ArrayList(attachs.length);
        String callbackKey = evt.getCallbackKey();
        String attachJsonString = this.getPageCache().get(callbackKey);
        if (!HRStringUtils.isEmpty((String)attachJsonString)) {
            attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        }
        ArrayList finalAttachments = attachments;
        Arrays.stream(attachs).map(attObj -> (Map)attObj).forEach(attachment -> finalAttachments.add(attachment));
        this.getPageCache().put(callbackKey, SerializationUtils.toJsonString(finalAttachments));
        this.getPageCache().put("isAttachChanged", "1");
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("attachmentpanelap_std", "attachmentpanelap_std");
        return diffMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String languageIdStr = this.getPageCache().get("language");
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)languageIdStr) && HRStringUtils.equals((String)name, (String)"languagecert")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter typeQFilter = new QFilter("languagetype", "=", (Object)Long.parseLong(languageIdStr));
            qFilters.add(typeQFilter);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        }
    }
}

