/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.ServiceFactory;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.hr.hspm.common.entity.ocr.IdCardBackResult;
import kd.hr.hspm.common.entity.ocr.IdCardFrontResult;
import kd.hr.hspm.formplugin.web.schedule.utils.PercreFieldUtils;
import kd.sdk.hr.hspm.business.helper.FieldPermHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.entity.PercreField;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.ApCreateUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.FieldContainerViewService;

public class PercreDrawPlugin
extends AbstractFormDrawEdit {
    private static final Log logger = LogFactory.getLog(PercreDrawPlugin.class);
    private final FieldContainerViewService fieldContainerViewService = new FieldContainerViewService();
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_percre");
    private List<String> CERTIFICATE_FLEX_COLUMN = Arrays.asList("credentialstype", "ismajor");
    private List<String> ATTACHMENT_FLEX_COLUMN = Arrays.asList("faceimage", "reverseimage", "attachmentpanelap_std");
    private List<String> DETAIL_FLEX_COLUMN = Arrays.asList("percardname", "number", "lastnameen", "firstnameen", "lastnamecn", "firstnamecn", "gender", "birthday", "nationality", "countrycode", "issuedate", "expirationdate", "issuingplace", "issuingauthor", "isnofixedterm", "birthplace", "idcardaddress", "isidentity", "folk");
    private static final Set<String> ALL_COLUMN = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"credentialstype", "number", "expirationdate", "countrycode", "issuingauthor", "issuedate", "isnofixedterm", "birthplace", "idcardaddress", "birthday", "lastnameen", "firstnameen", "lastnamecn", "firstnamecn", "nationality", "isidentity", "ismajor", "gender", "issuingplace", "folk", "faceimage", "reverseimage", "percardname"}));
    private static final String FACE_IMAGE = "faceimagebigpic";
    private static final String REVERSE_IMAGE = "reverseimagebigpic";
    private static final String PERCRE_TYPE_NUMBER = "credentialstype.number";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        formShowParameter.getCustomParams().put("params", FieldPermHelper.adjustConfigParamByFieldRules((String)((String)formShowParameter.getCustomParam("params"))));
    }

    public void beforeBindData(EventObject eventObject) {
        DateEdit birthday;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"credentialstype"});
            this.setValueFromDb(formShowParameter, "hrpi_percre", null);
            Long person = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
            if (this.getInfo(person).length == 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ismajor"});
            }
            boolean fPic = this.getModel().getDataEntity().containsProperty("faceimage");
            boolean rPic = this.getModel().getDataEntity().containsProperty("reverseimage");
            if (fPic) {
                String fPath = (String)this.getModel().getValue("faceimage");
                this.getView().getPageCache().put("oldfaceimagepathcache", fPath);
            }
            if (rPic) {
                String rPath = (String)this.getModel().getValue("reverseimage");
                this.getView().getPageCache().put("oldreverseimagepathcache", rPath);
            }
        }
        super.beforeBindData(eventObject);
        if (!HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        if (this.isFieldExist("birthday")) {
            birthday = (DateEdit)this.getControl("birthday");
            birthday.setMaxDate(new Date());
        }
        if (this.isFieldExist("issuedate")) {
            birthday = (DateEdit)this.getControl("issuedate");
            birthday.setMaxDate(new Date());
        }
        this.getModel().setDataChanged(false);
    }

    protected Map<String, List<DrawFormFieldDto>> getFlexFields() {
        HashMap<String, List<DrawFormFieldDto>> map = new HashMap<String, List<DrawFormFieldDto>>(4);
        List<DrawFormFieldDto> certificateFlexInfo = this.formatCertificateFlexInfo();
        List<DrawFormFieldDto> attachmentFlexInfo = this.formatAttachmentFlexInfo();
        List<DrawFormFieldDto> detailFlexInfo = this.formatDetailFlexInfo();
        map.put("certificateflex", certificateFlexInfo);
        map.put("picflex", attachmentFlexInfo);
        map.put("detailflex", detailFlexInfo);
        return map;
    }

    protected void drawMainFlex(List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, Map<String, Object> tabList, IFormView view) {
        flexPanelAp.setWrap(false);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("params");
        List drawFormFields = this.getAllFieldList(param);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        flexPanelAp.getItems().add(this.formatCertificateFlexInfoAp(drawFormFields));
        flexPanelAp.getItems().add(this.formatAttachmentFlexInfoAp(drawFormFields, status));
        flexPanelAp.getItems().add(this.formatDetailFlexInfoAp(drawFormFields));
    }

    private FlexPanelAp formatCertificateFlexInfoAp(List<DrawFormFieldDto> drawFormFields) {
        List collect = drawFormFields.stream().filter(configField -> {
            if (configField.getField().equals("ismajor")) {
                configField.setClassSimpleName(BooleanProp.class.getSimpleName());
            }
            return new HashSet<String>(this.CERTIFICATE_FLEX_COLUMN).contains(configField.getField());
        }).collect(Collectors.toList());
        String typeName = ResManager.loadKDString((String)"\u7c7b\u578b", (String)"PercreDrawPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        FlexPanelAp flexPanelAp = this.fieldContainerViewService.redrawAdconAp(collect, "containerFlex_1", typeName, "pertype", this.diffMap, this.getView(), null);
        flexPanelAp.setGrow(0);
        return flexPanelAp;
    }

    private FlexPanelAp formatAttachmentFlexInfoAp(List<DrawFormFieldDto> drawFormFields, OperationStatus status) {
        List collect = drawFormFields.stream().filter(configField -> new HashSet<String>(this.ATTACHMENT_FLEX_COLUMN).contains(configField.getField())).collect(Collectors.toList());
        String typeName = ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PercreDrawPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        FlexPanelAp flexPanelAp = this.fieldContainerViewService.redrawAdconAp(collect, "containerFlex_2", typeName, "perattach", this.diffMap, this.getView(), null);
        flexPanelAp.setDirection("row");
        flexPanelAp.setJustifyContent("center");
        flexPanelAp.setAlignItems("center");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("-50px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        flexPanelAp.setGrow(0);
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.setDefaultTips(flexPanelAp);
        }
        return flexPanelAp;
    }

    private void setDefaultTips(FlexPanelAp flexPanelAp) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey("percretips");
        String typeName = ResManager.loadKDString((String)"\u56fe\u7247\u63d0\u793a", (String)"PercreDrawPlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        flexAp.setName(new LocaleString(typeName));
        flexAp.setAlignContent("center");
        flexAp.setJustifyContent("center");
        flexAp.setDirection("column");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("10%");
        style.setMargin(margin);
        flexAp.setStyle(style);
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("imageap");
        imageAp.setImageKey("images/pc/emotion/hr_zwzzlx_280_160.png");
        imageAp.setWidth(new LocaleString("280px"));
        imageAp.setHeight(new LocaleString("160px"));
        imageAp.setAlignSelf("center");
        flexAp.getItems().add(imageAp);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label_tip");
        labelAp.setId("label_tip");
        labelAp.setAlignSelf("center");
        labelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60a8\u8981\u65b0\u589e\u7684\u8bc1\u4ef6\u7c7b\u578b\u3002", (String)"PercreDrawPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        flexAp.getItems().add(labelAp);
        flexPanelAp.getItems().add(flexAp);
    }

    private FlexPanelAp formatDetailFlexInfoAp(List<DrawFormFieldDto> drawFormFields) {
        List collect = drawFormFields.stream().filter(configField -> new HashSet<String>(this.DETAIL_FLEX_COLUMN).contains(configField.getField())).collect(Collectors.toList());
        String typeName = ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f", (String)"PercreDrawPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        FlexPanelAp flexPanelAp = this.fieldContainerViewService.redrawAdconAp(collect, "containerFlex_3", typeName, "perfield", this.diffMap, this.getView(), null);
        flexPanelAp.setGrow(0);
        return flexPanelAp;
    }

    private List<DrawFormFieldDto> formatCertificateFlexInfo() {
        ArrayList<DrawFormFieldDto> drawFormFieldList = new ArrayList<DrawFormFieldDto>();
        String mainType = ResManager.loadKDString((String)"\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        drawFormFieldList.add(new DrawFormFieldDto().setField("credentialstype").setName(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"PercreDrawPlugin_11", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("hbss_credentialstype"));
        drawFormFieldList.add(new DrawFormFieldDto().setField("ismajor").setName(mainType).setAlias(mainType).setFireUptEvt(true).setClassSimpleName(BooleanProp.class.getSimpleName()));
        return drawFormFieldList;
    }

    private List<DrawFormFieldDto> formatAttachmentFlexInfo() {
        ArrayList<DrawFormFieldDto> drawFormFieldList = new ArrayList<DrawFormFieldDto>();
        String attach = ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PercreDrawPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        drawFormFieldList.add(new DrawFormFieldDto().setField("attachmentpanelap_std").setName(attach).setAlias(attach).setFireUptEvt(true).setClassSimpleName(AttachmentProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("faceimage").setName(ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"PercreDrawPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u4eba\u50cf\u9762", (String)"PercreDrawPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(PictureProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("reverseimage").setName(ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"PercreDrawPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u56fd\u5fbd\u9762", (String)"PercreDrawPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(PictureProp.class.getSimpleName()));
        return drawFormFieldList;
    }

    private List<DrawFormFieldDto> formatDetailFlexInfo() {
        ArrayList<DrawFormFieldDto> drawFormFieldList = new ArrayList<DrawFormFieldDto>(18);
        String name = ResManager.loadKDString((String)"\u8bc1\u4ef6\u59d3\u540d", (String)"PercreDrawPlugin_14", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String sex = ResManager.loadKDString((String)"\u6027\u522b", (String)"PercreDrawPlugin_19", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String birthday = ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f", (String)"PercreDrawPlugin_20", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String county = ResManager.loadKDString((String)"\u56fd\u7c4d", (String)"PercreDrawPlugin_21", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String countryCode = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a", (String)"PercreDrawPlugin_22", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String issueDate = ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f", (String)"PercreDrawPlugin_23", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String expirationDate = ResManager.loadKDString((String)"\u8bc1\u4ef6\u5230\u671f\u65e5\u671f", (String)"PercreDrawPlugin_24", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String issuingPlace = ResManager.loadKDString((String)"\u7b7e\u53d1\u5730\u70b9", (String)"PercreDrawPlugin_25", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String issuingAuthor = ResManager.loadKDString((String)"\u7b7e\u53d1\u673a\u5173", (String)"PercreDrawPlugin_26", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        String cardNumber = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"PercreDrawPlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        drawFormFieldList.add(new DrawFormFieldDto().setField("number").setName(cardNumber).setAlias(cardNumber).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("percardname").setName(name).setAlias(name).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("lastnameen").setName(ResManager.loadKDString((String)"\u59d3(\u62fc\u97f3/\u82f1\u6587)", (String)"PercreDrawPlugin_15", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("firstnameen").setName(ResManager.loadKDString((String)"\u540d(\u62fc\u97f3/\u82f1\u6587)", (String)"PercreDrawPlugin_16", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("lastnamecn").setName(ResManager.loadKDString((String)"\u59d3(\u4e2d\u6587)", (String)"PercreDrawPlugin_17", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("firstnamecn").setName(ResManager.loadKDString((String)"\u540d(\u4e2d\u6587)", (String)"PercreDrawPlugin_18", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("gender").setName(sex).setAlias(sex).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("hbss_sex").setDisplayStyle(1));
        drawFormFieldList.add(new DrawFormFieldDto().setField("birthday").setName(birthday).setAlias(birthday).setClassSimpleName(DateProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("nationality").setName(county).setAlias(county).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("hbss_nationality"));
        drawFormFieldList.add(new DrawFormFieldDto().setField("countrycode").setName(countryCode).setAlias(countryCode).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("bd_country"));
        drawFormFieldList.add(new DrawFormFieldDto().setField("issuedate").setName(issueDate).setAlias(issueDate).setClassSimpleName(DateProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("expirationdate").setName(expirationDate).setAlias(expirationDate).setClassSimpleName(DateProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("issuingplace").setName(issuingPlace).setAlias(issuingPlace).setClassSimpleName(MuliLangTextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("issuingauthor").setName(issuingAuthor).setAlias(issuingAuthor).setClassSimpleName(MuliLangTextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("isnofixedterm").setName(ResManager.loadKDString((String)"\u662f\u5426\u6c38\u4e45\u6709\u6548", (String)"PercreDrawPlugin_27", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u662f\u5426\u6c38\u4e45\u6709\u6548", (String)"PercreDrawPlugin_27", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(BooleanProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("birthplace").setName(ResManager.loadKDString((String)"\u51fa\u751f\u5730", (String)"PercreDrawPlugin_28", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u51fa\u751f\u5730", (String)"PercreDrawPlugin_28", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(TextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("idcardaddress").setName(ResManager.loadKDString((String)"\u8bc1\u4ef6\u5730\u5740", (String)"PercreDrawPlugin_29", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u8bc1\u4ef6\u5730\u5740", (String)"PercreDrawPlugin_29", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(MuliLangTextProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("isidentity").setName(ResManager.loadKDString((String)"\u662f\u5426\u7528\u4e8e\u8eab\u4efd\u8ba4\u8bc1\uff1f", (String)"PercreDrawPlugin_30", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u662f\u5426\u7528\u4e8e\u8eab\u4efd\u8ba4\u8bc1\uff1f", (String)"PercreDrawPlugin_30", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(BooleanProp.class.getSimpleName()));
        drawFormFieldList.add(new DrawFormFieldDto().setField("folk").setName(ResManager.loadKDString((String)"\u6c11\u65cf", (String)"PercreDrawPlugin_31", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setAlias(ResManager.loadKDString((String)"\u6c11\u65cf", (String)"PercreDrawPlugin_31", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("hr-hspm-formplugin"));
        return drawFormFieldList;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)op.getOperateKey(), (String)"do_save")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long typeId = dataEntity.getLong("credentialstype.id");
            String number = dataEntity.getString("number");
            if (HspmCommonConstants.NUMBER_1010_ID.equals(typeId)) {
                if (!PercreFieldUtils.validNumber(number, this.getView()).booleanValue()) {
                    args.setCancel(true);
                    return;
                }
                if (this.isMultiIdCard(typeId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (this.isPercreNumberRepeat(number, typeId)) {
                args.setCancel(true);
            }
        }
    }

    private boolean isMultiIdCard(Long typeId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        String pkId = (String)formShowParameter.getCustomParam("pkid");
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and("credentialstype", "=", (Object)typeId);
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            qFilter.and(new QFilter("id", "!=", (Object)Long.parseLong(pkId)));
        }
        return this.serviceHelper.count("hrpi_percre", new QFilter[]{qFilter}) > 0;
    }

    private boolean isPercreNumberRepeat(String number, Long typeId) {
        if (HRStringUtils.isNotEmpty((String)number) && typeId != null && typeId > 0L) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String pkId = (String)formShowParameter.getCustomParam("pkid");
            Long percreId = HRStringUtils.isNotEmpty((String)pkId) ? Long.parseLong(pkId) : 0L;
            Tuple checkResult = UniquenessCheckUtil.checkCardNo((Long)percreId, (Long)typeId, (String)number, (boolean)true);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return true;
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult resut = afterDoOperationEventArgs.getOperationResult();
        if (resut.isSuccess() && HRStringUtils.equals((String)key, (String)"do_save")) {
            this.getView().getPageCache().put("isNotAllowedExe", "1");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            OperationStatus status = formShowParameter.getStatus();
            if (OperationStatus.EDIT.equals((Object)status)) {
                this.editSave();
            } else if (OperationStatus.ADDNEW.equals((Object)status)) {
                this.addSave();
            }
        }
    }

    private void addSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        DynamicObject[] info = this.getInfo(personId);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (this.isFieldExist("ismajor")) {
            boolean ismajor = dataEntity.getBoolean("ismajor");
            if (info.length == 0) {
                dataEntity.set("ismajor", (Object)true);
            } else if (ismajor) {
                this.openMajor(Arrays.asList(info), dynamicObjects);
            }
        }
        Map resultMap = this.addAttachData("hrpi_percre", this.getView(), dataEntity, dynamicObjects, false);
        this.successAfterSave(0L, resultMap, "attachmentpanelap_std", "hrpi_percre");
        AttacheHandlerService.getInstance().closeView(this.getView(), resultMap, this.getView().getParentView());
    }

    private void editSave() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        String pkId = (String)formShowParameter.getCustomParam("pkid");
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (this.isFieldExist("ismajor")) {
            DynamicObject[] info = this.getInfo(personId);
            Map<Boolean, List<DynamicObject>> isThisDyList = Stream.of(info).collect(Collectors.partitioningBy(dy -> pkId.equals(dy.getString("id"))));
            List<DynamicObject> thisDyList = isThisDyList.get(Boolean.TRUE);
            DynamicObject currentDbDy = thisDyList.get(0);
            boolean dbMajor = currentDbDy.getBoolean("ismajor");
            boolean isMajor = dataEntity.getBoolean("ismajor");
            if (isMajor && !dbMajor) {
                this.openMajor(isThisDyList.get(Boolean.FALSE), dynamicObjects);
            } else if (!isMajor && dbMajor) {
                this.closeMajor(isThisDyList.get(Boolean.FALSE), dynamicObjects);
            }
        }
        dynamicObjects.add((Object)this.createCurrentDy("hrpi_percre", this.getView(), null, null));
        Map stringObjectMap = this.updateAttachData("hrpi_percre", this.getView(), dynamicObjects, false);
        this.successAfterSave(pkId, stringObjectMap, "attachmentpanelap_std", "hrpi_percre");
        AttacheHandlerService.getInstance().closeView(this.getView(), stringObjectMap, this.getView().getParentView());
    }

    private DynamicObjectCollection closeMajor(List<DynamicObject> info, DynamicObjectCollection dynamicObjects) {
        DynamicObject otherDy;
        if (CollectionUtils.isEmpty(info)) {
            return dynamicObjects;
        }
        if (info.size() == 1) {
            otherDy = info.get(0);
        } else if (info.size() > 1) {
            otherDy = (DynamicObject)info.stream().max((dy1, dy2) -> {
                Date dy2Time;
                Date dy1Time = dy1.getDate("createtime");
                if (HRDateTimeUtils.dayAfter((Date)dy1Time, (Date)(dy2Time = dy2.getDate("createtime")))) {
                    return 1;
                }
                return -1;
            }).get();
        } else {
            return dynamicObjects;
        }
        otherDy.set("ismajor", (Object)true);
        dynamicObjects.add((Object)this.getNewDynamicObject(otherDy));
        if (dynamicObjects.getDynamicObjectType() != null) {
            dynamicObjects.getDynamicObjectType().setExtendName("hrpi_percre");
        }
        return dynamicObjects;
    }

    private DynamicObject getNewDynamicObject(DynamicObject otherDy) {
        DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)otherDy, (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private DynamicObjectCollection openMajor(List<DynamicObject> info, DynamicObjectCollection dynamicObjects) {
        info.stream().filter(dy -> (Boolean)dy.get("ismajor")).forEach(dy -> {
            dy.set("ismajor", (Object)Boolean.FALSE);
            dynamicObjects.add((Object)this.getNewDynamicObject((DynamicObject)dy));
        });
        if (dynamicObjects.getDynamicObjectType() != null) {
            dynamicObjects.getDynamicObjectType().setExtendName("hrpi_percre");
        }
        return dynamicObjects;
    }

    private DynamicObject[] getInfo(Long person) {
        QFilter personFilter = new QFilter("person", "=", (Object)person);
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, curFilter, statusFilter});
    }

    public void upload(UploadEvent evt) {
        Object[] attachs = evt.getUrls();
        List attachments = new ArrayList(attachs.length);
        String attachJsonString = this.getPageCache().get("attachmentpanelap_std");
        if (!HRStringUtils.isEmpty((String)attachJsonString)) {
            attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        }
        ArrayList finalAttachments = attachments;
        Arrays.stream(attachs).map(attObj -> (Map)attObj).forEach(attachment -> finalAttachments.add(attachment));
        this.getPageCache().put("attachmentpanelap_std", SerializationUtils.toJsonString(finalAttachments));
        this.getPageCache().put("isAttachChanged", "1");
    }

    public void remove(UploadEvent evt) {
        Object[] attachs = evt.getUrls();
        Map attachment = (Map)attachs[0];
        Object removeUid = attachment.get("uid");
        String removeUidString = this.getPageCache().get("removeUid");
        Set<String> removeUidSet = new HashSet<String>(attachs.length);
        if (!HRStringUtils.isEmpty((String)removeUidString)) {
            removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
        }
        removeUidSet.add(removeUid.toString());
        String attachJsonString = this.getPageCache().get("attachmentpanelap_std");
        this.getPageCache().put("removeUid", SerializationUtils.toJsonString(removeUidSet));
        List attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        List saveAttachments = attachments.stream().filter(attach -> !attach.get("uid").equals(removeUid)).collect(Collectors.toList());
        this.getPageCache().put("attachmentpanelap_std", SerializationUtils.toJsonString(saveAttachments));
        this.getPageCache().put("isAttachChanged", "1");
    }

    public void afterBindData(EventObject eventObject) {
        DynamicObject credentialstype = this.getModel().getDataEntity().getDynamicObject("credentialstype");
        long type = 0L;
        if (!HRObjectUtils.isEmpty((Object)credentialstype)) {
            type = credentialstype.getLong("id");
        }
        HashSet<String> igSet = new HashSet<String>(16);
        this.setVisibleByType(type, igSet);
        BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)true);
        this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
        this.setAttachment("hrpi_percre", "attachmentpanelap_std");
        this.getModel().setDataChanged(false);
    }

    private void hiddenAndShow(Set<String> showList, boolean showAttachment) {
        Object value;
        this.getView().setVisible(Boolean.TRUE, showList.toArray(new String[0]));
        String[] hiddenArr = (String[])ALL_COLUMN.stream().filter(column -> !showList.contains(column)).toArray(String[]::new);
        this.visibleAttachment(showAttachment, "attachmentpanelap_std");
        this.getView().setVisible(Boolean.FALSE, hiddenArr);
        if (this.isFieldExist("ismajor") && ((value = this.getModel().getValue("ismajor")) == null || HRStringUtils.equals((String)"0", (String)value.toString()))) {
            this.getModel().setValue("ismajor", null);
        }
    }

    private void setVisibleByType(long type, Set<String> ignoreSet) {
        if (type != 0L && !PercreFieldUtils.TYPE_FIELD_MAP.containsKey(type)) {
            type = HspmCommonConstants.NUMBER_1150_ID;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FACE_IMAGE, REVERSE_IMAGE});
        PercreField percreField = PercreFieldUtils.TYPE_FIELD_MAP.get(type);
        Set showList = percreField != null ? percreField.getFieldSet() : PercreFieldUtils.DEFAULT_SHOW;
        this.getPageCache().put("showlist", SerializationUtils.toJsonString((Object)showList));
        this.hiddenAndShow(showList, HspmCommonConstants.NUMBER_1150_ID.equals(type));
        if (type == HspmCommonConstants.NUMBER_1010_ID) {
            String imageName = ResManager.loadKDString((String)"\u4eba\u50cf\u9762", (String)"PercreDrawPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            String resImageName = ResManager.loadKDString((String)"\u56fd\u5fbd\u9762", (String)"PercreDrawPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(imageName, resImageName, percreField != null ? percreField.getFaceUrl() : null, percreField != null ? percreField.getReverseUrl() : null);
        } else if (type == HspmCommonConstants.NUMBER_1020_ID) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVERSE_IMAGE});
            String passportLab = ResManager.loadKDString((String)"\u4e2a\u4eba\u8d44\u6599\u9875", (String)"PercreDrawPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(passportLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (type == HspmCommonConstants.NUMBER_1080_ID) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVERSE_IMAGE});
            String officerLab = ResManager.loadKDString((String)"\u5185\u5bb9\u9875", (String)"PercreDrawPlugin_37", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(officerLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (type == HspmCommonConstants.NUMBER_1110_ID) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVERSE_IMAGE});
            String driverLab = ResManager.loadKDString((String)"\u9a7e\u9a76\u8bc1\u4e3b\u9875", (String)"PercreDrawPlugin_38", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(driverLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (type == HspmCommonConstants.NUMBER_1120_ID || type == HspmCommonConstants.NUMBER_1130_ID || type == HspmCommonConstants.NUMBER_1140_ID) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVERSE_IMAGE});
            String workPermitLab = ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u9762", (String)"PercreDrawPlugin_39", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.showDiffBackImg(workPermitLab, null, percreField != null ? percreField.getFaceUrl() : null, null);
        } else if (type == HspmCommonConstants.NUMBER_1150_ID) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FACE_IMAGE, REVERSE_IMAGE});
        } else if (percreField != null) {
            this.showDiffBackImg(null, null, percreField.getFaceUrl(), percreField.getReverseUrl());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FACE_IMAGE, REVERSE_IMAGE});
        }
        ignoreSet.addAll(ALL_COLUMN.stream().filter(item -> !showList.contains(item)).collect(Collectors.toSet()));
        if (!HspmCommonConstants.NUMBER_1150_ID.equals(type)) {
            ignoreSet.add("attachmentpanelap_std");
        }
    }

    private void showDiffBackImg(String imgLab, String resImgLab, String imgUrl, String resImgUrl) {
        HashMap<String, HashMap<String, String>> item;
        HashMap<String, String> map;
        if (HRStringUtils.isEmpty((String)imgLab)) {
            imgLab = ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"PercreDrawPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp labelAp = ApCreateUtils.createLabelAp((String)"faceimageshowlabel", (String)imgLab);
        this.getView().updateControlMetadata(labelAp.getKey(), labelAp.createControl());
        if (HRStringUtils.isEmpty((String)resImgLab)) {
            resImgLab = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"PercreDrawPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        LabelAp resLabelAp = ApCreateUtils.createLabelAp((String)"reverseimageshowlabel", (String)resImgLab);
        this.getView().updateControlMetadata(resLabelAp.getKey(), resLabelAp.createControl());
        if (HRStringUtils.isNotEmpty((String)imgUrl)) {
            map = new HashMap<String, String>(16);
            item = new HashMap<String, HashMap<String, String>>(16);
            map.put("dik", imgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("faceimage", item);
        }
        if (HRStringUtils.isNotEmpty((String)resImgUrl)) {
            map = new HashMap(16);
            item = new HashMap(16);
            map.put("dik", resImgUrl);
            item.put("item", map);
            this.getView().updateControlMetadata("reverseimage", item);
        }
    }

    private void visibleAttachment(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> visableMap = new HashMap<String, Object>(16);
        visableMap.put("policy", "");
        visableMap.put("visible", value);
        visableMap.put("keys", ctlKeys);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setVisible", visableMap);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        FormShowParameter formParameter = this.getView().getFormShowParameter();
        OperationStatus status = formParameter.getStatus();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"percretips"});
        Object oldValue = args.getChangeSet()[0].getOldValue();
        Object newValue = args.getChangeSet()[0].getNewValue();
        long type = this.getModel().getDataEntity().getLong("credentialstype.id");
        DataEntityPropertyCollection properties = this.getView().getModel().getDataEntity().getDataEntityType().getProperties();
        if (newValue == null || type == 0L) {
            if (OperationStatus.EDIT.equals((Object)status)) {
                long[] bizChangeFlags = this.getView().getModel().getDataEntity().getDataEntityState().getBizChangeFlags();
                if ("faceimage".equals(key)) {
                    PercreFieldUtils.setDeletePicFile(this.getView(), newValue, oldValue, "oldfaceimagepathcache");
                    PercreFieldUtils.setFieldChangeTips(this.getView(), properties, "faceimage", bizChangeFlags);
                } else if ("reverseimage".equals(key)) {
                    PercreFieldUtils.setDeletePicFile(this.getView(), newValue, oldValue, "oldreverseimagepathcache");
                    PercreFieldUtils.setFieldChangeTips(this.getView(), properties, "reverseimage", bizChangeFlags);
                }
            }
            return;
        }
        switch (key) {
            case "credentialstype": {
                DynamicObject typeDy = (DynamicObject)newValue;
                Long typeId = typeDy.getLong("id");
                if (this.isFieldExist("reverseimage")) {
                    this.getModel().setValue("reverseimage", (Object)"");
                }
                if (this.isFieldExist("faceimage")) {
                    this.getModel().setValue("faceimage", (Object)"");
                }
                if (HspmCommonConstants.NUMBER_1010_ID.equals(typeId) && this.isMultiIdCard(typeId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreDrawPlugin_33", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                }
                HashSet<String> igSet = new HashSet<String>(16);
                this.setVisibleByType(typeId, igSet);
                this.getView().getPageCache().put("cacheingore", SerializationUtils.toJsonString(igSet));
                for (String field : ALL_COLUMN) {
                    if ("credentialstype".equals(field) || !this.isFieldExist(field) || "ismajor".equals(field)) continue;
                    this.getModel().setValue(field, null);
                }
                boolean isIdentity = typeDy.getBoolean("isidentity");
                if (this.isFieldExist("isidentity")) {
                    this.getModel().setValue("isidentity", (Object)(isIdentity ? "1" : "0"));
                }
                PercreFieldUtils.setInfo(this.getView());
                break;
            }
            case "ismajor": {
                Long personId;
                QFilter qFilter;
                DynamicObject dy;
                Long pkId;
                DynamicObject updateDy;
                if (Boolean.TRUE.equals(Boolean.parseBoolean(newValue.toString()))) {
                    String typeName = this.getModel().getDataEntity().getString("credentialstype.name");
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c06\u6210\u4e3a\u65b0\u7684\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_32", (String)"hr-hspm-formplugin", (Object[])new Object[0]), typeName));
                    break;
                }
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String pkIdStr = (String)formShowParameter.getCustomParam("pkid");
                if (!HRStringUtils.isNotEmpty((String)pkIdStr) || !(updateDy = this.serviceHelper.queryOne("ismajor", (Object)(pkId = Long.valueOf(Long.parseLong(pkIdStr))))).getBoolean("ismajor") || (dy = this.serviceHelper.queryOne("credentialstype", new QFilter[]{qFilter = new QFilter("person", "=", (Object)(personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person")))).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("id", "!=", (Object)pkId))}, "createtime desc")) == null) break;
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c06\u6210\u4e3a\u65b0\u7684\u4e3b\u8bc1\u4ef6", (String)"PercreDrawPlugin_32", (String)"hr-hspm-formplugin", (Object[])new Object[0]), dy.getString("credentialstype.name")));
                break;
            }
            case "faceimage": {
                if (!HRStringUtils.isNotEmpty((String)((String)newValue)) || !HspmCommonConstants.NUMBER_1010_ID.equals(type) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromFaceOcr(newValue.toString());
                break;
            }
            case "reverseimage": {
                if (!HRStringUtils.isNotEmpty((String)((String)newValue)) || !HspmCommonConstants.NUMBER_1010_ID.equals(type) || !HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) break;
                this.refreshFieldFromReverseOcr(newValue.toString());
                break;
            }
            case "number": {
                DynamicObject dy = this.getModel().getDataEntity();
                this.isPercreNumberRepeat(dy.getString("number"), dy.getLong("credentialstype.id"));
                PercreFieldUtils.parseNumber(dy.getString("number"), this.getView());
                break;
            }
            case "isnofixedterm": {
                BusinessUtils.dateChangedAfterSelected((IFormView)this.getView(), (String)"isnofixedterm", (String)"expirationdate", (boolean)false);
                break;
            }
        }
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("attachmentpanelap_std", "attachmentpanelap_std");
        diffMap.put("cacheingore", "cacheingore");
        diffMap.put("card", "card");
        return diffMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromFaceOcr(String url) {
        block15: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                QFilter qFilter;
                HRBaseServiceHelper sexServiceHelper;
                DynamicObject sex;
                AlgoResultData data = ((IHspmOcrService)ServiceFactory.getService(IHspmOcrService.class)).distinguishOcrImage(this.getView().getEntityId(), "OPM-IdCardBack", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    break block15;
                }
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block15;
                }
                IdCardBackResult result = (IdCardBackResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardBackResult.class);
                if (this.isFieldExist("percardname") && HRStringUtils.isNotEmpty((String)result.getName())) {
                    this.getModel().setValue("percardname", (Object)result.getName());
                }
                if (this.isFieldExist("gender") && HRStringUtils.isNotEmpty((String)result.getSex()) && (sex = (sexServiceHelper = new HRBaseServiceHelper("hbss_sex")).loadDynamicObject(qFilter = new QFilter("name", "=", (Object)result.getSex()).and("enable", "=", (Object)"1").and("status", "=", (Object)"C"))) != null) {
                    this.getModel().setValue("gender", (Object)sex);
                }
                if (this.isFieldExist("folk") && HRStringUtils.isNotEmpty((String)result.getNation())) {
                    HRBaseServiceHelper flokServiceHelper = new HRBaseServiceHelper("hbss_flok");
                    String suffix = ResManager.loadKDString((String)"\u65cf", (String)"PercreDrawPlugin_36", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    QFilter qFilter2 = new QFilter("name", "=", (Object)(result.getNation() + suffix)).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
                    DynamicObject folk = flokServiceHelper.loadDynamicObject(qFilter2);
                    if (folk != null) {
                        this.getModel().setValue("folk", (Object)folk);
                    }
                }
                if (this.isFieldExist("birthday") && HRStringUtils.isNotEmpty((String)result.getBirth())) {
                    Date birthday = null;
                    try {
                        birthday = HspmDateUtils.parseDate((String)result.getBirth(), (String)"yyyy-MM-dd");
                    }
                    catch (ParseException parseException) {
                        logger.error("parse date error, birthday: {}", (Object)result.getBirth(), (Object)parseException);
                    }
                    if (birthday != null) {
                        this.getModel().setValue("birthday", (Object)birthday);
                    }
                }
                if (this.isFieldExist("idcardaddress") && HRStringUtils.isNotEmpty((String)result.getAddress())) {
                    this.getModel().setValue("idcardaddress", (Object)result.getAddress());
                }
                if (this.isFieldExist("number") && HRStringUtils.isNotEmpty((String)result.getIdNum())) {
                    this.getModel().setValue("number", (Object)result.getIdNum());
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFieldFromReverseOcr(String url) {
        block10: {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PercreDrawPlugin_41", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            try {
                int sepIndex;
                boolean isNeedSet;
                AlgoResultData data = ((IHspmOcrService)ServiceFactory.getService(IHspmOcrService.class)).distinguishOcrImage(this.getView().getEntityId(), "OPM-IDCardFront", url);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    break block10;
                }
                if (data.getErrorCode() != 0) {
                    this.getView().showErrorNotification(data.getDescription());
                    break block10;
                }
                IdCardFrontResult result = (IdCardFrontResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data.getData()), IdCardFrontResult.class);
                if (HRStringUtils.isNotEmpty((String)result.getAuthority()) && this.isFieldExist("issuingauthor")) {
                    this.getModel().setValue("issuingauthor", (Object)result.getAuthority());
                }
                boolean bl = isNeedSet = HRStringUtils.isNotEmpty((String)result.getValidDate()) && (this.isFieldExist("issuedate") || this.isFieldExist("expirationdate"));
                if (!isNeedSet || (sepIndex = result.getValidDate().indexOf(45)) <= 0) break block10;
                Date issueDate = null;
                Date expirationDate = null;
                try {
                    issueDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(0, sepIndex), (String)"yyyy.MM.dd");
                    expirationDate = HspmDateUtils.parseDate((String)result.getValidDate().substring(sepIndex + 1), (String)"yyyy.MM.dd");
                }
                catch (ParseException parseException) {
                    logger.error("parse date error, validDate: {}", (Object)result.getValidDate(), (Object)parseException);
                }
                if (issueDate != null && this.isFieldExist("issuedate")) {
                    this.getModel().setValue("issuedate", (Object)issueDate);
                }
                if (expirationDate != null && this.isFieldExist("expirationdate")) {
                    this.getModel().setValue("expirationdate", (Object)expirationDate);
                }
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }
}

