/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class PerserlenDrawPlugin
extends AbstractFormDrawEdit {
    private static final String ADJUSTWORKTIME = "adjustworktime";
    private static final String ADJUSTCOMTIME = "adjustcomtime";
    private static final String JOINWORKTIME = "joinworktime";
    private static final String FIRSTJOINCOMDATE = "firstjoincomdate";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hrpi_perserlen");
        super.loadCustomControlMetas(args);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setCancel(true);
        this.getView().updateView();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        this.setValueFromDb(formShowParameter, "hrpi_perserlen", "employee");
        BusinessUtils.setDateLimit((IFormView)this.getView(), (String)"hrpi_perserlen-joinworktime", (boolean)false, (boolean)true);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), (HRDataBaseEdit)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey()) || "edit_label".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btnsave".equals(source.getKey()) || "btnsave_label".equals(source.getKey())) {
            BigDecimal adjustworktime = this.getBigDecimalIfExist("hrpi_perserlen-adjustworktime");
            BigDecimal adjustcomtime = this.getBigDecimalIfExist("hrpi_perserlen-adjustcomtime");
            BigDecimal adjustworkage = this.getBigDecimalIfExist("hrpi_perserlen-adjustworkage");
            if (!this.checkInputData(adjustworktime, JOINWORKTIME)) {
                return;
            }
            if (!this.checkInputData(adjustcomtime, FIRSTJOINCOMDATE)) {
                return;
            }
            if (!this.checkWorkage(adjustworkage, JOINWORKTIME)) {
                return;
            }
            this.acrossEntitySaveOrUpdate();
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        } else if ("btncancel".equals(source.getKey()) || "btncancel_label".equals(source.getKey())) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.clickCancelChanged("");
            } else {
                this.getView().updateView();
            }
        }
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", false);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.contains(ADJUSTWORKTIME)) {
            this.checkInputData((BigDecimal)e.getChangeSet()[0].getNewValue(), JOINWORKTIME);
        } else if (key.contains(JOINWORKTIME)) {
            if (this.getBigDecimalIfExist("hrpi_perserlen-adjustworktime") != null) {
                this.checkInputData((BigDecimal)this.getModelVal("hrpi_perserlen-adjustworktime"), JOINWORKTIME);
            }
        } else if (key.contains(ADJUSTCOMTIME)) {
            this.checkInputData((BigDecimal)e.getChangeSet()[0].getNewValue(), FIRSTJOINCOMDATE);
        }
    }

    private boolean checkInputData(BigDecimal newValue, String startDateField) {
        if (newValue == null) {
            return true;
        }
        Date joinworktime = (Date)this.getModel().getValue("hrpi_perserlen-" + startDateField);
        if (joinworktime == null) {
            if (BigDecimal.ZERO.compareTo(newValue) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u65e5\u671f\u4fe1\u606f,\u518d\u7ef4\u62a4\u8c03\u6574\u503c\u3002", (String)"PerserlenDrawPlugin_11", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        BigDecimal diff = BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinworktime);
        if (newValue.add(diff).compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5e74\u9650\u4e0d\u80fd\u8d85\u51fa\u5f53\u524d\u5b9e\u9645\u5e74\u9650\u3002", (String)"PerserlenDrawPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkWorkage(BigDecimal newValue, String startDateField) {
        if (newValue == null) {
            return true;
        }
        Date workage = (Date)this.getModel().getValue("hrpi_perserlen-" + startDateField);
        BigDecimal diff = BusinessUtils.calcYearsDiff((Date)new Date(), (Date)workage);
        BigDecimal socialworkage = diff.add(newValue);
        if (socialworkage.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u793e\u4f1a\u5de5\u9f84\u4e3a\u975e\u8d1f\u6570\u3002", (String)"PerserlenDrawPlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

