/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.plugin.list;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DateColumnDesc;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class EmpSupRelListPlugin
extends HRDataBaseList {
    Map<Long, Boolean> idVsEndDateIsVisibleMap = Maps.newHashMapWithExpectedSize((int)20);

    public void setFilter(SetFilterEvent e) {
        Object depEmpId = this.getView().getFormShowParameter().getCustomParam("depemp");
        e.getQFilters().add(new QFilter("depemp", "=", depEmpId));
        e.getQFilters().add(new QFilter("datastatus", "in", (Object)new String[]{"1"}));
        e.setOrderBy("reporttype.number asc,enddate desc,startdate asc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("reporttype.name".equals(fieldName)) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            args.getCustomQFilters().add(enableFilter);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageDataCol = e.getPageData();
        for (DynamicObject pageData : pageDataCol) {
            long id = pageData.getLong("id");
            Date endDate = pageData.getDate("enddate");
            if (Objects.isNull(endDate)) {
                this.idVsEndDateIsVisibleMap.put(id, true);
                continue;
            }
            String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            String lastDayStr = HRDateTimeUtils.format((Date)HisEffDateCommonService.getInstance().getDate2999(null), (String)"yyyy-MM-dd");
            if (lastDayStr.equals(endDateStr)) {
                this.idVsEndDateIsVisibleMap.put(id, false);
                continue;
            }
            this.idVsEndDateIsVisibleMap.put(id, true);
        }
    }

    public void packageData(PackageDataEvent e) {
        Long id;
        Boolean endDateIsVisible;
        DateColumnDesc colum;
        Object source = e.getSource();
        if (source instanceof DateColumnDesc && "enddate".equals((colum = (DateColumnDesc)e.getSource()).getKey()) && !(endDateIsVisible = this.idVsEndDateIsVisibleMap.get(id = Long.valueOf(e.getRowData().getLong("id")))).booleanValue()) {
            e.setFormatValue(null);
        }
    }
}

