/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.ServiceFactory;
import kd.hr.hspm.business.mservice.IHspmIdentityService;
import kd.hr.hspm.formplugin.common.IDCardUtils;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.entity.PercreField;
import kd.sdk.hr.hspm.common.utils.CommonUtil;

public class PercreFieldUtils {
    private static final Log LOGGER = LogFactory.getLog(PercreFieldUtils.class);
    public static final Set<String> DEFAULT_SHOW = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"credentialstype"}));
    public static final Map<Long, PercreField> TYPE_FIELD_MAP;
    private static final String PERCARDNAME = "percardname";
    private static final String GENDER = "gender";
    private static final String FOLK = "folk";
    private static final String NATIONALITY = "nationality";
    public static final String FACEIMAGE = "faceimage";
    public static final String REVERSEIMAGE = "reverseimage";

    public static void setInfo(IFormView view) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
        QFilter idFilter = new QFilter("person.id", "=", (Object)personId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_pernontsprop");
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("name", PERCARDNAME);
        fieldMap.put(GENDER, GENDER);
        fieldMap.put(NATIONALITY, NATIONALITY);
        fieldMap.put(FOLK, FOLK);
        fieldMap.put("birthday", "birthday");
        DynamicObject dynamicObject = helper.queryOne(String.join((CharSequence)",", fieldMap.keySet()), new QFilter[]{statusFilter, versionFilter, idFilter});
        if (dynamicObject != null) {
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (!view.getModel().getDataEntityType().getAllFields().containsKey(entry.getValue())) continue;
                if (dynamicObject.get((String)entry.getKey()) instanceof DynamicObject) {
                    DynamicProperty idProperty = view.getModel().getDataEntityType().getProperty((String)entry.getValue() + "_id");
                    idProperty.setValue((Object)view.getModel().getDataEntity(), (Object)dynamicObject.getDynamicObject((String)entry.getKey()).getLong("id"));
                    view.getModel().setValue((String)entry.getValue(), dynamicObject.get((String)entry.getKey() + "_id"));
                    continue;
                }
                view.getModel().setValue((String)entry.getValue(), dynamicObject.get((String)entry.getKey()));
            }
        }
    }

    public static void parseNumber(String number, IFormView view) {
        DynamicObject credentialstype = view.getModel().getDataEntity().getDynamicObject("credentialstype");
        long type = credentialstype.getLong("id");
        if (!HspmCommonConstants.NUMBER_1010_ID.equals(type)) {
            return;
        }
        if (!PercreFieldUtils.validNumber(number, view).booleanValue()) {
            if (view.getModel().getDataEntityType().getAllFields().containsKey("birthday")) {
                view.getModel().setValue("birthday", null);
            }
            if (view.getModel().getDataEntityType().getAllFields().containsKey(GENDER)) {
                view.getModel().setValue(GENDER, null);
            }
            return;
        }
        Date date = CommonUtil.getBirthDayFromIdCard((String)number);
        int sex = CommonUtil.getSexFromIdCard((String)number);
        int age = CommonUtil.getAgeForIdCard((String)number);
        if (view.getModel().getDataEntityType().getAllFields().containsKey("birthday")) {
            view.getModel().setValue("birthday", (Object)date);
        }
        if (view.getModel().getDataEntityType().getAllFields().containsKey(GENDER)) {
            view.getModel().setValue(GENDER, (Object)(sex == 1 ? HspmCommonConstants.NUMBER_1010_ID : (sex == 2 ? HspmCommonConstants.NUMBER_1020_ID : 0L)));
        }
    }

    public static Boolean validNumber(String number, IFormView view) {
        Boolean isValid = ((IHspmIdentityService)ServiceFactory.getService(IHspmIdentityService.class)).validIdentityCardNo(null, "CN01", number);
        if (isValid == null) {
            isValid = IDCardUtils.verify18(number);
        }
        if (!isValid.booleanValue()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercreMobEditPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return isValid;
    }

    public static void setFieldChangeTips(IFormView view, DataEntityPropertyCollection properties, String faceImage, long[] bizChangeFlags) {
        view.getModel().setDataChanged(true);
        int faceOrdinal = ((IDataEntityProperty)properties.get((Object)faceImage)).getOrdinal();
        view.getModel().getDataEntity().getDataEntityState().setBizChanged(faceOrdinal, true);
        if (properties.containsKey((Object)"basedatafield_id")) {
            int hidFieldOrd = ((IDataEntityProperty)properties.get((Object)"basedatafield_id")).getOrdinal();
            view.getModel().getDataEntity().getDataEntityState().setBizChanged(hidFieldOrd, false);
        }
        try {
            if (bizChangeFlags != null && bizChangeFlags.length > 0) {
                view.getModel().getDataEntity().getDataEntityState().setBizChangeFlags(bizChangeFlags);
            }
        }
        catch (Exception ex) {
            LOGGER.error("setFieldChangeTips_Error", (Throwable)ex);
        }
    }

    public static void setDeletePicFile(IFormView view, Object newValue, Object oldValue, String cacheKey) {
        String dbPath = view.getPageCache().get(cacheKey);
        if (oldValue instanceof String) {
            String oldPath = (String)oldValue;
            if (HRStringUtils.isNotEmpty((String)dbPath) && dbPath.equals(oldPath) && newValue == null) {
                view.getModel().getDataEntity().getDataEntityState().setFromDatabase(true);
            } else {
                view.getModel().getDataEntity().getDataEntityState().setFromDatabase(false);
            }
        } else {
            view.getModel().getDataEntity().getDataEntityState().setFromDatabase(false);
        }
    }

    private static void cacheRemoveData(IFormView view, HashMap<String, Object> removeMap) {
        IPageCache pageCache = view.getPageCache();
        String removeKey = "TempRemoveCache" + view.getPageId();
        List<HashMap<String, Object>> cacheList = new ArrayList<HashMap<String, Object>>(16);
        String removeStr = pageCache.get(removeKey);
        if (StringUtils.isNotBlank((CharSequence)removeStr)) {
            cacheList = (List)SerializationUtils.fromJsonString((String)removeStr, List.class);
        }
        cacheList.add(removeMap);
        String cacheMapToString = SerializationUtils.toJsonString(cacheList);
        pageCache.put(removeKey, cacheMapToString);
    }

    static {
        HashMap<Long, PercreField> fieldMap = new HashMap<Long, PercreField>(32);
        fieldMap.put(HspmCommonConstants.NUMBER_1010_ID, new PercreField("/images/pc/cardbackground/hr_sfzzm_200_128.png", "/images/pc/cardbackground/hr_sfzfm_200_128.png", "/images/mobile/business_pic/sfztxm_295_160.png", "/images/mobile/business_pic/sfzghm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", "issuedate", "expirationdate", "issuingauthor", FOLK, "idcardaddress", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1020_ID, new PercreField("/images/pc/cardbackground/hr_hz_200_128.png", null, "/images/mobile/business_pic/hzsy_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, "number", "countrycode", PERCARDNAME, "lastnameen", "firstnameen", "lastnamecn", "firstnamecn", GENDER, "birthday", NATIONALITY, "issuedate", "expirationdate", "issuingplace", "issuingauthor", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1030_ID, new PercreField("/images/pc/cardbackground/hr_gajzz_200_128.png", "/images/pc/cardbackground/hr_gazmbm_200_128.png", "/images/mobile/business_pic/gatjzzzm_295_160.png", "/images/mobile/business_pic/gatjzzfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", "issuedate", "expirationdate", "issuingauthor", FOLK, "idcardaddress", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1040_ID, new PercreField("/images/pc/cardbackground/hr_twjzz_200_128.png", "/images/pc/cardbackground/hr_twzmbm_200_128.png", "/images/mobile/business_pic/gatjzzzm_295_160.png", "/images/mobile/business_pic/gatjzzfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", "issuedate", "expirationdate", "issuingauthor", FOLK, "idcardaddress", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1050_ID, new PercreField("/images/pc/cardbackground/hr_yjz_200_128.png", "/images/pc/cardbackground/hr_yjz_200_128.png", "/images/mobile/business_pic/wgrjltxm_295_160.png", "/images/mobile/business_pic/wgrjlzghm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", NATIONALITY, "issuedate", "expirationdate", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1060_ID, new PercreField("/images/pc/cardbackground/hr_gat_200_128.png", "/images/pc/cardbackground/hr_gazmbm_200_128.png", "/images/mobile/business_pic/gattxzzm_295_160.png", "/images/mobile/business_pic/gatxzzfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", "issuedate", "expirationdate", "issuingplace", "issuingauthor", "birthplace", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1070_ID, new PercreField("/images/pc/cardbackground/hr_twt_200_128.png", "/images/pc/cardbackground/hr_twzmbm_200_128.png", "/images/mobile/business_pic/gattxzzm_295_160.png", "/images/mobile/business_pic/gatxzzfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, REVERSEIMAGE, PERCARDNAME, "number", GENDER, "birthday", "issuedate", "expirationdate", "issuingplace", "issuingauthor", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1080_ID, new PercreField("/images/pc/cardbackground/hr_jgz_200_128.png", null, "/images/mobile/business_pic/jgz_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, "number", "issuingauthor", "issuedate", "expirationdate", PERCARDNAME, "birthday", GENDER, FOLK, "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1090_ID, new PercreField("/images/pc/cardbackground/hr_wlgatxz_200_128.png", "/images/pc/cardbackground/hr_gazmbm_200_128.png", "/images/mobile/business_pic/dlwlzm_295_160.png", "/images/mobile/business_pic/dlwlfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, "number", REVERSEIMAGE, PERCARDNAME, "lastnameen", "firstnameen", "birthday", GENDER, "issuedate", "expirationdate", "issuingauthor", "issuingplace", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1100_ID, new PercreField("/images/pc/cardbackground/hr_wltwtxz_200_128.png", "/images/pc/cardbackground/hr_twzmbm_200_128.png", "/images/mobile/business_pic/dlwlzm_295_160.png", "/images/mobile/business_pic/flwltwfm_295_160.png", (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, "number", REVERSEIMAGE, PERCARDNAME, "lastnameen", "firstnameen", "birthday", GENDER, "issuedate", "expirationdate", "issuingauthor", "issuingplace", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1110_ID, new PercreField("/images/pc/cardbackground/hr_jsz_200_128.png", null, "/images/mobile/business_pic/jsz_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, "number", PERCARDNAME, GENDER, NATIONALITY, "birthday", "idcardaddress", "isnofixedterm", "isidentity", "issuedate", "expirationdate"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1120_ID, new PercreField("/images/pc/cardbackground/hr_wgrgzza_200_128.png", null, "/images/mobile/business_pic/wgrgzxkz_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, PERCARDNAME, "number", GENDER, NATIONALITY, "issuedate", "issuingauthor", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1130_ID, new PercreField("/images/pc/cardbackground/hr_wgrgzzb_200_128.png", null, "/images/mobile/business_pic/wgrgzxkz_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, PERCARDNAME, "number", GENDER, NATIONALITY, "issuedate", "issuingauthor", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1140_ID, new PercreField("/images/pc/cardbackground/hr_wgrgzzc_200_128.png", null, "/images/mobile/business_pic/wgrgzxkz_295_160.png", null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "ismajor", FACEIMAGE, PERCARDNAME, "number", GENDER, NATIONALITY, "issuedate", "issuingauthor", "isnofixedterm", "isidentity"})));
        fieldMap.put(HspmCommonConstants.NUMBER_1150_ID, new PercreField(null, null, null, null, (Set)Sets.newHashSet((Object[])new String[]{"credentialstype", "number", "isnofixedterm", "isidentity"})));
        TYPE_FIELD_MAP = Collections.unmodifiableMap(fieldMap);
    }
}

