/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hspm.business.domian.service.infoclassify.IPereduexpinfoService;
import kd.hr.hspm.opplugin.infoclassify.pereduexpinfo.PereduexpinfoValidator;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;
import kd.sdk.hr.hspm.common.enums.PereduexpcerttypeFieldEnum;
import kd.sdk.hr.hspm.common.enums.PereduexpinfoFieldEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;

public class EduexpSaveOp
extends HRDataBaseOp {
    private final IPereduexpinfoService pereduexpinfoService = IPereduexpinfoService.getInstance();
    private final PereduexpinfoFieldEnum hrpiPereduexpEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXP;
    private final PereduexpinfoFieldEnum hrpiPereduexpcertEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PereduexpinfoValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.insertPereduexpinfo(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        String operationKey = args.getOperationKey();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey((String)operationKey);
        if (HRObjectUtils.isEmpty((Object)operateKeyEnum)) {
            return;
        }
        switch (operateKeyEnum) {
            case FORM_BTN_DO_SAVE: {
                this.saveNew(args, dataEntities);
                break;
            }
            case FORM_BTN_UPDATE: {
                this.saveOverride(args, dataEntities);
                break;
            }
        }
    }

    protected void validateOperateResult(BeginOperationTransactionArgs args, HrpiServiceOperateResult operateResult) {
        this.validateOperateResult(args, operateResult, true);
    }

    protected void validateOperateResult(BeginOperationTransactionArgs args, HrpiServiceOperateResult operateResult, boolean cancelOperationFlag) {
        if (!operateResult.isSuccess()) {
            if (cancelOperationFlag) {
                args.setCancelOperation(true);
            }
            throw new KDBizException(operateResult.getMessage());
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = dataEntity.getLong("id");
            DynamicObject dbDy = this.pereduexpinfoService.getPereduexpinfo(pkId);
            Map<String, Boolean> checkChangedMap = this.checkChanged(dataEntity, dbDy);
            boolean flag = false;
            for (Boolean checked : checkChangedMap.values()) {
                if (!checked.booleanValue()) continue;
                flag = true;
                break;
            }
            if (this.isNoDataChanged(args, flag)) continue;
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.updatePereduexpinfo(pkId, dataEntity, checkChangedMap);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected boolean isNoDataChanged(BeginOperationTransactionArgs args, boolean compareResult) {
        if (!compareResult) {
            args.setCancelOperation(true);
            this.getOperationResult().setMessage("the entity has not changed.");
            return true;
        }
        return false;
    }

    private void putAppCache(List<Long> pereduexpcertIdList) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hr");
        String pereduexpcertIdListCacheKey = String.format("removePereduexpcertIdList_%s_%s", PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), RequestContext.get().getCurrUserId());
        ihrAppCache.put(pereduexpcertIdListCacheKey, pereduexpcertIdList);
    }

    private Map<String, Boolean> checkChanged(DynamicObject dataEntity, DynamicObject dbDy) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        String extendName = dataEntity.getDataEntityType().getExtendName();
        boolean pereduexpChangeFlag = false;
        pereduexpChangeFlag = HRStringUtils.equals((String)extendName, (String)"hspm_pereduexp_dg") ? DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)dataEntity.getString("eduprops")) : DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
        resultMap.put(this.hrpiPereduexpEnum.getFormKey(), pereduexpChangeFlag);
        Long pkId = dataEntity.getLong("id");
        Map pereduexpcertDyMap = this.pereduexpinfoService.queryMapPereduexpcert(pkId);
        List certtypeIdList = this.pereduexpinfoService.queryCerttype();
        for (Long certtypeId : certtypeIdList) {
            if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)("operatetype_" + certtypeId))) continue;
            String operateType = dataEntity.getString("operatetype_" + certtypeId);
            if (!HRStringUtils.isEmpty((String)operateType) && HRStringUtils.equals((String)operateType, (String)"0")) {
                resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), Boolean.TRUE);
            }
            if (HRStringUtils.isEmpty((String)operateType) || !HRStringUtils.equals((String)operateType, (String)"1")) continue;
            DynamicObject pereduexpcertDy = this.pereduexpinfoService.coverPereduexpinfoToPereduexpcert(dataEntity, certtypeId);
            DynamicObject pereduexpcertDbDy = (DynamicObject)pereduexpcertDyMap.get(certtypeId);
            if (HRObjectUtils.isEmpty((Object)pereduexpcertDbDy)) {
                resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), Boolean.TRUE);
                continue;
            }
            boolean pereduexpcertChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)pereduexpcertDy, (DynamicObject)pereduexpcertDbDy, (String)PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId));
            resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), pereduexpcertChangeFlag);
        }
        return resultMap;
    }
}

