/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.percontact;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.service.infoclassify.IPercontactService;
import kd.hr.hspm.opplugin.infoclassify.percontact.PercontactValidator;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PercontactSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PercontactSaveOp.class);
    private final IPercontactService percontactService = IPercontactService.getInstance();
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final Map<Long, HrpiServiceOperateResult> operateResultMap = new HashMap<Long, HrpiServiceOperateResult>(16);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PercontactValidator());
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.percontactService.getPercontactByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.percontactService.updatePercontact(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.percontactService.getPercontactByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (!compareResult) {
                this.getOperationResult().setMessage("the entity has not changed.");
                LOGGER.info("the entity has not changed.");
                continue;
            }
            HrpiServiceOperateResult operateResult = this.percontactService.saveImportPercontact("override", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void afterSaveOverride(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveOverride(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveImport(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveImport(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    private void sendChangeInfoSyncToSysUser() {
        if (!this.operateResultMap.isEmpty()) {
            List personIdList = this.operateResultMap.entrySet().stream().filter(entry -> ((HrpiServiceOperateResult)entry.getValue()).isSyncFlag()).map(Map.Entry::getKey).collect(Collectors.toList());
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(personIdList);
        }
    }
}

