/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.percontact;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.opplugin.InfoClassifyValidator;

public class PercontactValidator
extends InfoClassifyValidator {
    protected void validateNew(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validatePhone(dataEntity);
            this.validatePerEmail(dataEntity);
        }
    }

    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    protected void validateImportOverride(ExtendedDataEntity[] dataEntities) {
        this.validateOverride(dataEntities);
    }

    private void validatePhone(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        String phoneDy = dy.getString("phone");
        String otherphoneDy = dy.getString("otherphone");
        this.validatePhone(dataEntity, phoneDy, ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u7801\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercontactValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        if (HRStringUtils.isNotEmpty((String)otherphoneDy)) {
            this.validatePhone(dataEntity, otherphoneDy, ResManager.loadKDString((String)"\u201c\u5176\u4ed6\u624b\u673a\u53f7\u7801\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercontactValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        this.validatePhoneUniqueness(dataEntity);
    }

    private void validatePhoneUniqueness(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        String phone = dy.getString("phone");
        Long personId = dy.getLong("person.id");
        Tuple checkResult = UniquenessCheckUtil.checkPhone((long)personId, (String)phone, (boolean)true);
        if (!((Boolean)checkResult.item1).booleanValue()) {
            this.addFatalErrorMessage(dataEntity, (String)checkResult.item2);
        }
    }

    private void validatePhone(ExtendedDataEntity dataEntity, String phoneDy, String defaultErrMsg) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phoneDy);
        if (!telephoneParseResult.isSuccess()) {
            this.addFatalErrorMessage(dataEntity, telephoneParseResult.getErrorMsg());
            return;
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            this.addFatalErrorMessage(dataEntity, defaultErrMsg);
            return;
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            this.addFatalErrorMessage(dataEntity, (String)result.get("message"));
        }
    }

    private void validatePerEmail(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        String peremail = dy.getString("peremail");
        String busEmail = dy.getString("busemail");
        Long personId = dy.getLong("person.id");
        if (HRStringUtils.isNotEmpty((String)peremail) && !BusinessUtils.isEmail((String)peremail)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4e2a\u4eba\u7535\u5b50\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercontactValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)busEmail) && !BusinessUtils.isEmail((String)busEmail)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u516c\u53f8\u7535\u5b50\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercontactValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        Tuple checkResult = UniquenessCheckUtil.checkPerEmail((long)personId, (String)peremail, (boolean)true);
        if (!((Boolean)checkResult.item1).booleanValue()) {
            this.addFatalErrorMessage(dataEntity, (String)checkResult.item2);
        }
    }
}

