/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.percre;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPercreService;
import kd.hr.hspm.opplugin.infoclassify.percre.PercreValidator;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifyImportPlugin;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PercreSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PercreSaveOp.class);
    private final IPercreService percreService = IPercreService.getInstance();
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final Map<Long, HrpiServiceOperateResult> operateResultMap = new HashMap<Long, HrpiServiceOperateResult>(16);
    private HrpiServiceOperateResult deleteOperateResult;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PercreValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.percreService.insertPercre(dataEntity);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.percreService.getPercreByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.percreService.updatePercre(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        DynamicObject[] dbDyArr = this.percreService.queryIsMajorByPkIdList(pkIdList);
        Map<Boolean, List<DynamicObject>> percreDyListMap = Arrays.stream(dbDyArr).collect(Collectors.partitioningBy(dy -> dy.getBoolean("ismajor")));
        List<DynamicObject> majorPercreDyList = percreDyListMap.get(Boolean.TRUE);
        List<DynamicObject> deletePercreDyList = percreDyListMap.get(Boolean.FALSE);
        String mainErrorMsg = ResManager.loadKDString((String)"\u4e3b\u8bc1\u4ef6\u4e0d\u53ef\u5220\u9664\u3002", (String)"PercreSaveOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
        if (!majorPercreDyList.isEmpty() && majorPercreDyList.size() == 1 && deletePercreDyList.isEmpty()) {
            args.setCancelOperation(true);
            throw new KDBizException(mainErrorMsg);
        }
        if (!deletePercreDyList.isEmpty()) {
            List deletePkIdList = deletePercreDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            this.deleteOperateResult = this.percreService.deletePercre(deletePkIdList);
            this.validateOperateResult(args, this.deleteOperateResult);
        }
        if (!majorPercreDyList.isEmpty()) {
            OperationResult operationResult = this.getOperationResult();
            operationResult.setSuccess(false);
            majorPercreDyList.forEach(majorPercreDy -> {
                String credentialstypeName = majorPercreDy.getString("credentialstype.name");
                String errorMsg = MessageFormat.format("{0}\uff1a{1}", credentialstypeName, mainErrorMsg);
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo(errorMsg, ErrorLevel.FatalError, majorPercreDy.get("id"));
                operateErrorInfo.setMessage(errorMsg);
                operationResult.addErrorInfo(operateErrorInfo);
            });
        }
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.percreService.queryExistsIdByPkIdList(pkIdList);
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        String entityNumber = dataEntities[0].getDynamicObjectType().getName();
        Long eventId = InfoclassifyImportPlugin.HisBatchImportCache.getInstance().getEventId(entityNumber);
        for (DynamicObject dataEntity : dataEntities) {
            this.saveImportNew(args, dataEntity, eventId);
        }
    }

    private void saveImportNew(BeginOperationTransactionArgs args, DynamicObject dataEntity, Long eventId) {
        HrpiServiceOperateResult operateResult = this.percreService.saveImportPercre("new", new DynamicObject[]{dataEntity}, eventId);
        this.validateOperateResult(args, operateResult, false);
        HrpiServiceOperateResult oldOpRes = this.operateResultMap.get(dataEntity.getLong("person.id"));
        if (HRObjectUtils.isEmpty((Object)oldOpRes) || !oldOpRes.isSyncFlag()) {
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        String entityNumber = dataEntities[0].getDynamicObjectType().getName();
        Long eventId = InfoclassifyImportPlugin.HisBatchImportCache.getInstance().getEventId(entityNumber);
        for (DynamicObject dataEntity : dataEntities) {
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.percreService.getPercreByPkId(pkId);
            this.saveImportOverride(args, dataEntity, dbDy, eventId);
        }
    }

    private void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject dataEntity, DynamicObject dbDy, Long eventId) {
        boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
        if (!compareResult) {
            this.getOperationResult().setMessage("the entity has not changed.");
            LOGGER.info("the entity has not changed.");
            return;
        }
        HrpiServiceOperateResult operateResult = this.percreService.saveImportPercre("override", new DynamicObject[]{dataEntity}, eventId);
        this.validateOperateResult(args, operateResult, false);
        HrpiServiceOperateResult oldOpRes = this.operateResultMap.get(dataEntity.getLong("person.id"));
        if (HRObjectUtils.isEmpty((Object)oldOpRes) || !oldOpRes.isSyncFlag()) {
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveImportOverridenew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        String entityNumber = dataEntities[0].getDynamicObjectType().getName();
        Long eventId = InfoclassifyImportPlugin.HisBatchImportCache.getInstance().getEventId(entityNumber);
        for (DynamicObject dataEntity : dataEntities) {
            long boid = dataEntity.getLong("boid");
            if (boid == 0L) {
                this.saveImportNew(args, dataEntity, eventId);
                continue;
            }
            DynamicObject dbDy = this.percreService.getPercreByPkId(Long.valueOf(dataEntity.getLong("id")));
            this.saveImportOverride(args, dataEntity, dbDy, eventId);
        }
    }

    protected void afterDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        OperationResult operationResult = this.getOperationResult();
        List successPkIds = operationResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
            List pkIdList = successPkIds.stream().map(pkId -> (Long)pkId).collect(Collectors.toList());
            this.percreService.removeAttachment("hrpi_percre", pkIdList);
        }
        if (this.deleteOperateResult != null && !CollectionUtils.isEmpty((Collection)this.deleteOperateResult.getSyncPersonIdList())) {
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(this.deleteOperateResult.getSyncPersonIdList());
        }
    }

    protected void afterSaveNew(AfterOperationArgs args, DynamicObject[] dataEntities) {
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveOverride(AfterOperationArgs args, DynamicObject[] dataEntities) {
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveImport(AfterOperationArgs args, DynamicObject[] dataEntities) {
        this.sendChangeInfoSyncToSysUser();
    }

    private void sendChangeInfoSyncToSysUser() {
        if (!this.operateResultMap.isEmpty()) {
            List personIdList = this.operateResultMap.entrySet().stream().filter(entry -> ((HrpiServiceOperateResult)entry.getValue()).isSyncFlag()).map(Map.Entry::getKey).collect(Collectors.toList());
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(personIdList);
        }
    }
}

