/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.percre;

import java.util.Date;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPercreService;
import kd.hr.hspm.business.mservice.IHspmIdentityService;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.common.utils.IDCardUtils;
import kd.sdk.hr.hspm.opplugin.InfoClassifyValidator;

public class PercreValidator
extends InfoClassifyValidator {
    private final IPercreService percreService = IPercreService.getInstance();
    private final HRBaseServiceHelper PERCRE_SERVER_HELPER = new HRBaseServiceHelper("hrpi_percre");

    protected void validateNew(ExtendedDataEntity[] dataEntities) {
        Date now = HspmDateUtils.getMidnight();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isValid = this.validIdentityCardNo(dataEntity);
            if (isValid) {
                this.validateIdCard(dataEntity);
            }
            this.validateCredentialstypeAndNumberUnique(dataEntity);
            this.validateDate(dataEntity, now);
        }
    }

    private void validateDate(ExtendedDataEntity dataEntity, Date now) {
        DynamicObject dy = dataEntity.getDataEntity();
        Date issueDate = dy.getDate("issuedate");
        Date birthday = dy.getDate("birthday");
        if (!HRObjectUtils.isEmpty((Object)issueDate)) {
            this.validateDateCompareAllowEqual(dataEntity, issueDate, now, ResManager.loadKDString((String)"\u8bc1\u4ef6\u7b7e\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreValidator_4", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)birthday)) {
            this.validateDateCompare(dataEntity, birthday, now, ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PersoninfoValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }

    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    protected void validateImportNew(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    protected void validateImportOverride(ExtendedDataEntity[] dataEntities) {
        this.validateOverride(dataEntities);
        String formId = dataEntities[0].getDataEntity().getDataEntityType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)formId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long boid = dataEntity.getDataEntity().getLong("boid");
            if (boid == 0L) continue;
            String personNumber = dataEntity.getDataEntity().getString("person.number");
            QFilter qFilter = new QFilter("boid", "=", (Object)boid);
            qFilter.and(new QFilter("person.number", "=", (Object)personNumber));
            if (!serviceHelper.isExists(qFilter)) {
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u7cfb\u7edf\u627e\u4e0d\u5230\u201c\u4e1a\u52a1ID\uff1a%1$s\uff0c\u59d3\u540d.\u5de5\u53f7\uff1a%2$s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"PercreValidator_5", (String)"hr-hspm-opplugin", (Object[])new Object[0]), boid, personNumber));
                continue;
            }
            if (dataEntity.getDataEntity().getBoolean("ismajor")) continue;
            qFilter.and(new QFilter("ismajor", "=", (Object)true));
            qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
            qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
            if (!this.PERCRE_SERVER_HELPER.isExists(qFilter)) continue;
            String name = dataEntity.getDataEntity().getDynamicObjectType().getProperty("ismajor").getDisplayName().getLocaleValue();
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5728\u5bfc\u5165\u65f6\u5c06\u201c%s\u201d\u7684\u503c\u6539\u4e3a\u5426\uff0c\u8bf7\u5728\u9875\u9762\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PercreValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]), name));
        }
    }

    protected void validateImportOverridenew(ExtendedDataEntity[] dataEntities) {
        this.validateImportOverride(dataEntities);
    }

    private boolean validIdentityCardNo(ExtendedDataEntity dataEntity) {
        Boolean isValid = Boolean.TRUE;
        DynamicObject dy = dataEntity.getDataEntity();
        long credentialstypeId = dy.getLong("credentialstype.id");
        if (credentialstypeId == HspmCommonConstants.NUMBER_1010_ID) {
            String number = dy.getString("number");
            isValid = IHspmIdentityService.getInstance().validIdentityCardNo(null, "CN01", number);
            if (isValid == null) {
                isValid = IDCardUtils.verify18((String)number);
            }
            if (!isValid.booleanValue()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PercreValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            }
        }
        return isValid;
    }

    private void validateIdCard(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        long credentialstypeId = dy.getLong("credentialstype.id");
        if (credentialstypeId == HspmCommonConstants.NUMBER_1010_ID) {
            long personIdDy = dy.getLong("person.id");
            boolean isExists = this.percreService.isExistsByCredentialstype(dy.getLong("id"), personIdDy, credentialstypeId);
            if (isExists) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u201c\u4e2d\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1\u201d\u7684\u8bc1\u4ef6\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"PercreValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateCredentialstype(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        long credentialstypeId = dy.getLong("credentialstype.id");
        if (credentialstypeId != HspmCommonConstants.NUMBER_1010_ID) {
            String number = dy.getString("number");
            long personId = dy.getLong("person.id");
            boolean isExists = this.percreService.isExistsByCredentialstypeAndNumber(dy.getLong("id"), personId, credentialstypeId, number);
            if (isExists) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PercreValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateCredentialstypeAndNumberUnique(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        long credentialstypeId = dy.getLong("credentialstype.id");
        Long percreId = dy.getLong("id");
        String number = dy.getString("number");
        if (credentialstypeId == 0L || StringUtils.isEmpty((String)number)) {
            return;
        }
        Tuple checkResult = UniquenessCheckUtil.checkCardNo((Long)percreId, (Long)credentialstypeId, (String)number, (boolean)true);
        if (!((Boolean)checkResult.item1).booleanValue()) {
            this.addFatalErrorMessage(dataEntity, (String)checkResult.item2);
        }
    }
}

