/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.pereduexpinfo;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPereduexpinfoService;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.opplugin.InfoClassifyValidator;

public class PereduexpinfoValidator
extends InfoClassifyValidator {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoValidator.class);
    private final IPereduexpinfoService pereduexpinfoService = IPereduexpinfoService.getInstance();
    private final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hrpi_pereduexp");

    protected void validateNew(ExtendedDataEntity[] dataEntities) {
        Date now = this.getNowDate();
        String extendName = dataEntities[0].getDataEntity().getDataEntityType().getExtendName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateDate(dataEntity, now);
            this.validateRequired(dataEntity);
            this.validateNumber(dataEntity);
        }
    }

    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    protected void validateImportNew(ExtendedDataEntity[] dataEntities) {
        Date now = this.getNowDate();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateDate(dataEntity, now);
            this.validateRequired(dataEntity);
            this.validateNumber(dataEntity);
        }
    }

    private void validateDate(ExtendedDataEntity dataEntity, Date now) {
        DynamicObject dy = dataEntity.getDataEntity();
        if (!PropertyHelper.existProperty((DynamicObject)dy, (String)"admissiondate") || !PropertyHelper.existProperty((DynamicObject)dy, (String)"gradutiondate")) {
            return;
        }
        Date admissiondate = dy.getDate("admissiondate");
        Date gradutiondate = dy.getDate("gradutiondate");
        this.validateDateCompareAllowEqual(dataEntity, admissiondate, gradutiondate, ResManager.loadKDString((String)"\u5165\u5b66\u65e5\u671f\u5e94\u65e9\u4e8e\u6bd5\u4e1a\u65e5\u671f\u3002", (String)"PereduexpinfoValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
    }

    private void validateRequired(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        if (!PropertyHelper.existProperty((DynamicObject)dy, (String)"graduateschool") || !PropertyHelper.existProperty((DynamicObject)dy, (String)"schoolrecord")) {
            return;
        }
        long graduateschoolId = dy.getLong("graduateschool.id");
        if (graduateschoolId == HspmCommonConstants.OTHER_SCHOOL_BOID && HRObjectUtils.isEmpty((Object)dy.getString("schoolrecord"))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5176\u4ed6\u9662\u6821\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PereduexpinfoValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateNumber(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        if (!PropertyHelper.existProperty((DynamicObject)dy, (String)"schoolsystem")) {
            return;
        }
        BigDecimal schoolsystem = dy.getBigDecimal("schoolsystem");
        if (!HRObjectUtils.isEmpty((Object)schoolsystem) && schoolsystem.compareTo(BigDecimal.ZERO) < 0) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b66\u5236(\u5e74)\u4e3a\u975e\u8d1f\u6570\u5b57\u3002", (String)"PereduexpinfoValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }

    protected void validateImportOverride(ExtendedDataEntity[] dataEntities) {
        this.validateImportNew(dataEntities);
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String formId = dataEntities[0].getDataEntity().getDataEntityType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)formId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long boid = dataEntity.getDataEntity().getLong("boid");
            if (boid == 0L) continue;
            String personNumber = dataEntity.getDataEntity().getString("person.number");
            QFilter qFilter = new QFilter("boid", "=", (Object)boid);
            qFilter.and(new QFilter("person.number", "=", (Object)personNumber));
            if (!serviceHelper.isExists(qFilter)) {
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u7cfb\u7edf\u627e\u4e0d\u5230\u201c\u4e1a\u52a1ID\uff1a%1$s\uff0c\u59d3\u540d.\u5de5\u53f7\uff1a%2$s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"PereduexpinfoValidator_6", (String)"hr-hspm-opplugin", (Object[])new Object[0]), boid, personNumber));
                continue;
            }
            if (dataEntity.getDataEntity().getBoolean("ishighestdegree")) continue;
            qFilter.and(new QFilter("ishighestdegree", "=", (Object)"1"));
            qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
            qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
            if (!this.HELPER.isExists(qFilter)) continue;
            String name = dataEntity.getDataEntity().getDynamicObjectType().getProperty("ishighestdegree").getDisplayName().getLocaleValue();
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5728\u5bfc\u5165\u65f6\u5c06\u201c%s\u201d\u7684\u503c\u6539\u4e3a\u5426\uff0c\u8bf7\u5728\u9875\u9762\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PercreValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]), name));
        }
    }
}

