/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.perhobby;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.service.infoclassify.IPerhobbyService;
import kd.hr.hspm.opplugin.infoclassify.perhobby.PerhobbyValidator;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PerhobbySaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PerhobbySaveOp.class);
    private final IPerhobbyService perhobbyService = IPerhobbyService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PerhobbyValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.perhobbyService.insertPerhobby(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.perhobbyService.getPerhobbyByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.perhobbyService.updatePerhobby(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        HrpiServiceOperateResult operateResult = this.perhobbyService.deletePerhobby(pkIdList);
        this.validateOperateResult(args, operateResult);
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.perhobbyService.queryExistsIdByPkIdList(pkIdList);
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            HrpiServiceOperateResult operateResult = this.perhobbyService.saveImportPerhobby("new", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
        }
    }
}

