/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.personinfo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.opplugin.infoclassify.basic.InfoClassifyHRImportPlugin;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;

public class PersoninfoHRImportPlugin
extends InfoClassifyHRImportPlugin {
    public void beforeLoadEntity(BeforeLoadEntityEventArgs args) {
        super.beforeLoadEntity(args);
        List qFilters = args.getqFilters();
        List<String> numberList = this.getNumberList(qFilters);
        DynamicObject[] personDynArr = this.getPersonDataByNumber(numberList);
        List effectPersonList = super.getEffectPersonList(personDynArr);
        Map<String, Long> numberVsIdMap = effectPersonList.stream().collect(Collectors.toMap(dyn -> dyn.getString("number"), dyn -> dyn.getLong("id")));
        for (int i = 0; i < qFilters.size(); ++i) {
            QFilter qFilter = (QFilter)qFilters.get(i);
            boolean isNumberFilter = HRStringUtils.equals((String)"person.number", (String)qFilter.getProperty());
            if (!isNumberFilter) continue;
            Object value = qFilter.getValue();
            Long id = numberVsIdMap.get(value);
            qFilters.set(i, new QFilter("person.id", "=", (Object)numberVsIdMap.get(value)));
        }
    }

    private List<String> getNumberList(List<QFilter> qFilters) {
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)qFilters.size());
        for (QFilter qFilter : qFilters) {
            Object value;
            boolean isNumberFilter = HRStringUtils.equals((String)"person.number", (String)qFilter.getProperty());
            if (!isNumberFilter || !Objects.nonNull(value = qFilter.getValue())) continue;
            numberList.add((String)value);
        }
        return numberList;
    }

    private DynamicObject[] getPersonDataByNumber(List<String> numberList) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter numberFilter = new QFilter("number", "in", numberList);
        return personHelper.query(new QFilter[]{isCurrentVersionFilter, dataStatusFilter, initStatusFilter, numberFilter});
    }
}

