/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.personinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.PersoninfoFieldEnum;
import kd.sdk.hr.hspm.common.utils.DynamicPropUtil;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifyImportPlugin;

public class PersoninfoImportPlugin
extends InfoclassifyImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PersoninfoImportPlugin.class);
    private static final HRBaseServiceHelper HRPI_PERTSPROP_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERTSPROP.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERREGION_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERREGION.getFormKey());
    private static final HRBaseServiceHelper HRPI_PERSON_SERVICE_HELPER = new HRBaseServiceHelper(PersoninfoFieldEnum.HRPI_PERSON.getFormKey());

    public String getDefaultImportType() {
        return InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo").getDefaultImportType();
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (!HRStringUtils.equals((String)p.getName(), (String)"person")) continue;
            items.add(new ComboItem(p.getDisplayName(), p.getName()));
        }
        return items;
    }

    public String getDefaultKeyFields() {
        return "person";
    }

    public List<String> getDefaultLockUIs() {
        return InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo").getDefaultLockUIs();
    }

    public String getBillFormId() {
        return InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo").getFormKey();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Set collect = rowdatas.stream().map(arg -> arg.getData().getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo").getSourceKey());
        DynamicObject[] ids = helper.query("person.id", new QFilter[]{new QFilter("id", "in", collect)});
        Set longs = Arrays.stream(ids).map(id -> id.getLong("person.id")).collect(Collectors.toSet());
        Map<Long, Long> idMap = Arrays.stream(ids).collect(Collectors.toMap(arg -> arg.getLong("id"), arg -> arg.getLong("person.id")));
        DataEntityPropertyCollection mainProperties = MetadataServiceHelper.getDataEntityType((String)InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo").getFormKey()).getProperties();
        DataEntityPropertyCollection pernonsPropProperties = MetadataServiceHelper.getDataEntityType((String)PersoninfoFieldEnum.HRPI_PERNONTSPROP.getFormKey()).getProperties();
        DataEntityPropertyCollection pertspropProperties = MetadataServiceHelper.getDataEntityType((String)PersoninfoFieldEnum.HRPI_PERTSPROP.getFormKey()).getProperties();
        String selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)pertspropProperties, (String)"person");
        QFilter pertspropFilter = new QFilter("person", "in", longs);
        pertspropFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pertspropFilter.and(QFilterUtil.getDataStatusFilter());
        DynamicObject[] query = HRPI_PERTSPROP_SERVICE_HELPER.query(selectProperties, new QFilter[]{pertspropFilter});
        Map<Long, DynamicObject> perMap = Arrays.stream(query).collect(Collectors.toMap(arg -> arg.getLong("person.id"), arg -> arg));
        DataEntityPropertyCollection perRegionProperties = MetadataServiceHelper.getDataEntityType((String)PersoninfoFieldEnum.HRPI_PERREGION.getFormKey()).getProperties();
        String selectPropertiesForRegion = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)perRegionProperties, (String)"person");
        QFilter pertspropFilterForRegion = new QFilter("person", "in", longs);
        pertspropFilterForRegion.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pertspropFilterForRegion.and(QFilterUtil.getDataStatusFilter());
        DynamicObject[] queryForRegion = HRPI_PERREGION_SERVICE_HELPER.query(selectPropertiesForRegion, new QFilter[]{pertspropFilterForRegion});
        Map<Long, DynamicObject> perMapForRegion = Arrays.stream(queryForRegion).collect(Collectors.toMap(arg -> arg.getLong("person.id"), arg -> arg));
        DataEntityPropertyCollection perPersonProperties = MetadataServiceHelper.getDataEntityType((String)PersoninfoFieldEnum.HRPI_PERSON.getFormKey()).getProperties();
        String selectPropertiesForPerson = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)perPersonProperties, (String)"");
        QFilter filterForPerson = new QFilter("id", "in", longs);
        filterForPerson.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        filterForPerson.and(QFilterUtil.getDataStatusFilter());
        DynamicObject[] queryForPerson = HRPI_PERSON_SERVICE_HELPER.query(selectPropertiesForPerson, new QFilter[]{filterForPerson});
        Map<Long, DynamicObject> perMapForPerson = Arrays.stream(queryForPerson).collect(Collectors.toMap(arg -> arg.getLong("id"), arg -> arg));
        for (ImportBillData rowdata : rowdatas) {
            Long id2 = rowdata.getData().getLong("id");
            Long personId = idMap.get(id2);
            DynamicObject perObject = perMap.get(personId);
            DynamicObject regionObject = perMapForRegion.get(personId);
            DynamicObject personObject = perMapForPerson.get(personId);
            String[] props = HRStringUtils.split((String)selectProperties, (String)",");
            String[] propsForRegion = HRStringUtils.split((String)selectPropertiesForRegion, (String)",");
            String[] propsForPerson = HRStringUtils.split((String)selectPropertiesForPerson, (String)",");
            this.copyForNull(rowdata, perObject, props);
            this.copyForNull(rowdata, regionObject, propsForRegion);
            this.copyForNull(rowdata, personObject, propsForPerson);
        }
        return super.save(rowdatas, logger);
    }

    private void copyForNull(ImportBillData rowdata, DynamicObject perObject, String[] props) {
        if (perObject == null) {
            return;
        }
        for (String prop : props) {
            if (HRStringUtils.isEmpty((String)prop)) continue;
            ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)rowdata.getEntityMapping().getCols().get(prop);
            IDataEntityProperty property = (IDataEntityProperty)this.mainEntityType.getProperties().get((Object)prop);
            if (colInfo == null || !rowdata.getData().containsKey((Object)prop)) {
                if (property instanceof MuliLangTextProp) {
                    this.dealMuliLangTextProp(rowdata, perObject, prop, property);
                    continue;
                }
                if (property instanceof BasedataProp) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String basedataProp = colInfo != null ? colInfo.getBasedataProp() : "number";
                    map.put("importprop", basedataProp);
                    DynamicObject dynamicObject = perObject.getDynamicObject(prop);
                    if (dynamicObject == null) continue;
                    map.put(basedataProp, dynamicObject.getString(basedataProp));
                    rowdata.getData().put(prop, map);
                    continue;
                }
                if (property instanceof DateProp) {
                    if (perObject.getDate(prop) == null) continue;
                    rowdata.getData().put(prop, (Object)HRDateTimeUtils.format((Date)perObject.getDate(prop)));
                    continue;
                }
                rowdata.getData().put(prop, (Object)perObject.getString(prop));
            }
            this.dealMuliLangTextProp(rowdata, perObject, prop, property);
        }
    }

    private void dealMuliLangTextProp(ImportBillData rowdata, DynamicObject perObject, String prop, IDataEntityProperty property) {
        if (!(property instanceof MuliLangTextProp)) {
            return;
        }
        HashMap hashMap = (HashMap)rowdata.getData().get((Object)prop);
        if (hashMap == null) {
            hashMap = new HashMap(16);
        }
        Set keySet = property.getDisplayName().keySet();
        for (Object key : keySet) {
            if (hashMap.containsKey(key)) continue;
            hashMap.put(key, perObject.getLocaleString(prop).get(key));
        }
        rowdata.getData().put(prop, hashMap);
    }
}

