/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.personinfo;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.opplugin.InfoClassifyValidator;

public class PersoninfoValidator
extends InfoClassifyValidator {
    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        Date now = HspmDateUtils.getMidnight();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateNumber(dataEntity);
            this.validateDate(dataEntity, now);
        }
    }

    protected void validateImportOverride(ExtendedDataEntity[] dataEntities) {
        this.validateOverride(dataEntities);
    }

    private void validateNumber(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        int height = dy.getInt("height");
        if (height < 0) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8eab\u9ad8\u4e3a\u975e\u8d1f\u6574\u6570\u3002", (String)"PersoninfoValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateDate(ExtendedDataEntity dataEntity, Date now) {
        DynamicObject dy = dataEntity.getDataEntity();
        Date birthday = dy.getDate("birthday");
        Date beginServiceDate = dy.getDate("beginservicedate");
        if (!HRObjectUtils.isEmpty((Object)birthday)) {
            this.validateDateCompare(dataEntity, birthday, now, ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PersoninfoValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)birthday)) {
            this.validateDateCompare(dataEntity, beginServiceDate, now, ResManager.loadKDString((String)"\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PersoninfoValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }
}

