/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.multiviewconfig.validator;

import java.util.Collection;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hspm.business.util.UniquenessCheckUtil;

public class InfoGroupUpdateAgreeValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper PERCRE_HELPER = new HRBaseServiceHelper("hrpi_percre");

    public void validate() {
        super.validate();
        ExtendedDataEntity dataEntity = this.dataEntities[0];
        DynamicObjectCollection collection = (DynamicObjectCollection)dataEntity.getDataEntity().get("entryentity");
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject dynamicObject : collection) {
                Tuple checkResult;
                long personId;
                if (dynamicObject.getBoolean("status")) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u201c\u540c\u610f\u201d\u5931\u8d25\uff1a\u5b57\u6bb5\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"InfoGroupUpdateAgreeValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
                    return;
                }
                String entityName = dynamicObject.getString("entityname");
                String fieldName = dynamicObject.getString("fieldname");
                String newValue = dynamicObject.getString("newvalue");
                if (!HRStringUtils.isNotEmpty((String)newValue)) continue;
                if ("hrpi_percontact".equals(entityName) && "phone".equals(fieldName)) {
                    personId = dataEntity.getDataEntity().getLong("person.id");
                    checkResult = UniquenessCheckUtil.checkPhone((long)personId, (String)newValue, (boolean)true);
                    if (!((Boolean)checkResult.item1).booleanValue()) {
                        this.addFatalErrorMessage(dataEntity, (String)checkResult.item2);
                        return;
                    }
                }
                if ("hrpi_percre".equals(entityName) && "number".equals(fieldName)) {
                    long dataId = dynamicObject.getLong("dataid");
                    Long percreId = dynamicObject.getBoolean("isnew") ? 0L : dataId;
                    DynamicObject precreDy = PERCRE_HELPER.queryOne((Object)dataId);
                    if (precreDy != null) {
                        long typeId = precreDy.getLong("credentialstype.id");
                        Tuple checkResult2 = UniquenessCheckUtil.checkCardNo((Long)percreId, (Long)typeId, (String)newValue, (boolean)true);
                        if (!((Boolean)checkResult2.item1).booleanValue()) {
                            this.addFatalErrorMessage(dataEntity, (String)checkResult2.item2);
                            return;
                        }
                    }
                }
                if (!"hrpi_percontact".equals(entityName) || !"peremail".equals(fieldName)) continue;
                personId = dataEntity.getDataEntity().getLong("person.id");
                checkResult = UniquenessCheckUtil.checkPerEmail((long)personId, (String)newValue, (boolean)true);
                if (((Boolean)checkResult.item1).booleanValue()) continue;
                this.addFatalErrorMessage(dataEntity, (String)checkResult.item2);
                return;
            }
        }
    }
}

