/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.approval;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.NoLineTimeHisVersionChangeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.InfoGroupApprovalUtil;

public class InfoGroupUpdateAgreeOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(InfoGroupUpdateAgreeOp.class);
    private static final HRBaseServiceHelper INFOGROUPPAGEREG_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static final HRBaseServiceHelper PEREDUEXP_HELPER = new HRBaseServiceHelper("hrpi_pereduexp");
    Long personId;
    String billNo;

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("creator");
        evt.getFieldKeys().add("billno");
        evt.getFieldKeys().add("person");
        evt.getFieldKeys().add("entryentity");
        evt.getFieldKeys().add("entryentity.entityname");
        evt.getFieldKeys().add("entryentity.fieldname");
        evt.getFieldKeys().add("entryentity.fieldtype");
        evt.getFieldKeys().add("entryentity.newvalue");
        evt.getFieldKeys().add("entryentity.status");
        evt.getFieldKeys().add("entryentity.reason");
        evt.getFieldKeys().add("entryentity.isnew");
        evt.getFieldKeys().add("entryentity.isdel");
        evt.getFieldKeys().add("entryentity.dataid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] datas = args.getDataEntities();
        DynamicObject dynamicObject = datas[0];
        LOGGER.info(MessageFormat.format("agree_op---->{0}", dynamicObject.get("billno")));
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)dynamicObject.get("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.updateEntityInfo(dynamicObject);
            RequestContext requestContext = RequestContext.getOrCreate();
            DynamicObject creator = dynamicObject.getDynamicObject("creator");
            if (!HRObjectUtils.isEmpty((Object)creator)) {
                this.replaceRequestContext(requestContext, creator);
            }
            this.addExtraDataForEduCert(dynamicObjects);
            this.updateAuditFieldInfo(dynamicObjects);
        }
    }

    private void addExtraDataForEduCert(DynamicObjectCollection dynamicObjects) {
        Set longs = dynamicObjects.stream().filter(dy -> dy.getString("entityname").equals("hrpi_pereduexp")).map(dy -> dy.getLong("dataid")).collect(Collectors.toSet());
        List collect = dynamicObjects.stream().filter(dy -> {
            DynamicObject eduDy;
            long eduExpId;
            return dy.getString("entityname").equals("hrpi_pereduexpcert") && (eduExpId = BusinessUtils.getEduexpByEduCertId((Long)dy.getLong("dataid")).longValue()) != 0L && !longs.contains(eduExpId) && (eduDy = PEREDUEXP_HELPER.queryOne((Object)eduExpId)) != null && "-3".equals(eduDy.getString("datastatus"));
        }).collect(Collectors.toList());
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject eduDy;
            Long eduExpId;
            DynamicObject dy2 = (DynamicObject)collect.get(i);
            if (!dy2.getString("entityname").equals("hrpi_pereduexpcert") || (eduExpId = BusinessUtils.getEduexpByEduCertId((Long)dy2.getLong("dataid"))) == null || (eduDy = PEREDUEXP_HELPER.queryOne((Object)eduExpId)) == null || !"-3".equals(eduDy.getString("datastatus"))) continue;
            DynamicObject addNew = dynamicObjects.addNew();
            addNew.set("entityname", (Object)"hrpi_pereduexp");
            addNew.set("fieldname", (Object)"id");
            addNew.set("fieldtype", (Object)FieldTypeEnum.LONG.getType());
            addNew.set("isnew", (Object)true);
            addNew.set("dataid", eduDy.getPkValue());
            addNew.set("newvalue", eduDy.getPkValue());
        }
        List collectDel = dynamicObjects.stream().filter(dy -> {
            DynamicObject eduDy;
            long eduExpId;
            return dy.getString("entityname").equals("hrpi_pereduexpcert") && dy.getBoolean("isdel") && (eduExpId = BusinessUtils.getEduexpByEduCertId((Long)dy.getLong("dataid")).longValue()) != 0L && !longs.contains(eduExpId) && (eduDy = PEREDUEXP_HELPER.queryOne((Object)eduExpId)) != null && "1".equals(eduDy.getString("datastatus"));
        }).collect(Collectors.toList());
        for (int i = 0; i < collectDel.size(); ++i) {
            DynamicObject eduDy;
            Long eduExpId;
            DynamicObject dy3 = (DynamicObject)collectDel.get(i);
            if (!dy3.getString("entityname").equals("hrpi_pereduexpcert") || (eduExpId = BusinessUtils.getEduexpByEduCertId((Long)dy3.getLong("dataid"))) == null || (eduDy = PEREDUEXP_HELPER.queryOne((Object)eduExpId)) == null || !"1".equals(eduDy.getString("datastatus")) || !dynamicObjects.stream().noneMatch(arg -> arg.getLong("dataid") == eduExpId.longValue() && arg.getString("entityname").equals("hrpi_pereduexp"))) continue;
            DynamicObject addNew = dynamicObjects.addNew();
            addNew.set("entityname", (Object)"hrpi_pereduexp");
            addNew.set("fieldname", (Object)"id");
            addNew.set("fieldtype", (Object)FieldTypeEnum.LONG.getType());
            addNew.set("isdel", (Object)true);
            addNew.set("dataid", eduDy.getPkValue());
            addNew.set("newvalue", eduDy.getPkValue());
        }
        List collectDelForCert = dynamicObjects.stream().filter(dy -> {
            List certIdByEduIds;
            return dy.getString("entityname").equals("hrpi_pereduexp") && dy.getBoolean("isdel") && !CollectionUtils.isEmpty((Collection)(certIdByEduIds = BusinessUtils.getEduCertIdByEduId((Long)dy.getLong("dataid"))));
        }).collect(Collectors.toList());
        for (int i = 0; i < collectDelForCert.size(); ++i) {
            List certIds;
            DynamicObject dy4 = (DynamicObject)collectDelForCert.get(i);
            if (!dy4.getString("entityname").equals("hrpi_pereduexp") || CollectionUtils.isEmpty((Collection)(certIds = BusinessUtils.getEduCertIdByEduId((Long)dy4.getLong("dataid"))))) continue;
            for (Long certId : certIds) {
                if (!dynamicObjects.stream().noneMatch(arg -> arg.getLong("dataid") == certId.longValue() && arg.getString("entityname").equals("hrpi_pereduexpcert"))) continue;
                DynamicObject addNew = dynamicObjects.addNew();
                addNew.set("entityname", (Object)"hrpi_pereduexpcert");
                addNew.set("fieldname", (Object)"id");
                addNew.set("fieldtype", (Object)FieldTypeEnum.LONG.getType());
                addNew.set("isdel", (Object)true);
                addNew.set("dataid", (Object)certId);
                addNew.set("newvalue", null);
            }
        }
    }

    private void replaceRequestContext(RequestContext requestContext, DynamicObject creator) {
        RequestContextUtils.createRequestContext((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)String.valueOf(creator.getLong("id")));
    }

    private void updateAuditFieldInfo(DynamicObjectCollection dynamicObjects) {
        Map<String, List<DynamicObject>> entityMap = dynamicObjects.stream().collect(Collectors.groupingBy(val -> val.get("entityname").toString()));
        HashMap<String, DynamicObjectCollection> updateAttachMap = new HashMap<String, DynamicObjectCollection>(entityMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : entityMap.entrySet()) {
            DynamicObject[] edus;
            QFilter qFilter;
            List longList;
            String entityName = entry.getKey();
            Map<Long, List<DynamicObject>> dataMap = entry.getValue().stream().collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(entityName);
            DynamicObjectCollection addCollection = new DynamicObjectCollection();
            DynamicObjectCollection updateCollection = new DynamicObjectCollection();
            HashMap<Long, Long> delPkPersonIdMap = new HashMap<Long, Long>(16);
            DynamicObject attachmentDy = null;
            long lastEduId = 0L;
            long lastPerId = 0L;
            if (entityName.equals("hrpi_pereduexp")) {
                longList = entry.getValue().stream().filter(dynamicObject -> dynamicObject.getString("newvalue").equals("1") && dynamicObject.getString("fieldname").equals("ishighestdegree")).map(dynamicObject -> dynamicObject.getLong("dataid")).collect(Collectors.toList());
                qFilter = new QFilter("id", "in", longList);
                edus = baseServiceHelper.query("id", new QFilter[]{qFilter}, "modifytime desc", 1);
                if (edus != null && edus.length > 0) {
                    lastEduId = edus[0].getLong("id");
                }
                if (lastEduId != 0L) {
                    for (DynamicObject dynamicObject2 : entry.getValue()) {
                        if (!dynamicObject2.getString("newvalue").equals("1") || !dynamicObject2.getString("fieldname").equals("ishighestdegree") || dynamicObject2.getLong("dataid") == lastEduId) continue;
                        dynamicObject2.set("newvalue", (Object)"0");
                    }
                }
                dataMap = entry.getValue().stream().collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            }
            if (entityName.equals("hrpi_percre")) {
                longList = entry.getValue().stream().filter(dynamicObject -> dynamicObject.getBoolean("newvalue") && dynamicObject.getString("fieldname").equals("ismajor")).map(dynamicObject -> dynamicObject.getLong("dataid")).collect(Collectors.toList());
                qFilter = new QFilter("id", "in", longList);
                edus = baseServiceHelper.query("id", new QFilter[]{qFilter}, "modifytime desc", 1);
                if (edus != null && edus.length > 0) {
                    lastPerId = edus[0].getLong("id");
                }
                if (lastPerId != 0L) {
                    for (DynamicObject dynamicObject2 : entry.getValue()) {
                        if (!dynamicObject2.getBoolean("newvalue") || !dynamicObject2.getString("fieldname").equals("ismajor") || dynamicObject2.getLong("dataid") == lastPerId) continue;
                        dynamicObject2.set("newvalue", (Object)false);
                    }
                }
                dataMap = entry.getValue().stream().collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            }
            for (Map.Entry<Long, List<DynamicObject>> dataEntry : dataMap.entrySet()) {
                Object field32;
                boolean bl;
                Optional<DynamicObject> opt;
                List<Object> fields = dataEntry.getValue();
                DynamicObject oldDy = baseServiceHelper.queryOne((Object)dataEntry.getKey());
                if (HRObjectUtils.isEmpty((Object)oldDy)) {
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6570\u636e dataid:{0}", (String)"InfoGroupUpdateApprovalOp_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dataEntry.getKey()));
                }
                if ("hrpi_pertsprop".equals(entityName)) {
                    Date effStartDate = oldDy.getDate("bsed");
                    Date date = oldDy.getDate("bsled");
                    LOGGER.info(MessageFormat.format("oldDy\u65f6\u5e8f\u5c5e\u6027\u751f\u6548\u65f6\u95f4\uff1a{0}\uff1b\u5931\u6548\u65f6\u95f4\uff1a{1};id:{2}", effStartDate != null ? HRDateTimeUtils.formatDate((Date)effStartDate) : "", date != null ? HRDateTimeUtils.formatDate((Date)date) : "", oldDy.getLong("id")));
                }
                if ("hrpi_percre".equals(entityName) || "hrpi_perocpqual".equals(entityName)) {
                    for (DynamicObject dynamicObject3 : fields) {
                        if (!dynamicObject3.getString("fieldname").equals("isnofixedterm") || !dynamicObject3.getBoolean("newvalue") || !oldDy.getDataEntityType().getProperties().containsKey((Object)"expirationdate")) continue;
                        oldDy.set("expirationdate", (Object)HRDateTimeUtils.getSysMaxDate());
                    }
                }
                if ((opt = fields.stream().filter(val -> InfoGroupApprovalUtil.isAttach((DynamicObject)val)).findAny()).isPresent()) {
                    attachmentDy = opt.get();
                    if (attachmentDy != null) {
                        this.handleAttachField(attachmentDy);
                    }
                    fields = fields.stream().filter(val -> !InfoGroupApprovalUtil.isAttach((DynamicObject)val)).collect(Collectors.toList());
                }
                boolean bl2 = false;
                if (CollectionUtils.isEmpty(fields)) {
                    if (!"-3".equals(oldDy.getString("datastatus"))) continue;
                    bl = true;
                }
                if (bl || fields.get(0).getBoolean("isnew")) {
                    this.addIfNotExist(addCollection, oldDy);
                    if ("hrpi_percre".equals(entityName) && oldDy.getBoolean("ismajor")) {
                        if (lastPerId != 0L && oldDy.getLong("id") != lastPerId) {
                            oldDy.set("ismajor", (Object)false);
                        }
                        this.openMajor(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
                    }
                    if (!"hrpi_pereduexp".equals(entityName) || !"1".equals(oldDy.getString("ishighestdegree"))) continue;
                    if (lastEduId != 0L && oldDy.getLong("id") != lastEduId) {
                        oldDy.set("ishighestdegree", (Object)"0");
                    }
                    this.openHighestDegree(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
                    continue;
                }
                if (((DynamicObject)fields.get(0)).getBoolean("isdel")) {
                    delPkPersonIdMap.put(dataEntry.getKey(), this.personId);
                    continue;
                }
                DynamicObject updateDy = baseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)updateDy);
                for (Object field32 : fields) {
                    this.setValue(updateDy, (DynamicObject)field32);
                    if (!"hrpi_pernontsprop".equals(entityName)) continue;
                    if (field32.getString("fieldname").equals("beginservicedate")) {
                        BusinessUtils.changeBeginServiceDateAfterAudit((DynamicObject)oldDy, (DynamicObject)updateDy, updateAttachMap, (DynamicObject)field32);
                    }
                    if (!field32.getString("fieldname").equals("birthday")) continue;
                    String birthday = field32.getString("newvalue");
                    Date date = HRStringUtils.isEmpty((String)birthday) ? null : new Date(Long.parseLong(birthday));
                    BigDecimal age = birthday == null ? BigDecimal.ZERO : BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)date, (Date)new Date()));
                    updateDy.set("age", (Object)age);
                }
                boolean isExist = false;
                field32 = updateCollection.iterator();
                while (field32.hasNext()) {
                    DynamicObject dynamicObject3 = (DynamicObject)field32.next();
                    if (!dynamicObject3.get("boid").equals(oldDy.getLong("id"))) continue;
                    HRDynamicObjectUtils.copy((DynamicObject)updateDy, (DynamicObject)dynamicObject3);
                    isExist = true;
                }
                if (!isExist) {
                    updateCollection.add((Object)updateDy);
                    if ("hrpi_pertsprop".equals(entityName)) {
                        Date effStartDate = updateDy.getDate("bsed");
                        Date effEndDate = updateDy.getDate("bsled");
                        LOGGER.info(MessageFormat.format("updateDy\u65f6\u5e8f\u5c5e\u6027\u751f\u6548\u65f6\u95f4\uff1a{0}\uff1b\u5931\u6548\u65f6\u95f4\uff1a{1};id:{2};boid:{3}", effStartDate != null ? HRDateTimeUtils.formatDate((Date)effStartDate) : "", effEndDate != null ? HRDateTimeUtils.formatDate((Date)effEndDate) : "", updateDy.getLong("id"), updateDy.getLong("boid")));
                    }
                }
                if ("hrpi_percre".equals(entityName)) {
                    if (oldDy.getBoolean("ismajor") && !updateDy.getBoolean("ismajor")) {
                        boolean anyMatch = entry.getValue().stream().anyMatch(dynamicObject -> dynamicObject.getString("fieldname").equals("ismajor") && dynamicObject.getBoolean("newvalue"));
                        if (anyMatch) continue;
                        this.closeMajor(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
                    } else if (!oldDy.getBoolean("ismajor") && updateDy.getBoolean("ismajor")) {
                        this.openMajor(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
                    }
                }
                if (!"hrpi_pereduexp".equals(entityName)) continue;
                if (oldDy.getBoolean("ishighestdegree") && !updateDy.getBoolean("ishighestdegree")) {
                    boolean anyMatch = entry.getValue().stream().anyMatch(dynamicObject -> dynamicObject.getString("fieldname").equals("ishighestdegree") && dynamicObject.getString("newvalue").equals("1"));
                    if (anyMatch) continue;
                    this.closeHighestDegree(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
                    continue;
                }
                if (oldDy.getBoolean("ishighestdegree") || !updateDy.getBoolean("ishighestdegree")) continue;
                this.openHighestDegree(baseServiceHelper, oldDy.getLong("person.id"), updateCollection);
            }
            this.dealWithSpecial(entityName, baseServiceHelper, addCollection, updateCollection);
            this.handleAdd(entityName, addCollection);
            this.handleDel(entityName, baseServiceHelper, delPkPersonIdMap);
            if (CollectionUtils.isEmpty((Collection)updateCollection)) continue;
            updateAttachMap.put(entityName, updateCollection);
        }
        if (!CollectionUtils.isEmpty(updateAttachMap)) {
            this.handleUpdate(updateAttachMap);
        }
    }

    private void handleDel(String entityName, HRBaseServiceHelper baseServiceHelper, Map<Long, Long> delPkPersonIdMap) {
        if (delPkPersonIdMap.isEmpty()) {
            return;
        }
        DynamicObject[] dyArr = baseServiceHelper.queryOriginalArray("person.id,boid,sourcevid", new QFilter[]{new QFilter("id", "in", delPkPersonIdMap.keySet())});
        Map resultMap = AttacheHandlerService.getInstance().invokeDel(new ArrayList<Long>(delPkPersonIdMap.keySet()), entityName, Boolean.TRUE);
        if (AttacheHandlerService.isSuccess((Map)resultMap)) {
            List personIds = AttacheHandlerService.getInstance().validateSyncFieldsDelChange(entityName, delPkPersonIdMap);
            if (personIds != null && personIds.size() > 0) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(personIds);
            }
            if (dyArr != null) {
                AttacheHandlerService.getInstance().sendHpfsChgDeleteRecord(dyArr, entityName, entityName);
            }
            AttacheHandlerService.getInstance().removeAllAttachment(entityName, delPkPersonIdMap.keySet());
        }
    }

    private void addIfNotExist(DynamicObjectCollection addCollection, DynamicObject oldDy) {
        boolean match = addCollection.stream().anyMatch(dynamicObject -> dynamicObject.get("boid").equals(oldDy.getLong("id")));
        if (!match) {
            addCollection.add((Object)oldDy);
        }
    }

    private void dealWithSpecial(String entityName, HRBaseServiceHelper baseServiceHelper, DynamicObjectCollection addCollection, DynamicObjectCollection updateCollection) {
        block7: {
            String finalKeyField;
            DynamicObjectCollection dynamicObjectCollection;
            Object falseValue;
            String keyField;
            block6: {
                if (!"hrpi_pereduexp".equals(entityName) && !"hrpi_percre".equals(entityName)) {
                    return;
                }
                keyField = "";
                Object trueValue = null;
                falseValue = null;
                if ("hrpi_pereduexp".equals(entityName)) {
                    keyField = "ishighestdegree";
                    trueValue = "1";
                    falseValue = "0";
                }
                if ("hrpi_percre".equals(entityName)) {
                    keyField = "ismajor";
                    trueValue = true;
                    falseValue = false;
                }
                dynamicObjectCollection = new DynamicObjectCollection();
                dynamicObjectCollection.addAll((Collection)addCollection);
                dynamicObjectCollection.addAll((Collection)updateCollection);
                finalKeyField = keyField;
                long count = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean(finalKeyField)).count();
                List longList = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("person", "=", (Object)this.personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter(keyField, "=", trueValue));
                DynamicObject[] edus = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
                if (count != 0L) break block6;
                if (edus != null && edus.length != 0 && !longList.contains(edus[0].getLong("id"))) break block7;
                Long newestId = dynamicObjectCollection.stream().max(Comparator.comparing(dynamicObject -> dynamicObject.getDate("createtime"))).map(dynamicObject -> dynamicObject.getLong("boid")).get();
                for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
                    if (dynamicObject2.getLong("boid") != newestId.longValue()) continue;
                    dynamicObject2.set(keyField, trueValue);
                }
                break block7;
            }
            Optional<Long> first = dynamicObjectCollection.stream().filter(dy -> dy.getBoolean(finalKeyField)).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("modifytime"), Comparator.reverseOrder())).map(dy -> dy.getLong("id")).findFirst();
            if (first.isPresent()) {
                for (DynamicObject dynamicObject3 : dynamicObjectCollection) {
                    if (dynamicObject3.getLong("id") == first.get().longValue()) continue;
                    dynamicObject3.set(keyField, falseValue);
                }
            }
        }
    }

    private void handleUpdate(Map<String, DynamicObjectCollection> attachMap) {
        Object[] entityNames;
        for (Object entityName : entityNames = attachMap.keySet().toArray()) {
            DynamicObjectCollection collection;
            this.putNewDyToMap(entityName.toString(), attachMap.get(entityName), attachMap);
            if (!"hrpi_pertsprop".equals(entityName) || (collection = attachMap.get(entityName)) == null || collection.size() <= 0) continue;
            for (DynamicObject dynamicObject : collection) {
                Date effStartDate = dynamicObject.getDate("bsed");
                Date effEndDate = dynamicObject.getDate("bsled");
                LOGGER.info(MessageFormat.format("dynamicObject\u65f6\u5e8f\u5c5e\u6027\u751f\u6548\u65f6\u95f4\uff1a{0}\uff1b\u5931\u6548\u65f6\u95f4\uff1a{1};id:{2};boid:{3}", effStartDate != null ? HRDateTimeUtils.formatDate((Date)effStartDate) : "", effEndDate != null ? HRDateTimeUtils.formatDate((Date)effEndDate) : "", dynamicObject.getLong("id"), dynamicObject.getLong("boid")));
            }
        }
        Set updateBoIds = BusinessUtils.getUpdateBoIdGenPkId(attachMap, (boolean)false);
        boolean syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(attachMap, this.personId.longValue(), true);
        Map resultMap = AttacheHandlerService.getInstance().invokeSaveOrUpdate(attachMap);
        LOGGER.info(MessageFormat.format("update-->invokeSaveOrUpdate result:[{0}]", resultMap));
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            throw new KDBizException(MessageFormat.format(" billno:[{0}] update failed", this.billNo));
        }
        if (syncFlag) {
            AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(this.personId));
        }
        AttacheHandlerService.getInstance().sendHpfsChgSaveOrUpdateRecord(attachMap, updateBoIds, "hspm_infoapproval");
    }

    private void handleAdd(String entityName, DynamicObjectCollection addCollection) {
        if (!CollectionUtils.isEmpty((Collection)addCollection)) {
            Object[] dyArray = new DynamicObject[addCollection.size()];
            addCollection.toArray(dyArray);
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setEffImmediately(true);
            hisVersionParamBo.setEntityNumber(entityName);
            hisVersionParamBo.setHisDyns((DynamicObject[])dyArray);
            hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
            NoLineTimeHisVersionChangeService.getInstance().handleNoLineData(hisVersionParamBo);
            HashMap<String, DynamicObjectCollection> attachMap = new HashMap<String, DynamicObjectCollection>(2);
            attachMap.put(entityName, addCollection);
            boolean syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(attachMap, this.personId.longValue(), false);
            if (syncFlag) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(this.personId));
            }
            AttacheHandlerService.getInstance().sendHpfsChgSaveOrUpdateRecord(attachMap, new HashSet(), "hspm_infoapproval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAttachField(DynamicObject attachmentDy) {
        boolean success = true;
        String formId = attachmentDy.getString("entityname");
        Long pkId = attachmentDy.getLong("dataid");
        String attachKey = attachmentDy.getString("fieldname");
        String value = attachmentDy.getString("newvalue");
        AttacheHandlerService attachmentHandler = AttacheHandlerService.getInstance();
        try (TXHandle txHandle = TX.requiresNew();){
            List list = AttachmentServiceHelper.getAttachments((String)formId, (Object)(pkId + ""), (String)attachKey);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (Map map : list) {
                    attachmentHandler.invokeRemoveAttachment(formId, (Object)pkId, (Object)(map.get("uid") + ""));
                }
            }
            if (HRStringUtils.isEmpty((String)value)) {
                return;
            }
            List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)value, (String)attachKey);
            if (CollectionUtils.isEmpty((Collection)attachments)) {
                LOGGER.warn("attachments is empty");
                return;
            }
            ArrayList newAttachments = new ArrayList(attachments.size());
            for (Map map : attachments) {
                List mapList = BusinessUtils.getTempUrl((String)formId, (Map)map);
                newAttachments.addAll(mapList);
            }
            HashMap attachmentMap = new HashMap(2);
            attachmentMap.put(attachKey, newAttachments);
            attachmentHandler.invokeAttachment(formId, (Object)pkId, "", attachmentMap);
        }
        if (!success) {
            throw new KDBizException(MessageFormat.format(" billno:[{0}] handleAttachField failed", this.billNo));
        }
    }

    private void openMajor(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        DynamicObject[] mainPercres;
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ismajor", "=", (Object)true));
        for (DynamicObject mainPercre : mainPercres = helper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            boolean match = updateCollection.stream().anyMatch(dynamicObject -> dynamicObject.get("boid").equals(mainPercre.getLong("id")));
            if (match) continue;
            DynamicObject newDy = this.getNewDynamicObject(helper, mainPercre);
            newDy.set("ismajor", (Object)false);
            updateCollection.add((Object)newDy);
        }
    }

    private void openHighestDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        DynamicObject[] edus;
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ishighestdegree", "=", (Object)"1"));
        for (DynamicObject edu : edus = helper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            boolean match = updateCollection.stream().anyMatch(dynamicObject -> dynamicObject.get("boid").equals(edu.getLong("id")));
            if (match) continue;
            DynamicObject newDy = this.getNewDynamicObject(helper, edu);
            newDy.set("ishighestdegree", (Object)"0");
            updateCollection.add((Object)newDy);
        }
    }

    private void closeHighestDegree(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ishighestdegree", "=", (Object)"0"));
        DynamicObject[] edus = helper.query("id", new QFilter[]{qFilter}, "createtime desc", 1);
        if (edus.length > 0) {
            for (DynamicObject dynamicObject : updateCollection) {
                if (!dynamicObject.get("boid").equals(edus[0].getLong("id"))) continue;
                dynamicObject.set("ishighestdegree", (Object)"1");
                return;
            }
            DynamicObject newDy = this.getNewDynamicObject(helper, helper.loadSingle((Object)edus[0].getLong("id")));
            newDy.set("ishighestdegree", (Object)"1");
            updateCollection.add((Object)newDy);
        }
    }

    private void closeMajor(HRBaseServiceHelper helper, Long personId, DynamicObjectCollection updateCollection) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("ismajor", "=", (Object)false));
        DynamicObject[] percres = helper.query("id", new QFilter[]{qFilter}, "createtime desc", 1);
        if (percres.length > 0) {
            for (DynamicObject dynamicObject : updateCollection) {
                if (!dynamicObject.get("boid").equals(percres[0].getLong("id"))) continue;
                dynamicObject.set("ismajor", (Object)true);
                return;
            }
            DynamicObject newDy = this.getNewDynamicObject(helper, helper.loadSingle((Object)percres[0].getLong("id")));
            newDy.set("ismajor", (Object)true);
            updateCollection.add((Object)newDy);
        }
    }

    private DynamicObject getNewDynamicObject(HRBaseServiceHelper helper, DynamicObject oldDy) {
        DynamicObject newDy = helper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)newDy);
        return newDy;
    }

    private void putNewDyToMap(String entityName, DynamicObjectCollection updateCollection, Map<String, DynamicObjectCollection> attachMap) {
        Long personid;
        if (entityName.equals("hrpi_pernontsprop")) {
            for (DynamicObject object : updateCollection) {
                String name = object.getString("name");
                personid = object.getLong("person.id");
                this.putNew(attachMap, name, personid, "hrpi_person", "name");
                this.putNew(attachMap, name, personid, "hspm_ermanfile", "name");
            }
        }
        if (entityName.equals("hrpi_person")) {
            for (DynamicObject object : updateCollection) {
                String headsculpture = object.getString("headsculpture");
                personid = object.getLong("boid");
                this.putNew(attachMap, headsculpture, personid, "hrpi_pernontsprop", "headsculpture");
            }
        }
    }

    private void putNew(Map<String, DynamicObjectCollection> attachMap, String value, Long personid, String entityName, String fieldName) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter idFilter = entityName.equals("hrpi_person") ? new QFilter("id", "=", (Object)personid) : new QFilter("person.id", "=", (Object)personid);
        DynamicObject[] dbDyArray = personHelper.loadDynamicObjectArray(new QFilter[]{qFilter, statusFilter, idFilter});
        if (dbDyArray != null && dbDyArray.length > 0) {
            DynamicObjectCollection objectCollection = attachMap.get(entityName);
            if (objectCollection == null) {
                objectCollection = new DynamicObjectCollection();
            }
            for (DynamicObject dbDy : dbDyArray) {
                if (HRStringUtils.equals((String)value, (String)dbDy.getString(fieldName))) continue;
                DynamicObject dbObj = null;
                for (DynamicObject dynamicObject : objectCollection) {
                    if (dynamicObject.getLong("boid") != dbDy.getLong("boid")) continue;
                    dbObj = dynamicObject;
                    break;
                }
                if (dbObj == null) {
                    dbObj = personHelper.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)dbObj);
                    objectCollection.add((Object)dbObj);
                }
                dbObj.set(fieldName, (Object)value);
            }
            if (!attachMap.containsKey(entityName) && objectCollection.size() > 0) {
                attachMap.put(entityName, objectCollection);
            }
        }
    }

    private void updateEntityInfo(DynamicObject dynamicObject) {
        DynamicObject dbDy = INFOGROUPPAGEREG_HELPER.queryOne((Object)dynamicObject.getLong("id"));
        DynamicObjectCollection dbDys = (DynamicObjectCollection)dbDy.get("entryentity");
        for (DynamicObject dy : dbDys) {
            if (dy.getBoolean("status")) {
                dy.set("status", (Object)Boolean.FALSE);
            }
            if (!(dy.get("reason") instanceof OrmLocaleValue)) continue;
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dy.get("reason");
            ormLocaleValue.setLocaleValue(null);
        }
        INFOGROUPPAGEREG_HELPER.updateOne(dbDy);
        this.personId = dbDy.getLong("person.id");
        this.billNo = dbDy.getString("billno");
    }

    private void setValue(DynamicObject updateDy, DynamicObject field) {
        String fieldName = field.getString("fieldname");
        String fieldType = field.getString("fieldtype");
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.geCodeByFieldType((String)fieldType);
        if (fieldTypeEnum == null) {
            LOGGER.error(MessageFormat.format("cant not found the fieldtype[{0}]", fieldType));
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6570\u636e\u7c7b\u578b", (String)"InfoGroupUpdateApprovalOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        String newValue = field.getString("newvalue");
        try {
            switch (fieldTypeEnum) {
                case MULILANG_TEXT: {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)updateDy.get(fieldName);
                    ormLocaleValue.setLocaleValue(newValue);
                    updateDy.set(fieldName, (Object)ormLocaleValue);
                    break;
                }
                case TEXT: {
                    updateDy.set(fieldName, (Object)newValue);
                    break;
                }
                case COMBO: {
                    updateDy.set(fieldName, (Object)newValue);
                    break;
                }
                case BOOLEAN: {
                    updateDy.set(fieldName, (Object)Boolean.parseBoolean(newValue));
                    break;
                }
                case DATE: 
                case DATE_TIME: {
                    updateDy.set(fieldName, (Object)(HRStringUtils.isEmpty((String)newValue) ? null : new Timestamp(Long.parseLong(newValue))));
                    break;
                }
                case LONG: {
                    updateDy.set(fieldName, (Object)Long.parseLong(newValue));
                    break;
                }
                case INTEGER: 
                case BIG_INT: {
                    updateDy.set(fieldName, (Object)Integer.parseInt(newValue));
                    break;
                }
                case DECIMAL: {
                    updateDy.set(fieldName, (Object)new BigDecimal(newValue));
                    break;
                }
                case AMOUNTPROP: {
                    updateDy.set(fieldName, (Object)newValue);
                    break;
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: {
                    updateDy.set(fieldName, (Object)Long.valueOf(newValue));
                    updateDy.set(fieldName + "_id", (Object)Long.valueOf(newValue));
                    break;
                }
                case MULBASEDATAPROP: {
                    updateDy.set(fieldName, (Object)ValueConvertHelper.getMulBaseDataCollection((DynamicObject)updateDy, (String)fieldName, (String)newValue));
                    break;
                }
                case PICTURE: {
                    updateDy.set(fieldName, (Object)newValue);
                    break;
                }
                default: {
                    updateDy.set(fieldName, (Object)newValue);
                    break;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25\u6216\u8005\u4e0d\u652f\u6301\u6539\u7c7b\u578b\u7684\u6570\u636e\u4fee\u6539 fieldName:{0}", (String)"InfoGroupUpdateApprovalOp_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]), fieldName));
        }
    }
}

