/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.report;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.validate.AbstractValidator;
import org.jetbrains.annotations.NotNull;

public class ReportDisplayaliasValidator
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
    }

    public void validate() {
        Map<String, String> fieldAliasEntityNameMap = this.queryFieldAliasEntityNameMap();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObjectCollection detailshowentityCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("detailshowentity");
            Map<String, List<DynamicObject>> displayaliasDyListMap = detailshowentityCollection.stream().collect(Collectors.groupingBy(dataEntity -> dataEntity.getLocaleString("displayalias").getLocaleValue()));
            for (Map.Entry<String, List<DynamicObject>> entry : displayaliasDyListMap.entrySet()) {
                List<DynamicObject> dataEntityList = entry.getValue();
                if (dataEntityList.size() <= 1) continue;
                String displayalias = entry.getKey();
                List shownodeidList = dataEntityList.stream().map(dataEntity -> dataEntity.getString("shownodeid")).distinct().collect(Collectors.toList());
                StringBuilder errMsgBuilder = new StringBuilder();
                for (int i = 0; i < shownodeidList.size(); ++i) {
                    errMsgBuilder.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"ReportDisplayaliasValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]), fieldAliasEntityNameMap.get(shownodeidList.get(i))));
                    if (i == shownodeidList.size() - 1) continue;
                    if (i != shownodeidList.size() - 2) {
                        errMsgBuilder.append(',');
                        continue;
                    }
                    errMsgBuilder.append(ResManager.loadKDString((String)"\u4e0e", (String)"ReportDisplayaliasValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
                }
                String errMsgOne = ResManager.loadKDString((String)"\u7684", (String)"ReportDisplayaliasValidator_5", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
                String errMsgTwo = ResManager.loadKDString((String)"%s\u91cd\u590d\uff0c\u8bf7\u524d\u5f80\u9ad8\u7ea7\u8bbe\u7f6e\u4fee\u6539\u5b57\u6bb5\u663e\u793a\u540d\u3002", (String)"ReportDisplayaliasValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[]{displayalias});
                errMsgBuilder.append(errMsgOne).append(errMsgTwo);
                this.addFatalErrorMessage(extendedDataEntity, errMsgBuilder.toString());
            }
        }
    }

    @NotNull
    private Map<String, String> queryFieldAliasEntityNameMap() {
        String reportpage = this.getOption().getVariableValue("reportpage");
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)reportpage);
        List fields = queryEntityType.getSelectFields();
        List joinEntityList = queryEntityType.getJoinEntitys();
        Set joinEntityAliasSet = joinEntityList.stream().map(JoinEntity::getAlias).collect(Collectors.toSet());
        HashMap<String, String> fieldAliasEntityNameMap = new HashMap<String, String>(16);
        for (QuerySelectField querySelectField : fields) {
            String basePage;
            String secondName = ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848", (String)"ReportDisplayaliasValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
            String entityAlias = querySelectField.getAlias().split("\\.")[0];
            if (joinEntityAliasSet.contains(entityAlias) && (secondName = querySelectField.getLocaleDisplayName().getLocaleValue().split("\\.")[0]).endsWith(basePage = ResManager.loadKDString((String)"\u57fa\u7840\u9875\u9762", (String)"ReportDisplayaliasValidator_4", (String)"hr-hspm-opplugin", (Object[])new Object[0]))) {
                secondName = secondName.replace(basePage, "");
            }
            fieldAliasEntityNameMap.put(querySelectField.getAlias(), secondName);
        }
        return fieldAliasEntityNameMap;
    }
}

