/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hspm.business.domian.repository.inforevise.EmployeeRepository;

public class EmpEntrelReviseSaveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(EmpEntrelReviseSaveValidator.class);

    public void validate() {
        try {
            ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
            Set mIdSet = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("employee.mid")).collect(Collectors.toSet());
            DynamicObject[] employeeDynArr = EmployeeRepository.getInstance().queryDynArrayByMIdSet(mIdSet, "startdate desc");
            for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
                Date workStartDate;
                DynamicObject postDyn;
                Date workEndDate;
                DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
                Date startDate = dataEntity.getDate("startdate");
                Date endDate = dataEntity.getDate("enddate");
                if (Objects.isNull(endDate)) {
                    endDate = HisEffDateCommonService.getInstance().getDate2999(null);
                }
                if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                    this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u3002", (String)"EmpEntrelReviseSaveValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
                }
                long mId = dataEntity.getLong("employee.mid");
                List<DynamicObject> employeeDynListAfterFilter = Arrays.stream(employeeDynArr).filter(dyn -> mId == dyn.getLong("mid")).collect(Collectors.toList());
                Collections.sort(employeeDynListAfterFilter, Comparator.comparing(o -> o.getDate("startdate")));
                DynamicObject preDyn = this.getPreDyn(employeeDynListAfterFilter, dataEntity);
                if (Objects.nonNull(preDyn) && HRDateTimeUtils.dayBefore((Date)startDate, (Date)(workEndDate = preDyn.getDate("enddate")))) {
                    String dateStr = HRDateTimeUtils.format((Date)workEndDate, (String)"yyyy-MM-dd");
                    this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u4e00\u6b21\u7528\u5de5\u7ed3\u675f\u65e5\u671f%s\u3002", (String)"EmpEntrelReviseSaveValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr));
                }
                if (!Objects.nonNull(postDyn = this.getPostDyn(employeeDynListAfterFilter, dataEntity)) || !HRDateTimeUtils.dayBefore((Date)(workStartDate = postDyn.getDate("startDate")), (Date)endDate)) continue;
                String dateStr = HRDateTimeUtils.format((Date)workStartDate, (String)"yyyy-MM-dd");
                this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u4e0b\u6b21\u7528\u5de5\u5f00\u59cb\u65e5\u671f%s\u3002", (String)"EmpEntrelReviseSaveValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr));
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    private DynamicObject getPostDyn(List<DynamicObject> employeeDynListAfterFilter, DynamicObject dataEntity) {
        long employeeBoId = dataEntity.getLong("employee.boid");
        for (int i = 0; i < employeeDynListAfterFilter.size(); ++i) {
            DynamicObject curDyn = employeeDynListAfterFilter.get(i);
            long curBoId = curDyn.getLong("boid");
            if (employeeBoId != curBoId) continue;
            if (i == employeeDynListAfterFilter.size() - 1) {
                return null;
            }
            return employeeDynListAfterFilter.get(i + 1);
        }
        LOG.info("getPostDyn get null");
        return null;
    }

    private DynamicObject getPreDyn(List<DynamicObject> employeeDynListAfterFilter, DynamicObject dataEntity) {
        long employeeBoId = dataEntity.getLong("employee.boid");
        for (int i = 0; i < employeeDynListAfterFilter.size(); ++i) {
            DynamicObject curDyn = employeeDynListAfterFilter.get(i);
            long curBoId = curDyn.getLong("boid");
            if (employeeBoId != curBoId) continue;
            if (i > 0) {
                return employeeDynListAfterFilter.get(i - 1);
            }
            return null;
        }
        return null;
    }
}

