/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;
import kd.hr.hspm.business.domian.service.impl.inforevise.EmpposorgrelServiceImpl;
import kd.hr.hspm.business.domian.service.inforevise.IInfoReviseService;
import kd.hr.hspm.opplugin.web.revise.EmpPosOrgRelReviseSaveValidator;
import kd.hr.hspm.opplugin.web.revise.PersonReviseSaveOp;

public class EmpPosOrgRelReviseSaveOp
extends PersonReviseSaveOp {
    private static final Log LOG = LogFactory.getLog(EmpPosOrgRelReviseSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new EmpPosOrgRelReviseSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("employee");
        e.getFieldKeys().add("stdpositionvid");
        e.getFieldKeys().add("jobvid");
        e.getFieldKeys().add("isprimary");
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.clearPositionIfJob(e);
        super.beginOperationTransaction(e);
    }

    @Override
    protected void setBusinessStatus(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Date endDate = dataEntity.getDate("enddate");
            if (Objects.nonNull(endDate) && !HRDateTimeUtils.dayEquals((Date)endDate, (Date)HisEffDateCommonService.getInstance().getDate2999(null))) {
                dataEntity.set("businessstatus", (Object)"2");
                continue;
            }
            dataEntity.set("businessstatus", (Object)"1");
        }
    }

    @Override
    protected List<String> getData2999Field() {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)16);
        fieldList.add("enddate");
        fieldList.add("lastworkdate");
        return fieldList;
    }

    private void clearPositionIfJob(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List idList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        DynamicObject[] empPosOrgRelDynArrFromDB = EmpposorgrelRepository.getInstance().queryColEffectiveHisDataByIds(idList);
        Map<Long, DynamicObject> idVsEmpPosOrgRelDynMap = Arrays.stream(empPosOrgRelDynArrFromDB).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (DynamicObject dataEntity2 : dataEntities) {
            String aPositionTypeFromDB;
            long curId = dataEntity2.getLong("id");
            DynamicObject empPosOrgRelDynFromDB = idVsEmpPosOrgRelDynMap.get(curId);
            if (Objects.isNull(empPosOrgRelDynFromDB)) {
                LOG.info("empPosOrgRelDyn is new");
                continue;
            }
            String aPositionType = dataEntity2.getString("apositiontype");
            if (!HRStringUtils.equals((String)aPositionType, (String)(aPositionTypeFromDB = empPosOrgRelDynFromDB.getString("apositiontype"))) || !HRStringUtils.equals((String)aPositionTypeFromDB, (String)"2")) continue;
            Long jobBoId = dataEntity2.getLong("jobvid.boid");
            Long jobBoIdFromDB = empPosOrgRelDynFromDB.getLong("jobvid.boid");
            if (jobBoId == null || jobBoIdFromDB == null || jobBoId.equals(jobBoIdFromDB)) continue;
            dataEntity2.set("positionvid", null);
            dataEntity2.set("position", null);
        }
    }

    private void setLastWorkDate(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Date endDate = dataEntity.getDate("lastworkdate");
            if (!Objects.isNull(endDate)) continue;
            dataEntity.set("lastworkdate", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
        }
    }

    @Override
    protected String getBaseEntityName() {
        return "hrpi_empposorgrel";
    }

    @Override
    protected IInfoReviseService getReviseSaveService() {
        return new EmpposorgrelServiceImpl();
    }
}

