/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.hspm.business.domian.service.inforevise.IInfoReviseService;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.business.revise.service.impl.PersonReviseLogServiceImpl;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PersonReviseSaveOp
extends HRCoreBaseBillOp
implements PersonReviseConstants {
    private static final Log LOG = LogFactory.getLog(PersonReviseSaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.set2999Date(e);
        this.setBusinessStatus(e);
        e.setCancelOperation(true);
        DynamicObject dataEntity = e.getDataEntities()[0];
        IInfoReviseService iInfoReviseService = this.getReviseSaveService();
        if (Objects.isNull(iInfoReviseService)) {
            return;
        }
        OperateOption option = this.getOption();
        String reviseSaveType = option.getVariableValue("revisetype");
        if ("newbo".equals(reviseSaveType)) {
            this.treatForNewBo(dataEntity, iInfoReviseService, option);
        } else if ("reviseversion".equals(reviseSaveType)) {
            this.treatReviseVersion(dataEntity, iInfoReviseService, option);
        }
    }

    protected void setBusinessStatus(BeginOperationTransactionArgs e) {
    }

    private void set2999Date(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            List<String> data2999Field = this.getData2999Field();
            for (String field : data2999Field) {
                Date dateField = dataEntity.getDate(field);
                if (!Objects.isNull(dateField)) continue;
                dataEntity.set(field, (Object)HisEffDateCommonService.getInstance().getDate2999(null));
            }
        }
    }

    protected List<String> getData2999Field() {
        return new ArrayList<String>();
    }

    private void treatReviseVersion(DynamicObject dataEntity, IInfoReviseService iInfoReviseService, OperateOption option) {
        HrpiServiceOperateResult result = iInfoReviseService.revise(dataEntity);
        if (!result.isSuccess()) {
            option.setVariableValue("resultFlag", "fail");
            option.setVariableValue("errMsg", result.getMessage());
            return;
        }
        Map<String, Object> resultMap = this.getResultMap(dataEntity, result);
        if (CollectionUtils.isEmpty(resultMap)) {
            option.setVariableValue("resultFlag", "noInfoChange");
            option.setVariableValue("resultCode", "fail");
            option.setVariableValue("errMsg", ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u53d8\u66f4\u4fe1\u606f\u3002", (String)"PersonReviseDetailEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        String resultCode = (String)resultMap.get("code");
        if ("200".equals(resultCode)) {
            DynamicObject[] hisVersionReviseDyns;
            Map dataMap = (Map)resultMap.get("data");
            for (DynamicObject hisVersionReviseDyn : hisVersionReviseDyns = (DynamicObject[])dataMap.get("hisVersionReviseDyns")) {
                LOG.info("treatReviseVersion fid ={},fboid={}, fdatastatus={}", new Object[]{hisVersionReviseDyn.getLong("id"), hisVersionReviseDyn.getLong("boid"), hisVersionReviseDyn.getString("datastatus")});
            }
            long dataEntityId = dataEntity.getLong("id");
            DynamicObject beforeDyn = Arrays.stream(hisVersionReviseDyns).filter(dyn -> EnumHisDataVersionStatus.REVISED.getStatus().equals(dyn.getString("datastatus"))).filter(dyn -> dyn.getLong("sourcevid") == dataEntityId).findFirst().get();
            DynamicObject afterDyn = Arrays.stream(hisVersionReviseDyns).filter(dyn -> dataEntity.getString("datastatus").equals(dyn.getString("datastatus"))).filter(dyn -> "false".equals(dyn.getString("iscurrentversion"))).filter(dyn -> dyn.getLong("id") == dataEntityId).findFirst().get();
            DynamicObject reviseDyn = Arrays.stream(hisVersionReviseDyns).filter(dyn -> EnumHisDataVersionStatus.REVISED.getStatus().equals(dyn.getString("datastatus"))).filter(dyn -> "false".equals(dyn.getString("iscurrentversion"))).findFirst().get();
            PersonReviseLogServiceImpl personReviseLogService = new PersonReviseLogServiceImpl();
            Long reviseRecordId = Long.valueOf(option.getVariableValue("reviserecordid"));
            personReviseLogService.saveReviseLogDyn(dataEntity, Long.valueOf(beforeDyn.getLong("id")), Long.valueOf(afterDyn.getLong("id")), "5", reviseRecordId);
            option.setVariableValue("resultFlag", "success");
            if (Objects.nonNull(afterDyn)) {
                option.setVariableValue("reviseHisId", String.valueOf(reviseDyn.getLong("id")));
                option.setVariableValue("newHisId", String.valueOf(afterDyn.getLong("id")));
                option.setVariableValue("newBoId", String.valueOf(afterDyn.getLong("boid")));
            }
        } else {
            String errorMessage = (String)resultMap.get("errorMessage");
            option.setVariableValue("resultCode", "fail");
            option.setVariableValue("errMsg", errorMessage);
        }
    }

    private Map<String, Object> getResultMap(DynamicObject dataEntity, HrpiServiceOperateResult result) {
        Map resultMap = Maps.newHashMapWithExpectedSize((int)16);
        String reviseEntityName = dataEntity.getDynamicObjectType().getName();
        String baseEntityName = ReviseEntityNameHelperEnum.getBaseEntityNameByReviseEntityName((String)reviseEntityName);
        List outDataList = result.getData();
        if (Objects.isNull(outDataList)) {
            return resultMap;
        }
        for (Map outData : outDataList) {
            Map innerData = (Map)outData.get("data");
            String baseEntityNumberFromData = (String)innerData.get("entitynumber");
            if (!baseEntityName.equals(baseEntityNumberFromData)) continue;
            resultMap = outData;
        }
        return resultMap;
    }

    private void treatForNewBo(DynamicObject dataEntity, IInfoReviseService iInfoReviseService, OperateOption option) {
        HrpiServiceOperateResult result = iInfoReviseService.saveBatch(dataEntity);
        if (!result.isSuccess()) {
            option.setVariableValue("resultFlag", "fail");
            option.setVariableValue("errMsg", result.getMessage());
            return;
        }
        Map resultMap = (Map)result.getData().get(0);
        String resultCode = (String)resultMap.get("code");
        if ("200".equals(resultCode)) {
            option.setVariableValue("resultFlag", "success");
            Map dataMap = (Map)resultMap.get("data");
            Map responseMap = (Map)((List)dataMap.get("versionChangeRespDataList")).get(0);
            String entityNumber = (String)responseMap.get("entitynumber");
            DynamicObject[] newDynArr = (DynamicObject[])responseMap.get("newDynamicObjects");
            DynamicObject curNewHisDyn = Arrays.stream(newDynArr).filter(dyn -> "false".equals(dyn.getString("iscurrentversion"))).findFirst().get();
            long afterId = curNewHisDyn.getLong("id");
            PersonReviseLogServiceImpl personReviseLogService = new PersonReviseLogServiceImpl();
            Long reviseRecordId = Long.valueOf(option.getVariableValue("reviserecordid"));
            personReviseLogService.saveReviseLogDyn(dataEntity, Long.valueOf(0L), Long.valueOf(afterId), "0", reviseRecordId);
            option.setVariableValue("resultFlag", "success");
            option.setVariableValue("newHisId", String.valueOf(curNewHisDyn.getLong("id")));
            option.setVariableValue("newBoId", String.valueOf(curNewHisDyn.getLong("boid")));
        } else {
            String errorMessage = (String)resultMap.get("errorMessage");
            option.setVariableValue("resultCode", "fail");
            option.setVariableValue("errMsg", errorMessage);
        }
    }

    protected IInfoReviseService getReviseSaveService() {
        return null;
    }

    protected String getBaseEntityName() {
        return "";
    }
}

