/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;
import kd.hr.hspm.business.domian.repository.inforevise.ReviseLogRepository;
import kd.hr.hspm.business.revise.helper.PersonReviseHelper;
import kd.hr.hspm.mservice.api.IReviseRecordService;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.business.revise.helper.DynamicConvertUtils;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class ReviseRecordServiceImpl
implements IReviseRecordService,
PersonReviseConstants {
    private static final Log LOGGER = LogFactory.getLog(ReviseRecordServiceImpl.class);
    private static final String KEY_IS_SUCCESS = "success";
    private static final String KEY_ERROR_MSG = "message";
    private static final String MERGE_TYPE_NO = "-1";
    private static final String MERGE_TYPE_NEW = "1";
    private static final String MERGE_TYPE_DEL = "2";
    private static final String MERGE_TYPE_REV = "3";

    public Map<String, Object> queryAndCompareReviseLog(String entityNumber, List<Long> reviseRecordIdList) {
        return this.queryAndCompareReviseLog(entityNumber, reviseRecordIdList, Lists.newArrayListWithExpectedSize((int)0));
    }

    public Map<String, Object> queryAndCompareReviseLog(String entityNumber, List<Long> reviseRecordIdList, List<String> ignoreFieldList) {
        LOGGER.info("entityName={}, reviseRecordIdList={}", (Object)entityNumber, reviseRecordIdList);
        List supportReviseEntityNumberList = BusinessUtils.getReviseSupportEntityNumberList();
        if (!supportReviseEntityNumberList.contains(entityNumber)) {
            return this.setFail("don't support this revise entityNumber.");
        }
        if (CollectionUtils.isEmpty(reviseRecordIdList)) {
            return this.setFail("reviseRecordIdList is empty.");
        }
        DynamicObject[] reviseLogDynArr = ReviseLogRepository.getInstance().loadByRecordId(entityNumber, reviseRecordIdList);
        List reviseLogIdList = Arrays.stream(reviseLogDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reviseLogIdList)) {
            LOGGER.info("reviseLogIdList is empty.");
            return this.setFail("can't query out any reviselogid, data error.");
        }
        Set reviseNumberSet = Arrays.stream(reviseLogDynArr).map(dyn -> dyn.getString("revisenumber")).collect(Collectors.toSet());
        if (reviseNumberSet.size() > 1) {
            LOGGER.info("reviseLogIdList is empty.");
            return this.setFail("can't support to query the revise record of multiple entities.");
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        dataMap.put("entityNumber", entityNumber);
        ArrayList reviseBoList = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, List<DynamicObject>> reviseBoIdVsLogDynListMap = Arrays.stream(reviseLogDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("revisebo.id")));
        Set<Long> reviseBoIdSet = reviseBoIdVsLogDynListMap.keySet();
        Map<Long, DynamicObject> idVsDynMap = this.getRelatedEntityDynMap(entityNumber, reviseBoIdSet);
        List employeeIdList = idVsDynMap.values().stream().map(dyn -> dyn.getLong("employee.id")).collect(Collectors.toList());
        DynamicObject[] isPrimaryEmpPosOrgRelDynArr = EmpposorgrelRepository.getInstance().queryIsPrimaryDataByEmployeeIdList(employeeIdList);
        Map<Long, DynamicObject> employeeIdVsIsPrimaryEmpPosOrgRelDynMap = Arrays.stream(isPrimaryEmpPosOrgRelDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("employee.id"), dyn -> dyn, (o1, o2) -> o1));
        Set<Map.Entry<Long, List<DynamicObject>>> entries = reviseBoIdVsLogDynListMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            long beforeId;
            HashMap reviseBoListDataMap = Maps.newHashMapWithExpectedSize((int)16);
            Long reviseBoId = entry.getKey();
            DynamicObject curDyn = idVsDynMap.get(reviseBoId);
            reviseBoListDataMap.put("reviseBo", reviseBoId);
            this.putFourLayerPersonInfo(entityNumber, reviseBoListDataMap, curDyn, employeeIdVsIsPrimaryEmpPosOrgRelDynMap);
            List<DynamicObject> reviseLogDynList = entry.getValue();
            int size = reviseLogDynList.size();
            reviseLogDynList.sort(Comparator.comparing(o -> o.getDate("createtime")));
            String mergeType = this.getMergeType(reviseLogDynList);
            ArrayList reviseLogList = Lists.newArrayListWithExpectedSize((int)16);
            HashMap reviseLogDataMap = Maps.newHashMapWithExpectedSize((int)16);
            reviseLogDataMap.put("reviseReason", this.getReviseReason(reviseLogDynList));
            reviseLogDataMap.put("reviseDesc", this.getReviseDesc(reviseLogDynList));
            reviseLogDataMap.put("reviseBo", reviseBoId);
            Date lastLogCreateTime = reviseLogDynList.get(reviseLogDynList.size() - 1).getDate("createtime");
            reviseLogDataMap.put("reviseDate", lastLogCreateTime);
            if (HRStringUtils.equals((String)mergeType, (String)MERGE_TYPE_NO)) {
                LOGGER.info("queryAndCompareReviseLog BOID={} has no field change", (Object)reviseBoId);
                continue;
            }
            if (HRStringUtils.equals((String)mergeType, (String)MERGE_TYPE_NEW)) {
                reviseLogDataMap.put("reviseType", "0");
                reviseLogDataMap.put("reviseBefore", 0L);
                long afterId = this.getLastDynId(reviseLogDynList, size);
                reviseLogDataMap.put("reviseAfter", afterId);
                DynamicObject afterDyn = CommonQueryRepository.getInstance().loadInfoById(entityNumber, Long.valueOf(afterId));
                DynamicObject beforeDyn = new HRBaseServiceHelper(entityNumber).generateEmptyDynamicObject();
                reviseLogDataMap.put("reviseCompareLogList", this.getReviseCompareLogList(entityNumber, beforeDyn, afterDyn, ignoreFieldList));
            } else if (HRStringUtils.equals((String)mergeType, (String)MERGE_TYPE_DEL)) {
                reviseLogDataMap.put("reviseType", MERGE_TYPE_NEW);
                reviseLogDataMap.put("reviseAfter", 0L);
                beforeId = this.getBeforeDynId(reviseLogDynList);
                reviseLogDataMap.put("reviseBefore", beforeId);
                DynamicObject beforeDyn = CommonQueryRepository.getInstance().loadInfoById(entityNumber, Long.valueOf(beforeId));
                DynamicObject afterDyn = new HRBaseServiceHelper(entityNumber).generateEmptyDynamicObject();
                reviseLogDataMap.put("reviseCompareLogList", this.getReviseCompareLogList(entityNumber, beforeDyn, afterDyn, ignoreFieldList));
            } else if (HRStringUtils.equals((String)mergeType, (String)MERGE_TYPE_REV)) {
                reviseLogDataMap.put("reviseType", "5");
                beforeId = this.getBeforeDynId(reviseLogDynList);
                reviseLogDataMap.put("reviseBefore", beforeId);
                long afterId = this.getLastDynId(reviseLogDynList, size);
                reviseLogDataMap.put("reviseAfter", afterId);
                DynamicObject beforeDyn = CommonQueryRepository.getInstance().loadInfoById(entityNumber, Long.valueOf(beforeId));
                DynamicObject afterDyn = CommonQueryRepository.getInstance().loadInfoById(entityNumber, Long.valueOf(afterId));
                List<Map<String, Object>> reviseCompareLogList = this.getReviseCompareLogList(entityNumber, beforeDyn, afterDyn, ignoreFieldList);
                reviseLogDataMap.put("reviseCompareLogList", reviseCompareLogList);
                if (CollectionUtils.isEmpty(reviseCompareLogList)) {
                    reviseLogDataMap.put("reviseType", MERGE_TYPE_NO);
                    LOGGER.info("queryAndCompareReviseLog BOID={} has no field change", (Object)reviseBoId);
                    continue;
                }
            }
            reviseLogList.add(reviseLogDataMap);
            reviseBoListDataMap.put("reviseLogList", reviseLogList);
            reviseBoList.add(reviseBoListDataMap);
        }
        dataMap.put("reviseBoList", reviseBoList);
        return this.successMap(dataMap);
    }

    private void putFourLayerPersonInfo(String entityNumber, Map<String, Object> reviseBoListDataMap, DynamicObject curDyn, Map<Long, DynamicObject> employeeIdVsIsPrimaryEmpPosOrgRelDynMap) {
        reviseBoListDataMap.put("person", curDyn.getLong("person.id"));
        long employeeId = curDyn.getLong("employee.id");
        reviseBoListDataMap.put("employee", curDyn.getLong("employee.id"));
        if ("hrpi_empposorgrel".equals(entityNumber)) {
            reviseBoListDataMap.put("depemp", curDyn.getLong("depemp.id"));
            reviseBoListDataMap.put("cmpemp", curDyn.getLong("cmpemp.id"));
            reviseBoListDataMap.put("empPosOrgRel", curDyn.getLong("id"));
        } else {
            DynamicObject isPrimaryEmpPosOrgRelDyn = employeeIdVsIsPrimaryEmpPosOrgRelDynMap.get(employeeId);
            if (Objects.isNull(isPrimaryEmpPosOrgRelDyn)) {
                reviseBoListDataMap.put("cmpemp", null);
                reviseBoListDataMap.put("empPosOrgRel", null);
                reviseBoListDataMap.put("depemp", null);
            } else {
                long empPosOrgRelId = isPrimaryEmpPosOrgRelDyn.getLong("id");
                long depEmpId = isPrimaryEmpPosOrgRelDyn.getLong("depemp.id");
                long cmpEmpId = isPrimaryEmpPosOrgRelDyn.getLong("cmpemp.id");
                reviseBoListDataMap.put("cmpemp", cmpEmpId);
                reviseBoListDataMap.put("empPosOrgRel", empPosOrgRelId);
                reviseBoListDataMap.put("depemp", depEmpId);
            }
        }
    }

    private Map<Long, DynamicObject> getRelatedEntityDynMap(String entityNumber, Set<Long> reviseBoIdSet) {
        HashSet fieldSet = Sets.newHashSetWithExpectedSize((int)16);
        fieldSet.add("id");
        if ("hrpi_empposorgrel".equals(entityNumber)) {
            fieldSet.add("person");
            fieldSet.add("depemp");
            fieldSet.add("employee");
            fieldSet.add("cmpemp");
        } else if ("hrpi_empentrel".equals(entityNumber)) {
            fieldSet.add("person");
            fieldSet.add("employee");
        } else if ("hrpi_trialperiod".equals(entityNumber)) {
            fieldSet.add("person");
            fieldSet.add("employee");
        }
        QFilter reviseBoIdFilter = new QFilter("id", "in", reviseBoIdSet);
        DynamicObject[] dynArr = CommonQueryRepository.getInstance().queryColsInfoByFilter(entityNumber, (Set)fieldSet, reviseBoIdFilter);
        return Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private long getBeforeDynId(List<DynamicObject> reviseLogDynList) {
        DynamicObject firstDyn = reviseLogDynList.get(0);
        return firstDyn.getLong("revisebefore.id");
    }

    private long getLastDynId(List<DynamicObject> reviseLogDynList, int size) {
        DynamicObject lastDyn = reviseLogDynList.get(size - 1);
        return lastDyn.getLong("reviseafter.id");
    }

    private List<Map<String, Object>> getReviseCompareLogList(String entityNumber, DynamicObject beforeDyn, DynamicObject afterDyn, List<String> ignoreFieldList) {
        List compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList((String)entityNumber);
        if (CollectionUtils.isEmpty(ignoreFieldList)) {
            compareExcludeFieldList.addAll(ignoreFieldList);
        }
        DynamicConvertUtils dynamicConvertUtils = new DynamicConvertUtils(compareExcludeFieldList);
        List compareResults = dynamicConvertUtils.compareAndGetAllDiffCol(afterDyn, beforeDyn);
        ArrayList reviseCompareLogList = Lists.newArrayListWithExpectedSize((int)16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection mainEntityTypeProps = mainEntityType.getProperties();
        Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
        Map<String, String> fieldVsNameMap = this.getFieldVsNameMap(afterDyn);
        for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
            if (compareResult.isSame()) continue;
            HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)16);
            String propKey = compareResult.getPropKey();
            IDataEntityProperty iDataEntityProperty = propMap.get(propKey);
            String fieldName = fieldVsNameMap.get(propKey);
            String beforeDisplayValue = PersonReviseHelper.getDisplayValueByProp((DynamicObject)beforeDyn, (IDataEntityProperty)propMap.get(propKey));
            String afterDisplayValue = PersonReviseHelper.getDisplayValueByProp((DynamicObject)afterDyn, (IDataEntityProperty)propMap.get(propKey));
            if (HRStringUtils.equals((String)propKey, (String)"servicelength") && HRStringUtils.equals((String)beforeDisplayValue, (String)afterDisplayValue)) continue;
            compareResultMap.put("reviseField", propKey);
            compareResultMap.put("reviseFieldName", fieldName);
            compareResultMap.put("reviseValBefore", beforeDisplayValue);
            compareResultMap.put("reviseValAfter", afterDisplayValue);
            reviseCompareLogList.add(compareResultMap);
        }
        return reviseCompareLogList;
    }

    private Map<String, String> getFieldVsNameMap(DynamicObject curDyn) {
        DataEntityPropertyCollection properties = curDyn.getDataEntityType().getProperties();
        HashMap fieldVsNameMap = Maps.newHashMapWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : curDyn.getDataEntityType().getProperties()) {
            if (!Objects.nonNull(property.getDisplayName())) continue;
            fieldVsNameMap.put(property.getName(), property.getDisplayName().getLocaleValue());
        }
        return fieldVsNameMap;
    }

    private List<Map<String, Object>> getReviseReason(List<DynamicObject> reviseLogDynList) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject reviseLogDyn : reviseLogDynList) {
            DynamicObject reviseReasonDyn = reviseLogDyn.getDynamicObject("revisereason");
            if (!Objects.nonNull(reviseReasonDyn)) continue;
            list.add(this.getBaseDataReturnValue(reviseReasonDyn));
        }
        return list;
    }

    private Map<String, Object> getBaseDataReturnValue(DynamicObject dyn) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if (Objects.nonNull(dyn)) {
            map.put("id", dyn.getLong("id"));
            map.put("name", dyn.getString("name"));
        }
        return map;
    }

    private List<String> getReviseDesc(List<DynamicObject> reviseLogDynList) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject reviseLogDyn : reviseLogDynList) {
            String reviseDesc = reviseLogDyn.getString("revisedesc");
            if (!HRStringUtils.isNotEmpty((String)reviseDesc)) continue;
            list.add(reviseDesc);
        }
        return list;
    }

    private String getMergeType(List<DynamicObject> reviseLogDynList) {
        int size = reviseLogDynList.size();
        DynamicObject firstDyn = reviseLogDynList.get(0);
        DynamicObject lastDyn = reviseLogDynList.get(size - 1);
        String firstDynReviseType = firstDyn.getString("revisetype");
        String lastDynReviseType = lastDyn.getString("revisetype");
        if (HRStringUtils.equals((String)firstDynReviseType, (String)"0") && HRStringUtils.equals((String)lastDynReviseType, (String)MERGE_TYPE_NEW)) {
            return MERGE_TYPE_NO;
        }
        if (HRStringUtils.equals((String)firstDynReviseType, (String)"0")) {
            return MERGE_TYPE_NEW;
        }
        if (HRStringUtils.equals((String)lastDynReviseType, (String)MERGE_TYPE_NEW)) {
            return MERGE_TYPE_DEL;
        }
        return MERGE_TYPE_REV;
    }

    private Map<String, Object> successMap(Object data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_IS_SUCCESS, true);
        resultMap.put(KEY_ERROR_MSG, "");
        resultMap.put("data", data);
        return resultMap;
    }

    private Map<String, Object> setFail(String errMsg) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        resultMap.put(KEY_IS_SUCCESS, false);
        resultMap.put(KEY_ERROR_MSG, errMsg);
        return resultMap;
    }
}

