/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.approval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.approval.ext.defaultimpl.DefaultApprovalEntryOrderServiceExtend;
import kd.sdk.hr.hspm.formplugin.approval.IApprovalEntryOrderServiceExtend;
import kd.sdk.hr.hspm.formplugin.approval.dto.ApprovalOrderParamDTO;
import kd.sdk.hr.hspm.formplugin.approval.dto.FieldAndOrderDTO;

public class ApprovalMulLineTableOrderHelper {
    private static final Log LOGGER = LogFactory.getLog(ApprovalMulLineTableOrderHelper.class);

    public static Map<String, String> treatExtOrderParam() {
        List<ApprovalOrderParamDTO> extOrderParamList = ApprovalMulLineTableOrderHelper.getExtOrderParamFromImpl();
        if (!CollectionUtils.isEmpty(extOrderParamList)) {
            extOrderParamList = ApprovalMulLineTableOrderHelper.mergeAndValidateInParam(extOrderParamList);
        }
        return extOrderParamList.stream().collect(Collectors.toMap(param -> param.getEntityName(), param -> ApprovalMulLineTableOrderHelper.appendOrderConditionStr(param.getFieldAndOrderDTOList())));
    }

    private static List<ApprovalOrderParamDTO> getExtOrderParamFromImpl() {
        ArrayList extOrderParamList = Lists.newArrayListWithExpectedSize((int)16);
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultApprovalEntryOrderServiceExtend(), IApprovalEntryOrderServiceExtend.class, (String)"kd.hr.hspm.formplugin.web.approval.InfoApprovalPlugin.getExtOrderParam");
        extendPluginProxy.callReplaceIfPresent(plugin -> {
            LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
            LOGGER.info("before callReplace getExtOrderParam");
            List orderParamDTOList = plugin.getOrderParam();
            if (!CollectionUtils.isEmpty((Collection)orderParamDTOList)) {
                extOrderParamList.addAll(orderParamDTOList);
            }
            LOGGER.info("after callReplace getExtOrderParam");
            return null;
        });
        return extOrderParamList;
    }

    private static List<ApprovalOrderParamDTO> mergeAndValidateInParam(List<ApprovalOrderParamDTO> extOrderParamList) {
        try {
            List<ApprovalOrderParamDTO> mergedOrderParamList = ApprovalMulLineTableOrderHelper.mergeOrderParam(extOrderParamList);
            for (ApprovalOrderParamDTO approvalOrderParamDTO : mergedOrderParamList) {
                String entityName = approvalOrderParamDTO.getEntityName();
                List fieldAndOrderDTOList = approvalOrderParamDTO.getFieldAndOrderDTOList();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
                DataEntityPropertyCollection properties = serviceHelper.generateEmptyDynamicObject().getDataEntityType().getProperties();
                List propertyNameList = properties.stream().map(property -> property.getName()).collect(Collectors.toList());
                Iterator iterator = fieldAndOrderDTOList.iterator();
                while (iterator.hasNext()) {
                    FieldAndOrderDTO next = (FieldAndOrderDTO)iterator.next();
                    if (propertyNameList.contains(next.getFieldName())) continue;
                    iterator.remove();
                    LOGGER.info("InfoApprovalPlugin.validateInParam.removeParam:entityName={},property={}", (Object)entityName, (Object)next.getFieldName());
                }
            }
            return mergedOrderParamList;
        }
        catch (Exception e) {
            LOGGER.error("InfoApprovalPlugin.validateInParam error", (Throwable)e);
            throw e;
        }
    }

    private static String appendOrderConditionStr(List<FieldAndOrderDTO> fieldAndOrderDTOList) {
        StringBuilder sb = new StringBuilder();
        for (FieldAndOrderDTO fieldAndOrderDTO : fieldAndOrderDTOList) {
            sb.append(fieldAndOrderDTO.getFieldName()).append(" ").append(fieldAndOrderDTO.getOrder().getName()).append(",");
        }
        if (HRStringUtils.isNotEmpty((String)sb.toString())) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private static List<ApprovalOrderParamDTO> mergeOrderParam(List<ApprovalOrderParamDTO> extOrderParamList) {
        HashMap entityNameVsFieldAndOrderDTOMap = Maps.newHashMapWithExpectedSize((int)extOrderParamList.size());
        for (ApprovalOrderParamDTO approvalOrderParamDTO : extOrderParamList) {
            String entityName = approvalOrderParamDTO.getEntityName();
            List dtoList = entityNameVsFieldAndOrderDTOMap.getOrDefault(entityName, new ArrayList());
            dtoList.addAll(approvalOrderParamDTO.getFieldAndOrderDTOList());
            entityNameVsFieldAndOrderDTOMap.put(entityName, dtoList);
        }
        ArrayList mergedOrderParamList = Lists.newArrayListWithExpectedSize((int)extOrderParamList.size());
        for (Map.Entry entityNameVsListMapEntries : entityNameVsFieldAndOrderDTOMap.entrySet()) {
            String entryName = (String)entityNameVsListMapEntries.getKey();
            List value = (List)entityNameVsListMapEntries.getValue();
            mergedOrderParamList.add(new ApprovalOrderParamDTO(entryName, value));
        }
        return mergedOrderParamList;
    }
}

